<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>商铺积分情况查询</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1"  style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid = "800612"; 
		
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [ {
				"label" : "开始日期：",
				"type" : "DatePicker",
				"name" : "sdate",
				"format" : "yyyy-MM-dd",
				"enabled" : true,
				"required" : true,
				"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"style" : "width:22.5%"
			}, {
				"label" : "结束日期：",
				"type" : "DatePicker",
				"name" : "edate",
				"format" : "yyyy-MM-dd",
				"enabled" : true,
				"required" : true,
				"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"style" : "width:22.5%"
			}, {
				"label" : "门店：",
				"name" : "muid",
				"defaultValue" : "",
				"required" : true,
				type : "fut_popselect",//类型
				selectkey:"muid",//弹框类型
				textName :"muid_name", //文本显示字段
				beforefunc:"head_beforefunc",
				itemchangedfunc:"head_itemchanged_muid",
				"enabled" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "商品编码：",
				"type" : "TextBox",
				"name" : "gdid",
				"enabled" : true,
				"style" : "width:22.5%"
			},{
				"label" : "门店：",
				"name" : "mucode",
				"type" : "TextBox",
				"visible" : false,
			},{
				"label" : "商户：",
				"name" : "sbid",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey:"sbid",//弹框类型
				textName :"sbid_name", //文本显示字段
				beforefunc:"head_beforefunc",
				"enabled" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "商铺：",
				"name" : "spid",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey:"shiplist",//弹框类型
				textName :"spid_name", //文本显示字段
				beforefunc:"head_beforefunc",
				"enabled" : true,
				"style" : "width:22.5%"			
			} ,{
				"label" : "收银机：",
				"type" : "TextBox",
				"name" : "syj",
				"enabled" : true,
				"style" : "width:22.5%"		
			}, {
				"label" : "小票号：",
				"type" : "TextBox",
				"name" : "invno",
				"enabled" : true,
				"style" : "width:22.5%"		
			}, ]
		};
		
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_800612",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "cdldate", 
					header : "发生日期",
					allowSort : true,
					headerAlign : "center",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					width : 100,
				},{
					field : "muid_name",
					name : "muid_name",
					header : "门店",
					width : 200,
				},{
					field : "sbid_name",
					name : "sbid_name",
					header : "商户",
					width : 250,
				},{
					field : "spid_name",
					name : "sbpid_name",
					header : "商铺",
					width : 250,
				},{
					field : "ppcode",
					name : "ppcode",
					header : "品牌",
					width : 150,
				},{
					field : "cdlgdid",
					name : "cdlgdid",
					header : "商品编码",
					width : 100,
				},{
					field : "cdlsyjid",
					header : "收银机",
					allowSort : true,
					headerAlign : "center",
					width : 100,
				},{
					field : "cdlinvno",
					header : "小票号",
					allowSort : true,
					headerAlign : "center",
					width : 100,
				},{
					field : "cdltrans",
					name : "cdltrans",
					header : "销售类型",
					width : 100,
				}, {
					field: "cdlcjje",
					header: "消费金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 100,
				}, {
					field: "cdljf",
					header: "总积分" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 100,
				}, {
					field: "csjf",
					header: "产生积分" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 100,
				}, {
					field: "cdljfk",
					header: "积分抵现" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 100,
				}]
			},
		}; 

		mini.parse();
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid");
			var sbid = mini.getbyName("sbid");
			if (buttonEdit.name == "sbid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "sbid in (select sbid from supmkt where muid ='" + muid.getValue() + "')";
			}
			if (buttonEdit.name == "spid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = " a.muid ='" + muid.getValue()  + "'";
			}
			return 0;
		}
		
		function head_itemchanged_muid(e,data){
			mini.getbyName("mucode").setValue(data[0].mucode);
			mini.getbyName("sbid").setValue("");
			mini.getbyName("sbid").setText("");
			mini.getbyName("spid").setValue("");
			mini.getbyName("spid").setText("");
			return 0;
		}
		function onDrawSummaryCell(e){
			var rows = e.data
			var cdlcjje = 0;
			var cdljf = 0;
			var csjf = 0;
			var cdljfk = 0;
			
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.cdlcjje) == false) {
						cdlcjje += parseFloat(row.cdlcjje);
					}
					if (isNaN(row.cdljf) == false) {
						cdljf += parseFloat(row.cdljf);
					}
					if (isNaN(row.csjf) == false) {
						csjf += parseFloat(row.csjf);
					}
					if (isNaN(row.cdljfk) == false) {
						cdljfk += parseFloat(row.cdljfk);
					}
				}
			}

			if (e.field == "ppcode") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "cdlcjje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(cdlcjje),"#,0.00")+"</b>";
			}
			if (e.field == "cdljf") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(cdljf),"#,0.00")+"</b>";
			}
			if (e.field == "csjf") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(csjf),"#,0.00")+"</b>";
			}
			if (e.field == "cdljfk") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(cdljfk),"#,0.00")+"</b>";
			}
			e.cellStyle = "text-align:right";  
		}
	</script>
	  
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>