<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>空铺明细表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1"
		style="margin-bottom: 10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js"
		type="text/javascript"></script>
	<script type="text/javascript">
		var postid =getUrlParam("postid");
		//字典数据初始化
		var moduleid = "800618";

		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};

		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [ {
				"label" : "查询条件",
				"type" : "fieldset",
				"items" : [ {
					"label" : "门店：",
					"name" : "muid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "muid",//弹框类型
					textName : "muid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:30%"
				}, {
					"label" : "门店：",
					"name" : "mucode",
					"type" : "TextBox",
					"visible" : false,
				}, {
					"label" : "位置：",
					"name" : "mmfid",
					"type" : "ButtonEdit",
					"enabled" : true,
					//"required" : true,
					"defaultValue" : "",
					type : "fut_popselect",
					selectkey : "treePosition",
					textName : "[" + "MMFCODE" + "]" + "MMFCNAME",
					beforefunc : "head_beforefunc",
					multiSelect: true
				}, {
					"label" : "楼层：",
					"name" : "mmffid",
					"type" : "ButtonEdit",
					"enabled" : true,
					//"required" : true,
					"defaultValue" : "",
					type : "fut_popselect",
					selectkey : "rankmmfid",
					textName : "[" + "MMFCODE" + "]" + "MMFCNAME",
					beforefunc : "head_beforefunc",
					multiSelect: true
				} ]
			} ]
		};

		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mall,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid" : "select_800618",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				}, {
					field : "qy",
					header : "位置",
					allowSort : true,
					headerAlign : "center",
					width : 160,
				}, {
					field : "lc",
					header : "楼层",
					allowSort : true,
					headerAlign : "center",
					width : 160,
				}, {
					field : "muid_name",
					header : "门店",
					allowSort : true,
					headerAlign : "center",
					width : 120,
				}, {
					field : "fzr",
					header : "招商员",
					allowSort : true,
					headerAlign : "center",
					width : 120,
				}, {
					field : "spid_name",
					header : "商铺号",
					allowSort : true,
					headerAlign : "center",
					width : 160,
				}, {
					field : "yt",
					header : "业种大类",
					allowSort : true,
					headerAlign : "center",
					width : 120,
				}, {
					field : "oppcode",
					header : "原品牌",
					allowSort : true,
					headerAlign : "center",
					width : 120,
				}, {
					field : "symj",
					header : "建筑面积",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "jzmj",
					header : "套内面积",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "zjdj",
					header : "租金单价",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "lowprice",
					header : "底价",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				},{
					field : "yxj",
					header : "每月小计",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "emptysdate",
					header : "空铺开始日期",
					allowSort : true,
					headerAlign : "center",
					editor : OcmControl.newControl('DatePicker'),
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					width : 120,
				}, {
					field : "kpss",
					header : "空铺损失",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				} ]
			},
		};
		var tabs = {
			properties : {
				"id" : "tabs",
			},
			items : [ {
				"title" : "明细",
				"name" : "gridbox1",
				"control" : gridbox1,
			} ]
		}
		formheader1.tabs = tabs;
		formheader1.tabsToolbar = false;
		mini.parse();
		//弹框条件过滤
		function head_beforefunc(e, data) {
			var muid = mini.getbyName("muid");
			var mmfid = mini.getbyName("mmfid");
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var buttonEdit = e.sender;

			if (e.value != "undefined" && e.value != "") {
				e.searchParam.code = e.value;
			}
			//过滤上级编码
			if (buttonEdit.name == "mmfid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				if (muid.getValue() != "") {
					e.searchParam.muid = muid.getValue();
				}
				if(e.sender.multiSelect == true){
					e.searchParam.multiSelect = true;
				}
				if(app.token&&postid&&postid!='1'){
					e.searchParam.token = app.token;
				}
			}
			if (buttonEdit.name == "mmffid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				// if (mmfid.getValue() == "") {
				// 	mini.alert("请先选择区域");
				// 	return -1;
				// }
				if (muid.getValue() != "") {
					e.searchParam.muid = muid.getValue();
				}
				if (mmfid.value != "" && mmfid.value != 'undefined') {
					var array = [];
					array = mmfid.value.split(",")
					e.searchParam.mmffids = array;
				}
				if(e.sender.multiSelect == true){
					e.searchParam.multiSelect = true;
				}
			}

			return 0;
		}
		function onDrawSummaryCell(e) {
			var rows = e.data
			var symj = 0;
			var jzmj = 0;
			var yxj = 0;
			if (rows.length > 0) {
				for (var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.symj) == false) {
						symj += parseFloat(row.symj);
					}
					if (isNaN(row.jzmj) == false) {
						jzmj += parseFloat(row.jzmj);
					}
					if (isNaN(row.yxj) == false) {
						yxj += parseFloat(row.yxj);
					}
				}
			}

			if (e.field == "oppcode") {
				e.cellHtml = "<b>" + "合计: " + "</b>";
			}
			if (e.field == "symj") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(symj), "#,0.00")
						+ "</b>";
			}
			if (e.field == "jzmj") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(jzmj), "#,0.00")
						+ "</b>";
			}
			if (e.field == "yxj") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(yxj), "#,0.00")
						+ "</b>";
			}

			e.cellStyle = "text-align:right";
		}
	</script>

	<script src="report.js" type="text/javascript"></script>
</body>
</html>