<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>数据接口销售报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	
	<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js"
		type="text/javascript"></script>

  <script type="text/javascript">
  //字典数据初始化
  var moduleid = "800622";
 
  var toolbar1 = {
		    items : [ [ {
		      "text" : "查询",
		      "iconCls" : "icon-search",
		      "name" : "searchData",
		      "onclick" : "searchData",
		      "enabled" : true,
		    }, {
		      "text" : "清除",
		      "iconCls" : "icon-remove",
		      "name" : "clearData",
		      "onclick" : "clearData",
		      "enabled" : true,
		    },{
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			}] ]
		  };


		var formheader1 = {
				"type" : "formgrid",
				"properties" : {
					"id" : "formheader1",
				},
				items : [{
					"label" : "销售日期：",
					"type" : "DatePicker",
					"name" : "salesdate",
					"format" : "yyyy-MM-dd",
					"enabled" : true,
					"style" : "width:30%"
				}, {
					"label" : "至：",
					"type" : "DatePicker",
					"name" : "saleedate",
					"format" : "yyyy-MM-dd",
					"enabled" : true,
					"style" : "width:30%",
				},{
					"label" : "门店：",
					"name" : "muid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "muid",//弹框类型
					textName : "muid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:30%"
				},{
					"label" : "商户：",
					"name" : "sbid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "sbid",//弹框类型
					textName : "sbid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:30%"
				},{
					"label" : "商铺：",
					"name" : "spid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "spid",//弹框类型
					textName : "spid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:30%"
				},{
					"label" : "商品：",
					"name" : "goodsid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "gbid",//弹框类型
					textName : "name", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:30%"
				}]
			};
		
		var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_800622",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [{
							type : "indexcolumn",
							header : "序号",
							headerAlign : "center",
						},  {
							field : "muid",
							header : "门店",
							headerAlign : "center",
							allowSort : false,
							width : 160,
						},{
							field : "saledate",
							header : "销售日期",
							allowSort : true,
							headerAlign : "center",
							editor : OcmControl.newControl('DatePicker'),
							dataType : "date",
							dateFormat : "yyyy-MM-dd",
							width : 120,
						},{
							field : "sbid",
							header : "商户",
							headerAlign : "center",
							allowSort : false,
							width : 160,
						},{
							field : "spid",
							header : "商铺",
							headerAlign : "center",
							allowSort : false,
							width : 160,
						}, {
							field : "goodsid",
							header : "商品",
							headerAlign : "center",
							allowSort : false,
							width : 160,
						},{
							field : "cash",
							header : "销售金额",
							allowSort : true,
							headerAlign : "center",
							align : "right",
							editor : OcmControl.newControl('NumButtonEdit'),
							editorSet : {
								format : "n0",
							},
							numberFormat : "#,0.00",
							width : 120,
						}]
				}
			};
			mini.parse();
			
			//弹框条件过滤
			function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid");
			var sbid = mini.getbyName("sbid");
			var spid = mini.getbyName("spid");
			if (buttonEdit.name == "sbid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "sbid in (select sbid from supmkt where muid ='" + muid.getValue() + "')";
			}
			if (buttonEdit.name == "spid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = " muid ='" + muid.getValue()  + "'";
			}
			if (buttonEdit.name == "goodsid") {
				if (muid.getValue() != "" && muid.getValue() != "undefined" ) {
					e.searchParam.wherestr = " muid ='" + muid.getValue()  + "'";
				}
				if (sbid.getValue() != "" && sbid.getValue() != "undefined" ) {
					e.searchParam.wherestr = " sbid ='" + sbid.getValue()  + "'";
				}
				if (spid.getValue() != "" && spid.getValue() != "undefined" ) {
					e.searchParam.wherestr = " spid ='" + spid.getValue()  + "'";
				}
			}
			return 0;
		}
			
			function onDrawSummaryCell(e) {
				var rows = e.data
				var cash = 0;
				if (rows.length > 0) {
					for (var i = 0; i < rows.length; i++) {
						var row = rows[i];
						if (isNaN(row.cash) == false) {
							cash += parseFloat(row.cash);
						}
					}
				}

				if (e.field == "muid") {
					e.cellHtml = "<b>" + "合计: " + "</b>";
				}
				if (e.field == "cash") {
					e.cellHtml = "<b>" + mini.formatNumber(Number(cash), "#,0.00")
							+ "</b>";
				}

				e.cellStyle = "text-align:right";
			}
		</script>

  <script src="report.js" type="text/javascript"></script>
</body>
</html>