<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>减免明细报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom: 10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
	<script type="text/javascript">
		//字典数据初始化
		var TRANSTYPE  = [{ code : "1",  name : "应收"},{ code : "2",  name : "实收"},{ code : "3",  name : "退款"},
							   { code : "5",  name : "应收调整"},{ code : "6",  name : "业主付款"}]; 
		
		var SWTYPE  = [{ code : "A1",  name : "应收调整"},{ code : "F3",  name : "临时费用调整"},{ code : "F4",  name : "周期性费用减免"},
						   { code : "Z2",  name : "滞纳金减免"}]; 

		var moduleid = "800636";

		  var toolbar1 = {
				    items : [ [ {
				      "text" : "查询",
				      "iconCls" : "icon-search",
				      "name" : "searchData",
				      "onclick" : "searchData",
				      "enabled" : true,
				    }, {
				      "text" : "清除",
				      "iconCls" : "icon-remove",
				      "name" : "clearData",
				      "onclick" : "clearData",
				      "enabled" : true,
				    }, {
						"text" : "导出",
						"iconCls" : "icon-upload",
						"name" : "exportData",
						"onclick" : "exportData",
						"enabled" : true,
					} ] ]
				  };

		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [ {
				"label" : "审核开始日期：",
				"name" : "sdate",
				"type" : "DatePicker",
				"format" : "yyyy-MM-dd",
				 "required" : "true",
				"enabled" : true,
				"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
			/* 	"style" : "width:22.5%"  */
			}, {
				"label" : "审核结束日期：",
				"name" : "edate",
				"type" : "DatePicker",
				"format" : "yyyy-MM-dd",
				 "required" : "true",
				"enabled" : true,
				"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				/*  "style" : "width:22.5%" */ 
			}, {
				"label" : "门店：",
	            "name" : "muid",
	            "enabled" : true,
	            "type" : "fut_popselect",
	            "defaultValue" : "",
				"selectkey":"muid",
				"textName":"muid_name",
				itemchangedfunc:"head_itemchanged",
				/*  "style" : "width:22.5%"  */
			},{
				"label" : "合同：",
	            "name" : "contno",
	            "defaultValue" : "",
	            "enabled" : true,
	            "type" : "fut_popselect",
				"selectkey":"contno",
				beforefunc:"head_beforefunc",
				/*  "style" : "width:22.5%"  */
			},/*  {
				"label" : "费用类型：",
				"name" : "ctype",
				"enabled" : true,
				"type" : "fut_popselect",
				"selectkey":"ctcode",
				"textName" :"ctype_name",
				  "style" : "width:22.5%" * 
			} ,*/{
				"label" : "费用项目：",
				"name" : "cccode",
				"enabled" : true,
				"type" : "fut_popselect",
				"selectkey":"cccode",
				"textName" :"cctcode_name",
				/*  "style" : "width:22.5%" */	 
			}]
		};

		var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_800636",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {	
						field : "muid_name",
						header : "门店",
						headerAlign : "center",
						width : 160,
					},{	
						field : "sbid_name",
						header : "商户",
						headerAlign : "center",
						width : 225,
					}, {	
						field : "contno",
						header : "合同",
						headerAlign : "center",
						width : 100,
					}, /*  {	
						field : "ctype_name",
						header : "费用类型",
						headerAlign : "center",
						width : 130,
					}, */{	
						field : "cccode_name",
						header : "费用项目",
						headerAlign : "center",
						width : 130,
					}, {
						field : "shdate",
						header : "审核日期",
						headerAlign : "center",
						dataType : "date",
						dateFormat : "yyyy-MM-dd",
						width : 100,
					},{
						field : "feesdate",
						header : "减免开始日期",
						headerAlign : "center",
						dataType : "date",
						dateFormat : "yyyy-MM-dd",
						width : 100,
					},  {
						field : "feeedate",
						header : "减免结束日期",
						headerAlign : "center",
						dataType : "date",
						dateFormat : "yyyy-MM-dd",
						width : 100,
					},{
						field : "jmje",
						header : "免租金额",
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 120,
					}, {
						field : "ystzje",
						header : "应收调整金额",
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 120,
					},{
						field : "fytzje",
						header : "费用调整金额",
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 120,
					},{
						field : "fyjmje",
						header : "周期性费用减免金额",
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 120,
					},{
						field : "znjmje",
						header : "滞纳金调整金额",
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 120,
					}]
				},
			};
		mini.parse();
		
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid");
			if (buttonEdit.name == "contno") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					mini.getbyName("contno").setValue("");
					mini.getbyName("contno").setText("");
					return -1;
				}
				e.searchParam.wherestr = " muid ='" + muid.getValue()  + "'";
			}
			return 0;
		}
		function head_itemchanged(e,data){
			mini.getbyName("contno").setValue("");
			mini.getbyName("contno").setText("");
			return 0;
		}
		
		function onDrawSummaryCell(e) {
			var rows = e.data;
			var ystzje = 0;
			var fytzje = 0;
			var fyjmje = 0;
			var znjmje = 0;
			var jmje = 0;
			var zje = 0;
			var list = [];
			if (rows.length > 0) {
				for (var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.ystzje) == false) {
						ystzje += parseFloat(row.ystzje);
					}
					if (isNaN(row.fytzje) == false) {
						fytzje += parseFloat(row.fytzje);
					}
					if (isNaN(row.fyjmje) == false) {
						fyjmje += parseFloat(row.fyjmje);
					}
					if (isNaN(row.znjmje) == false) {
						znjmje += parseFloat(row.znjmje);
					}
					if (isNaN(row.jmje) == false) {
						jmje += parseFloat(row.jmje);
					}
				}
				zje = parseFloat(jmje) - parseFloat(ystzje) - parseFloat(fytzje) + parseFloat(fyjmje) - parseFloat(znjmje)
			}

			if (e.field == "muid_name") {
			    e.cellHtml = "<b>" + "合计: " + "</b>"; 
			}
			if (e.field == "contno") {
				var str="";
				for (var i=0;i<list.length; i++) {
					var key = list[i].key;
					str=str + "<b>"+key+"</b><br>";
				}
				str = str + "<b>" + " " + "</b><br>";
				str = str + "<b>" + "减免合计：(免租" + "</b><br>";
				e.cellHtml = str;
			}
			if (e.field == "cccode_name") {
				var str="";
				for (var i=0;i<list.length; i++) {
					var key = list[i].key;
					str=str + "<b>"+key+"</b><br>";
				}
				str = str + "<b>" + " " + "</b><br>";
				str = str + "<b>" + "- 应收调整  - 费用调整  " + "</b><br>";
				e.cellHtml = str;
			}
			if (e.field == "shdate") {
				var str="";
				for (var i=0;i<list.length; i++) {
					var key = list[i].key;
					str=str + "<b>"+key+"</b><br>";
				}
				str = str + "<b>" + " " + "</b><br>";
				str = str + "<b>" + "- 滞纳金调整 +" + "</b><br>";
				e.cellHtml = str;
			}
			
			if (e.field == "feesdate") {
				var str="";
				for (var i=0;i<list.length; i++) {
					var key = list[i].key;
					str=str + "<b>"+key+"</b><br>";
				}
				str = str + "<b>" + " " + "</b><br>";
				str = str + "<b>" + "周期性费用减免)" + "</b><br>";
				e.cellHtml = str;
			}
			
			if (e.field == "feeedate") {
				var str="";
				if (zje == 0) {
					str=str + "<br><b>0.00</b><br>";
				} else {
					str = str + "<br><b>" + mini.formatNumber(Number(zje),"#,0.00") + "</b><br>";
				}
				e.cellHtml = str;
			}
			
			if (e.field == "jmje") {
				e.cellHtml = "<b>" + jmje.toFixed(2) + "</b>";
			}
			if (e.field == "ystzje") {
				e.cellHtml = "<b>" + ystzje.toFixed(2) + "</b>";
			}
			if (e.field == "fytzje") {
				e.cellHtml = "<b>" + fytzje.toFixed(2) + "</b>";
			}
			if (e.field == "fyjmje") {
				e.cellHtml = "<b>" + fyjmje.toFixed(2) + "</b>";
			}
			if (e.field == "znjmje") {
				e.cellHtml = "<b>" + znjmje.toFixed(2) + "</b>";
			}
			e.cellStyle = "text-align:right"; 
		}
		
	</script>

	<script src="report.js" type="text/javascript"></script>

</body>
</html>