<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>商户销售月报</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='800706'
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [{"label" : "查询条件",
            	"type" : "fieldset",
            	"items" :[{
					"label" : "发生月份：",
					"type" : "MonthPicker",
					"name" : "sdate",
					"format" : "yyyy-MM",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(),"yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(),"yyyy-MM"),
					"style" : "width:22.5%"
				}, {
					"label" : "结束月份：",
					"type" : "MonthPicker",
					"name" : "edate",
					"format" : "yyyy-MM",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(),"yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(),"yyyy-MM"),
					"style" : "width:22.5%"
				}, {
					"label" : "门店：",
					"type" : "ButtonEdit",
					"name" : "muid",
					"enabled" : true,
					"required" : false,
					"multiSelect":true,
					"onbuttonclick" : "onMktidClick",
					"onValuechanged" : "onMktidChange",
					"style" : "width:22.5%"
				}, {
					"label" : "商品编码：",
					"type" : "TextBox",
					"name" : "gbid",
					"enabled" : true,
					"style" : "width:22.5%"
				},{
					"label" : "商户：",
					"name" : "sbid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey:"sbid",//弹框类型
					textName :"sbid_name", //文本显示字段
					beforefunc:"head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%"
				}, {
					"label" : "商铺：",
					"name" : "spcode",
					"type" : "TextBox",
					"visible" : false,
				}]}
			]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_800706",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "muid_name", 
					header : "门店",
					headerAlign : "center",
					width : 150,
				},{
					field : "sbid_name", 
					header : "商户",
					headerAlign : "center",
					width : 180,
				},{
					field : "sbdz", 
					header : "店招",
					headerAlign : "center",
					width : 120,
				} ,{
					field : "sgldate",
					header : "发生月份",
					headerAlign : "center",
					//dateFormat : "yyyy-MM",
					//dataType : "date",
					align:"center",
					width : 100,
				}, {
					field: "sglsl",
					header: "消费数量" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 100,
				}, {
					field: "sglxssr",
					header: "消费金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 100,
				}, {
					field: "sglcash",
					header: "现金" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 100,
				}, {
					field: "sglcheck",
					header: "支票" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 90,
				}, {
					field: "sglccard",
					header: "信用卡" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 90,
				}, {
					field: "sglfcard",
					header: "储值卡" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 90,
				}, {
					field: "sglgcert",
					header: "礼券" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 90,
				}, {
					field: "sglopay",
					header: "其他" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 90,
				} ]
			},
		}; 
		 var tabs = {
	    			properties : {
						"id" : "tabs",
					},
					items : [{
						"title" : "明细",
						"name" : "gridbox1",
	 					"control" : gridbox1,
					}]
	       }
		   formheader1.tabs=tabs;
	       formheader1.tabsToolbar = false;
		mini.parse();
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid");
			var sbid = mini.getbyName("sbid");
			var contno = mini.getbyName("contno");
			if (buttonEdit.name == "sbid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = " sbid in (select sbid from supmkt where fgetwizardname(muid, 'MUID1') in (" + muid.getValue() + "))";
			}
			if (buttonEdit.name == "contno") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "muid ='" + muid.getValue()  + "'";
				if (sbid.getValue() != undefined && sbid.getValue() != "") {
					e.searchParam.wherestr += "and sbid ='" + sbid.getValue() + "'";
				}
			}
			if (buttonEdit.name == "spid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = " a.muid ='" + muid.getValue()  + "'";
				if (sbid.getValue() != undefined && sbid.getValue() != "") {
					e.searchParam.wherestr += " and a.contno in (SELECT contno FROM contmain where sbid = '" + sbid.getValue() + "')";
				}
			}
			return 0;
		}
		
		function head_itemchanged_contno(e,data){
			mini.getbyName("sbid").setValue(data[0].sbid);
			mini.getbyName("sbid").setText(data[0].sbid_name);
			mini.getbyName("spid").setValue("");
			mini.getbyName("spid").setText("");
			return 0;
		}
		function head_itemchanged_muid(e,data){
			mini.getbyName("mucode").setValue(data[0].mucode);
			mini.getbyName("sbid").setValue("");
			mini.getbyName("sbid").setText("");
			mini.getbyName("spid").setValue("");
			mini.getbyName("spid").setText("");
			return 0;
		}
		function head_itemchanged_spid(e,data){
			mini.getbyName("spcode").setValue(data[0].code);
			return 0;
		}
		function onDrawSummaryCell(e){
			var rows = e.data
			var sglxssr = 0; var sglcash = 0;
			var sglcheck = 0; var sglccard = 0;
			var sglfcard = 0; var sglgcert = 0;
			var sglopay = 0; var sglsl = 0;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.sglsl) == false) {
						sglsl += parseFloat(row.sglsl);
					}
					if (isNaN(row.sglxssr) == false) {
						sglxssr += parseFloat(row.sglxssr);
					}
					if (isNaN(row.sglcash) == false) {
						sglcash += parseFloat(row.sglcash);
					}
					if (isNaN(row.sglcheck) == false) {
						sglcheck += parseFloat(row.sglcheck);
					}
					if (isNaN(row.sglccard) == false) {
						sglccard += parseFloat(row.sglccard);
					}
					if (isNaN(row.sglfcard) == false) {
						sglfcard += parseFloat(row.sglfcard);
					}
					if (isNaN(row.sglgcert) == false) {
						sglgcert += parseFloat(row.sglgcert);
					}
					if (isNaN(row.sglopay) == false) {
						sglopay += parseFloat(row.sglopay);
					}
					
				}
			}

			if (e.field == "sbid_name") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "sglopay") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(sglopay),"#,0.00")+"</b>";
			}
			if (e.field == "sglgcert") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(sglgcert),"#,0.00")+"</b>";
			}
			if (e.field == "sglfcard") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(sglfcard),"#,0.00")+"</b>";
			}
			if (e.field == "sglccard") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(sglccard),"#,0.00")+"</b>";
			}
			if (e.field == "sglcheck") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(sglcheck),"#,0.00")+"</b>";
			}
			if (e.field == "sglcash") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(sglcash),"#,0.00")+"</b>";
			}
			if (e.field == "sglxssr") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(sglxssr),"#,0.00")+"</b>";
			}
			if (e.field == "sglsl") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(sglsl),"#,0.00")+"</b>";
			}
			
			e.cellStyle = "text-align:right";  
		}
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>