<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>招商减免报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1"
		style="margin-bottom: 10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js"
		type="text/javascript"></script>
	<script type="text/javascript">
		//字典数据初始化
		var moduleid = "800720";

		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};

		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [ {
				"label" : "查询条件",
				"type" : "fieldset",
				"items" : [ {
					"label" : "结算年份：",
					"type" : "DatePicker",
					"name" : "sdate",
					"format" : "yyyy",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(), "yyyy"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy"),
					"style" : "width:22.5%"
				},{
					"label" : "门店：",
					"name" : "muid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "muid",//弹框类型
					textName : "muid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%"
				}, {
					"label" : "门店：",
					"name" : "mucode",
					"type" : "TextBox",
					"visible" : false,
				}, {
					"label" : "区域：",
					"name" : "mmfid",
					"type" : "ButtonEdit",
					"enabled" : true,
					//"required" : true,
					"defaultValue" : "",
					type : "fut_popselect",
					selectkey : "treeMmfidno",
					textName : "mmfid_name",
					beforefunc : "head_beforefunc",
					"style" : "width:22.5%"
				},{
					"label" : "商户：",
					"name" : "sbid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "sbid",//弹框类型
					textName : "sbname", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%"
				}, {
					"label" : "商户：",
					"name" : "sbname",
					"type" : "TextBox",
					"visible" : false,
				} ]
			} ]
		};

		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mall,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid" : "select_800720",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				}, {
					field : "muid_name",
					header : "门店",
					allowSort : true,
					headerAlign : "center",
					width : 120,
				}, {
					field : "qy_name",
					header : "区域",
					allowSort : true,
					headerAlign : "center",
					width : 160,
				},{
					field : "spid_name",
					header : "商铺号",
					allowSort : true,
					headerAlign : "center",
					width : 180,
				},{
					field : "sbid_name",
					header : "商户",
					allowSort : true,
					headerAlign : "center",
					width : 200,
				},{
					field : "contno",
					header : "合同号",
					allowSort : true,
					headerAlign : "center",
					width : 80,
				},{
					field : "sumje",
					header : "全年减免金额合计",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "monje1",
					header : "1月",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "monje2",
					header : "2月",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "monje3",
					header : "3月",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "monje4",
					header : "4月",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "monje5",
					header : "5月",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "monje6",
					header : "6月",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "monje7",
					header : "7月",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "monje8",
					header : "8月",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "monje9",
					header : "9月",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "monje10",
					header : "10月",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "monje11",
					header : "11月",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				}, {
					field : "monje12",
					header : "12月",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "#,0.00",
					width : 120,
				} ]
			},
		};
		var tabs = {
			properties : {
				"id" : "tabs",
			},
			items : [ {
				"title" : "明细",
				"name" : "gridbox1",
				"control" : gridbox1,
			} ]
		}
		formheader1.tabs = tabs;
		formheader1.tabsToolbar = false;
		mini.parse();
		//弹框条件过滤
		function head_beforefunc(e, data) {
			var muid = mini.getbyName("muid");
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var buttonEdit = e.sender;

			if (e.value != "undefined" && e.value != "") {
				e.searchParam.code = e.value;
			}
			//过滤上级编码
			if (buttonEdit.name == "mmfid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				if (muid.getValue() != "") {
					e.searchParam.muid = muid.getValue();
				}
				e.searchParam.isonlynode = "N";
			}
			// 门店过滤商户
			if (buttonEdit.name == "sbid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "sbid in (select sbid from supmkt where muid ='" + muid.getValue()  + "')";
			}

			return 0;
		}
		function onDrawSummaryCell(e) {
			var rows = e.data
			var sumje = 0;
			var monje1 = 0;
			var monje2 = 0;
			var monje3 = 0;
			var monje4 = 0;
			var monje5 = 0;
			var monje6 = 0;
			var monje7 = 0;
			var monje8 = 0;
			var monje9 = 0;
			var monje10 = 0;
			var monje11 = 0;
			var monje12 = 0;
			if (rows.length > 0) {
				for (var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.sumje) == false) {
						sumje += parseFloat(row.sumje);
					}
					if (isNaN(row.monje1) == false) {
						monje1 += parseFloat(row.monje1);
					}
					if (isNaN(row.monje2) == false) {
						monje2 += parseFloat(row.monje2);
					}
					if (isNaN(row.monje3) == false) {
						monje3 += parseFloat(row.monje3);
					}
					if (isNaN(row.monje4) == false) {
						monje4 += parseFloat(row.monje4);
					}
					if (isNaN(row.monje5) == false) {
						monje5 += parseFloat(row.monje5);
					}
					if (isNaN(row.monje6) == false) {
						monje6 += parseFloat(row.monje6);
					}
					if (isNaN(row.monje7) == false) {
						monje7 += parseFloat(row.monje7);
					}
					if (isNaN(row.monje8) == false) {
						monje8 += parseFloat(row.monje8);
					}
					if (isNaN(row.monje9) == false) {
						monje9 += parseFloat(row.monje9);
					}
					if (isNaN(row.monje10) == false) {
						monje10 += parseFloat(row.monje10);
					}
					if (isNaN(row.monje11) == false) {
						monje11 += parseFloat(row.monje11);
					}
					if (isNaN(row.monje12) == false) {
						monje12 += parseFloat(row.monje12);
					}
				}
			}

			if (e.field == "contno") {
				e.cellHtml = "<b>" + "合计: " + "</b>";
			}
			if (e.field == "sumje") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(sumje), "#,0.00")
						+ "</b>";
			}
			if (e.field == "monje1") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(monje1), "#,0.00")
						+ "</b>";
			}
			if (e.field == "monje2") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(monje2), "#,0.00")
						+ "</b>";
			}
			if (e.field == "monje3") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(monje3), "#,0.00")
						+ "</b>";
			}
			if (e.field == "monje4") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(monje4), "#,0.00")
						+ "</b>";
			}
			if (e.field == "monje5") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(monje5), "#,0.00")
						+ "</b>";
			}
			if (e.field == "monje6") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(monje6), "#,0.00")
						+ "</b>";
			}
			if (e.field == "monje7") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(monje7), "#,0.00")
						+ "</b>";
			}
			if (e.field == "monje8") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(monje8), "#,0.00")
						+ "</b>";
			}
			if (e.field == "monje9") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(monje9), "#,0.00")
						+ "</b>";
			}
			if (e.field == "monje10") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(monje10), "#,0.00")
						+ "</b>";
			}
			if (e.field == "monje11") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(monje11), "#,0.00")
						+ "</b>";
			}
			if (e.field == "monje12") {
				e.cellHtml = "<b>" + mini.formatNumber(Number(monje12), "#,0.00")
						+ "</b>";
			}

			e.cellStyle = "text-align:right";
		}
	</script>

	<script src="report.js" type="text/javascript"></script>
</body>
</html>