<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>收付款报表(丽宝)</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	  <div class="ocm-formheader" config="formheader1"></div>
	  <div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	  </div>

	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
    <script src="/mall-business-ui/pages/common/commonfunc.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var dictData = OcmControl.getDict("WMID","code,name,pro1,ddvalue") || {};
		var moduleid ='800927'
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [{
				"label" : "门店：",
				"name" : "muid",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey:"muid",//弹框类型
				textName :"muid_name", //文本显示字段
				beforefunc:"head_beforefunc",
				itemchangedfunc:"head_itemchanged_muid",
				"enabled" : true,
				"style" : "width:22.5%"
			},{
				"label" : "商户：",
				"name" : "sbid",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey:"sbid",//弹框类型
				textName :"sbid_name", //文本显示字段
				beforefunc:"head_beforefunc",
				"enabled" : true,
				"style" : "width:22.5%"
			},{
				"label" : "合同：",
				"name" : "contno",
				"type" : "ButtonEdit",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey:"contno",//弹框类型
				textName :"contno", //文本显示字段
				beforefunc:"head_beforefunc",
				itemchangedfunc : "head_itemchanged_contno",
				"enabled" : true,
				"style" : "width:22.5%"	
			}, {
				"label" : "品牌：",
				"name" : "ppcode",
				"enabled" : true,
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey:"ppcode",
				textName :"ppcode_name",
				"style" : "width:22.5%"
			}, {
				"label" : "账单月：",
				"type" : "MonthPicker",
				"name" : "saccmon",
				"format" : "yyyy-MM",
				"enabled" : true,
				"value" : mini.formatDate(new Date(),"yyyy-MM"),
				"defaultValue" : mini.formatDate(new Date(),"yyyy-MM"),
				"style" : "width:22.5%"
			}, {
				"label" : "至：",
				"type" : "MonthPicker",
				"name" : "eaccmon",
				"format" : "yyyy-MM",
				"enabled" : true,
				"value" : mini.formatDate(new Date(),"yyyy-MM"),
				"defaultValue" : mini.formatDate(new Date(),"yyyy-MM"),
				"style" : "width:22.5%"
			}, {
					"label" : "费用开始日期：",
					"type" : "DatePicker",
					"name" : "feesdate",
					"format" : "yyyy-MM-dd",
					"enabled" : true,
					"style" : "width:22.5%"
				}, {
					"label" : "费用结束日期：",
					"type" : "DatePicker",
					"name" : "feeedate",
					"format" : "yyyy-MM-dd",
					"enabled" : true,
					"style" : "width:22.5%"
				},{
					"label" : "实际到账日期：",
					"type" : "DatePicker",
					"name" : "ssgdate",
					"format" : "yyyy-MM-dd",
					"enabled" : true,
					"style" : "width:22.5%"
				}, {
					"label" : "至：",
					"type" : "DatePicker",
					"name" : "esgdate",
					"format" : "yyyy-MM-dd",
					"enabled" : true,
					"style" : "width:22.5%"
				} ]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_800927",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "muid_name", 
					header : "门店",
					headerAlign : "center",
					width : 180,
				},{
					field : "billno", 
					header : "收/付款单号",
					headerAlign : "center",
					width : 160,
				},{
					field : "auditdate", 
					header : "审核日期",
					type : "date",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd HH:mm:ss",
					dataType : "date",
					align:"center",
					width : 150,
				},{
					field : "setbillno", 
					header : "结算单号",
					headerAlign : "center",
					width : 120,
				},{
					field : "contno", 
					header : "合同",
					headerAlign : "center",
					width : 120,
				},{
					field : "sbid_name", 
					header : "商户",
					headerAlign : "center",
					width : 200,
				},{
					field : "spid_name", 
					header : "商铺",
					headerAlign : "center",
					width : 120,
				},{
					field : "ppcode_name", 
					header : "品牌",
					headerAlign : "center",
					width : 120,
				},{
					field : "cccode_name", 
					header : "费用名称",
					headerAlign : "center",
					width : 150,
				},{
					field : "startdate", 
					header : "开始日期",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align:"center",
					width : 100,
				},{
					field : "enddate", 
					header : "结束日期",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align:"center",
					width : 100,
				},{
					field : "amount", 
					header : "应收/付",
					headerAlign : "center",
					numberFormat : "c2",
					align: "right",
					width : 150,
				},{
					field : "recamount", 
					header : "已收/付款",
					headerAlign : "center",
					numberFormat : "c2",
					align: "right",
					width : 150,
				},{
					field : "bcpay", 
					header : "本次收/付款",
					headerAlign : "center",
					numberFormat : "c2",
					align: "right",
					width : 150,
				},{
					field : "ysbalance", 
					header : "欠款",
					headerAlign : "center",
					numberFormat : "c2",
					align: "right",
					width : 150,
				},{
					field : "accmon", 
					header : "账单月",
					headerAlign : "center",
					align:"center",
					width : 150,
				},{
					field : "sgdate", 
					header : "实际到账日期",
					headerAlign : "center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					align:"center",
					width : 100,
				},{
					field : "payname", 
					header : "付款方式",
					headerAlign : "center",
					width : 60,
				},{
					field : "auditor", 
					header : "收/付款人",
					headerAlign : "center",
					width : 150,
				},]
			},
		};
		
		mini.parse();
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid");
			var sbid = mini.getbyName("sbid");
			if (buttonEdit.name == "sbid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "sbid in (select sbid from supmkt where muid ='" + muid.getValue() + "')";
			}
			if (buttonEdit.name == "contno") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "muid ='" + muid.getValue()  + "'";
				if (sbid.getValue() != undefined && sbid.getValue() != "") {
					e.searchParam.wherestr += "and sbid ='" + sbid.getValue() + "'";
				}
			}
			return 0;
		};
		function head_itemchanged_muid(e,data){
			mini.getbyName("sbid").setValue("");
			mini.getbyName("sbid").setText("");
			return 0;
		};
		function head_itemchanged_contno(e,data){
			mini.getbyName("sbid").setValue(data[0].sbid);
			mini.getbyName("sbid").setText(data[0].sbid_name);
			return 0;
		};
		function onDrawSummaryCell(e,data){
			var rows = e.data;
			var amount = 0;
			var recamount = 0;
			var bcpay = 0;
			var ysbalance = 0;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.amount) == false) {
						amount += parseFloat(row.amount);
					}
					if (isNaN(row.recamount) == false) {
						recamount += parseFloat(row.recamount);
					}
					if (isNaN(row.bcpay) == false) {
						bcpay += parseFloat(row.bcpay);
					}
					if (isNaN(row.ysbalance) == false) {
						ysbalance += parseFloat(row.ysbalance);
					}
				}
			}
			
			if (e.field == "billno") {
				e.cellHtml ="<b>"+ "合计: " + "</b>";
			}
			if (e.field == "amount") {
				e.cellHtml ="<b>"+ "￥" + mini.formatNumber(Number(amount),"#,0.00")+"</b>";
			}
			if (e.field == "recamount") {
				e.cellHtml ="<b>"+ "￥" + mini.formatNumber(Number(recamount),"#,0.00")+"</b>";
			}
			if (e.field == "bcpay") {
				e.cellHtml ="<b>"+ "￥" + mini.formatNumber(Number(bcpay),"#,0.00")+"</b>";
			}
			if (e.field == "ysbalance") {
				e.cellHtml ="<b>"+ "￥" + mini.formatNumber(Number(ysbalance),"#,0.00")+"</b>";
			}

			e.cellStyle = "text-align:right";  
		}
	</script>
	<script src="report.js" type="text/javascript"></script>
</body>
</html>