<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>销项、消费税报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1"style="margin-bottom: 10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js"
		type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var dictData = OcmControl.getDict("WMID,XXTAXRATE","code,name,pro1,ddvalue") || {};
		var moduleid = "800935";
		var billstatus = [ {  code : "M",  name : "生成"}, {  code : "Y",  name : "审核"}, {  code : "E",  name : "付款"} ];

		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};

		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [{"label" : "查询条件",
            	"type" : "fieldset",
            	"items" :[{
    				"label" : "发生时间：",
    				"name" : "sdate",
    				"type" : "DatePicker",
    				"format" : "yyyy-MM-dd",
    				"enabled" : true,
    				"required" : true,
    				"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
    				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
    				"style" : "width:30%"
    			}, {
    				"label" : "结束时间：",
    				"name" : "edate",
    				"type" : "DatePicker",
    				"format" : "yyyy-MM-dd",
    				"enabled" : true,
    				"required" : true,
    				"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
    				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
    				"style" : "width:30%"
    			}, {
					"label" : "门店：",
					"name" : "muid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey:"rankmuid",//弹框类型
					textName :"muid_name", //文本显示字段
					//beforefunc:"head_beforefunc",
					//itemchangedfunc:"head_itemchanged_muid",
					"enabled" : true,
					"style" : "width:30%"
				},{
					"label" : "柜组：",
					"name" : "spid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey:"rankspid",//弹框类型
					textName :"spid_name", //文本显示字段
					beforefunc:"head_beforefunc",
					"enabled" : true,
					"style" : "width:30%"
				},{
					"label" : "销项税率：",
					"type" : "ComboBox",
					"name" : "tax",
					"enabled" : true,
					"style" : "width:30%",
					"data" : dictData.XXTAXRATE,
					"showNullItem" : true,
				}]
		}]};

		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mall,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid" : "select_800935",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				}, {
					field : "muid_name",
					header : "门店",
					allowSort : true,
					headerAlign : "center",
					width : 150,
				},{
					field : "spid_name",
					header : "柜组",
					allowSort : true,
					headerAlign : "center",
					width : 120,
				}, {
					field : "sglxssr",
					header : "销售收入",
					allowSort : true,
					headerAlign : "center",
					numberFormat : "n2",
					align: "right",
					width : 80,
				},{
					field : "sglxstax",
					header : "销项税率",
					allowSort : true,
					headerAlign : "center",
					numberFormat : "n2",
					align: "right",
					width : 80,
				},{
					field : "sglbhsxssr",
					header : "不含税销售收入",
					allowSort : true,
					headerAlign : "center",
					numberFormat : "n2",
					align: "right",
					width : 80,
				}, {
					field : "sglxsse",
					header : "销项税额",
					allowSort : true,
					headerAlign : "center",
					numberFormat : "n2",
					align: "right",
					width : 80,
				} ,{
					field : "sglxfse",
					header : "消费税额",
					allowSort : true,
					headerAlign : "center",
					numberFormat : "n2",
					align: "right",
					width : 80,
				} ,]
			},
		};

		mini.parse();
		
		function head_beforefunc(e){
			var buttonEdit = e.sender;
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid");
			if (buttonEdit.name == "spid") {
				/*if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}*/
				e.searchParam.wherestr = " a.spstatus NOT IN ('E','N')";
			}
			return 0;
		}
		
		function head_beforefunc2(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid");
			var sbid = mini.getbyName("sbid");
			var spid = mini.getbyName("spid");
			var contno = mini.getbyName("contno");
			if (buttonEdit.name == "sbid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}else{
					e.searchParam.muid = muid.getValue();
					e.searchParam.wherestr = " (a.SBWMID1 = 'Y' or a.SBWMID2 = 'Y' or a.SBWMID3 = 'Y' or a.SBWMID4 = 'Y') ";
				}
			}
			if (buttonEdit.name == "contno") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = "muid ='" + muid.getValue()  + "'";
				if (sbid.getValue() != undefined && sbid.getValue() != "") {
					e.searchParam.wherestr += "and sbid ='" + sbid.getValue() + "'";
				}
				if (spid.getValue() != undefined && spid.getValue() != "") {
					e.searchParam.wherestr += "and spid like'%" + sbid.getValue() + "%'";
				}
			}
			if (buttonEdit.name == "spid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = " muid ='" + muid.getValue()  + "' and spstatus = 'Y'";
				if (contno.getValue()!= undefined && contno.getValue() != "") {
					e.searchParam.wherestr += " and  oid in (SELECT spid FROM contmanaframe where contno = '"+ contno.getValue()+ "')";
				}
			}
			if (buttonEdit.name == "mmfid") {
				if (muid.getValue() == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.muid = muid.getValue();
			}
			return 0;
		}
		function onDrawSummaryCell(e,data){
			var rows = e.data;
			var sglxssr = 0;
			var sglbhsxssr = 0;
			var sglxsse = 0;
			var sglxfse = 0;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.sglxssr) == false) {
						sglxssr += parseFloat(row.sglxssr);
					}
					if (isNaN(row.sglbhsxssr) == false) {
						sglbhsxssr += parseFloat(row.sglbhsxssr);
					}
					if (isNaN(row.sglxsse) == false) {
						sglxsse += parseFloat(row.sglxsse);
					}
					if (isNaN(row.sglxfse) == false) {
						sglxfse += parseFloat(row.sglxfse);
					}
				}
			}
			
			if (e.field == "spid_name") {
				e.cellHtml ="<b>"+ "合计: " + "</b>";
			}
			if (e.field == "sglxssr") {
				e.cellHtml ="<b>"+ "￥" + mini.formatNumber(Number(sglxssr),"#,0.00")+"</b>";
			}
			if (e.field == "sglbhsxssr") {
				e.cellHtml ="<b>"+ "￥" + mini.formatNumber(Number(sglbhsxssr),"#,0.00")+"</b>";
			}
			if (e.field == "sglxsse") {
				e.cellHtml ="<b>"+ "￥" + mini.formatNumber(Number(sglxsse),"#,0.00")+"</b>";
			}
			if (e.field == "sglxfse") {
				e.cellHtml ="<b>"+ "￥" + mini.formatNumber(Number(sglxfse),"#,0.00")+"</b>";
			}

			e.cellStyle = "text-align:right";  
		}
	</script>
	<script src="report.js" type="text/javascript"></script>

</body>
</html>