<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>盘点盈亏清单(预审)</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='K10408';
		
		var dicData = OcmControl.getDict("STOCKMD","code,name,ddvalue") ||{};
		dicData.ISNOT = [{code:'Y',name:'是'} , {code:'N',name:'否'}];
	    var BCTTYPE = [{"code": "1","name": "大盘"},{"code": "2","name": "小盘"}];
		
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"initHeight":100,
			"properties" : {
				"id" : "formheader1",
			},
			items : [{"label" : "查询条件",
            	"type" : "fieldset",
            	"items" :[  {
					"label" : "门店：",
					"name" : "muid",
					"type" : "ButtonEdit",
					type : "fut_popselect",
					selectkey:"muid",
					textName :"muid_name", 
					"enabled" : true,
					"required" : "true",
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_muid",
					"style" : "width:22.5%",
				},{
					label : "盘点日期：",
					name : "bctdate",
					type : "ButtonEdit",
					required : true,
					defaultValue : "",
					type : "fut_popselect",
					selectkey:"pddate",
					textName : "bctdate",
					beforefunc:"head_beforefunc",
					itemchangedfunc:"head_itemchanged_bctdate", 
					allowInput : true,
					"enabled" : true,
					"style" : "width:22.5%",
				}, {
					"label" : "盘点序号：",
					"name" : "cmfseq",
					"type" : "TextBox",
					"enabled" : true,
					"readOnly" : true,
					"style" : "width:22.5%",
					 "visible" : true,
				},{
					"label" : "盘点类型：",
					"type" : "ComboBox",
					"name" : "bcttype",
					"enabled" : true,
					"data" : BCTTYPE,
					/* "required" : "true", */
					/* "value":"1", */
					"readOnly" : true,
					"style" : "width:22.5%;display:block;float:none",
				},{
					"label" : "柜组(起)：",
					"name" : "smfid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "selfspcode",//弹框类型
					textName : "smfid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_smfid", 
					"enabled" : true,
					"style" : "width:22.5%",
			     }, {
					"label" : "柜组(止)：",
					"name" : "emfid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",
					selectkey : "selfspcode",
					textName : "emfid_name", 
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_emfid", 
					"enabled" : true,
					"style" : "width:22.5%",
			     }, {
					"label" : "子库存：",
					"name" : "md",
					"type": "ComboBox",
					"defaultValue": "1",
					data: dicData.STOCKMD,
					"enabled" : true,
					"style" : "width:22.5%"
				},]}
			]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_K10408",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "spid_name", 
					header : "柜组",
					headerAlign : "center",
					width : 200,
				},{
					field : "md_name", 
					header : "子库存",
					headerAlign : "center",
					width : 90,
				},{
					field : "sbid_name", 
					header : "供应商",
					headerAlign : "center",
					width : 200,
				},{
					field : "wmid_name", 
					header : "经营方式",
					headerAlign : "center",
					width : 90,
				},{
					field : "cksgdid", 
					header : "商品编码",
					headerAlign : "center",
					width : 100,
				},{
					field : "gbbarcode", 
					header : "商品条码",
					headerAlign : "center",
					width : 100,
				},{
					field : "ckssample", 
					header : "样品",
					headerAlign : "center",
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.ISNOT,
					/* allowSort : false, */
					width : 50,
			   },{
					field : "gbcname", 
					header : "商品名称",
					headerAlign : "center",
					width : 160,
				},{
					field : "ppcode_name", 
					header : "品牌",
					headerAlign : "center",
					width : 140,
				},{
					field: "pdsl",
					header: "盘点数量" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					excel:{
						  type:"n",
						  format:"0.0000",
						  align:"right"
						},
					width : 90,
				},{
					field: "kcsl",
					header: "库存数量" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					excel:{
						  type:"n",
						  format:"0.0000",
						  align:"right"
						},
					width : 90,
				},{
					field: "cysl",
					header: "差异数量" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					excel:{
						  type:"n",
						  format:"0.0000",
						  align:"right"
						},
					width : 90,
				},{
					field: "pdhsjjje",
					header: "盘点含税进价金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "kchsjjje",
					header: "库存含税进价金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "cyhsjjje",
					header: "含税进价差异金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "pdbhsjjje",
					header: "盘点不含税进价金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.0000",
						  align:"right"
						},
				},{
					field: "kcbhsjjje",
					header: "库存不含税进价金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.0000",
						  align:"right"
						},
				},{
					field: "cybhsjjje",
					header: "差异不含税进价金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.0000",
						  align:"right"
						},
				},{
					field: "ckssj",
					header: "售价" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 120,
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "pdhssjje",
					header: "盘点含税售价金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "kchssjje",
					header: "库存含税售价金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "cysjje",
					header: "含税售价差异金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				}, ]
			},
		}; 
		 var tabs = {
	    			properties : {
						"id" : "tabs",
					},
					items : [{
						"title" : "明细",
						"name" : "gridbox1",
	 					"control" : gridbox1,
					}]
	       }
		   formheader1.tabs=tabs;
	       formheader1.tabsToolbar = false;
	       
		mini.parse();
		
		//盘点日检查
		function onDateChanged(e){
			var bctdate = mini.getbyName("bctdate").getValue();
			bctdate = mini.formatDate(e.value,"yyyy-MM-dd");
			var muid = mini.getbyName("muid").getValue();
			if (muid == undefined || muid == "") {
				/* mini.alert("请选择门店");
				mini.getbyName("bctdate").setValue("");
				return -1; */
				if (!getBctdate(bctdate)) {
					  mini.alert("["+bctdate+"]不是盘点日!");
					  mini.getbyName("bctdate").setValue("");
					  return;
				}
			}else{
				if (!getBctmuiddate(muid,bctdate)) {
					  mini.alert("["+bctdate+"]不是盘点日!");
					  mini.getbyName("bctdate").setValue("");
					  return;
				}
			}			
			
		};
		
		function getBctdate(bctdate){
			var searchParam = {
			  		queryid   :"select_bcheckdate",
			  		"bctdate" : bctdate
			  	};
			var bctvalue = false;
			itemLoader.doRequest(OmdUrl.mall, "mss.work.report.query",searchParam, null, null, 
					function(data) {
						var _dicData = data.report;
						if (_dicData.length>0) {
							bctvalue = true;
						}
		  			}, null, null, false);
			
			return bctvalue;
		};
		
		function getBctmuiddate(market,bctdate){
			var searchParam = {
			  		queryid   :"select_bcheckdate",
			  		"market"  : market,
			  		"bctdate" : bctdate
			  	};
			var bctvalue = false;
			itemLoader.doRequest(OmdUrl.mall, "mss.work.report.query",searchParam, null, null, 
					function(data) {
						var _dicData = data.report;
						if (_dicData.length>0) {
							bctvalue = true;
						}
		  			}, null, null, false);
			
			return bctvalue;
		}
		
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid").getValue();
			if (buttonEdit.name == "bctdate") {
				if (muid != "" && muid!= undefined) {
					e.searchParam.wherestr = " dbusrpub.Fgetwizardname(mktcode, 'MUCODE2') ='" + muid  + "'";
				}
			}
			var bctdate = mini.getbyName("bctdate").getValue();
			if (buttonEdit.name == "smfid") {
				if (muid == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = " spflag = 'Y'  and  sylx='01' and muid = '"+ muid +"'";
				if(bctdate != "" && bctdate != undefined){
					e.searchParam.wherestr += " and oid in(select cmfmfid from dbusrmkt.chkmfid where cmfdate = to_date('"+ bctdate +"','yyyy-MM-dd'))";
				}
			}
			if (buttonEdit.name == "emfid") {
				var smfid = mini.getbyName("smfid").getValue();
				if (smfid  == "") {
					mini.alert("请先选择起始柜组");
					return -1;
				}
				e.searchParam.wherestr = " spflag = 'Y'  and  sylx='01' and muid = '"+ muid +"'";
				if(bctdate != "" && bctdate != undefined){
					e.searchParam.wherestr += " and oid in(select cmfmfid from dbusrmkt.chkmfid where cmfdate = to_date('"+ bctdate +"','yyyy-MM-dd'))";
				}
			}			
			return 0;
		}
		
		function head_itemchanged_muid(e,data){
			mini.getbyName("bctdate").setValue("");
		    mini.getbyName("bctdate").setText("");
			mini.getbyName("smfid").setValue("");
			mini.getbyName("smfid").setText("");
			mini.getbyName("emfid").setValue("");
			mini.getbyName("emfid").setText("");
			mini.getbyName("cmfseq").setValue("");
			mini.getbyName("bcttype").setValue("");
			return 0;
		}
		
		function head_itemchanged_bctdate(e,data){
			if(data.length>0){
				mini.getbyName("cmfseq").setValue(data[0].seq);
				mini.getbyName("bcttype").setValue(data[0].bcttypecode);
				var muid = mini.getbyName("muid").getValue();	
				if(muid == ""||muid=="undefined"){
					mini.getbyName("muid").setValue(data[0].mktid);
					mini.getbyName("muid").setText(data[0].mktcode);
				}
			}else{
				mini.getbyName("cmfseq").setValue("");
				mini.getbyName("bcttype").setValue("");
			}
			return 0;
		}

		function head_itemchanged_smfid(e,data){
			mini.getbyName("smfid").setText(data[0].spid_name);
			mini.getbyName("emfid").setValue(data[0].code);
			mini.getbyName("emfid").setText(data[0].spid_name);
			return 0;
		}
		
		function head_itemchanged_emfid(e,data){
			mini.getbyName("emfid").setText(data[0].spid_name);
			return 0;
		}
		
		function onDrawSummaryCell(e){
			var rows = e.data
			var pdsl = 0; 
			var kcsl = 0;
			var cysl = 0; 
			var pdhsjjje = 0;
			var kchsjjje = 0;
			var cyhsjjje = 0;
			var pdbhsjjje = 0;
			var kcbhsjjje = 0;
			var cybhsjjje = 0;
			var pdhssjje = 0;
			var kchssjje = 0;
			var cysjje = 0;			
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.pdsl) == false) {
						pdsl += parseFloat(row.pdsl);
					}
					if (isNaN(row.kcsl) == false) {
						kcsl += parseFloat(row.kcsl);
					}
					if (isNaN(row.cysl) == false) {
						cysl += parseFloat(row.cysl);
					}
					if (isNaN(row.pdhsjjje) == false) {
						pdhsjjje += parseFloat(row.pdhsjjje);
					}
					if (isNaN(row.kchsjjje) == false) {
						kchsjjje += parseFloat(row.kchsjjje);
					}
					if (isNaN(row.cyhsjjje) == false) {
						cyhsjjje += parseFloat(row.cyhsjjje);
					}
					if (isNaN(row.pdbhsjjje) == false) {
						pdbhsjjje += parseFloat(row.pdbhsjjje);
					}
					if (isNaN(row.kcbhsjjje) == false) {
						kcbhsjjje += parseFloat(row.kcbhsjjje);
					}
					if (isNaN(row.cybhsjjje) == false) {
						cybhsjjje += parseFloat(row.cybhsjjje);
					}
					if (isNaN(row.pdhssjje) == false) {
						pdhssjje += parseFloat(row.pdhssjje);
					}
					if (isNaN(row.kchssjje) == false) {
						kchssjje += parseFloat(row.kchssjje);
					}
					if (isNaN(row.cysjje) == false) {
						cysjje += parseFloat(row.cysjje);
					}
				}
			}

			if (e.field == "ppcode_name") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "pdsl") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(pdsl),"#,0.0000")+"</b>";
			}
			if (e.field == "kcsl") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(kcsl),"#,0.0000")+"</b>";
			}
			if (e.field == "cysl") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(cysl),"#,0.0000")+"</b>";
			}
			if (e.field == "pdhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(pdhsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "kchsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(kchsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "cyhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(cyhsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "pdbhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(pdbhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "kcbhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(kcbhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "cybhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(cybhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "pdhssjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(pdhssjje),"#,0.00")+"</b>";
			}
			if (e.field == "kchssjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(kchssjje),"#,0.00")+"</b>";
			}
			if (e.field == "cysjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(cysjje),"#,0.00")+"</b>";
			}
			e.cellStyle = "text-align:right";  
		}
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>