<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>错漏盘商品清单</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='K10409';
		
		var dicData = OcmControl.getDict("STOCKMD","code,name,ddvalue") ||{};
		dicData.ISNOT = [{code:'Y',name:'是'} , {code:'N',name:'否'}];
		
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"initHeight":100,
			"properties" : {
				"id" : "formheader1",
			},
			items : [{"label" : "查询条件",
            	"type" : "fieldset",
            	"items" :[  {
					"label" : "门店：",
					"name" : "muid",
					"type" : "ButtonEdit",
					type : "fut_popselect",
					selectkey:"muid",
					textName :"muid_name", 
					"enabled" : true,
					"required" : "true",
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_muid",
					"style" : "width:22.5%",
				},{
					label : "盘点日期：",
					name : "bctdate",
					type : "ButtonEdit",
					required : true,
					defaultValue : "",
					type : "fut_popselect",
					selectkey:"pddate",
					textName : "bctdate",
					beforefunc:"head_beforefunc",
					itemchangedfunc:"head_itemchanged_bctdate", 
					allowInput : true,
					"enabled" : true,
					"style" : "width:22.5%",
				}, {
					"label" : "盘点序号：",
					"name" : "cmfseq",
					"type" : "TextBox",
					"enabled" : true,
					"readOnly" : true,
					"style" : "width:22.5%",
					 "visible" : false,
				}, {
					"label" : "柜组(起)：",
					"name" : "smfid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "selfspcode",//弹框类型
					textName : "smfid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_smfid", 
					"enabled" : true,
					"style" : "width:22.5%",
					"required" : "true",
			     }, {
					"label" : "柜组(止)：",
					"name" : "emfid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",
					selectkey : "selfspcode",
					textName : "emfid_name", 
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_emfid", 
					"enabled" : true,
					"style" : "width:22.5%",
					"required" : "true",
			     }, {
					"label" : "商品编码：",
					"type" : "TextBox",
					"name" : "gbid",
					"enabled" : true,
					"style" : "width:22.5%"
				},{
					"label" : "子库存：",
					"name" : "md",
					"type": "ComboBox",
					"defaultValue": "1",
					data: dicData.STOCKMD,
					"enabled" : true,
					"style" : "width:22.5%"
				},]}
			]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_K10409",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "spid_name", 
					header : "柜组",
					headerAlign : "center",
					width : 200,
				},{
					field : "errtype", 
					header : "错误类型",
					headerAlign : "center",
					width : 90,
				},{
					field : "md_name", 
					header : "子库存",
					headerAlign : "center",
					width : 90,
				},{
					field : "cksgdid", 
					header : "商品编码",
					headerAlign : "center",
					width : 100,
				},{
					field : "gbbarcode", 
					header : "商品条码",
					headerAlign : "center",
					width : 100,
				},{
					field : "ckssample", 
					header : "样品",
					headerAlign : "center",
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.ISNOT,
					/* allowSort : false, */
					width : 50,
			   },{
					field : "gbcname", 
					header : "商品名称",
					headerAlign : "center",
					width : 160,
				},{
					field : "ppcode_name", 
					header : "品牌",
					headerAlign : "center",
					width : 140,
				},{
					field: "bcdsj",
					header: "售价" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 120,
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "bcdsl",
					header: "盘点数量" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					excel:{
						  type:"n",
						  format:"0.0000",
						  align:"right"
						},
					width : 90,
				},{
					field: "ckskcsl",
					header: "库存数量" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					excel:{
						  type:"n",
						  format:"0.0000",
						  align:"right"
						},
					width : 90,
				},{
					field: "sl_cy",
					header: "数量差异" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					excel:{
						  type:"n",
						  format:"0.0000",
						  align:"right"
						},
					width : 90,
				},{
					field: "bcdsjje",
					header: "盘点售价金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "ckssjje",
					header: "库存售价金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "sjje_cy",
					header: "售价金额差异" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "cur_kcsl",
					header: "当前库存" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.0000",
						  align:"right"
						},
				},{
					field: "aft_kcsl",
					header: "预计校正后库存" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.0000",
						  align:"right"
						},
				}, ]
			},
		}; 
		 var tabs = {
	    			properties : {
						"id" : "tabs",
					},
					items : [{
						"title" : "明细",
						"name" : "gridbox1",
	 					"control" : gridbox1,
					}]
	       }
		   formheader1.tabs=tabs;
	       formheader1.tabsToolbar = false;
	       
		mini.parse();
		
		//盘点日检查
		function onDateChanged(e){
			var bctdate = mini.getbyName("bctdate").getValue();
			bctdate = mini.formatDate(e.value,"yyyy-MM-dd");
			var muid = mini.getbyName("muid").getValue();
			if (muid == undefined || muid == "") {
				/* mini.alert("请选择门店");
				mini.getbyName("bctdate").setValue("");
				return -1; */
				if (!getBctdate(bctdate)) {
					  mini.alert("["+bctdate+"]不是盘点日!");
					  mini.getbyName("bctdate").setValue("");
					  return;
				}
			}else{
				if (!getBctmuiddate(muid,bctdate)) {
					  mini.alert("["+bctdate+"]不是盘点日!");
					  mini.getbyName("bctdate").setValue("");
					  return;
				}
			}			
			
		};
		
		function getBctdate(bctdate){
			var searchParam = {
			  		queryid   :"select_bcheckdate",
			  		"bctdate" : bctdate
			  	};
			var bctvalue = false;
			itemLoader.doRequest(OmdUrl.mall, "mss.work.report.query",searchParam, null, null, 
					function(data) {
						var _dicData = data.report;
						if (_dicData.length>0) {
							bctvalue = true;
						}
		  			}, null, null, false);
			
			return bctvalue;
		};
		
		function getBctmuiddate(market,bctdate){
			var searchParam = {
			  		queryid   :"select_bcheckdate",
			  		"market"  : market,
			  		"bctdate" : bctdate
			  	};
			var bctvalue = false;
			itemLoader.doRequest(OmdUrl.mall, "mss.work.report.query",searchParam, null, null, 
					function(data) {
						var _dicData = data.report;
						if (_dicData.length>0) {
							bctvalue = true;
						}
		  			}, null, null, false);
			
			return bctvalue;
		}
		
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid").getValue();
			if (buttonEdit.name == "bctdate") {
				if (muid != "" && muid!= undefined) {
					e.searchParam.wherestr = " dbusrpub.Fgetwizardname(mktcode, 'MUCODE2') ='" + muid  + "'";
				}
			}
			var bctdate = mini.getbyName("bctdate").getValue();
			if (buttonEdit.name == "smfid") {
				if (muid == "") {
					mini.alert("请先选择门店");
					return -1;
				}
				e.searchParam.wherestr = " spflag = 'Y'  and  sylx='01'  and muid = '"+ muid +"'";
				if(bctdate != "" && bctdate != undefined){
					e.searchParam.wherestr += " and oid in(select cmfmfid from dbusrmkt.chkmfid where cmfdate = to_date('"+ bctdate +"','yyyy-MM-dd'))";
				}
			}
			if (buttonEdit.name == "emfid") {
				var smfid = mini.getbyName("smfid").getValue();
				if (smfid  == "") {
					mini.alert("请先选择起始柜组");
					return -1;
				}
				e.searchParam.wherestr = " spflag = 'Y'  and  sylx='01' and muid = '"+ muid +"'";
				if(bctdate != "" && bctdate != undefined){
					e.searchParam.wherestr += " and oid in(select cmfmfid from dbusrmkt.chkmfid where cmfdate = to_date('"+ bctdate +"','yyyy-MM-dd'))";
				}
			}			
			return 0;
		}
		
		function head_itemchanged_muid(e,data){
			mini.getbyName("bctdate").setValue("");
		    mini.getbyName("bctdate").setText("");
			mini.getbyName("smfid").setValue("");
			mini.getbyName("smfid").setText("");
			mini.getbyName("emfid").setValue("");
			mini.getbyName("emfid").setText("");
			return 0;
		}

		function head_itemchanged_bctdate(e,data){
			if(data.length>0){
				mini.getbyName("cmfseq").setValue(data[0].seq);
				var muid = mini.getbyName("muid").getValue();	
				if(muid == ""||muid=="undefined"){
					mini.getbyName("muid").setValue(data[0].mktid);
					mini.getbyName("muid").setText(data[0].mktcode);
				}
				mini.getbyName("smfid").setValue("");
				mini.getbyName("smfid").setText("");
				mini.getbyName("emfid").setValue("");
				mini.getbyName("emfid").setText("");
			}
			return 0;
		}
		
		function head_itemchanged_smfid(e,data){
			mini.getbyName("smfid").setText(data[0].spid_name);
			mini.getbyName("emfid").setValue(data[0].code);
			mini.getbyName("emfid").setText(data[0].spid_name);
			return 0;
		}
		
		function head_itemchanged_emfid(e,data){
			mini.getbyName("emfid").setText(data[0].spid_name);
			return 0;
		}
		
		function onDrawSummaryCell(e){
			var rows = e.data
			var sl_cy = 0; 
			var sjje_cy = 0;	
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.sl_cy) == false) {
						sl_cy += parseFloat(row.sl_cy);
					}
					if (isNaN(row.sjje_cy) == false) {
						sjje_cy += parseFloat(row.sjje_cy);
					}					
				}
			}

			if (e.field == "ppcode_name") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "sl_cy") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(sl_cy),"#,0.0000")+"</b>";
			}
			if (e.field == "sjje_cy") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(sjje_cy),"#,0.00")+"</b>";
			}
			e.cellStyle = "text-align:right";  
		}
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>