<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>盘点损溢明细</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid = "K10410";
		var dictData = OcmControl.getDict("WMID,STOCKMD","code,name,ddvalue") ||{};

		var wmid = [ {
			code : '1',
			name : '经销',
			ddvalue : '[1]经销'
		}, {
			code : '2',
			name : '成本代销',
			ddvalue : '[2]成本代销'
		}, {
			code : '3',
			name : '扣率代销',
			ddvalue : '[3]扣率代销'
		} ];

		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};

		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [ {
				"label" : "查询条件",
				"type" : "fieldset",
				"items" : [ {
					"label" : "门店：",
					"name" : "muid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "muid",//弹框类型
					textName : "muid_name", //文本显示字段
					"enabled" : true,
					required : true,
					"style" : "width:22.5%",
				}, {
					label : "盘点日期：",
					name : "bchpddate",
					type : "ButtonEdit",
					required : true,
					defaultValue : "",
					type : "fut_popselect",
					selectkey : "pddate2",
					textName : "bchpddate",
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_bctdate",
					allowInput : true,
					"enabled" : true,
					"style" : "width:22.5%",
				}, {
					"label" : "记账日期(起)：",
					"type" : "DatePicker",
					"name" : "sinputdate",
					"format" : "yyyy-MM-dd",
					allowInput : true,
					"enabled" : true,
					"style" : "width:22.5%"
				}, {
					"label" : "记账日期(止)：",
					"type" : "DatePicker",
					"name" : "einputdate",
					"format" : "yyyy-MM-dd",
					allowInput : true,
					"enabled" : true,
					"style" : "width:22.5%"
				},{
					"label" : "盘点单号：",
					"type" : "TextBox",
					"name" : "pddh",
					"enabled" : true,
					"style" : "width:22.5%"
				}, {
					"label" : "柜组：",
					"name" : "mfid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "selfspid",//弹框类型
					textName : "mfid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%"
				}, {
					"label" : "商品编码：",
					"type" : "TextBox",
					"name" : "gdid",
					"enabled" : true,
					"style" : "width:22.5%"
				},  {
					"label" : "商品条码：",
					"type" : "TextBox",
					"name" : "barcode",
					"enabled" : true,
					"style" : "width:22.5%"
				}, {
					"label" : "经营方式：",
					"name" : "wmid",
					textName : "wmid_name",
					"type" : "ComboBox",
					"data" : wmid,
					"valueField" : "code",
					"textField" : "name",
					"enabled" : true,
					"renderer" : "OcmControl.dictRendererWithCode",
					"style" : "width:22.5%"
				}, {
					"label" : "供应商：",
					"name" : "supid",
					displayField : "supid_name",
					type : "fut_popselect",
					selectkey : "selfsbid",
					textName : "supid_name",
					responseName : "supid",
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%"
				}, ]
			} ]
		};

		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mall,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid" : "select_K10410",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				}, {
					field : "pddh",
					header : "盘点单号",
					allowSort : true,
					headerAlign : "center",
					align : "left",
					width : 160,
				}, {
					field : "gdid",
					header : "商品编码",
					allowSort : true,
					headerAlign : "center",
					align : "left",
				}, {
					field : "barcode",
					header : "商品条码",
					allowSort : true,
					headerAlign : "center",
					align : "left",
					width : 130,
				}, {
					field : "cname",
					header : "商品名称",
					allowSort : true,
					headerAlign : "center",
					align : "left",
					width : 200,
				}, {
					field : "muid_name",
					header : "门店",
					allowSort : true,
					headerAlign : "center",
					align : "left",
					width : 200,
				}, {
					field : "spid_name",
					header : "柜组",
					allowSort : true,
					headerAlign : "center",
					align : "left",
					width : 200,
				}, {
					field : "md",
					header : "子库存",
					allowSort : true,
					headerAlign : "center",
					renderer : "OcmControl.dictRendererWithCode",
					data : dictData.STOCKMD,
					align : "left",
				}, {
					field : "mid_name",
					header : "商品分类",
					allowSort : true,
					headerAlign : "center",
					align : "left",
					width : 150,
				}, {
					field : "supid_name",
					header : "供应商",
					allowSort : true,
					headerAlign : "center",
					align : "left",
					width : 150,
				}, {
					field : "wmid",
					header : "经营方式",
					allowSort : true,
					headerAlign : "center",
					renderer : "OcmControl.dictRendererWithCode",
					data : dictData.WMID,
					align : "left",
				}, {
					field : "hsjj",
					header : "进价",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					numberFormat : "n2",
				}, {
					field : "sj",
					header : "售价",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					numberFormat : "n2",
				}, {
					field : "sl",
					header : "损益数量",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					numberFormat : "n0",
				}, {
					field : "hsjjje",
					header : "损益含税进价金额",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					numberFormat : "n2",
					width : 130,
				}, {
					field : "bhsjjje",
					header : "损益不含税进价金额",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					numberFormat : "n4",
					width : 130,
				}, {
					field : "sjje",
					header : "损益金额",
					allowSort : true,
					headerAlign : "center",
					align : "right",
					numberFormat : "n2",
				} ]
			},
		};

		mini.parse();

		function head_beforefunc(e) {
			var buttonEdit = e.sender;
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var buttonEdit = e.sender;

			if (e.value != "undefined" && e.value != "") {
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid").getValue("");
			if (buttonEdit.name == "mfid") {
				if (muid == "") {
					mini.alert("请先选择门店");
					return -1;
				} else {
					e.searchParam.muid = muid;
					e.searchParam.wherestr = "Nvl(Sylx,'02')='01'  and Spstatus In ('E','Y') and oid in (select spid from shoplist where muid ='"
							+ muid + "') ";
				}
			}
			if (buttonEdit.name == "bchpddate") {
				if (muid == "") {
					mini.alert("请先选择门店");
					return -1;
				}else{
					e.searchParam.mktid = muid;
				} 
			}
			return 0;
		}

		function head_itemchanged_bctdate(e, data) {
			if (data.length > 0) {
				var muid = mini.getbyName("muid").getValue();
				if (muid == "" || muid == "undefined") {
					mini.getbyName("muid").setValue(data[0].mktid);
					mini.getbyName("muid").setText(data[0].mktcode);
				}
			}
			return 0;
		}
		
		function onDrawSummaryCell(e){
			var rows = e.data
			var sl = 0;
			var hsjjje = 0; 
			var bhsjjje = 0;
			var sjje = 0;
						
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.sl) == false) {
						sl += parseFloat(row.sl);
					}
					if (isNaN(row.hsjjje) == false) {
						hsjjje += parseFloat(row.hsjjje);
					}
					if (isNaN(row.bhsjjje) == false) {
						bhsjjje += parseFloat(row.bhsjjje);
					}
					if (isNaN(row.sjje) == false) {
						sjje += parseFloat(row.sjje);
					}
				}
			}

			if (e.field == "pddh") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "sl") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(sl),"#,0")+"</b>";
			}
			if (e.field == "hsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(hsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "bhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(bhsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "sjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(sjje),"#,0.00")+"</b>";
			}
			e.cellStyle = "text-align:right";  
		}
	</script>
	<script src="report.js" type="text/javascript"></script>
</body>
</html>