<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>商品进销存明细表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='K10603';
		
		//字典数据初始化
		var dictData = OcmControl.getDict("WMID,STOCKMD","code,name,ddvalue") || {};
		dictData.wmid = [{code: '1',name: '经销',ddvalue: '[1]经销'},{code: '2',name: '成本代销',ddvalue: '[2]成本代销'},{code: '3',name: '扣率代销',ddvalue: '[3]扣率代销'}];
		dictData.ISNOT = [{code:'Y',name:'是'} , {code:'N',name:'否'}];
		
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"initHeight":100,
			"properties" : {
				"id" : "formheader1",
			},
			items : [{"label" : "查询条件",
            	"type" : "fieldset",
            	"items" :[ {
			       	 "label" : "发生日期(起)：",
			         "type" : "DatePicker",
			         "name" : "fssdate",
			         "format" : "yyyy-MM-dd",
			          "required" : "true",
			         "enabled" : true,
			          "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"), 
			         "style" : "width:22.5%",
			      }, {
			         "label" : "发生日期(止)：",
			         "type" : "DatePicker",
			         "name" : "fsedate",
			         "format" : "yyyy-MM-dd",
			          "required" : "true", 
			         "enabled" : true,
			          "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"), 
			         "style" : "width:22.5%",
			      },{
			       	 "label" : "记账日期(起)：",
			         "type" : "DatePicker",
			         "name" : "jzsdate",
			         "format" : "yyyy-MM-dd",
			          /* "required" : "true", */
			         "enabled" : true,
			         /*  "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),  */
			         "style" : "width:22.5%",
			      }, {
			         "label" : "记账日期(止)：",
			         "type" : "DatePicker",
			         "name" : "jzedate",
			         "format" : "yyyy-MM-dd",
			          /* "required" : "true",  */
			         "enabled" : true,
			          /* "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),  */
			         "style" : "width:22.5%",
			      },{
					 "label" : "商品编码：",
					 "type" : "TextBox",
					 "name" : "gbid",
					 /* "required" : "true", */
					 "enabled" : true,
					 "style" : "width:22.5%",
				  },{
					 "label" : "商品条码：",
					 "type" : "TextBox",
					 "name" : "gbbarcode",
					 "enabled" : true,
					 "style" : "width:22.5%",
				  },{
					 "label" : "商品名称：",
					 "type" : "TextBox",
					 "name" : "gbname",
					 "enabled" : true,
					 "style" : "width:22.5%",
				   },{
					 "label" : "子库存：",
					 "name" : "md",
					 "type": "ComboBox",
					 "defaultValue": "1",
					 data: dictData.STOCKMD,
					 "enabled" : true,
					 "style" : "width:22.5%"
				 },{
					"label" : "门店：",
					"name" : "muid",
					"type" : "ButtonEdit",
					type : "fut_popselect",
					selectkey:"muid",
					textName :"muid_name", 
					"enabled" : true,
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_muid",
					"style" : "width:22.5%",
				}, {
					"label" : "柜组：",
					"name" : "mfid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "spid",//弹框类型
					textName : "sbid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%",
			     },{
					"label" : "供应商：",
					"name" : "supid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "sbid",//弹框类型
					textName : "sbid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%",
			     },{
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "wmid",
					"enabled" : true,
					"data" : dictData.wmid,
					"style" : "width:22.5%",
				}]}
			]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_K10603",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "muid_name", 
					header : "门店",
					headerAlign : "center",
					width : 150,
				},{
					field : "spid_name", 
					header : "柜组",
					headerAlign : "center",
					width : 200,
				},{
					field : "sbid_name", 
					header : "供应商",
					headerAlign : "center",
					width : 200,
				},{
					field : "gbcname", 
					header : "商品名称",
					headerAlign : "center",
					width : 150,
				},{
					field : "jglgdid", 
					header : "商品编码",
					headerAlign : "center",
					width : 90,
				},{
					field : "gbbarcode", 
					header : "商品条码",
					headerAlign : "center",
					width : 100,
				},{
					field : "md", 
					header : "子库存",
					headerAlign : "center",
					width : 80,
				},{
					field : "jgldate", 
					header : "记账日期",
					headerAlign : "center",
					width : 85,
				},{
					field : "jgltranname", 
					header : "摘要",
					headerAlign : "center",
					width : 80,
				},{
					field: "jglhsjj",
					header: "含税进价" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 80,
					align:"right",
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "jglsj",
					header: "售价" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 80,
					align:"right",
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field : "wmid", 
					header : "经营方式",
					headerAlign : "center",
					width : 90,
				},{
					field : "jglsample", 
					header : "样品",
					headerAlign : "center",
					renderer : "OcmControl.dictRendererWithCode",
					data : dictData.ISNOT,
					width : 50,
			   },{
					field : "jglbatchseq", 
					header : "批次序号",
					headerAlign : "center",
					width : 80,
				},{
					header : "增",
					allowSort : true,
					headerAlign : "center",
					"columns" : [{
								field: "jglsld",
								header: "数量 " ,
								headerAlign : "center",	
								editor : OcmControl.newControl('NumButtonEdit'),
								editorSet:{format: "n4",},
								numberFormat:"n4",
								width : 120,
								align:"right",
								excel:{
									  type:"n",
									  format:"0.0000",
									  align:"right"
									},
							},{
								field: "jglhsjjjed",
								header: "含税进价金额" ,
								headerAlign : "center",	
								editor : OcmControl.newControl('NumButtonEdit'),
								editorSet:{format: "n2",},
								numberFormat:"n2",
								align:"right",
								excel:{
									  type:"n",
									  format:"0.00",
									  align:"right"
									},
								width : 120,
							 },{
								field: "jglbhsjjjed",
								header: "不含税进价金额" ,
								headerAlign : "center",	
								editor : OcmControl.newControl('NumButtonEdit'),
								editorSet:{format: "n4",},
								numberFormat:"n4",
								align:"right",
								excel:{
									  type:"n",
									  format:"0.0000",
									  align:"right"
									},
								width : 120,
							 }]
				},{
					header : "减",
					allowSort : true,
					headerAlign : "center",
					"columns" : [{
								field: "jglslc",
								header: "数量 " ,
								headerAlign : "center",	
								editor : OcmControl.newControl('NumButtonEdit'),
								editorSet:{format: "n4",},
								numberFormat:"n4",
								width : 120,
								align:"right",
								excel:{
									  type:"n",
									  format:"0.0000",
									  align:"right"
									},
							},{
								field: "jglhsjjjec",
								header: "含税进价金额" ,
								headerAlign : "center",	
								editor : OcmControl.newControl('NumButtonEdit'),
								editorSet:{format: "n2",},
								numberFormat:"n2",
								align:"right",
								excel:{
									  type:"n",
									  format:"0.00",
									  align:"right"
									},
								width : 120,
							 },{
								field: "jglbhsjjjec",
								header: "不含税进价金额" ,
								headerAlign : "center",	
								editor : OcmControl.newControl('NumButtonEdit'),
								editorSet:{format: "n4",},
								numberFormat:"n4",
								align:"right",
								excel:{
									  type:"n",
									  format:"0.0000",
									  align:"right"
									},
								width : 120,
							 }]
				},{
					header : "存",
					allowSort : true,
					headerAlign : "center",
					"columns" : [{
								field: "jglqmsl",
								header: "数量 " ,
								headerAlign : "center",	
								editor : OcmControl.newControl('NumButtonEdit'),
								editorSet:{format: "n4",},
								numberFormat:"n4",
								width : 120,
								align:"right",
								excel:{
									  type:"n",
									  format:"0.0000",
									  align:"right"
									},
							},{
								field: "jglqmhscbje",
								header: "含税成本金额" ,
								headerAlign : "center",	
								editor : OcmControl.newControl('NumButtonEdit'),
								editorSet:{format: "n2",},
								numberFormat:"n2",
								align:"right",
								excel:{
									  type:"n",
									  format:"0.00",
									  align:"right"
									},
								width : 120,
							 },{
								field: "jglqmbhscbje",
								header: "不含税成本金额" ,
								headerAlign : "center",	
								editor : OcmControl.newControl('NumButtonEdit'),
								editorSet:{format: "n4",},
								numberFormat:"n4",
								align:"right",
								excel:{
									  type:"n",
									  format:"0.0000",
									  align:"right"
									},
								width : 120,
							 }]
				},{
					field : "memo", 
					header : "备注",
					headerAlign : "center",
					width : 240,
				},{
					field : "gbspec", 
					header : "规格",
					headerAlign : "center",
					width : 90,
				},{
					field : "gbcshh", 
					header : "厂商货号",
					headerAlign : "center",
					width : 90,
				}]
			},
		}; 	       
		mini.parse();
		
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid").getValue();
			if (buttonEdit.name == "supid") {
				/* e.searchParam.wherestr  = " (sbwmid1 ='Y' or sbwmid2 = 'Y' or sbwmid3 = 'Y') "; */
				if (muid != "undefined" && muid != ""){
				   e.searchParam.wherestr  = " sbid in(select sbid from supmkt where muid = '"+ muid +"')";
				}
			}
			if (buttonEdit.name == "mfid") {
				if (muid != "undefined" && muid != ""){
				   e.searchParam.wherestr  = "  muid = '"+ muid +"'";
				}
			}	
			return 0;
		}
		
		function head_itemchanged_muid(e,data){
			mini.getbyName("supid").setValue("");
			mini.getbyName("supid").setText("");
			mini.getbyName("mfid").setValue("");
			mini.getbyName("mfid").setText("");
			return 0;
		}
		
		function onDrawSummaryCell(e){
			var rows = e.data
			var jglsld = 0;       var jglhsjjjed = 0;	    var jglbhsjjjed = 0; 	  
			var jglslc = 0;       var jglhsjjjec = 0;	    var jglbhsjjjec = 0;       
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.jglsld) == false) {
						jglsld += parseFloat(row.jglsld);
					}
					if (isNaN(row.jglhsjjjed) == false) {
						jglhsjjjed += parseFloat(row.jglhsjjjed);
					}	
					if (isNaN(row.jglbhsjjjed) == false) {
						jglbhsjjjed += parseFloat(row.jglbhsjjjed);
					}
					if (isNaN(row.jglslc) == false) {
						jglslc += parseFloat(row.jglslc);
					}
					if (isNaN(row.jglhsjjjec) == false) {
						jglhsjjjec += parseFloat(row.jglhsjjjec);
					}
					if (isNaN(row.jglbhsjjjec) == false) {
						jglbhsjjjec += parseFloat(row.jglbhsjjjec);
					}			
				}
			}

			if (e.field == "jgldate") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "jglsld") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jglsld),"#,0.0000")+"</b>";
			}
			if (e.field == "jglhsjjjed") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jglhsjjjed),"#,0.00")+"</b>";
			}
			if (e.field == "jglbhsjjjed") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(jglbhsjjjed),"#,0.0000")+"</b>";
			}
			if (e.field == "jglslc") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jglslc),"#,0.0000")+"</b>";
			}
			if (e.field == "jglhsjjjec") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jglhsjjjec),"#,0.00")+"</b>";
			}
			if (e.field == "jglbhsjjjec") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(jglbhsjjjec),"#,0.0000")+"</b>";
			}
			e.cellStyle = "text-align:right";  
		}
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>