<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>SPU码商品销售与库存周转分析</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='K10607';
		
		//字典数据初始化
		var dictData = OcmControl.getDict("WMID","code,name,ddvalue") || {};
		dictData.wmid = [{code: '1',name: '经销',ddvalue: '[1]经销'},{code: '2',name: '成本代销',ddvalue: '[2]成本代销'},{code: '3',name: '扣率代销',ddvalue: '[3]扣率代销'}];
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"initHeight":100,
			"properties" : {
				"id" : "formheader1",
			},
			items : [{
				"label" : "记账日期(起)：",
				"type" : "DatePicker",
				"name" : "sdate",
				"format" : "yyyy-MM-dd",
				"required" : "true",
				"enabled" : true,
				"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"style" : "width:22.5%",
			}, {
				"label" : "记账日期(止)：",
				"type" : "DatePicker",
				"name" : "edate",
				"format" : "yyyy-MM-dd",
				"required" : "true",
				"enabled" : true,
				"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"style" : "width:22.5%",
			},{
					"label" : "门店：",
					"name" : "muid",
					"type" : "ButtonEdit",
					type : "fut_popselect",
					selectkey:"muid",
					textName :"muid_name",
					"enabled" : true,
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_muid",
					"style" : "width:22.5%",
				}, {
					"label" : "楼层：",
					"name" : "floor",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
				    selectkey : "rankmmfid",
				    textName : "[" + "MMFCODE" + "]" + "MMFCNAME",
				    beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%",
				},{
					"label" : "柜组：",
					"name" : "mfid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "spid",//弹框类型
					textName : "sbid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%",
				},{
					 "label" : "SPU码：",
					 "type" : "TextBox",
					 "name" : "gbid",
					 "enabled" : true,
					 "style" : "width:22.5%",
				  },{
					 "label" : "厂商货号：",
					 "name" : "cshh",
					 "type": "TextBox",
					 "enabled" : true,
					 "style" : "width:22.5%"
				 },{
					"label" : "供应商：",
					"name" : "supid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "selfsbid",//弹框类型
					textName : "name", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%",
			     },{
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "wmid",
					"enabled" : true,
					"data" : dictData.wmid,
					"style" : "width:22.5%",
				},{
				    "label" : "品牌：",
					"type" : "ButtonEdit",
					"name" : "ppcode",
					"enabled" : true,
				     type : "fut_popselect",
				     selectkey:"ppcode",
				     textName :"ppcode_name",
					"style" : "width:22.5%",
		         },{
			     	label : "说明字段：",
				    type : "TextBox",
				      id : "text1",
				    name : "text1",
			     	readOnly : "true",
			   	   "style" : "width:50%",
			}]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_K10607",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawcell": "Drawcellcolor",
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "mktname",
					header : "门店",
					headerAlign : "center",
					width : 150,
				},{
					field : "floorname",
					header : "楼层",
					headerAlign : "center",
					width : 130,
				},{
					field : "spname",
					header : "柜组",
					headerAlign : "center",
					width : 150,
				},{
					field : "sbid_name", 
					header : "供应商",
					headerAlign : "center",
					width : 200,
				},{
					field : "gbanalcode",
					header : "SPU码",
					headerAlign : "center",
					width : 90,
				},{
					field : "gbcshh",
					header : "厂商货号",
					headerAlign : "center",
					width : 80,
				},{
					field : "ppname",
					header : "品牌",
					headerAlign : "center",
					width : 150,
				},{
					field : "jgdgdid",
					header : "商品子码",
					headerAlign : "center",
					width : 90,
				},{
					field : "gbcname",
					header : "商品子码名称",
					headerAlign : "center",
					width : 200,
				},{
					field : "gbspec",
					header : "规格",
					headerAlign : "center",
					width : 50,
				},{
					field: "xssl",
					header: "销售数量 " ,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 70,
					align:"right",
					excel:{
						type:"n",
						format:"0.00",
						align:"right"
					},
				},{
					field: "xsjj",
					header: "销售含税总金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 100,
					align:"right",
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "xscb",
					header: "销售成本含税" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 100,
					align:"right",
					excel:{
						  type:"n",
						  format:"0.00",
						  align:"right"
						},
				},{
					field: "xsml",
					header: "销售毛利率" ,
					headerAlign : "center",
					numberFormat : "p2",
					align:"right",
					width : 70,
				},{
					field: "dqkcs",
					header: "当前库存数 " ,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 70,
					align:"right",
					excel:{
						   type:"n",
						   format:"0.00",
						   align:"right"
					      },
				},{
					field: "jhsl",
					header: "商品库存数 " ,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 70,
					align:"right",
					excel:{
						type:"n",
						format:"0.00",
						align:"right"
					},
				},{
					field: "gdidsql",
					header: "商品售罄率" ,
					headerAlign : "center",
					numberFormat : "p2",
					align:"right",
					width : 70,
				},{
					field: "jhje",
					header: "本期库存总金额" ,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					align:"right",
					excel:{
						    type:"n",
						    format:"0.00",
						    align:"right"
					      },
								width : 100,
				  },{
					field: "pjkc",
					header: "平均库存数 " ,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 70,
					align:"right",
					excel:{
						type:"n",
						format:"0.00",
						align:"right"
					},
				},{
					field: "zzcs",
					header: "存货周转次数 " ,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					width : 70,
					align:"right",
					excel:{
						type:"n",
						format:"0.00",
						align:"right"
					},
				}]
			},
		}; 	       
		mini.parse();
		$("#text1").html("<div style='color: blue; margin-left:63px;margin-top:2px;'>说明：售罄率<65%红色标识,表示库存积压；售罄率>85%绿色标识,表示进货量太少;</div>");
		//红：售罄率<65%
		//绿：售罄率>85%
		function Drawcellcolor(e){
			if(e.row.gdidsql < 0.65){
				e.rowStyle = 'color:#f00';
			}else if(e.row.gdidsql > 0.85){
				e.rowStyle = 'color:#84bf96';
				//e.rowStyle = 'color:#f100';
			}
			return e.value;
		}
		
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid").getValue();
			if (buttonEdit.name == "supid") {
				if (muid != "undefined" && muid != ""){
				   e.searchParam.wherestr  = " sbid in(select sbid from supmkt where muid = '"+ muid +"')";
				}
			}
			if (buttonEdit.name == "floor") {
				if (muid != "undefined" && muid != ""){
				//	e.searchParam.wherestr  = "  muid = '"+ muid +"'";
					e.searchParam.muid = muid;
				}
				else{
					mini.alert("请先选择门店");
					return -1;
				}
			}
			if (buttonEdit.name == "mfid") {
				if (muid != "undefined" && muid != ""){
					e.searchParam.wherestr = "  muid = '" + muid + "' and sylx = '01' ";
				}
				else{
					mini.alert("请先选择门店");
					return -1;
				}
			}	
			return 0;
		}
		
		function head_itemchanged_muid(e,data){
			mini.getbyName("supid").setValue("");
			mini.getbyName("supid").setText("");
			mini.getbyName("mfid").setValue("");
			mini.getbyName("mfid").setText("");
			return 0;
		}
		
		function onDrawSummaryCell(e){
			var rows = e.data
			var xssl = 0;       var xsjj = 0;	    var xscb = 0;
			var dqkcs = 0;       var jhje = 0;	    var pjkc = 0;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.xssl) == false) {
						xssl += parseFloat(row.xssl);
					}
					if (isNaN(row.xsjj) == false) {
						xsjj += parseFloat(row.xsjj);
					}	
					if (isNaN(row.xscb) == false) {
						xscb += parseFloat(row.xscb);
					}
					if (isNaN(row.dqkcs) == false) {
						dqkcs += parseFloat(row.dqkcs);
					}
					if (isNaN(row.jhje) == false) {
						jhje += parseFloat(row.jhje);
					}
					if (isNaN(row.pjkc) == false) {
						pjkc += parseFloat(row.pjkc);
					}			
				}
			}

			if (e.field == "gbspec") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "xssl") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(xssl),"#,0.00")+"</b>";
			}
			if (e.field == "xsjj") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(xsjj),"#,0.00")+"</b>";
			}
			if (e.field == "xscb") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(xscb),"#,0.0000")+"</b>";
			}
			if (e.field == "dqkcs") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(dqkcs),"#,0.00")+"</b>";
			}
			if (e.field == "jhje") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(jhje),"#,0.0000")+"</b>";
			}
			if (e.field == "pjkc") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(pjkc),"#,0.00")+"</b>";
			}
			e.cellStyle = "text-align:right";  
		}
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>