<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>柜组商品动销率</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='K10608';
		
		//字典数据初始化
		var dictData = OcmControl.getDict("WMID","code,name,ddvalue") || {};
		dictData.wmid = [{code: '1',name: '经销',ddvalue: '[1]经销'},{code: '2',name: '成本代销',ddvalue: '[2]成本代销'},{code: '3',name: '扣率代销',ddvalue: '[3]扣率代销'}];
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
			"type" : "formgrid",
			"initHeight":100,
			"properties" : {
				"id" : "formheader1",
			},
			items : [{
				"label" : "发生日期(起)：",
				"type" : "DatePicker",
				"name" : "sdate",
				"format" : "yyyy-MM-dd",
				"required" : "true",
				"enabled" : true,
				"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"style" : "width:22.5%",
			}, {
				"label" : "发生日期(止)：",
				"type" : "DatePicker",
				"name" : "edate",
				"format" : "yyyy-MM-dd",
				"required" : "true",
				"enabled" : true,
				"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"style" : "width:22.5%",
			},{
					"label" : "门店：",
					"name" : "muid",
					"type" : "ButtonEdit",
					type : "fut_popselect",
					selectkey:"muid",
					textName :"muid_name",
					"enabled" : true,
					beforefunc : "head_beforefunc",
					itemchangedfunc : "head_itemchanged_muid",
					"style" : "width:22.5%",
				},{
					"label" : "柜组：",
					"name" : "mfid",
					"type" : "ButtonEdit",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey : "spid",//弹框类型
					textName : "sbid_name", //文本显示字段
					beforefunc : "head_beforefunc",
					"enabled" : true,
					"style" : "width:22.5%",
				},{
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "wmid",
					"enabled" : true,
					"data" : dictData.wmid,
					"style" : "width:22.5%",
				},{
				    "label" : "品类: ",
					"name" : "catcode",
				    "defaultValue" : "",
			    	type : "fut_popselect",//类型
			    	selectkey : "goodscat",//弹框类型
			    	textName : "gbcatcode_name", //文本显示字段
			    	"enabled" : true,
			    	"style" : "width:22.5%"
		}]
		};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_K10608",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "mktname",
					header : "门店",
					headerAlign : "center",
					width : 150,
				},{
					field : "spname",
					header : "柜组",
					headerAlign : "center",
					width : 150,
				},{
					field : "catname",
					header : "品类",
					headerAlign : "center",
					width : 150,
				},{
					field : "wmid_name",
					header : "经营方式",
					headerAlign : "center",
					width : 150,
				},{
					field: "countsl",
					header: "商品品项总数 " ,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 70,
					align:"right",
					excel:{
						type:"n",
						format:"0.00",
						align:"right"
					},
				},{
					field: "dxl",
					header: "动销率" ,
					headerAlign : "center",
					numberFormat : "p2",
					align:"right",
					width : 70
				}]
			},
		};

		mini.parse();
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid").getValue();
			if (buttonEdit.name == "mfid") {
				if (muid != "undefined" && muid != ""){
					e.searchParam.wherestr = "  muid = '" + muid + "' and sylx = '01' ";
				}
				else{
					mini.alert("请先选择门店");
					return -1;
				}
			}	
			return 0;
		}
		
		function head_itemchanged_muid(e,data){
			mini.getbyName("mfid").setValue("");
			mini.getbyName("mfid").setText("");
			return 0;
		}
		
		function onDrawSummaryCell(e){
			var rows = e.data
			var countsl = 0;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.countsl) == false) {
						countsl += parseFloat(row.countsl);
					}
				}
			}

			if (e.field == "spname") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "countsl") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(countsl),"#,0.00")+"</b>";
			}

			e.cellStyle = "text-align:right";  
		}
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>