<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>SPU码商品低库存跟踪</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var moduleid ='K10611';
		
		//字典数据初始化
		var dicData = OcmControl.getDict("STOCKMD","code,name,ddvalue") ||{};
		var wmid = [{code: '1',name: '经销',ddvalue: '[1]经销'},{code: '2',name: '成本代销',ddvalue: '[2]成本代销'},{code: '3',name: '扣率代销',ddvalue: '[3]扣率代销'}];
		dicData.sample = [{code:'Y',name:'是'} , {code:'N',name:'否'}];
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
		
		var formheader1 = {
				"type" : "formgrid",
				"initHeight":100,
				"properties" : {
					"id" : "formheader1",
				},
				items : [{"label" : "查询条件",
	            	"type" : "fieldset",
	            	"items" :[  {
						"label" : "门店：",
						"name" : "muid",
						"type" : "ButtonEdit",
						type : "fut_popselect",
						selectkey:"muid",
						textName :"muid_name", 
						"enabled" : true,
						required : false,
						beforefunc : "head_beforefunc",
						itemchangedfunc : "head_itemchanged_muid",
						style : "width:22.5%",
					},{
						label : "供应商：",
						name : "supid",
						type : "fut_popselect",
						required : false,
						selectkey : "selfsbid",
						textName : "sbid_name",
						beforefunc:"head_beforefunc",
						enabled : true,
						style : "width:22.5%",
					},{
						"label" : "SPU码：",
						"type" : "TextBox",
						"name" : "gbanalcode",
						"enabled" : true,
						style : "width:22.5%",
					},{
						"label" : "厂商货号：",
						"type" : "TextBox",
						"name" : "gbcshh",
						"enabled" : true,
						style : "width:22.5%",
					},{
						"label" : "品牌：",
						"name" : "gbppcode",
						"enabled" : true,
						"defaultValue" : "",
						type : "fut_popselect",
						selectkey:"ppcode",
						textName :"ppcode_name",
						"style" : "width:22.5%",
					},{
						"label" : "商品分类：",
						"name" : "gbcatcode",
						"defaultValue" : "",
						type : "fut_popselect",//类型
						selectkey : "goodscat",//弹框类型
						textName : "gbcatcode_name", //文本显示字段
						"enabled" : true,
						style : "width:22.5%",
					}, {
						"label" : "库存数量小于：",
						"type" : "TextBox",
						"name" : "kcsl",
						"enabled" : true,
						"required" : true,
						style : "width:22.5%",
					}, ]}
				]
			};
		
		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_spudkcgz",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "muid_name", 
					header : "门店",
					headerAlign : "center",
					width : 150,
				},{
					field : "spu_code",      //Gbanalcode
					header : "SPU编码",
					headerAlign : "center",
					width : 150,
				},{
					field : "gdid", 
					header : "SKU编码",
					headerAlign : "center",
					width : 150,
				},{
					field : "gbbarcode", 
					header : "商品条码",
					headerAlign : "center",
					width : 150,
				},{
					field : "ppcode_name", 
					header : "品牌",
					headerAlign : "center",
					width : 150,
				},{
					field : "gbcname", 
					header : "商品名称",
					headerAlign : "center",
					width : 150,
				},{
					field : "gbspec", 
					header : "规格",
					headerAlign : "center",
					width : 50,
				},{
					field : "sbid_name", 
					header : "供应商",
					headerAlign : "center",
					width : 200,
				},{
					field : "gbcshh",
					header : "厂商货号",
					headerAlign : "center",
					width : 200,
				},{
					field: "hsjj",
					header: "含税进价" ,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					width : 140,
					excel:{
						type:"n",
						format:"0.0000",
						align:"right"
					},
				},{
					field : "kl",
					header : "扣率",
					headerAlign : "center",
					width : 100,
					numberFormat : "p2",
					align: "right",
				},{
					field: "sj",
					header: "售价" ,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2",},
					numberFormat:"n2",
					width : 140,
					excel:{
						type:"n",
						format:"0.00",
						align:"right"
					},
				},{
					field : "wmid_name",
					header : "经营方式",
					headerAlign : "center",
					width : 90,
				},{
					field: "kcsl",
					header: "库存数量" ,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					excel:{
						type:"n",
						format:"0.0000",
						align:"right"
					},
					width : 90,
				},{
					field: "kcbhsjjje",
					header: "库存不含税进价金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.0000",
						  align:"right"
						},
				},{
					field: "kchsjjje",
					header: "库存含税进价金额" ,
					headerAlign : "center",	
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n4",},
					numberFormat:"n4",
					width : 140,
					excel:{
						  type:"n",
						  format:"0.0000",
						  align:"right"
						},
				},]
			},
		}; 
		mini.parse();

		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid").getValue();
			if (buttonEdit.name == "supid") {
				if (muid !=undefined && muid != "") {
					e.searchParam.wherestr = " sbid IN (SELECT sbid FROM supmkt WHERE muid in ('" + muid  + "'))";
				}
			}
			
			if (buttonEdit.name == "bctdate") {
				if (muid != "" && muid!= undefined) {
					e.searchParam.wherestr = " dbusrpub.Fgetwizardname(mktcode, 'MUCODE2') ='" + muid  + "'";
				}
			}

			return 0;
		}
		
		function head_itemchanged_muid(e,data){
			mini.getbyName("supid").setText("");
			mini.getbyName("supid").setValue("");

			mini.getbyName("gbanalcode").setValue("");

			mini.getbyName("gbcshh").setValue("");
		    
			mini.getbyName("gbcatcode").setValue("");

			mini.getbyName("gbppcode").setValue("");
			
			mini.getbyName("kcsl").setValue("");
			
			//mini.getbyName("barcode").setValue("");
			return 0;
		}
		


		function onDrawSummaryCell(e){
			var rows = e.data
			var kcsl = 0;
			var kchsjjje = 0;
			var kcbhsjjje = 0;
			var kchssjje = 0;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.kcsl) == false) {
						kcsl += parseFloat(row.kcsl);
					}
					if (isNaN(row.kchsjjje) == false) {
						kchsjjje += parseFloat(row.kchsjjje);
					}
					if (isNaN(row.kcbhsjjje) == false) {
						kcbhsjjje += parseFloat(row.kcbhsjjje);
					}
					if (isNaN(row.kchssjje) == false) {
						kchssjje += parseFloat(row.kchssjje);
					}
				}
			}

			if (e.field == "gbcname") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "kcsl") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(kcsl),"#,0.0000")+"</b>";
			}
			if (e.field == "kchsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(kchsjjje),"#,0.00")+"</b>";
			}
			if (e.field == "kcbhsjjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(kcbhsjjje),"#,0.0000")+"</b>";
			}
			if (e.field == "kchssjje") {
				e.cellHtml = "<b>"+mini.formatNumber(Number(kchssjje),"#,0.00")+"</b>";
			}
			e.cellStyle = "text-align:right";  
		}
	
	</script>
	
	<script src="report.js" type="text/javascript"></script>
	
</body>
</html>