<%@ page language="java" contentType="text/html; charset=utf-8"
		 pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
	<title>不动销直销商品查询</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
<div class="ocm-formheader" config="formheader1"></div>
<div class="mini-fit">
	<div class="ocm-gridbox" config="gridbox1" border="0"></div>
</div>
<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
<!--<script src="/mall-business-ui/pages/contract/com/event.js" type="text/javascript"></script>-->

<script type="text/javascript">
	//字典数据初始化
	var moduleid ='K10615';

	//字典数据初始化
	var dicData = OcmControl.getDict("STOCKMD","code,name,ddvalue") ||{};
	var wmid = [{code: '1',name: '经销',ddvalue: '[1]经销'},{code: '2',name: '成本代销',ddvalue: '[2]成本代销'},{code: '3',name: '扣率代销',ddvalue: '[3]扣率代销'}];
	dicData.sample = [{code:'Y',name:'是'} , {code:'N',name:'否'}];
	var toolbar1 = {
		items : [ [ {
			"text" : "查询",
			"iconCls" : "icon-search",
			"name" : "searchData",
			"onclick" : "searchData",
			"enabled" : true,
		}, {
			"text" : "清除",
			"iconCls" : "icon-remove",
			"name" : "clearData",
			"onclick" : "clearData",
			"enabled" : true,
		}, {
			"text" : "导出",
			"iconCls" : "icon-upload",
			"name" : "exportData",
			"onclick" : "exportData",
			"enabled" : true,
		} ] ]
	};

	var formheader1 = {
		"type" : "formgrid",
		"initHeight":100,
		"properties" : {
			"id" : "formheader1",
		},
		items : [{"label" : "查询条件",
			"type" : "fieldset",
			"items" :[  {
				"label" : "门店：",
				"name" : "muid",
				"type" : "ButtonEdit",
				type : "fut_popselect",
				selectkey:"muid",
				textName :"muid_name",
				"enabled" : true,
				required : false,
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged_muid",
				style : "width:22.5%",
			},{
				label : "供应商：",
				name : "supid",
				type : "fut_popselect",
				required : false,
				selectkey : "selfsbid",
				textName : "sbid_name",
				beforefunc:"head_beforefunc",
				enabled : true,
				style : "width:22.5%",
			},{
				"label" : "柜组：",
				"name" : "mfid",
				"type" : "ButtonEdit",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "selfspcode",//弹框类型
				textName : "smfid_name", //文本显示字段
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged_smfid",
				"enabled" : true,
				style : "width:22.5%",
			},{
				"label" : "部门：",
				"type" : "ButtonEdit",
				"name" : "department",
				"required" : false,
				"enabled" : true,
				displayField : "mmfcname",
				type : "fut_popselect",
				selectkey : "mana",
				textName : "mmfcname",
				//responseName : "mmfid",
				//beforefunc : "head_beforefunc_mana",
				//itemchangedfunc : "head_itemchanged_mana",
				"visible" : false,
				style : "width:22.5%"
			},{
				"label" : "子库存：",
				"name" : "md",
				"type": "ComboBox",
				"defaultValue": "1",
				data: dicData.STOCKMD,
				"enabled" : true,
				"style" : "width:22.5%"
			},{
				"label" : "经营方式：",
				"name" : "wmid",
				textName : "wmid_name",
				"type" : "ComboBox",
				"data" : wmid,
				"valueField" : "code",
				"textField" : "name",
				"enabled" : true,
				"renderer" : "OcmControl.dictRendererWithCode",
				style : "width:22.5%",
			}, {
				"label" : "品牌：",
				"name" : "gbppcode",
				"enabled" : true,
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey:"ppcode",
				textName :"ppcode_name",
				"style" : "width:22.5%",
			},{
				"label" : "不动销天数大于：",
				"type" : "TextBox",
				"name" : "bdxts",
				"enabled" : true,
				"value" : "1",
				style : "width:22.5%",
			}, {
				"label" : "商品分类：",
				"name" : "gbcatcode",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "goodscat",//弹框类型
				textName : "gbcatcode_name", //文本显示字段
				"enabled" : true,
				style : "width:22.5%",
			}, {
				"label" : "商品条码：",
				"type" : "TextBox",
				"name" : "barcode",
				"enabled" : true,
				style : "width:22.5%",
			},]}
		]
	};

	//查询结果列表
	var gridbox1 = {
		"type" : "gridbox",
		"resources" : OmdUrl.mss,
		"method" : "mss.work.report.query",
		"response" : "report",
		"manualLoad" : true,
		"searchParam" : {
			"queryid":"select_K10615",
		},
		"properties" : {
			"id" : "gridbox1",
			"showSummaryRow" : true,
			"ondrawsummarycell" : "onDrawSummaryCell",
			"columns" : [ {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			},{
				field : "muid_name",
				header : "门店",
				headerAlign : "center",
				width : 150,
			},{
				field : "floor_name",
				header : "楼层",
				headerAlign : "center",
				width : 150,
			},{
				field : "spid_name",
				header : "柜组",
				headerAlign : "center",
				width : 150,
			},{
				field : "gdid",
				header : "商品编码",
				headerAlign : "center",
				width : 150,
			},{
				field : "gbbarcode",
				header : "商品条码",
				headerAlign : "center",
				width : 150,
			},{
				field : "gbcname",
				header : "商品名称",
				headerAlign : "center",
				width : 150,
			},{
				field : "ppcode_name",
				header : "品牌",
				headerAlign : "center",
				width : 150,
			},{
				field : "gbspec",
				header : "规格",
				headerAlign : "center",
				width : 50,
			},{
				field : "sbid_name",
				header : "主营供应商",
				headerAlign : "center",
				width : 200,
			},{
				field: "hsjj",
				header: "进价" ,
				headerAlign : "center",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "n4",},
				numberFormat:"n4",
				width : 140,
				excel:{
					type:"n",
					format:"0.0000",
					align:"right"
				},
			},{
				field : "klxs",
				header : "扣率",
				headerAlign : "center",
				width : 100,
				numberFormat : "p2",
				align: "right",
			},{
				field: "sj",
				header: "售价" ,
				headerAlign : "center",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "n2",},
				numberFormat:"n2",
				width : 100,
				excel:{
					type:"n",
					format:"0.00",
					align:"right"
				},
			},{
				field : "zzxsrq",
				header : "最早销售日期",
				headerAlign : "center",
				dateFormat : "yyyy-MM-dd",
				dataType : "date",
				align:"center",
				width : 100,
				allowSort : true,
				excel:{
					type:"d",
					format:"yyyy/m/dd",
					align:"right"
				}
			},{
				field : "zwxsrq",
				header : "最后销售日期",
				headerAlign : "center",
				dateFormat : "yyyy-MM-dd",
				dataType : "date",
				align:"center",
				width : 100,
				allowSort : true,
				excel:{
					type:"d",
					format:"yyyy/m/dd",
					align:"right"
				}
			},{
				field : "zwjhrq",
				header : "最后进货日期",
				headerAlign : "center",
				dateFormat : "yyyy-MM-dd",
				dataType : "date",
				align:"center",
				width : 100,
				allowSort : true,
				excel:{
					type:"d",
					format:"yyyy/m/dd",
					align:"right"
				}
			},{
				field: "kcsl",
				header: "当前库存数量" ,
				headerAlign : "center",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "n4",},
				numberFormat:"n4",
				excel:{
					type:"n",
					format:"0.0000",
					align:"right"
				},
				width : 90,
			},{
				field: "kchsjjje",
				header: "当前库存进价金额(不含税)" ,
				headerAlign : "center",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "n4",},
				numberFormat:"n4",
				width : 140,
				excel:{
					type:"n",
					format:"0.0000",
					align:"right"
				},
			},{
				field: "sjje",
				header: "当前库存售价金额" ,
				headerAlign : "center",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "n2",},
				numberFormat:"n2",
				width : 140,
				excel:{
					type:"n",
					format:"0.00",
					align:"right"
				},
			},{
				field : "bdxts",
				header : "不动销天数",
				headerAlign : "center",
				width : 100,
			},]
		},
	};
	mini.parse();

	//部门条件查询
	function head_beforefunc_mana(e) {
		var form = details1.form;
		var muid = form.getField("muid").getValue();

		if (muid == undefined || muid == "") {
			mini.alert("请先选择门店");
			return -1;
		}
		if (!e.searchParam) {
			e.searchParam = {};
		}
		e.searchParam.muid = muid;
		return 0;
	}

	//部门回填值
	function head_itemchanged_mana(e, data) {
		return 0;
	}

	function head_beforefunc(e){
		if(!e.searchParam){
			e.searchParam = {};
		}
		var buttonEdit = e.sender;
		if (e.value != "undefined" && e.value != ""){
			e.searchParam.code = e.value;
		}
		var muid = mini.getbyName("muid").getValue();
		if (buttonEdit.name == "supid") {
			if (muid !=undefined && muid != "") {
				e.searchParam.wherestr = " sbid IN (SELECT sbid FROM supmkt WHERE muid in ('" + muid  + "'))";
			}
		}

        if (buttonEdit.name == "mfid") {
            if (muid == "") {
                mini.alert("请先选择门店");
                return -1;
            }
            e.searchParam.wherestr = " spflag = 'Y'  and  sylx='01' and muid = '" + muid + "'";
        }

		if (buttonEdit.name == "bctdate") {
			if (muid != "" && muid!= undefined) {
				e.searchParam.wherestr = " dbusrpub.Fgetwizardname(mktcode, 'MUCODE2') ='" + muid  + "'";
			}
		}

		return 0;
	}

	function head_itemchanged_smfid(e,data){
		mini.getbyName("mfid").setValue(data[0].code);
		mini.getbyName("mfid").setText(data[0].spid_name);
		return 0;
	}

	function head_itemchanged_muid(e,data){
		mini.getbyName("supid").setText("");
		mini.getbyName("supid").setValue("");

		mini.getbyName("mfid").setValue("");
		mini.getbyName("wmid").setValue("");

		mini.getbyName("barcode").setValue("");

		mini.getbyName("bdxts").setValue("");

		mini.getbyName("md").setValue("");
		mini.getbyName("gbcatcode").setValue("");
		mini.getbyName("gbppcode").setValue("");
		mini.getbyName("department").setValue("");

		//mini.getbyName("gdid").setValue("");

		//mini.getbyName("barcode").setValue("");
		return 0;
	}



	function onDrawSummaryCell(e){
		var rows = e.data
		var kcsl = 0;
		var kchsjjje = 0;
		var kcbhsjjje = 0;
		var kchssjje = 0;
		if (rows.length > 0) {
			for ( var i = 0; i < rows.length; i++) {
				var row = rows[i];
				if (isNaN(row.kcsl) == false) {
					kcsl += parseFloat(row.kcsl);
				}
				if (isNaN(row.kchsjjje) == false) {
					kchsjjje += parseFloat(row.kchsjjje);
				}
				if (isNaN(row.kcbhsjjje) == false) {
					kcbhsjjje += parseFloat(row.kcbhsjjje);
				}
				if (isNaN(row.kchssjje) == false) {
					kchssjje += parseFloat(row.kchssjje);
				}
			}
		}

		if (e.field == "gbcname") {
			e.cellHtml = "<b>"+"合计: "+"</b>";
		}
		if (e.field == "kcsl") {
			e.cellHtml = "<b>"+mini.formatNumber(Number(kcsl),"#,0.0000")+"</b>";
		}
		if (e.field == "kchsjjje") {
			e.cellHtml = "<b>"+mini.formatNumber(Number(kchsjjje),"#,0.00")+"</b>";
		}
		if (e.field == "kcbhsjjje") {
			e.cellHtml = "<b>"+mini.formatNumber(Number(kcbhsjjje),"#,0.0000")+"</b>";
		}
		if (e.field == "kchssjje") {
			e.cellHtml = "<b>"+mini.formatNumber(Number(kchssjje),"#,0.00")+"</b>";
		}
		e.cellStyle = "text-align:right";
	}

</script>

<script src="report.js" type="text/javascript"></script>

</body>
</html>