<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>门店大类销售额排名报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
    <div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	
	<div class="ocm-formheader" config="formheader1"></div>
	
	<!-- <div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div> -->
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>

  <script type="text/javascript">
  //字典数据初始化
  var moduleid = "500921";
  
 var cnwmid = [ {  code : "5",  name : "租赁"}, {  code : "4",  name : "联营"} ];
 var tempflag = [ {  code : "1",  name : "品类拉动前六类"}, {  code : "2",  name : "品类拉动次六类"}, {  code : "3",  name : "品类拉动后六类"} ];
  
 var toolbar1 = {
		    items : [ [ {
		      "text" : "查询",
		      "iconCls" : "icon-search",
		      "name" : "searchData",
		      "onclick" : "searchData",
		      "enabled" : true,
		    }, {
		      "text" : "清除",
		      "iconCls" : "icon-remove",
		      "name" : "clearData",
		      "onclick" : "clearData",
		      "enabled" : true,
		    } , {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
		    } ] ]
		  };


		var formheader1 = {
				"type" : "formgrid",
				"initHeight":120,
				"properties" : {
					"id" : "formheader1",
				},
				items : [{"label" : "查询条件",
	            	"type" : "fieldset",
	            	"items" :[{
				       	 "label" : "发生日期(起)：",
				         "type" : "DatePicker",
				         "name" : "sdate",
				         "format" : "yyyy-MM-dd",
				         /*  "required" : "true",  */
				         "enabled" : true,
				          "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"), 
				         "style" : "width:30%"
				      }, {
				         "label" : "发生日期(止)：",
				         "type" : "DatePicker",
				         "name" : "edate",
				         "format" : "yyyy-MM-dd",
				         /*  "required" : "true",  */
				         "enabled" : true,
				          "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"), 
				         "style" : "width:30%"
				      },{
							"label" : "销售门店：",
							"type" : "ButtonEdit",
							"name" : "mktid",
							"enabled" : true,
							"onbuttonclick" : "onMktidClick",
							"onValuechanged" : "onMktidChange",
							"style" : "width:30%"
				      }, {
					       	 "label" : "记账日期(起)：",
					         "type" : "DatePicker",
					         "name" : "jzsdate",
					         "format" : "yyyy-MM-dd",
					         "enabled" : true,
					         /* "value" : mini.formatDate(new Date(),"yyyy-MM-dd"), */
					         /* "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"), */
					         "style" : "width:30%"
					      }, {
					         "label" : "记账日期(止)：",
					         "type" : "DatePicker",
					         "name" : "jzedate",
					         "format" : "yyyy-MM-dd",
					         "enabled" : true,
					         /* "value" : mini.formatDate(new Date(),"yyyy-MM-dd"), */
					        /*  "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"), */
					         "style" : "width:30%"
					      },{
					        "label" : "商品分类：",
					        "type" : "ButtonEdit",
					        "name" : "manacat",
					        "enabled" : true,
					        "onbuttonclick" : "onXGoodstypeClick",
					        "onValuechanged" : "onXGoodstypeChange",
					        "style" : "width:30%"
					 }, {
						"label" : "经营方式：",
						"type" : "ComboBox",
						"name" : "wmid",
						"enabled" : true,
						"data" : cnwmid,
						"style" : "width:30%"
					}, {
						"label" : "拉动：",
						"type" : "ComboBox",
						"name" : "tempflag",
						"enabled" : true,
						"data" : tempflag,
						"style" : "width:30%"
					}]},
	            ]
			};


		var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_500921",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "scdmkt",
						header : "销售门店",
						allowSort : true,
						headerAlign : "center",
						allowSort : false,
						width : 160,
					}, {
						field : "scdcatid",
						header : "商品分类",
						headerAlign : "center",
						allowSort : false,
						readOnly: true,
						width : 100,
					}, {
						field : "pm",
						header : "排名",
						allowSort : true,
						headerAlign : "center",
						width : 60,
						align : "center",
					},{
						header : "本期",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "xssr",
							header : "销售额",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
						}, {
							field : "fxssr",
							header : "门店占比",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							numberFormat : "p3",
							align : "right",
						}]
					},{
						header : "同期",
						allowSort : false,
						headerAlign : "center",
						"columns" : [{
							field : "oxssr",
							header : "销售额",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
						}, {
							field : "ofxssr",
							header : "门店占比",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							numberFormat : "p3",
							align : "right",
						   renderer:"OnTb",  
						}]
					},{
						header : "同比",
						allowSort : false,
						headerAlign : "center",
						"columns" : [{
							field : "txssr",
							header : "销售额增长率",
							headerAlign : "center",
							align : "right",
							allowSort : false,
							numberFormat : "p3",
							renderer:"OnTbvalue",
						}, {
							field : "dxssr",
							header : "销售额增长额",
							allowSort : false,
							headerAlign : "center",
							dataType : "float",
							align : "right",
							width : 100,
						} ,{
							field : "sfxssr",
							header : "门店占比增长率",
							headerAlign : "center",
							numberFormat : "p3",
							align : "right",
							allowSort : false,
						}]
					}]
				},
			};
	       var tabs = {
	    			properties : {
						"id" : "tabs",
					},
					items : [{
						"title" : "明细",
						"name" : "gridbox1",
	 					"control" : gridbox1,
					}]
	       }
		   formheader1.tabs=tabs;
	       formheader1.tabsToolbar = false;
			mini.parse();
			
			function onDrawSummaryCell(e) {
				var rows = e.data;
				var xssr = 0;
				var oxssr = 0; 
				var dxssr = 0;
				var list = [];
				if (rows.length > 0) {
					for (var i = 0; i < rows.length; i++) {
						var row = rows[i];
						xssr = accAdd(xssr,row.xssr);
						oxssr = accAdd(oxssr,row.oxssr);
						dxssr = accAdd(dxssr,row.dxssr);
					}
				}
				
				if (rows.length > 0) {
					var flag = false;
					for (var i = 0; i < rows.length; i++) {
						flag = false;
						var para= {};
						para.key = rows[i].scdmkt;
						para.xssr =rows[i].xssr;
						para.oxssr =rows[i].oxssr;
						para.dxssr =rows[i].dxssr;
						for(var j=0;j<list.length; j++) {
							if (list[j].key == para.key) {
								list[j].xssr =  accAdd(list[j].xssr,para.xssr);
								list[j].oxssr = accAdd(list[j].oxssr,para.oxssr);
								list[j].dxssr = accAdd(list[j].dxssr,para.dxssr);
								flag = true;
								break;
							}
						}
						if (!flag) {
							if (!flag) {
								list.push(para);
							}
						}
					}
				}

				if (e.field == "scdmkt") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var key = list[i].key;
						str=str + "<b>"+key+"</b><br>";
					}
					str = str + "<b>" + "合计: " + "</b>";
					e.cellHtml = str;
				}
				if (e.field == "xssr") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempxssr = list[i].xssr;
						str=str + "<b>"+ mini.formatNumber(Number(tempxssr),"#,0.00")+"</b><br>";
					}
					str = str + "<b>" + xssr.toFixed(2) + "</b>";
					e.cellHtml = str;
				}
				if (e.field == "oxssr") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempoxssr = list[i].oxssr;
						str=str + "<b>"+mini.formatNumber(Number(tempoxssr),"#,0.00")+"</b><br>";
					}
					str = str + "<b>" + oxssr.toFixed(2) + "</b>";
					e.cellHtml = str;
				}
				if (e.field == "dxssr") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tempdxssr = list[i].dxssr;
						str=str + "<b>"+mini.formatNumber(Number(tempdxssr),"#,0.00")+"</b><br>";
					}
					str = str + "<b>" + dxssr.toFixed(2)+ "</b>";
					e.cellHtml = str;
				}
				
				if (e.field == "txssr") {
					var str="";
					for (var i=0;i<list.length; i++) {
						if (list[i].oxssr == 0) {
							str=str + "<b>—</b><br>";
						} else {
							var temptxssr = accDiv(list[i].dxssr,list[i].xssr);
							temptxssr = accMul(temptxssr,100) ;
							str=str + "<b>"+temptxssr.toFixed(3)+"%</b><br>";
						}
						
					}
					if (oxssr == 0) {
						str=str + "<b>—</b><br>";
					} else {
						var temptxssr2 = accDiv(dxssr,xssr);
						temptxssr2 = accMul(temptxssr2,100) ;
						str = str + "<b>" + temptxssr2+ "%</b>";
					}
					e.cellHtml = str;
				}
				
				e.cellStyle = "text-align:right"; 
			}
			// 浮点型相加
			function accAdd(arg1, arg2) {
				var r1, r2, m;
				try {
					r1 = arg1.toString().split(".")[1].length;
				} catch (e) {
					r1 = 0;
				}
				;
				try {
					r2 = arg2.toString().split(".")[1].length;
				} catch (e) {
					r2 = 0;
				}
				;
				m = Math.pow(10, Math.max(r1, r2));
				return (arg1 * m + arg2 * m) / m;
			};
			// 浮点型相除
			function accDiv(arg1, arg2) {
				var t1 = 0, t2 = 0, r1, r2;
				try {
					t1 = arg1.toString().split(".")[1].length
				} catch (e) {
				}
				try {
					t2 = arg2.toString().split(".")[1].length
				} catch (e) {
					}
				with (Math) {
				r1 = Number(arg1.toString().replace(".", ""))
				r2 = Number(arg2.toString().replace(".", ""))
				return (r1 / r2) * pow(10, t2 - t1);
				}
			}
			// 浮点型相乘
			function accMul(arg1, arg2) {
				var m = 0, s1 = arg1.toString(), s2 = arg2.toString();
				try {
					m += s1.split(".")[1].length
				} catch (e) {
				}
				try {
					m += s2.split(".")[1].length
				} catch (e) {
				}
				return Number(s1.replace(".", "")) * Number(s2.replace(".", ""))
						/ Math.pow(10, m)
			}
			function OnTb(e) {
				var value = e.value;
				if (Number(value) == 1 || Number(value) == 0) {
					return "—";
				}else{
					/* value = accMul(value,100) ;
					value = value + "%"; */
					value = mini.formatNumber(Number(value),"p3");
				}
				return value;
			};
		</script>

  <script src="report.js" type="text/javascript"></script>
</body>
</html>