<%@ page language="java" contentType="text/html; charset=utf-8"
  pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>门店各品牌销售情况</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>

<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

  <script type="text/javascript">
	var moduleid = "501908";
		
    var toolbar1 = {
      items : [ [ {
        "text" : "查询",
        "iconCls" : "icon-search",
        "name" : "searchData",
        "onclick" : "searchData",
        "enabled" : true,
      }, {
        "text" : "清除",
        "iconCls" : "icon-remove",
        "name" : "clearData",
        "onclick" : "clearData",
        "enabled" : true,
      }, {
		"text" : "导出",
		"iconCls" : "icon-upload",
		"name" : "exportData",
		"onclick" : "exportData",
		"enabled" : true,
      } ] ]
    };


			var formheader1 = {
				"type" : "formgrid",
				"properties" : {
					"id" : "formheader1",
				},
				items : [ {
					"label" : "开始日期：",
					"type" : "MonthPicker",
					"name" : "sdate",
					"format" : "yyyy-MM",
					"required" : "false",
					"enabled" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
					"style" : "width:22.5%"
				}, {
					"label" : "结束日期：",
					"type" : "MonthPicker",
					"name" : "edate",
					"format" : "yyyy-MM",
					"required" : "false",
					"enabled" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
					"style" : "width:22.5%"
				}, /* {
					"label" : "门店：",
					"name" : "cdlmkt",
					"enabled" : true,
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey:"muid",//弹框类型
					textName :"muid_name",
					"style" : "width:22.5%"
				}, {
					"label" : "品牌：",
					"type" : "ButtonEdit",
					"name" : "ppcode",
					"enabled" : true,
					"onbuttonclick" : "onPpcodeClick",
					"onValuechanged" : "onPpcodeChange",
					"style" : "width:22.5%"
				}, {
					"label" : "会员级别：",
					"type" : "ComboBox",
					"name" : "custtype",
					"enabled" : true,
					"data" : custtype,
					"valueField" : "code",
					"textField" : "name",
					"style" : "width:22.5%"
				}, */ {
					/* "label" : "门店：",
					"name" : "mkt",
					"enabled" : true,
					displayField : "mucode",
					type : "fut_popselect",
					selectkey : "muid",
					textName : "muid_name",
					responseName : "mucode",
					"required" : "true",
					"style" : "width:22.5%" */
					"label" : "门店：",
		            "type" : "ButtonEdit",
		            "name" : "mkt",
		            "enabled" : true,
		            "required" : false,
		            "onbuttonclick" : "onMktidClick",
		            "onValuechanged" : "onMktidChange",
		            "style" : "width:30%"
				} ]
			};

			var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_501908",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "month",
						header : "年月",
						allowSort : true,
						headerAlign : "center",
						width : 120,
					}, {
						field : "mkt",
						header : "门店",
						allowSort : true,
						headerAlign : "center",
						width : 180,
					}, {
						field : "pl",
						header : "品类",
						allowSort : true,
						headerAlign : "center",
						width : 100,
					}, {
						field : "dl",
						header : "大类",
						allowSort : true,
						headerAlign : "center",
						width : 100,
					}, {
						field : "pp",
						header : "品牌",
						allowSort : true,
						headerAlign : "center",
						width : 150,
					}, {
						field : "wmid",
						header : "经营方式",
						allowSort : true,
						headerAlign : "center",
						//align : "right",
						readOnly : true,
						width : 120,
					}, {
						field : "sw",
						header : "商位",
						allowSort : true,
						headerAlign : "center",
						//align : "right",
						readOnly : true,
						width : 150,
					}, {
						field : "contno",
						header : "合同号",
						allowSort : true,
						headerAlign : "center",
						//align : "right",
						readOnly : true,
						width : 180,
					}, {
						field : "yeday",
						header : "营业天数",
						allowSort : true,
						headerAlign : "center",
						dataType : "float",
						align : "right",
						width : 120,
					}, {
						field : "mj",
						header : "面积（㎡）",
						allowSort : true,
						headerAlign : "center",
						width : 100,
						dataType : "float",
						align : "right",
					}, {
						field : "monthje",
						header : "当月销售（元）",
						allowSort : true,
						headerAlign : "center",
						width : 100,
						dataType : "float",
						align : "right",
						numberFormat : "#,0.00",
						vtype :"float",
					}, {
						field : "yearje",
						header : "本年累计销售（元）",
						allowSort : true,
						headerAlign : "center",
						width : 120,
						dataType : "float",
						align : "right",
						numberFormat : "#,0.00",
						vtype :"float",
						
						
					}, {
						field : "rjxs",
						header : "日坪销售（元/㎡/天）",
						allowSort : true,
						headerAlign : "center",
						width : 180,
						dataType : "float",
						align : "right",
						numberFormat : "#,0.00",
						vtype :"float",
					}, {
						field : "ks",
						header : "客数（人次）",
						allowSort : true,
						headerAlign : "center",
						width : 100,
						dataType : "float",
						align : "right",
					}, {
						field : "kdj",
						header : "客单价（元）",
						allowSort : true,
						headerAlign : "center",
						width : 100,
						dataType : "float",
						align : "right",
						numberFormat : "#,0.00",
						vtype :"float",
					}, {
						field : "bdfs",
						header : "租金/收益方式",
						allowSort : true,
						headerAlign : "center",
						//align : "right",
						readOnly : true,
					}, {
						field : "dqkl",
						header : "当前扣率",
						allowSort : true,
						headerAlign : "center",
						width : 100,
						dataType : "float",
						align : "right",
					}, {
						field : "bdrzj",
						header : "保底日租金（元/天/㎡）",
						allowSort : true,
						headerAlign : "center",
						width : 180,
						dataType : "float",
						align : "right",
						numberFormat : "#,0.00",
						vtype :"float",
					}, {
						field : "bdxs",
						header : "保底销售（万元/年）",
						allowSort : true,
						headerAlign : "center",
						width : 150,
						dataType : "float",
						align : "right",
						numberFormat : "#,0.00",
						vtype :"float",
					}, {
						field : "opendate",
						dataType : "date",
						dateFormat : "yyyy-MM-dd",
						header : "开业时间",
						width : 100,
						allowSort : true,
						headerAlign : "center",
					}, {
						field : "ccdate",
						dataType : "date",
						dateFormat : "yyyy-MM-dd",
						header : "退铺时间",
						width : 100,
						allowSort : true,
						headerAlign : "center",

					} ]
				},
			};
			
		function onDrawSummaryCell(e) {
			//当月广场营业面积    mj
			//当月销售坪效  rjxs * 30
			//广场客单价       kdj
			//服饰及零售类客单价  kdj dl=1  [1]服饰及零售类
			//餐饮及辅营类客单价  kdj dl=2  [2]餐饮及辅营类
			var rows = e.data;
			var mj = 0;
			var rjxs = 0;
			var kdj = 0;
			var kdj1 = 0;
			var kdj2 = 0;
			var ks = 0;
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					//当月广场营业面积
					if (isNaN(row.mj) == false) {
						mj += parseFloat(row.mj);
					}
					//当月销售坪效   rjxs * 30  
					if (isNaN(row.rjxs) == false) {
						rjxs += parseFloat(row.rjxs)*30;
					}
					//广场客单价
					if (isNaN(row.ks) == false) {
						ks += parseFloat(row.ks);
					}
					//广场客单价
					if (isNaN(row.kdj) == false) {
						kdj += parseFloat(row.kdj);
					}
					//服饰及零售类客单价 
					if (isNaN(row.kdj) == false && row.dl == '[1]服饰及零售类') {
						kdj1 += parseFloat(row.kdj);
					}
					//餐饮及辅营类客单价
					if (isNaN(row.kdj) == false && row.dl == '[2]餐饮及辅营类') {
						kdj2 += parseFloat(row.kdj);
					}
				}
			}
            
			//合计
			if (e.field == "month") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "mkt") {
				e.cellHtml ="<b>"+ "当月广场营业面积: " + mini.formatNumber(Number(mj),"#,0.00")+"</b>";
			}
			if (e.field == "pp") {
				e.cellHtml = "<b>"+ "当月销售坪效: " + mini.formatNumber(Number(rjxs),"#,0.00")+"</b>";
			}
			if (e.field == "contno") {
				var gckdj = 0;
				if(isNaN(Number(kdj)/Number(ks)) == false){
					gckdj = Number(kdj)/Number(ks);
				}
				e.cellHtml ="<b>"+ "广场客单价: " + mini.formatNumber(gckdj,"#,0.00")+"</b>";
			}
			if (e.field == "rjxs") {
				var flkdj = 0;
				if(isNaN(Number(kdj1)/Number(ks)) == false){
					flkdj = Number(kdj1)/Number(ks);
				}
				e.cellHtml ="<b>"+ "服饰及零售类客单价 : " + mini.formatNumber(flkdj,"#,0.00")+"</b>";
			}
			if (e.field == "bdrzj") {
				var cfkdj = 0;
				if(isNaN(Number(kdj2)/Number(ks)) == false){
					cfkdj = Number(kdj1)/Number(ks);
				}
				e.cellHtml = "<b>"+ "餐饮及辅营类客单价: " + mini.formatNumber(cfkdj,"#,0.00")+"</b>";
			}
			
			e.cellStyle = "text-align:right";  
		}
		 
			mini.parse();
		</script>

  <script src="report.js" type="text/javascript"></script>
  
</body>
</html>

  