<%@ page language="java" contentType="text/html; charset=utf-8"
  pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>合同指标完成情况分析表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>

<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

  <script type="text/javascript">
  
  var wmid = [ {  code : "5",  name : "租赁"}, {code : "4",  name : "联营"}];	
  
  
	var moduleid = "501909";
		
    var toolbar1 = {
      items : [ [ {
        "text" : "查询",
        "iconCls" : "icon-search",
        "name" : "searchData",
        "onclick" : "searchData",
        "enabled" : true,
      }, {
        "text" : "清除",
        "iconCls" : "icon-remove",
        "name" : "clearData",
        "onclick" : "clearData",
        "enabled" : true,
      }, {
		"text" : "导出",
		"iconCls" : "icon-upload",
		"name" : "exportData",
		"onclick" : "exportData",
		"enabled" : true,
      } ] ]
    };


			var formheader1 = {
				"type" : "formgrid",
				"properties" : {
					"id" : "formheader1",
				},
				items : [ {
					"label" : "年月：",
					"type" : "MonthPicker",
					"name" : "sdate",
					"format" : "yyyy-MM",
					"required" : "false",
					"enabled" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
					"style" : "width:22.5%"
				}, /* {
					"label" : "结束年月：",
					"type" : "MonthPicker",
					"name" : "edate",
					"format" : "yyyy-MM",
					"required" : "false",
					"enabled" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
					"style" : "width:22.5%"
				}, */ {
					
					"label" : "门店：",
		            "type" : "ButtonEdit",
		            "name" : "mkt",
		            "enabled" : true,
		            "required" : false,
		            "onbuttonclick" : "onMktidClick",
		            "onValuechanged" : "onMktidChange",
		            "style" : "width:22.5%"
				},{
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "wmid",
					"enabled" : true,
					"data" : wmid,
					"showNullItem":true,
					"style" : "width:22.5%"
				},{
					"label" : "商户：",
		            "type" : "ButtonEdit",
		            "name" : "sbid",
		            "enabled" : true,
		            "required" : false,
		            "onbuttonclick" : "onSupcodeClick",
		            "onValuechanged" : "onSupcodeChange",
		            "style" : "width:22.5%"
				},{ 
					"label" : "商铺：",
					"type" : "ButtonEdit",
					"name" : "spid",
					"enabled" : true,
					"onbuttonclick" : "onShoplistClick",
					"onValuechanged" : "onShoplistChange",
					"style" : "width:22.5%"
				}]
			};
		
			var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_501909",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, /* {
						field : "dates",
						header : "年月",
						allowSort : true,
						headerAlign : "center",
						width : 120,
					},  */{
						field : "mkt",
						header : "门店",
						allowSort : true,
						headerAlign : "center",
						width : 180,
					}, {
						field : "sbname",
						header : "商户",
						allowSort : true,
						headerAlign : "center",
						width : 150,
					}, {
						field : "wmid",
						header : "经营方式",
						allowSort : true,
						headerAlign : "center",
						width : 100,
					}, {
						field : "mmfid",
						header : "店铺位置",
						allowSort : true,
						headerAlign : "center",
						width : 150,
					}, {
						field : "contno",
						header : "合同号",
						allowSort : true,
						headerAlign : "center",
						//align : "right",
						readOnly : true,
						width : 120,
					}, {
						field : "spname",
						header : "商铺名称",
						allowSort : true,
						headerAlign : "center",
						//align : "right",
						readOnly : true,
						width : 180,
					}, {
						field : "spbuildarea",
						header : "商铺面积",
						allowSort : true,
						headerAlign : "center",
						dataType : "float",
						align : "right",
						readOnly : true,
						width : 180,
					}, {
						field : "opendate",
						header : "实际开业日期",
						allowSort : true,
						headerAlign : "center",
						dataType : "date",
						dateFormat : "yyyy-MM-dd",
						width : 120,
					}, {
						field : "cmlapdate",
						header : "合同终止日期",
						allowSort : true,
						dataType : "date",
						dateFormat : "yyyy-MM-dd",
						headerAlign : "center",
						width : 100,
					}, {
						field : "pl",
						header : "品类",
						allowSort : true,
						headerAlign : "center",
						width : 100,
					}, {
						field : "dytps",
						header : "当月退铺",
						allowSort : true,
						headerAlign : "center",
						width : 100,
						dataType : "float",
						align : "right",
						numberFormat : "#,0.00",
						vtype :"float",
					}, {
						field : "nocompletetotal",
						header : "全部未完成",
						allowSort : true,
						headerAlign : "center",
						width : 100,
						dataType : "float",
						align : "right",
						numberFormat : "#,0.00",
						vtype :"float",
					}, {
						field : "nocomplete36",
						header : "累计三个月未完成",
						allowSort : true,
						headerAlign : "center",
						width : 120,
						dataType : "float",
						align : "right",
						numberFormat : "#,0.00",
						vtype :"float",
					}, {
						field : "nocomplete612",
						header : "累计六个月未完成",
						allowSort : true,
						headerAlign : "center",
						width : 120,
						dataType : "float",
						align : "right",
						numberFormat : "#,0.00",
						vtype :"float",
					}, {
						header : "累计指标完成情况",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "indextotal",
							header : "销售指标",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "montotal",
							header : "实际销售",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "completionratetotal",
							header : "完成率",
							headerAlign : "center",
							numberFormat : "p2",
							align : "right",
							allowSort : false,
						}]
					}, {
						header : "前11月指标完成情况",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "index1",
							header : "销售指标",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "mon1",
							header : "实际销售",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "completionrate1",
							header : "完成率",
							headerAlign : "center",
							numberFormat : "p2",
							align : "right",
							allowSort : false,
						}]
					}, {
						header : "前10月指标完成情况",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "index2",
							header : "销售指标",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "mon2",
							header : "实际销售",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "completionrate2",
							header : "完成率",
							headerAlign : "center",
							numberFormat : "p2",
							align : "right",
							allowSort : false,
						}]
					}, {
						header : "前9月指标完成情况",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "index3",
							header : "销售指标",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "mon3",
							header : "实际销售",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "completionrate3",
							header : "完成率",
							headerAlign : "center",
							numberFormat : "p2",
							align : "right",
							allowSort : false,
						}]
					}, {
						header : "前8月指标完成情况",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "index4",
							header : "销售指标",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "mon4",
							header : "实际销售",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "completionrate4",
							header : "完成率",
							headerAlign : "center",
							numberFormat : "p2",
							align : "right",
							allowSort : false,
						}]
					}, {
						header : "前7月指标完成情况",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "index5",
							header : "销售指标",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "mon5",
							header : "实际销售",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "completionrate5",
							header : "完成率",
							headerAlign : "center",
							numberFormat : "p2",
							align : "right",
							allowSort : false,
						}]
					}, {
						header : "前6月指标完成情况",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "index6",
							header : "销售指标",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "mon6",
							header : "实际销售",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "completionrate6",
							header : "完成率",
							headerAlign : "center",
							numberFormat : "p2",
							align : "right",
							allowSort : false,
						}]
					}, {
						header : "前5月指标完成情况",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "index7",
							header : "销售指标",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "mon7",
							header : "实际销售",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "completionrate7",
							header : "完成率",
							headerAlign : "center",
							numberFormat : "p2",
							align : "right",
							allowSort : false,
						}]
					}, {
						header : "前4月指标完成情况",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "index8",
							header : "销售指标",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "mon8",
							header : "实际销售",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "completionrate8",
							header : "完成率",
							headerAlign : "center",
							numberFormat : "p2",
							align : "right",
							allowSort : false,
						}]
					}, {
						header : "前3月指标完成情况",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "index9",
							header : "销售指标",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "mon9",
							header : "实际销售",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "completionrate9",
							header : "完成率",
							headerAlign : "center",
							numberFormat : "p2",
							align : "right",
							allowSort : false,
						}]
					}, {
						header : "前2月指标完成情况",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "index10",
							header : "销售指标",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "mon10",
							header : "实际销售",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "completionrate10",
							header : "完成率",
							headerAlign : "center",
							numberFormat : "p2",
							align : "right",
							allowSort : false,
						}]
					}, {
						header : "前1月指标完成情况",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "index11",
							header : "销售指标",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "mon11",
							header : "实际销售",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "completionrate11",
							header : "完成率",
							headerAlign : "center",
							numberFormat : "p2",
							align : "right",
							allowSort : false,
						}]
					}, {
						header : "当月指标完成情况",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "index12",
							header : "销售指标",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "mon12",
							header : "实际销售",
							allowSort : false,
							headerAlign : "center",
							width : 100,
							dataType : "float",
							align : "right",
							numberFormat : "#,0.00",
							vtype :"float",
						}, {
							field : "completionrate12",
							header : "完成率",
							headerAlign : "center",
							numberFormat : "p2",
							align : "right",
							allowSort : false,
						}]
					} ]
				},
			};
			
		function onDrawSummaryCell(e) {
			//当月退铺数   dytps
			//指标全部未完成数  nocompletetotal
			//指标累计三个月未完成数     completionrate36
			//指标累计六个月未完成数     completionrate612
			var rows = e.data;
			var dytps = 0;	
			var nocompletetotal = 0;	
			var nocomplete36 = 0;	
			var nocomplete612 = 0;	
			if (rows.length > 0) {
				for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					//当月退铺数   dytps
					if (isNaN(row.dytps) == false) {
						dytps += parseFloat(row.dytps);
					}
					//指标全部未完成数  nocompletetotal
					if (isNaN(row.nocompletetotal) == false) {
						nocompletetotal += parseFloat(row.nocompletetotal);
					}
					//指标累计三个月未完成数     nocomplete36
					if (isNaN(row.nocomplete36) == false) {
						nocomplete36 += parseFloat(row.nocomplete36);
					}
					//指标累计六个月未完成数     nocomplete612
					if (isNaN(row.nocomplete612) == false) {
						nocomplete612 += parseFloat(row.nocomplete612);
					}
				}
			}
            
			//合计
			if (e.field == "pl") {
				e.cellHtml = "<b>"+"合计: "+"</b>";
			}
			if (e.field == "dytps") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(dytps),"#,0.00")+"</b>";
			}
			if (e.field == "nocompletetotal") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(nocompletetotal),"#,0.00")+"</b>";
			}
			if (e.field == "nocomplete36") {
				e.cellHtml = "<b>"+ mini.formatNumber(Number(nocomplete36),"#,0.00")+"</b>";
			}
			if (e.field == "nocomplete612") {
				e.cellHtml ="<b>"+ mini.formatNumber(Number(nocomplete612),"#,0.00")+"</b>";
			}
			
			
			e.cellStyle = "text-align:right";  
		}
		 
			mini.parse();
		</script>

  <script src="report.js" type="text/javascript"></script>
  
</body>
</html>

  