<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>门店品牌透视基础报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	
	<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>

  <script type="text/javascript">
  //字典数据初始化
  var moduleid = "500911";
  
  var cnjymode = [ {  code : "01",  name : "特卖"}, {  code : "02",  name : "正柜"} ];
  var cnwmid = [ {  code : "5",  name : "租赁"}, {  code : "4",  name : "联营"} ];

		  var toolbar1 = {
		    items : [ [ {
		      "text" : "查询",
		      "iconCls" : "icon-search",
		      "name" : "searchData",
		      "onclick" : "searchData",
		      "enabled" : true,
		    }, {
		      "text" : "清除",
		      "iconCls" : "icon-remove",
		      "name" : "clearData",
		      "onclick" : "clearData",
		      "enabled" : true,
		    }, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
		    } ] ]
		  };


			var formheader1 = {
				"type" : "formgrid",
				"properties" : {
					"id" : "formheader1",
				},
				items : [ {
					"label" : "开始月份：",
					"type" : "MonthPicker",
					"name" : "sdate",
					"format" : "yyyy-MM",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
				}, {
					"label" : "结束月份：",
					"type" : "MonthPicker",
					"name" : "edate",
					"format" : "yyyy-MM",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
				}, {
					"label" : "门店：",
					"type" : "ButtonEdit",
					"name" : "mktid",
					"enabled" : true,
					"onbuttonclick" : "onMktidClick",
					"onValuechanged" : "onMktidChange",
					"style" : "width:30%;"
				}, {
					"label" : "经营类型：",
					"type" : "ComboBox",
					"name" : "conttype",
					"enabled" : true,
					"data" : cnjymode,
					"style" : "width:30%"
				}, {
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "wmid",
					"enabled" : true,
					"data" : cnwmid,
					"style" : "width:30%"
				} ]
			};

			var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_brandperspective",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "mktid",
						header : "门店",
						allowSort : true,
						headerAlign : "center",
						width : 160,
					 },{
						field : "sglhsrq",
						header : "销售时间",
						allowSort : true,
						headerAlign : "center",
						width : 100,
					}, {
						field : "sglsupid",
						header : "供应商",
						allowSort : true,
						headerAlign : "center",
						width : 180,
					}, {
						field : "sglwmid",
						header : "经营方式",
						type : "comboboxcolumn",  
						headerAlign : "center",
						readOnly: true,
			        	textField:"name",
		        	    valueField:"code" ,
						renderer: "OcmControl.dictRendererWithCode",
						data : cnwmid,
						width : 100,		
					},{
						field : "sglcatidbig",
						header : "经营分类",
						allowSort : true,
						headerAlign : "center",
						width : 120,
					}, {
						field : "conttype",
						header : "经营类型",
						type : "comboboxcolumn",  
						headerAlign : "center",
						readOnly: true,
			        	textField:"name",
		        	    valueField:"code" ,
						renderer: "OcmControl.dictRendererWithCode",
						data : cnjymode,
						width : 100,
					}, {
						field : "sglppcode",
						header : "品牌名称",
						allowSort : true,
						headerAlign : "center",
						width : 120,
					}, {
						field : "ppename",
						header : "品牌英文",
						allowSort : true,
						headerAlign : "center",
						width : 100,
					}, {
						field : "xssr",
						header : "销售额",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 80,
					} ]
				},
			};

			mini.parse();

			function onDrawSummaryCell(e) {
				var rows = e.data;
				var list =[];
				var flag =false;
				if (rows.length > 0) {
					for (var i = 0; i < rows.length; i++) {
						flag = false;
						var para = {};
						var row = rows[i];
						para.key = row.mktid;
						para.xssr = row.xssr;
						for (var j=0;j<list.length; j++) {
							if (para.key == list[j].key) {
								list[j].xssr = parseFloat(list[j].xssr) + parseFloat(para.xssr);
								flag =true;
								break;
							}
						}
						
						if (!flag) {
							list.push(para);
						}
					}
				}

				if (e.field == "mktid") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var key = list[i].key;
						str=str + "<b>"+key+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "xssr") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var xssr = list[i].xssr;
						str=str + "<b>"+parseFloat(xssr).toFixed(2)+"</b><br>";
					}
					e.cellHtml = str;
				}
				e.cellStyle = "text-align:right";
			}
		</script>

  <script src="profit.js" type="text/javascript"></script>
  
</body>
</html>