<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>品牌销售报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">

  <div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
  
  <div class="ocm-formheader" config="formheader1"></div>
  
  <div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
  
  <script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
  <script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

  <script type="text/javascript">
  //字典数据初始化
  var moduleid = "500904";
  var cnwmid = [ {  code : "5",  name : "租赁"}, {  code : "4",  name : "联营"} ];
  // 渠道
  var channel = {};
  // var searchParam = {};
  //  itemLoader.doRequest(OmdUrl.mdm, "ocm.mdm.cha.search",
  //      searchParam, null, null, function(data) {
  //    channel = data.channel;
  // }, null, null, false);
  var searchParam = {
      "queryid" : "select_channel",
  };
  itemLoader.doRequest(OmdUrl.mall, "mss.work.report.query", searchParam,
      null, null, function(data) {
          channel = data.report;
      }, null, null, false);

  

  var toolbar1 = {
    items : [ [ {
      "text" : "查询",
      "iconCls" : "icon-search",
      "name" : "searchData",
      "onclick" : "searchData",
      "enabled" : true,
    }, {
      "text" : "清除",
      "iconCls" : "icon-remove",
      "name" : "clearData",
      "onclick" : "clearData",
      "enabled" : true,
    }, {
		"text" : "导出",
		"iconCls" : "icon-upload",
		"name" : "exportData",
		"onclick" : "exportData",
		"enabled" : true,
    } ] ]
  };

  
			var formheader1 = {
				"type" : "formgrid",
				"properties" : {
					"id" : "formheader1",
				},
				items : [ {
					"label" : "发生开始日期：",
					"type" : "DatePicker",
					"name" : "fssdate",
					"format" : "yyyy-MM-dd",
					//"required" : "true",
					"enabled" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"style" : "width:30%"
				}, {
					"label" : "发生结束日期：",
					"type" : "DatePicker",
					"name" : "fsedate",
					"format" : "yyyy-MM-dd",
					//"required" : "true",
					"enabled" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"style" : "width:30%"
				}, {
					"label" : "门店：",
					"type" : "ButtonEdit",
					"name" : "scdmkt",
					"enabled" : true,
					 "required" : true, 
					"onbuttonclick" : "onMktidClick",
					"onValuechanged" : "onMktidChange",
					"style" : "width:30%"
				}, {
					"label" : "记账开始日期：",
					"type" : "DatePicker",
					"name" : "jzsdate",
					"format" : "yyyy-MM-dd",
					//"required" : "true",
					"enabled" : true,
					//"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					//"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"style" : "width:30%"
				}, {
					"label" : "记账结束日期：",
					"type" : "DatePicker",
					"name" : "jzedate",
					"format" : "yyyy-MM-dd",
					//"required" : "true",
					"enabled" : true,
					//"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					//"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"style" : "width:30%"
				}, {
					"label" : "渠道：",
					"type" : "ComboBox",
					"name" : "scdchaid",
					"enabled" : true,
					"style" : "width:30%",
					"data" : channel,
				}, {
					"label" : "品牌：",
					"type" : "ButtonEdit",
					"name" : "scdbrand",
					"enabled" : true,
					"onbuttonclick" : "onPpcodeClick",
					"onValuechanged" : "onPpcodeChange",
					"style" : "width:30%"
				}, {
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "sglwmid",
					"enabled" : true,
					"data" : cnwmid,
					"showNullItem" : true,
					"style" : "width:30%"
				} ]
			};

			var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_brandsale",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "scdmkt",
						header : "门店",
						allowSort : true,
						headerAlign : "center",
						width : 150,
					}, {
						field : "scdbrand",
						header : "品牌",
						allowSort : true,
						headerAlign : "center",
						width : 150,
					}, {
						field : "scdchaid",
						header : "渠道",
						allowSort : true,
						headerAlign : "center",
						width : 120,
					}, {
						field : "sglwmid",
						header : "经营方式",
						allowSort : true,
						headerAlign : "center",
						width : 80,
					},{
						field : "sl",
						header : "销售数量",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0",
						vtype : "float",
						align : "right",
						width : 80,
					},{
						field : "xssr",
						header : "销售收入",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 80,
					}, {
						field : "jl",
						header : "小票数",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0",
						vtype : "float",
						align : "right",
						width : 80,
					},{
						field : "dj",
						header : "客单价",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 80,
					},{
						field : "totzk",
						header : "总折扣",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 80,
					}, {
						field : "xscb",
						header : "销售成本",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 80,
					}, {
						field : "xscbtz",
						header : "销售调整",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 80,
					}, {
						field : "supzk",
						header : "商户折扣承担",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 80,
					}, {
						field : "ml",
						header : "毛利",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 80,
					}, {
						field : "mll",
						header : "毛利率",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "p2",
						vtype : "float",
						align : "right",
						width : 80,
					}, {
						field : "xxse",
						header : "销项税额",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 80,
					}, {
						field : "xfse",
						header : "消费税额",
						allowSort : true,
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 80,
					} ]
				},
			};

			mini.parse();
			
			function onDrawSummaryCell(e) {
				var rows = e.data;
				var sl = 0;
				var xssr = 0;
				var jl = 0;
				var dj = 0;
				var totzk = 0;
				var xscb = 0;
				var xscbtz = 0;
				var supzk = 0;
				var ml = 0;
				var mll = 0;
				var xxse = 0;
				var xfse = 0;
				if (rows.length > 0) {
					for (var i = 0; i < rows.length; i++) {
						var row = rows[i];
						if (isNaN(row.sl) == false) {
							sl += parseFloat(row.sl);
						}
						if (isNaN(row.xssr) == false) {
							xssr += parseFloat(row.xssr);
						}
						if (isNaN(row.jl) == false) {
							jl += parseFloat(row.jl);
						}
						if (isNaN(row.dj) == false) {
							dj += parseFloat(row.dj);
						}
						if (isNaN(row.totzk) == false) {
							totzk += parseFloat(row.totzk);
						}
						if (isNaN(row.xscb) == false) {
							xscb += parseFloat(row.xscb);
						}
						if (isNaN(row.xscbtz) == false) {
							xscbtz += parseFloat(row.xscbtz);
						}
						if (isNaN(row.supzk) == false) {
							supzk += parseFloat(row.supzk);
						}
						if (isNaN(row.ml) == false) {
							ml += parseFloat(row.ml);
						}
						if (isNaN(row.mll) == false) {
							mll += parseFloat(row.mll);
						}
						if (isNaN(row.xxse) == false) {
							xxse += parseFloat(row.xxse);
						}
						if (isNaN(row.xfse) == false) {
							xfse += parseFloat(row.xfse);
						}
					}
				}

				if (e.field == "scdmkt") {
					e.cellHtml = "<b>" + "合计: " + "</b>";
				}
				if (e.field == "sl") {
					e.cellHtml = "<b>" + sl.toFixed(0) + "</b>";
				}
				if (e.field == "xssr") {
					e.cellHtml = "<b>" + xssr.toFixed(2) + "</b>";
				}
				if (e.field == "jl") {
					e.cellHtml = "<b>" + jl.toFixed(0) + "</b>";
				}
				if (e.field == "dj") {
					e.cellHtml = "<b>" + dj.toFixed(2) + "</b>";
				}
				if (e.field == "totzk") {
					e.cellHtml = "<b>" + totzk.toFixed(2) + "</b>";
				}
				if (e.field == "xscb") {
					e.cellHtml = "<b>" + xscb.toFixed(2) + "</b>";
				}
				if (e.field == "xscbtz") {
					e.cellHtml = "<b>" + xscbtz.toFixed(2) + "</b>";
				}
				if (e.field == "supzk") {
					e.cellHtml = "<b>" + supzk.toFixed(2) + "</b>";
				}
				if (e.field == "ml") {
					e.cellHtml = "<b>" + ml.toFixed(2) + "</b>";
				}
				if (e.field == "mll") {
					e.cellHtml = "<b>"+ mini.formatNumber(mll,"#0.00%")+"</b>";
				}
				if (e.field == "xxse") {
					e.cellHtml = "<b>" + xxse.toFixed(2) + "</b>";
				}
				if (e.field == "xfse") {
					e.cellHtml = "<b>" + xfse.toFixed(2) + "</b>";
				}
				e.cellStyle = "text-align:right";
			}
			
			
		</script>

  <script src="report.js" type="text/javascript"></script>
  
</body>
</html>