<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<!DOCTYPE html />
<html>
<head>
<title>日销售报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">

    <div class="ocm-systoolbar" config="toolbar1"  style="margin-bottom:10px"></div>
	
	<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>

	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
	
	<script type="text/javascript">
	
	var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};
	
		//查询条件
		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [{
				"label" : "门店：",
				"name" : "muid",
				"type" : "ButtonEdit",
				"enabled" : true,
				"defaultValue" : "",
				
				type : "fut_popselect",
				selectkey:"muid",
				textName :"muid_name",
				beforefunc:"head_beforefunc",
			},{
				"label" : "门店：",
				"name" : "muid_name",
				"type" : "TextBox",
				"visible" : false,
			},{
				"label" : "开始日期：",
				"type" : "DatePicker",
				"name" : "saledate",
				"format" : "yyyy-MM-dd",
				"enabled" : true,
				"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
			}/* ,{
				"label" : "结束日期：",
				"type" : "DatePicker",
				"name" : "edate",
				"format" : "yyyy-MM-dd",
				"enabled" : true,
				"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
			} */]};
		
		
		var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mss,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid":"select_daysale",
				},
				"oncellbeginedit" : "OcmControl.checkboxEditor",
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					},{
						field : "spid",
						headerAlign : "center",
						header : "铺位号",
						allowSort : false,
						visible : true,
						width : 120,
					},{
						field : "rentalarea",
						headerAlign : "center",
						header : "面积(/平米)",
						allowSort : false,
						visible : true,
						width : 100,
					},{
						field : "ppcode",
						headerAlign : "center",
						header : "品牌",
						allowSort : false,
						visible : true,
						width : 120,
					},{
						field : "mid",
						headerAlign : "center",
						header : "品类",
						allowSort : false,
						visible : true,
						width : 120,
					},{
						field : "custsalenum",
						headerAlign : "center",
						header : "会员销售数量",
						allowSort : false,
						visible : true,
						width : 120,
					},{
						field : "custsaleamt",
						headerAlign : "center",
						header : "会员销售金额",
						allowSort : false,
						visible : true,
						vtype:"double",
						numberFormat : "#,##0.00",
						width : 150,
					},{
						field : "totalsale",
						headerAlign : "center",
						header : "总销售数量",
						allowSort : false,
						visible : true,
						width : 120,
					},{
						field : "totalsaleamont",
						headerAlign : "center",
						header : "总销售金额",
						allowSort : false,
						visible : true,
						vtype:"double",
						numberFormat : "#,##0.00",
						width : 150,
					},{
						field : "custsalerate",
						headerAlign : "center",
						header : "会员销售占比",
						allowSort : false,
						visible : true,
						vtype:"double",
						numberFormat : "#,##0.00",
						width : 150,
					},{
						field : "tplsalecate",
						headerAlign : "center",
						header : "同品类总销售金额排名",
						allowSort : false,
						visible : true,
						width : 150,
					},{
						field : "totalsalerank",
						headerAlign : "center",
						header : "销售金额总排名",
						allowSort : false,
						visible : true,
						width : 120,
					},{
						field : "rent",
						headerAlign : "center",
						header : "租金",
						allowSort : false,
						visible : true,
						vtype:"double",
						numberFormat : "#,##0.00",
						width : 150,
					},{
						field : "salesflat",
						headerAlign : "center",
						header : "租售比",
						allowSort : false,
						visible : true,
						vtype:"double",
						numberFormat : "#,##0.00",
						width : 150,
					},{
						field : "Salesflatrank",
						headerAlign : "center",
						header : "租售比排名",
						allowSort : false,
						visible : true,
						width : 120,
					},{
						field : "saleseffect",
						headerAlign : "center",
						header : "销售坪效",
						allowSort : false,
						visible : true,
						vtype:"double",
						numberFormat : "#,##0.00",
						width : 150,
					},{
						field : "PINGRANK",
						headerAlign : "center",
						header : "坪效排名",
						allowSort : false,
						visible : true,
						width : 120,
					}]}
				};
		
		mini.parse();
		
		function onDrawSummaryCell(e) {
			var rows = e.data;
			var custsalenum = 0;
			var custsaleamt = 0;
			var totalsale = 0;
			var totalsaleamont = 0;
			var custsalerate = 0;
			var rent = 0;
			var salesflat = 0;
			var saleseffect = 0;

			if (rows.length > 0) {
				for (var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.custsalenum) == false) {
						custsalenum += parseFloat(row.custsalenum);
					}
					if (isNaN(row.custsaleamt) == false) {
						custsaleamt += parseFloat(row.custsaleamt);
					}
					if (isNaN(row.totalsale) == false) {
						totalsale += parseFloat(row.totalsale);
					}
					if (isNaN(row.totalsaleamont) == false) {
						totalsaleamont += parseFloat(row.totalsaleamont);
					}
					if (isNaN(row.custsalerate) == false) {
						custsalerate += parseFloat(row.custsalerate);
					}
					if (isNaN(row.rent) == false) {
						rent += parseFloat(row.rent);
					}
					if (isNaN(row.salesflat) == false) {
						salesflat += parseFloat(row.salesflat);
					}
					if (isNaN(row.saleseffect) == false) {
						saleseffect += parseFloat(row.saleseffect);
					}
				}
			}

			if (e.field == "mid") {
				e.cellHtml = "总计: ";
			}
			if (e.field == "custsalenum") {
				e.cellHtml = custsalenum.toFixed(0);
			}
			if (e.field == "custsaleamt") {
				e.cellHtml = custsaleamt.toFixed(2);
			}
			if (e.field == "totalsale") {
				e.cellHtml = totalsale.toFixed(0);
			}
			if (e.field == "totalsaleamont") {
				e.cellHtml = totalsaleamont.toFixed(2);
			}
			if (e.field == "custsalerate") {
				e.cellHtml = custsalerate.toFixed(2);
			}
			if (e.field == "rent") {
				e.cellHtml = rent.toFixed(2);
			}
			if (e.field == "salesflat") {
				e.cellHtml = salesflat.toFixed(2);
			}
			if (e.field == "saleseffect") {
				e.cellHtml = saleseffect.toFixed(2);
			}
			e.cellStyle = "text-align:right";
		}
		
		
		var muid = mini.getbyName("muid");
		
		//弹框条件过滤
		function head_beforefunc(e, data) {
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var buttonEdit = e.sender;

			if (e.value != "undefined" && e.value != "") {
				e.searchParam.code = e.value;
			}
			
			//过滤门店
			if (buttonEdit.name == "muid") {
				e.searchParam.wherestr = " 2=2 ";
			}
			
			return 0;
		};
	</script>
	
	<script src="daysale-view.js" type="text/javascript"></script>
</body>
</html>