<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>整体招商进度监控查询表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">


	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>

	<div class="ocm-formheader" config="formheader1"></div>

	<div class="mini-fit">
		<div config="gridbox1" class="ocm-gridbox"
			style="width: 100%; height: 100%" showfooter="false"
			showPager="false"></div>

	</div>

	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js"
		type="text/javascript"></script>

	<script type="text/javascript">
		//字典数据初始化
		var dicData = OcmControl.getDict("BZTXT", "code,name,ddvalue")
				|| {};
		var nowstatus = [{code:"Y",name:"已核销"},{code:"N",name:"未核销"}]; 
		var iskp = [{code:"X",name:"是"},{code:"N",name:"否"}]; 
		var status_flag = [{code:"0",name:"未提"},{code:"1",name:"提取"}]; 
		var moduleid = "800111";
		var billmoduleid = "800111";

		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			}, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};

		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [  {
				"label" : "日期区间：",
				"type" : "DatePicker",
				"name" : "sdate",
				"format" : "yyyy-MM-dd",
				"enabled" : true,
				"required" : true,
				"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				/* "visible" : false, */
			}, {
				"label" : "--：",
				"type" : "DatePicker",
				"name" : "edate",
				"format" : "yyyy-MM-dd",
				"enabled" : true,
				"required" : true,
				"value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
				/* "visible" : false, */
			}, {
				"label" : "门店：",
				"name" : "muid",
				"type" : "ButtonEdit",
				"enabled" : true,
				//"required" : true,
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey:"muid",
				textName :"muid_name",
				beforefunc:"head_beforefunc",
				itemchangedfunc : "head_itemchanged_muid",
			}, {
				"label" : "门店：",
				"name" : "muid_name",
				"type" : "TextBox",
				"visible" : false,
			}, {
				"label" : "楼层：",
				"name" : "mmfid",
				"type" : "ButtonEdit",
				"enabled" : true,
				//"required" : true,
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey:"mmfidno",
				textName :"mmfid_name",
				beforefunc:"head_beforefunc",
			}]
		};

		//查询结果列表
		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid" : "select_drh800111",
			},
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				//showPager:false,
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				}, {
					field : "muid",
					headerAlign : "center",
					header : "费用编号",
					allowSort : false,
					visible : false,
					width : 180,
				}, {
					field : "mmfid_name",
					headerAlign : "center",
					header : "楼层",
					allowSort : false,
					visible : true,
					width : 200,
				}, {
					field : "spnum",
					headerAlign : "center",
					header : "商铺总数量",
					allowSort : false,
					visible : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : nowstatus,
					width : 80,
					vtype:"double",
					numberFormat : "#,##0",
				}, {
					field : "sumsplettarea",
					headerAlign : "center",
					header : "商铺总面积",
					allowSort : false,
					visible : true,
					width : 100,
					vtype:"double",
					numberFormat : "#,##0.00",
				}, {
					field : "spyz",
					headerAlign : "center",
					header : "已签约",
					allowSort : false,
					visible : true,
					width : 80,
					vtype:"double",
					numberFormat : "#,##0",
				}, {
					field : "spwz",
					headerAlign : "center",
					header : "未签约",
					allowSort : false,
					visible : true,
					width : 80,
					vtype:"double",
					numberFormat : "#,##0",
				}, {
					field : "todayqy",
					headerAlign : "center",
					header : "今日签约",
					allowSort : false,
					visible : true,
					width : 80,
					vtype:"double",
					numberFormat : "#,##0",
				}, {
					field : "ljsplettarea",
					headerAlign : "center",
					header : "累计签约面积",
					allowSort : false,
					visible : true,
					width : 120,
					vtype:"double",
					numberFormat : "#,##0.00",
				}, {
					field : "ljqye",
					headerAlign : "center",
					header : "累计签约额",
					allowSort : false,
					visible : true,
					width : 140,
					vtype:"double",
					numberFormat : "#,##0.00",
				}, {
					field : "ljyjzj",
					headerAlign : "center",
					header : "累计已缴租金",
					allowSort : false,
					visible : true,
					width : 140,
					vtype:"double",
					numberFormat : "#,##0.00",
				}, {
					field : "ljwjzj",
					headerAlign : "center",
					header : "累计未交租金",
					allowSort : false,
					visible : true,
					width : 140,
					vtype:"double",
					numberFormat : "#,##0.00",
				}, {
					field : "ljyjbzj",
					headerAlign : "center",
					header : "累计已缴保证金",
					allowSort : false,
					visible : true,
					width : 140,
					vtype:"double",
					numberFormat : "#,##0.00",
				} ]
			},
		};

		mini.parse();

		function onDrawSummaryCell(e) {
			var rows = e.data;
			var spnum = 0;
			var sumsplettarea = 0;
			var spyz = 0;
			var spwz = 0;
			var todayqy = 0;
			var ljsplettarea = 0;
			var ljqye = 0;
			var ljyjzj = 0;
			var ljwjzj = 0;
			var ljyjbzj = 0;

			if (rows.length > 0) {
				for (var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.spnum) == false) {
						spnum += parseFloat(row.spnum);
					}
					if (isNaN(row.sumsplettarea) == false) {
						sumsplettarea += parseFloat(row.sumsplettarea);
					}
					if (isNaN(row.spyz) == false) {
						spyz += parseFloat(row.spyz);
					}
					if (isNaN(row.spwz) == false) {
						spwz += parseFloat(row.spwz);
					}
					if (isNaN(row.todayqy) == false) {
						todayqy += parseFloat(row.todayqy);
					}
					if (isNaN(row.ljsplettarea) == false) {
						ljsplettarea += parseFloat(row.ljsplettarea);
					}
					if (isNaN(row.ljqye) == false) {
						ljqye += parseFloat(row.ljqye);
					}
					if (isNaN(row.ljyjzj) == false) {
						ljyjzj += parseFloat(row.ljyjzj);
					}
					if (isNaN(row.ljwjzj) == false) {
						ljwjzj += parseFloat(row.ljwjzj);
					}
					if (isNaN(row.ljyjbzj) == false) {
						ljyjbzj += parseFloat(row.ljyjbzj);
					}

				}
			}

			if (e.field == "mmfid_name") {
				e.cellHtml = "总计: ";
			}
			if (e.field == "spnum") {
				e.cellHtml = spnum;
			}
			if (e.field == "sumsplettarea") {
				e.cellHtml = sumsplettarea.toFixed(2);;
			}
			if (e.field == "spyz") {
				e.cellHtml = spyz;;
			}
			if (e.field == "spwz") {
				e.cellHtml = spwz;;
			}
			if (e.field == "todayqy") {
				e.cellHtml = todayqy;;
			}
			if (e.field == "ljsplettarea") {
				e.cellHtml = ljsplettarea.toFixed(2);;
			}
			if (e.field == "ljqye") {
				e.cellHtml = ljqye.toFixed(2);;
			}
			if (e.field == "ljyjzj") {
				e.cellHtml = ljyjzj.toFixed(2);;
			}
			if (e.field == "ljwjzj") {
				e.cellHtml = ljwjzj.toFixed(2);;
			}
			if (e.field == "ljyjbzj") {
				e.cellHtml = ljyjbzj.toFixed(2);;
			}
			e.cellStyle = "text-align:right";
		}

		var muid = mini.getbyName("muid");
		var contno=mini.getbyName("contno");
		var sbid = mini.getbyName("sbid");
		var form = new mini.Form("#formheader1");
		var querylist = mini.get("gridbox1");

		//弹框条件过滤
		function head_beforefunc(e, data) {
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var buttonEdit = e.sender;

			if (e.value != "undefined" && e.value != "") {
				e.searchParam.code = e.value;
			}

			//过滤门店
			if (buttonEdit.name == "muid") {
				e.searchParam.wherestr = " 2=2 ";
			}
			//过滤上级编码
			if (buttonEdit.name == "mmfid"){
				e.searchParam.wherestr = "";
				e.searchParam.wherestr += "Mmclass = '3'"
				if (muid.getValue() != ""){
					e.searchParam.wherestr += "And a.Muid = '"+ muid.getValue() + "' ";
				}
			}

			return 0;
		}
		
		function head_itemchanged_muid(e,data){
			mini.getbyName("mmfid").setValue("");
			mini.getbyName("mmfid").setText("");
			return 0;
		}
	</script>

	<script src="report.js" type="text/javascript"></script>



</body>
</html>