<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>商品明细报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
 <div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>	
	<script type="text/javascript">
	//字典数据初始化
	 var dictData = OcmControl.getDict("GBTYPE,WMID,GMFSTATUS","code,name,pro1,ddvalue") || {};

	    var WMID = [ {  code : "5",  name : "租赁"}, {  code : "4",  name : "联营"} ];
		var STATUS = [ {  code : "Y",  name : "有效"}, {  code : "N",  name : "无效"} ];
		var moduleid = "500908";
		var toolbar1 = {
			items : [ [ {
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
				"onclick" : "searchData",
				"enabled" : true,
			}, {
				"text" : "清除",
				"iconCls" : "icon-remove",
				"name" : "clearData",
				"onclick" : "clearData",
				"enabled" : true,
			} , {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
			} ] ]
		};

		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [ {
				"label" : "门店：",
				"name" : "muid",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey:"muid",//弹框类型
				textName :"muid_name", //文本显示字段
				itemchangedfunc:"head_itemchanged_muid",
				"enabled" : true,
			}, {
				"label" : "门店：",
				"name" : "mktid",
				"type" : "TextBox",
				"visible" : false,
			}, {
				"label" : "商户：",
				"name" : "sbid",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey:"sbid",//弹框类型
				textName :"sbid_name", //文本显示字段
				beforefunc:"head_beforefunc",
				itemchangedfunc : "head_itemchanged_sbid",
				"enabled" : true,
			}, {
	            "label" : "商铺：",
	            "name" : "spid",
				"type" : "ButtonEdit",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey:"spid",//弹框类型
				textName :"spid_name", //文本显示字段
				beforefunc:"head_beforefunc",
				itemchangedfunc : "head_itemchanged_spid",
				"enabled" : true,
			}, {
	            "label" : "商品类型：",
	            "type" : "ComboBox",
	            "name" : "gbtype",
	            "enabled" : true,
	            "showNullItem" : true,
	            "data" : dictData.GBTYPE,
			}, {
				"label" : "品牌：",
				"name" : "gbppcode",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey:"ppcode",//弹框类型
				textName :"gbppcode_name", //文本显示字段
				"enabled" : true,
			}, {
				"label" : "商品分类：",
				"name" : "gbcatcode",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey:"goodscat",//弹框类型
				textName :"gbcatcode_name", //文本显示字段
				"enabled" : true,
			}, {
				"label" : "商户：",
				"name" : "gmfsupid",
				"type" : "TextBox",
				"visible" : false,
			}, {
				"label" : "商铺：",
				"name" : "gmfmfid",
				"type" : "TextBox",
				"visible" : false,
			}, {
				"label" : "商品编码：",
				"type" : "TextBox",
				"name" : "gbid",
				"enabled" : true,
			}, {
				"label" : "商品条码：",
				"type" : "TextBox",
				"name" : "gbbarcode",
				"enabled" : true,
			}, {
	            "label" : "经营状态：",
	            "type" : "ComboBox",
	            "name" : "gbbstatus",
	            "enabled" : true,
	            "showNullItem" : true,
	            "data" : dictData.GMFSTATUS,
			} ]
		};

		var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mall,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid" : "select_goodsbase",
			},
			"properties" : {
				"id" : "gridbox1",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				}, {
					field : "mktid",
					header : "门店",
					headerAlign : "center",
					width : 180,
				}, {
					field : "gmfsupid",
					header : "商户",
					headerAlign : "center",
					width : 250,
				}, {
					field : "gmfmfid",
					header : "商铺",
					headerAlign : "center",
					width : 200,
				}, {
					field : "gbid",
					header : "商品编码",
					headerAlign : "center",
					width : 80,
				}, {
					field : "gbcname",
					header : "商品名称",
					headerAlign : "center",
					width : 180,
				}, {
					field : "gbbarcode",
					header : "商品条码",
					headerAlign : "center",
					width : 80,
				}, {
					field: "gbtype",
					header: "商品类型",
					headerAlign : "center",
					width : 80,
				}, {
					field : "gbstatus",
					headerAlign : "center",
					header : "经营状态",
					width : 80,
				}, {
					field : "gmfwmid",
					header : "经营方式",
					headerAlign : "center",
					width : 100,
				}, {
					field : "ppcode",
					header : "品牌",
					headerAlign : "center",
					width : 180,
				}, {
					field : "mid",
					header : "商品分类",
					headerAlign : "center",
					width : 120,
				}, {
					field : "gmpsj",
					header : "售价",
					headerAlign : "center",	
					width : 100,
					numberFormat : "n2",
					align: "right",
				}, {
					field : "gmfkl",
					header : "扣率",
					headerAlign : "center",	
					width : 100,
					numberFormat : "p2",
					align: "right",
				},{
					field : "gmfxstax", 
					header : "销售税率",
					headerAlign : "center",	
					width : 100,
					numberFormat : "p2",
					align: "right",
				},{
					field : "gmfxftax", 
					header : "消费税率",
					headerAlign : "center",	
					width : 100,
					numberFormat : "p2",
					align: "right",
				} ]
			},
		};

		mini.parse();
		
		function head_beforefunc(e){
			if(!e.searchParam){
				e.searchParam = {};
			}
			var buttonEdit = e.sender;
			if (e.value != "undefined" && e.value != ""){
				e.searchParam.code = e.value;
			}
			var muid = mini.getbyName("muid").getValue();
			if (muid) {
				muid = "'"+muid+"'";
			}else{
				muid = getManaunit("2");
			}
			var sbid = mini.getbyName("sbid");
			if (buttonEdit.name == "sbid") {
				e.searchParam.wherestr = "sbid in (select sbid from supmkt where muid in (" + muid + "))";
				
			}
			if (buttonEdit.name == "spid") {
				e.searchParam.wherestr = " muid in (" + muid + ")";
			}
			return 0;
		}
		
		function head_itemchanged_contno(e,data){
			mini.getbyName("sbid").setValue(data[0].sbid);
			mini.getbyName("gmfsupid").setValue(data[0].sbcode);
			mini.getbyName("sbid").setText(data[0].sbid_name);
			mini.getbyName("spid").setValue("");
			mini.getbyName("spid").setText("");
			return 0;
		}
		function head_itemchanged_sbid(e,data){
			mini.getbyName("gmfsupid").setValue(data[0].code);
			return 0;
		}
		function head_itemchanged_spid(e,data){
			mini.getbyName("gmfmfid").setValue(data[0].code);
			return 0;
		}
		function head_itemchanged_muid(e,data){
			mini.getbyName("mktid").setValue(data[0].mucode);
			mini.getbyName("sbid").setValue("");
			mini.getbyName("gmfmfid").setValue("");
			mini.getbyName("sbid").setText("");
			mini.getbyName("spid").setValue("");
			mini.getbyName("gmfsupid").setValue("");
			mini.getbyName("spid").setText("");
			return 0;
		}
	</script>
	<script src="report.js" type="text/javascript"></script>
</body>
</html>