mini.parse();
var gridbox = mini.get("gridbox1");
var initData = null;

if (gridbox) {
    gridbox.on("cellcommitedit", onCellCommitEdit);
    gridbox.on("cellbeginedit", onCellbeginedit);
}
//初始传入方法
function SetData(data) {
    init(data);
}
function init(data) {
    var obj= {};
    if(data.length > 0) {
        for (var i = 0; i < data.length;i++) {
            data[i].billstatus = "N";
            data[i].billmoduleid = billmoduleid;
            data[i].ccarea = "B";
            data[i].cctstatus = "1";
            data[i].ccprecision = "0";
            data[i].cciskp = "N";
            data[i].cciszk = "0";  //是否票减为默认为Y
            data[i].cctaxtype = "1";
            data[i].ccisdk = "N";
            data[i].acctype = "N";
            data[i].ccisznj = "N";
            data[i].cctype = "01";
            data[i].ccsetbilltype = "01";
            data[i].cocode = "0";
            data[i].rent_r2s = "N";
            data[i].defaultcost = "n";
            data[i].nsta= "2021";
        }
        gridbox.addRows(data);
    } else {
        gridbox.addRow(obj);
    }
}

function onCellbeginedit(e){
    var editor = e.editor;
    var record = e.record;
    var field = e.field;
    var grid = e.sender;
    if (field == "tpdkssj" && e.rowIndex!=0) {
        e.cancel = true;
        return -1;
    }
    if (field == "cciskp") {
        if(record.ccdeftype == "16"){
            e.cancel = true;
        }
    }
}

function onCellCommitEdit(e){
    var value = e.value;
    var field = e.field;
    var record = e.record;
    var rows = gridbox.getData();
    if (field == "cccode") {
        //判断列表中是否有相同的编码
        if (!checkonecccode(value,record._id,rows)) {
            mini.alert("费用代码重复，请检查");
            e.cancel = true;
            return;
        }
    }
    if (field == "cccname") {
        //判断列表中是否有相同的中文名
        if (!checkonecccname(value,record._id,rows)) {
            mini.alert("费用名称重复，请检查");
            e.cancel = true;
            return;
        }
    }
    if (field == "cciszk") {
        if(record.ccdeftype == "3" || record.ccdeftype == "8"){
            if (value == "Y") {
                mini.alert("提取方式为[3]固定租金或[8]抽成租金时，不能为[Y]票减");
                var row={
                    "cciszk" : "0"
                };
                grid.updateRow(record,row);
                e.cancel = true;
                return;
            }
        }
    }
}

function Ok(e) {
    var obj = saveData();
    if (obj == true) {
        window.CloseOwnerWindow(obj);
    }
}

function Cancel(e) {
    window.CloseOwnerWindow("close");
}

//保存
function saveData() {
    var saveflag = false;
    var gridbox1changes = gridbox.getChanges();
    for(var i = 0;i<gridbox1changes.length;i++){
        var row = gridbox1changes[i];
        if(chargeRulemode != "1"){
            if (!row.cccode) {
                mini.alert("费用编码不能为空！");
                return;
            } else {
                if (!checkCodecharges(row.cccode)) {
                    mini.alert("费用编码：["+row.cccode+"] 已存在")
                    return;
                }
            }
        }
        if (!row.cccname) {
            mini.alert("费用名称不能为空！");
            return;
        } else {
            if (!checkCodecharges(row.cccname)) {
                mini.alert("费用名称：["+row.cccname+"] 已存在")
                return;
            }
        }
        if (!row.ccdeftype) {
            mini.alert("费用提取方式不能为空！");
            return;
        }
        if((row.ccdeftype == '3' || row.ccdeftype == '8') && row.cciszk == "Y" ){
            mini.alert("提取方式为[3]固定租金或[8]抽成租金时，不能为[Y]票减");
            return;
        }
        if(row.cciskp == 'Y' && row.fykptype == ""){
            mini.alert("第" + (i + 1) + "行请选择税务分类");
            return;
        }
        gridbox1changes[i].nsta = "2021";
        //gridbox1changes[i].tmdd = getTmdd();
    }
    setGridData(gridbox1changes);
    itemLoader.doRequest(OmdUrl.mall, 'mall.work.codecharge.save', gridbox1changes, null, null, function(data) {
        saveflag = true;
    }, null, null, false);
    return saveflag;
}

function checkCodecharges(value) {
    var flag = true;
    var method="mall.mdm.codecharge.search";
    var searchParam = {
        "$or": [{"cccode": {"==": value}}, {"cccname": {"==": value}}, {"ccename": {"==": value}}],
    };
    itemLoader.doRequest(OmdUrl.mallmdm, method, searchParam, null, null, function(data) {
        if (data.codecharge && data.codecharge.length > 0){
            flag = false;
        }
    }, null, null, false);
    return flag;
}

function checkonecccode(value,_id,rows) {
    var checkcccodeflag = true;
    for (var i = 0; i < rows.length;i++) {
        if (rows[i]._id != _id && rows[i].cccode == value) {
            checkcccodeflag = false;
            break;
        }
    }
    return checkcccodeflag;
}

function checkonecccname(value,_id,rows) {
    var checkcccnameflag = true;
    for (var i = 0; i < rows.length;i++) {
        if (rows[i]._id != _id && rows[i].cccname == value) {
            checkcccnameflag = false;
            break;
        }
    }
    return checkcccnameflag;
}