<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>门店销售年龄段查询报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	
	<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>

  <script type="text/javascript">
  //字典数据初始化
  var moduleid = "500918";
  
  var saleage = [ {  code : "0",  name : "未录入"},{  code : "1",  name : "16岁以下"},{  code : "2",  name : "16-25岁"},
                    {  code : "3",  name : "26-35岁"},{  code : "4",  name : "36-45岁"},
                    {  code : "5",  name : "46-55岁"},{  code : "6",  name : "56岁以上"}];
  
 var conttype = [ {  code : "01",  name : "正柜"},{  code : "02",  name : "特卖"}];
 var cnwmid = [ {  code : "5",  name : "租赁"}, {  code : "4",  name : "联营"} ];
  var toolbar1 = {
		    items : [ [ {
		      "text" : "查询",
		      "iconCls" : "icon-search",
		      "name" : "searchData",
		      "onclick" : "searchData",
		      "enabled" : true,
		    }, {
		      "text" : "清除",
		      "iconCls" : "icon-remove",
		      "name" : "clearData",
		      "onclick" : "clearData",
		      "enabled" : true,
		    } , {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
		    } ] ]
		  };


		var formheader1 = {
				"type" : "formgrid",
				"properties" : {
					"id" : "formheader1",
				},
				items : [ {
					"label" : "销售月份：",
					"type" : "MonthPicker",
					"name" : "sdate",
					"format" : "yyyy-MM",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
					"style" : "width:30%"
				}, {
					"label" : "销售月份：",
					"type" : "MonthPicker",
					"name" : "edate",
					"format" : "yyyy-MM",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
					"style" : "width:30%"
				}, {
					"label" : "销售门店：",
					"type" : "ButtonEdit",
					"name" : "mktid",
					"enabled" : true,
					"onbuttonclick" : "onMktidClick",
					"onValuechanged" : "onMktidChange",
					"style" : "width:30%"
				}, {
					"label" : "会员年龄：",
					"type" : "ComboBox",
					"name" : "saleage",
					"enabled" : true,
					"data" : saleage,
					"style" : "width:30%"
				}, {
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "wmid",
					"enabled" : true,
					"data" : cnwmid,
					"style" : "width:30%"
				}, {
					"label" : "合同类型：",
					"type" : "ComboBox",
					"name" : "conttype",
					"enabled" : true,
					"data" : conttype,
					"style" : "width:30%"
				} ]
			};


		var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_saleage",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "cdlmkt",
						header : "门店",
						allowSort : true,
						headerAlign : "center",
						width : 160,
					}, {
						field : "age",
						header : "会员年龄",
						type : "comboboxcolumn",  
						headerAlign : "center",
						readOnly: true,
 		        	    textField:"name",
		        	    valueField:"code" , 
						data: saleage,
						renderer: "OcmControl.dictRendererWithCode",
						width : 100,
					}, {
						field : "num",
						header : "人数",
						allowSort : true,
						headerAlign : "center",
						width : 160,
					}, {
						field : "xssr",
						header : "消费金额",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 100,
					}, {
						field : "jl",
						header : "交易笔数",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 100,
					}, {
						field : "dj",
						header : "客单价",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 100,
					}, {
						field : "tdj",
						header : "人均消费金额",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 100,
					}, {
						field : "tjl",
						header : "人均消费笔数",
						allowSort : true,
						headerAlign : "center",
						numberFormat : "#,0.00",
						vtype : "float",
						align : "right",
						width : 100,
					}]
				},
			};
			mini.parse();
			
			function onDrawSummaryCell(e) {
	 			var rows = e.data;
				var list = [];
				var flag = false;
				if (rows.length > 0) {
					for (var i = 0; i < rows.length; i++) {
						flag = false;
						var row = rows[i];
						var para = {};
						para.key = row.cdlmkt;
						para.num  = parseFloat(row.num);
						para.xssr  = parseFloat(row.xssr);
						para.jl  =  parseFloat(row.jl);
						for (var j=0;j<list.length;j++) {
							if (para.key == list[j].key) {
								list[j].num = list[j].num + para.num;
								list[j].xssr = list[j].xssr +  para.xssr;
								list[j].jl = list[j].jl +  para.jl;
								flag =true;
								break;
							}
						}
						
						if (!flag) {
							list.push(para);
						}
					}
				}
				
			
				if (e.field == "cdlmkt") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var key = list[i].key;
						str=str + "<b>"+key+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "num") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var num = list[i].num;
						str=str + "<b>"+num+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "xssr") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var xssr = list[i].xssr;
						str=str + "<b>"+xssr.toFixed(2)+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "jl") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var jl = list[i].jl;
						str=str + "<b>"+jl+"</b><br>";
					}
					e.cellHtml = str;
				}
				
				if (e.field == "dj") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var dj = list[i].xssr/list[i].jl;
						str=str + "<b>"+dj.toFixed(2)+"</b><br>";
					}
					e.cellHtml = str;
				}
				
				if (e.field == "tdj") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tdj = list[i].xssr/list[i].num;
						str=str + "<b>"+tdj.toFixed(2)+"</b><br>";
					}
					e.cellHtml = str;
				}
				
				if (e.field == "tjl") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tjl = list[i].jl/list[i].num;
						str=str + "<b>"+tjl.toFixed(2)+"</b><br>";
					}
					e.cellHtml = str;
				}
				e.cellStyle = "text-align:right"; 
			}
		</script>

  <script src="profit.js" type="text/javascript"></script>
</body>
</html>