<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>门店会员销售报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	
	<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>

  <script type="text/javascript">
  //字典数据初始化
  var moduleid = "500920";
  var dictData = OcmControl.getDict("CONTTYPE","code,name,pro1,ddvalue") || {};
  var salexs = [ {  code : "1",  name : "销售总额"},{  code : "2",  name : "会员销售额"}, {  code : "3",  name : "非会员销售额"}];
  
  var conttype = [  {  code : "01",  name : "正柜"},{  code : "02",  name : "特卖"} ];
  var cnwmid = [ {  code : "5",  name : "租赁"}, {  code : "4",  name : "联营"} ];

  var toolbar1 = {
		    items : [ [ {
		      "text" : "查询",
		      "iconCls" : "icon-search",
		      "name" : "searchData",
		      "onclick" : "searchData",
		      "enabled" : true,
		    }, {
		      "text" : "清除",
		      "iconCls" : "icon-remove",
		      "name" : "clearData",
		      "onclick" : "clearData",
		      "enabled" : true,
		    }, {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
		    } ] ]
		  };


		var formheader1 = {
				"type" : "formgrid",
				"properties" : {
					"id" : "formheader1",
				},
				items : [  {
					"label" : "发生月：",
			         "name" : "fssdate",
			         "type" : "MonthPicker",
					 "format" : "yyyy-MM",
					 "enabled" : true,
					 "value" : mini.formatDate(new Date(), "yyyy-MM"),
					 "defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
			         "style" : "width:30%"
				}, {
					"label" : "至：",
					"type" : "MonthPicker",
					"name" : "fsedate",
					"format" : "yyyy-MM",
					"enabled" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
			         "style" : "width:30%"
				},{
					"label" : "销售门店：",
					"type" : "ButtonEdit",
					"name" : "scdmkt",
					"enabled" : true,
					"onbuttonclick" : "onMktidClick",
					"onValuechanged" : "onMktidChange",
					"style" : "width:30%"
				},{
					"label" : "记账月：",
			         "name" : "sdate",
			         "type" : "MonthPicker",
					 "format" : "yyyy-MM",
					 "enabled" : true,
					 /* "required" : true,
					 "value" : mini.formatDate(new Date(), "yyyy-MM"),
					 "defaultValue" : mini.formatDate(new Date(), "yyyy-MM"), */
			         "style" : "width:30%"
				}, {
					"label" : "至：",
					"type" : "MonthPicker",
					"name" : "edate",
					"format" : "yyyy-MM",
					"enabled" : true,
					/* "required" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"), */
			         "style" : "width:30%"
				},{
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "wmid",
					"enabled" : true,
					"data" : cnwmid,
					"style" : "width:30%"
				}, /* =  =P~ 2018.07.20 EOMLT-739  销售类报表取消合同相关查询条件
				   {
					"label" : "合同类型：",
					"type" : "ComboBox",
					"name" : "conttype",
					"enabled" : true,
					"data" : dictData.CONTTYPE,
					"style" : "width:30%"
				} */ ]
			};


		var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_salecard",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "scdmkt",
						header : "门店",
						allowSort : false,
						headerAlign : "center",
						width : 160,
					}, {
						field : "flag",
						header : "销售范围",
						type : "comboboxcolumn",  
						headerAlign : "center",
						readOnly: true,
 		        	    textField:"name",
		        	    valueField:"code", 
						data: salexs,
						renderer: "OcmControl.dictRendererWithCode",
						width : 100,
						allowSort : false,
					}, {
						field : "xssr",
						header : "本期销售",
						allowSort : false,
						headerAlign : "center",
						width : 100,
						dataType : "float",
						align : "right",
					}, {
						field : "oxssr",
						header : "同期销售",
						allowSort : false,
						headerAlign : "center",
						width : 100,
						dataType : "float",
						align : "right",
					}, {
						field : "txssr",
						header : "销售同比",
						headerAlign : "center",
						align : "right",
						allowSort : false,
						renderer:"OnTbmrvalue",
						width : 100,
					}, {
						field : "dxssr",
						header : "销售同比差额",
						allowSort : false,
						headerAlign : "center",
						dataType : "float",
						align : "right",
						width : 100,
					}, {	
						field : "jxssr",
						header : "本期结构(%)",
						headerAlign : "center",
						numberFormat : "p2",
						align : "right",
						allowSort : false,
					}, {
						field : "ojxssr",
						header : "同期结构(%)",
						headerAlign : "center",
						numberFormat : "p2",
						align : "right",
						allowSort : false,
					}, {
						field : "pjxssr",
						header : "同比结构差异",
						headerAlign : "center",
						numberFormat : "p2",
						align : "right",
						allowSort : false,
					} ]
				},
			};
			mini.parse();
			
			
			function onDrawSummaryCell(e) {
				var rows = e.data;
				var xssr = 0;
				var oxssr = 0;
				if (rows.length > 0) {
					for (var i = 0; i < rows.length; i++) {
						var row = rows[i];
						if (row.flag == '1') {
							xssr  += parseFloat(row.xssr);
							oxssr  += parseFloat(row.oxssr);
						}
					}
				}

				if (e.field == "sglmarket") {
					e.cellHtml = "<b>" + "合计: " + "</b>";
				}
				if (e.field == "xssr") {
					e.cellHtml = "<b>" + xssr.toFixed(2) + "</b>";
				}
				if (e.field == "oxssr") {
					e.cellHtml = "<b>" + oxssr.toFixed(2) + "</b>";
				}
				if (e.field == "dxssr") {
					var dxssr =xssr-oxssr;
					e.cellHtml = "<b>" + dxssr.toFixed(2) + "</b>";
				}
				if (e.field == "txssr") {
					if (oxssr == 0) {
						e.cellHtml = "<b>—</b>";
					} else {
						var txssr = (xssr-oxssr)/xssr;
						e.cellHtml = "<b>" + txssr.toFixed(2) + "</b>";
					}
					
				}
				e.cellStyle = "text-align:right";
			}
			
			function OnTbmrvalue(e) {
				var value = e.value;
				if (Number(value) == 0) {
					return "—";
				} else {
					 var temp = Number(value) * 100;
					 value = temp.toFixed(2) + "%";
				}
				return value;
			};
		</script>

  <script src="profit.js" type="text/javascript"></script>
</body>
</html>