<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<!DOCTYPE html />
<html>
<head>
<title>销售对比</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">

    <div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	
	<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" 
		    style="width: 100%; height: 100%" showfooter="false"
			showPager="false"></div>
	</div>

    <script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js"
		type="text/javascript"></script>
	
     <script type="text/javascript">
		//字典数据初始化
		function getDictData() {
		 var dictData = {};
		   var searchParam = {"dict_group_code":"SETMODE"};
					  itemLoader.doRequest(OmdUrl.master, "omp.work.dict.getbydictgroupcode",
							 searchParam, null, null, function(data) {
						 dictData = data;
			}, null, null, false);
		  return dictData;
		}
		var dicData =  getDictData();
			
	    var toolbar1 = {
				items : [ [ {
					"text" : "查询",
					"iconCls" : "icon-search",
					"name" : "searchData",
					"onclick" : "searchData",
					"enabled" : true,
				}, {
					"text" : "清除",
					"iconCls" : "icon-remove",
					"name" : "clearData",
					"onclick" : "clearData",
					"enabled" : true,
				}, {
					"text" : "导出",
					"iconCls" : "icon-upload",
					"name" : "exportData",
					"onclick" : "exportData",
					"enabled" : true,
				} ] ]
			};
	    
	    
	  //查询条件
		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [{
				"label" : "统计月份：",
				"name" : "startdate",
				"type" : "MonthPicker",
				"enabled" : true,
				"required" : true,
			},{
				"label" : "统计月份：",
				"name" : "enddate",
				"type" : "MonthPicker",
				"enabled" : true,
				"visible" : false,
			},{
				"label" : "上月第一天：",
				"name" : "firstdate",
				"type" : "MonthPicker",
				"enabled" : true,
				"visible" : false,
			},{
				"label" : "上月最后一天：",
				"name" : "lastdate",
				"type" : "MonthPicker",
				"enabled" : true,
				"visible" : false,
			},{
				"label" : "去年统计月第一天：",
				"name" : "firstyear",
				"type" : "MonthPicker",
				"enabled" : true,
				"visible" : false,
			},{
				"label" : "去年统计月最后一天：",
				"name" : "lastyear",
				"type" : "MonthPicker",
				"enabled" : true,
				"visible" : false,
			},{
				"label" : "门店：",
				"name" : "muid",
				"type" : "ButtonEdit",
				"enabled" : true,
				"defaultValue" : "",
				
				type : "fut_popselect",
				selectkey : "muid",
				textName : "muid_name",
				beforefunc : "head_beforefunc",
			},{
				"label" : "门店：",
				"name" : "muid_name",
				"type" : "TextBox",
				"visible" : false,
			},{
				"label" : "经营品牌：",
				"name" : "ppcode",
				"type" : "ButtonEdit",
				"enabled" : true,
				"defaultValue" : "",
				
				type : "fut_popselect",
				selectkey:"ppcode",
				beforefunc:"head_beforefunc",
				textName :"ppcode_name",
			},{
				"label" : "品牌：",
				"name" : "ppcode_name",
				"type" : "TextBox",
				"visible" : false,
			},{
				"label" : "租户：",
				"name" : "sbid",
				"type" : "ButtonEdit",
				"defaultValue" : "",
				"enabled" : true,
				
				type : "fut_popselect",
				selectkey:"sbid",
				textName :"sbid_name",
				beforefunc:"head_beforefunc",
			},{
				"label" : "租户：",
				"name" : "sbid_name",
				"type" : "TextBox",
				"visible" : false,
			},{
				"label" : "合同：",
				"name" : "contno",
				"defaultValue" : "",
				"enabled" : true,
				"visible":true,
				type : "fut_popselect",
				selectkey:"contno",
				beforefunc:"head_beforefunc",
				
			},{
				"label" : "楼层:",
				"name" : "floorid",
				"defaultValue" : "",
				"enabled" : true,
				"visible":true,
				type : "fut_popselect",
				selectkey:"floor",
				textName :"floorid_name"
			},{
				"label" : "楼层：",
				"name" : "floorid_name",
				"type" : "TextBox",
				"visible" : false,
			},{
		        "label" : "结算方式：",
		           "type" : "ComboBox",
		           "name" : "setmode",
		           "enabled" : true,
		           "data" : dicData.SETMODE,
		           "style" : "width:30%"
		        }]	
	  };
     
	  
		var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mss,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid":"select_salesdb",
				},
				"oncellbeginedit" : "OcmControl.checkboxEditor",
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					},{
						field : "contno",
						headerAlign : "center",
						header : "合同号",
						allowSort : false,
						width : 120,
					},{
						field : "spid",
						headerAlign : "center",
						header : "铺位号",
						allowSort : false,
						width : 120,
					},{
						field : "sbid",
						headerAlign : "center",
						header : "租户",
						allowSort : false,
						width : 220,
					},{
						field : "ppcode",
						headerAlign : "center",
						header : "品牌",
						allowSort : false,
						width : 120,
					},{
						field : "bqxs",
						headerAlign : "center",
						header : "销售额",
						allowSort : false,
						visible : true,
						vtype:"double",
						numberFormat : "#,##0.00",
						width : 150,
					},{
						field : "sqxs",
						headerAlign : "center",
						header : "上期（与所选统计期间对应）",
						allowSort : false,
						visible : true,
						vtype:"double",
						numberFormat : "#,##0.00",
						width : 160,
					},{
						field : "sqzf",
						headerAlign : "center",
						header : "增幅%",
						allowSort : false,
						visible : true,
						vtype:"float",
						numberFormat : "p0",
						width : 100,
					},{
						field : "qntqxs",
						headerAlign : "center",
						header : "上年同期（与所选统计期间对应）",
						allowSort : false,
						visible : true,
						vtype:"double",
						numberFormat : "#,##0.00",
						width : 180,
					},{
						field : "qntqzf",
						headerAlign : "center",
						header : "增幅%",
						allowSort : false,
						visible : true,
						vtype:"double",
						numberFormat : "p0",
						width : 100,
					}]
				}
		};
		
		mini.parse();
		
		function onDrawSummaryCell(e) {
			var rows = e.data;
			var bqxs = 0;
			var sqxs = 0;
			var qntqxs = 0;

			if (rows.length > 0) {
				for (var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.bqxs) == false) {
						bqxs += parseFloat(row.bqxs);
					}
					if (isNaN(row.sqxs) == false) {
						sqxs += parseFloat(row.sqxs);
					}
					if (isNaN(row.qntqxs) == false) {
						qntqxs += parseFloat(row.qntqxs);
					}

				}
			}

			if (e.field == "ppcode") {
				e.cellHtml = "总计: ";
			}
			if (e.field == "bqxs") {
				e.cellHtml = bqxs.toFixed(2);
			}
			if (e.field == "sqxs") {
				e.cellHtml = sqxs.toFixed(2);
			}
			if (e.field == "qntqxs") {
				e.cellHtml = qntqxs.toFixed(2);
			}
			e.cellStyle = "text-align:right";
		}
		
		var muid = mini.getbyName("muid");
		var contno=mini.getbyName("contno");
		var sbid = mini.getbyName("sbid");
		var form = new mini.Form("#formheader1");
		var querylist = mini.get("gridbox1");
		
		//弹框条件过滤
		function head_beforefunc(e, data) {
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var buttonEdit = e.sender;

			if (e.value != "undefined" && e.value != "") {
				e.searchParam.code = e.value;
			}

			//过滤大区
			/* if (buttonEdit.name == "dq") {
				e.searchParam.wherestr = " mfclass = 3";
			} */
			//过滤门店
			if (buttonEdit.name == "muid") {
				e.searchParam.wherestr = " 2=2 ";
				/* if (dq.getValue() != "") { */
				/* 	e.searchParam.wherestr += " and muid in (select muid from manaorg where mfpid in( select mfid from manaorg where mfpid in (select mfid from manaorg where mfid = '"
							+ dq.getValue() + "'))) "; 
				 }*/
			}
			//设置合同
			if (buttonEdit.name == "contno"){
				e.searchParam.wherestr = "";
				e.searchParam.wherestr += " 2=2 ";
				if (muid.getValue() != ""){
					e.searchParam.wherestr += " and muid = '"+ muid.getValue() + "' ";
				}
				if (sbid.getValue() != ""){
					e.searchParam.wherestr += " and sbid = '"+ sbid.getValue() + "' ";
				}
			}
			

			return 0;
		}
     </script>
     
     <script src="saledb.js" type="text/javascript"></script>
</body>
</html>