<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>门店前六类品牌TOP10销售报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	
	<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>

  <script type="text/javascript">
  //字典数据初始化
  var moduleid = "500919";
  
  var cnwmid = [ {  code : "5",  name : "租赁"}, {  code : "4",  name : "联营"} ];

  var toolbar1 = {
		    items : [ [ {
		      "text" : "查询",
		      "iconCls" : "icon-search",
		      "name" : "searchData",
		      "onclick" : "searchData",
		      "enabled" : true,
		    }, {
		      "text" : "清除",
		      "iconCls" : "icon-remove",
		      "name" : "clearData",
		      "onclick" : "clearData",
		      "enabled" : true,
		    } , {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
		    } ] ]
		  };


		var formheader1 = {
				"type" : "formgrid",
				"properties" : {
					"id" : "formheader1",
				},
				items : [ {
					"label" : "开始时间：",
			         "name" : "sdate",
			         "type" : "MonthPicker",
						"format" : "yyyy-MM",
						"enabled" : true,
						"required" : true,
						"value" : mini.formatDate(new Date(), "yyyy-MM"),
						"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
			         "style" : "width:30%"
				}, {
					"label" : "结束时间：",
					"type" : "MonthPicker",
					"name" : "edate",
					"format" : "yyyy-MM",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
			         "style" : "width:30%"
				}, {
					"label" : "销售门店：",
					"type" : "ButtonEdit",
					"name" : "scdmkt",
					"enabled" : true,
					"onbuttonclick" : "onMktidClick",
					"onValuechanged" : "onMktidChange",
					"style" : "width:30%"
				}, {
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "wmid",
					"enabled" : true,
					"data" : cnwmid,
					"style" : "width:30%"
			      }, {
			        "label" : "商品分类：",
			        "type" : "ButtonEdit",
			        "name" : "dcat",
			        "enabled" : true,
			        "onbuttonclick" : "onDGoodstypeClick",
			        "onValuechanged" : "onDGoodstypeChange",
			        "style" : "width:30%"
				} ]
			};


		var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_salesppcode",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "mktid",
						header : "门店",
						allowSort : true,
						headerAlign : "center",
						width : 160,
					}, {
						field : "catid",
						header : "经营种类",
						allowSort : true,
						headerAlign : "center",
						width : 120,
					}, {
						field : "rn",
						header : "排名",
						allowSort : true,
						headerAlign : "center",
						width : 60,
					}, {
						field : "brandid",
						header : "商品品牌",
						allowSort : true,
						headerAlign : "center",
						width : 120,
					}, {
						field : "xssr",
						header : "当期销售",
						allowSort : true,
						headerAlign : "center",
						dataType : "float",
						align : "right",
						width : 100,
					}, {
						field : "tqxssr",
						header : "同期销售",
						allowSort : true,
						headerAlign : "center",
						dataType : "float",
						align : "right",
						width : 100,
					}, {
						field : "tb",
						header : "同比",
						headerAlign : "center",
						align : "right",
						allowSort : false,
						renderer:"OnTbvalue",
					}, {
						field : "ypx",
						header : "月均坪效",
						headerAlign : "center",
						dataType : "float",
						align : "right",
						allowSort : true,
					} ]
				},
			};
			mini.parse();
			
			function onDrawSummaryCell(e) {
				var rows = e.data;
				var xssr = 0.00;
				var tqxssr = 0.00;
				if (rows.length > 0) {
					for (var i = 0; i < rows.length; i++) {
						var row = rows[i];
						if (isNaN(row.xssr) == false) {
							xssr += parseFloat(row.xssr);
						}
						if (isNaN(row.tqxssr) == false) {
							tqxssr += parseFloat(row.tqxssr);
						}
					}
				}

				if (e.field == "catid") {
					e.cellHtml = "<b>" + "合计: " + "</b>";
				}
				if (e.field == "xssr") {
					e.cellHtml = "<b>" + xssr.toFixed(2) + "</b>";
				}
				if (e.field == "tqxssr") {
					e.cellHtml = "<b>" + tqxssr.toFixed(2) + "</b>";
				}
				e.cellStyle = "text-align:right";
			}
		</script>

  <script src="report.js" type="text/javascript"></script>
</body>
</html>