<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>门店品牌销售规模</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>	
	<div style="color:red;">&nbsp;&nbsp;&nbsp;是否晋级：占比比去年同期高晋级；是否降级：占比比去年同期低降级。</div><br>
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/commonfunc.js" type="text/javascript"></script>
  <script type="text/javascript">
  //字典数据初始化
  var moduleid = "500917";
  
  var dictData = OcmControl.getDict("WMID,SALESCALE","code,name,pro1,ddvalue") || {};
  
  var toolbar1 = {
		    items : [ [ {
		      "text" : "查询",
		      "iconCls" : "icon-search",
		      "name" : "searchData",
		      "onclick" : "searchData",
		      "enabled" : true,
		    }, {
		      "text" : "清除",
		      "iconCls" : "icon-remove",
		      "name" : "clearData",
		      "onclick" : "clearData",
		      "enabled" : true,
		    } , {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
		    } ] ]
		  };


		var formheader1 = {
				"type" : "formgrid",
				"properties" : {
					"id" : "formheader1",
				},
				items : [ {
					"label" : "开始日期：",
					"type" : "DatePicker",
					"name" : "sdate",
					"format" : "yyyy-MM-dd",
					 "required" : "true",
					"enabled" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				}, {
					"label" : "结束日期：",
					"type" : "DatePicker",
					"name" : "edate",
					"format" : "yyyy-MM-dd",
					"required" : "true",
					"enabled" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				}, {
					"label" : "销售门店：",
					"name" : "mktid",
					"defaultValue" : "",
					type : "fut_popselect",//类型
					selectkey:"muid",//弹框类型
					textName :"muid_name", //文本显示字段
					"enabled" : true,
					"style" : "width:30%"
				}, {
					"label" : "销售规模：",
					"type" : "ComboBox",
					"name" : "salescale",
					"enabled" : true,
					"data" : dictData.SALESCALE,
					"style" : "width:30%"
				}, {
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "wmid",
					"enabled" : true,
					"data" : dictData.WMID,
					"style" : "width:30%"
				}]
			};


		var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_salescale",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "mktid",
						header : "门店",
						allowSort : true,
						headerAlign : "center",
						width : 160,
					}, {
						field : "salescale",
						header : "销售规模",
						allowSort : false,
						headerAlign : "center",
						width : 140,
					}, {
						field : "brandid",
						header : "品牌",
						allowSort : true,
						headerAlign : "center",
						width : 160,
					}, {
						header : "当期销售",
						allowSort : true,
						headerAlign : "center",
						"columns" : [{
							field : "xssr",
							header : "销售额",
							allowSort : true,
							headerAlign : "center",
							numberFormat : "#,0.00",
							vtype : "float",
							align : "right",
							width : 100,
						}, {
							field : "zb",
							header : "占比",
							headerAlign : "center",
							numberFormat : "p2",
							vtype : "float;range:0,1",
							align : "right",
							allowSort : true,
							editorSet : {onValuechanged : "setdoublevalue"},
						 }]
					}, {
						header : "同期销售",
						allowSort : true,
						headerAlign : "center",
						"columns" : [{
							field : "tqxssr",
							header : "销售额",
							allowSort : true,
							headerAlign : "center",
							numberFormat : "#,0.00",
							vtype : "float",
							align : "right",
							width : 100,
						}, {
							field : "tqzb",
							header : "占比",
							headerAlign : "center",
							numberFormat : "p2",
							vtype : "float;range:0,1",
							align : "right",
							allowSort : true,
							editorSet : {onValuechanged : "setdoublevalue"},
						 }]
					}, {
						field : "isup",
						header : "是否晋级",
						allowSort : false,
						headerAlign : "center",
						width : 100,
					}, {
						field : "isdrop",
						header : "是否降级",
						allowSort : false,
						headerAlign : "center",
						width : 100,
					}]
				},
			};
			mini.parse();
			
			
			function onDrawSummaryCell(e) {
				var rows = e.data;
                var list = [];
                var Para= {};
                Para.xssr =  "0";
                Para.tqxssr = "0";
            	for ( var i = 0; i < rows.length; i++) {
					var row = rows[i];
					Para.xssr =   accAdd(row.xssr,Para.xssr) ;
					Para.tqxssr =   accAdd(row.tqxssr,Para.tqxssr) ;
				}

				if (rows.length > 0) {
					for ( var i = 0; i < rows.length; i++) {
						flag = false;
						var para={};
						var row = rows[i];
						para.key = row.mktid;
						para.xssr =  row.xssr;
						para.tqxssr =  row.tqxssr;
						for(var j=0;j<list.length; j++) {
							if (list[j].key == para.key) {
								list[j].xssr =  accAdd(list[j].xssr,para.xssr);
								list[j].tqxssr =  accAdd(list[j].tqxssr,para.tqxssr);
								flag = true;
								break;
							}
						}
						if (!flag) {
							list.push(para);
						}
					}
				}
				if (e.field == "mktid") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var key = list[i].key;
						str=str + "<b>"+key+"</b><br>";
					}
					e.cellHtml = str;
				}
				if (e.field == "mktid") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var key = list[i].key;
						str=str + "<b>"+key+"</b><br>";
					}
					str=str + "<b>总计: </b><br>";
					e.cellHtml = str;
				}
				
				if (e.field == "xssr") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var xssr = list[i].xssr;
						str=str + "<b>"+Number(xssr).toFixed(2)+"</b><br>";
					}
					str=str + "<b>"+Number(Para.xssr).toFixed(2)+"</b><br>";
					e.cellHtml = str;
				}
				
				if (e.field == "tqxssr") {
					var str="";
					for (var i=0;i<list.length; i++) {
						var tqxssr = list[i].tqxssr;
						str=str + "<b>"+Number(tqxssr).toFixed(2)+"</b><br>";
					}
					str=str + "<b>"+Number(Para.tqxssr).toFixed(2)+"</b><br>";
					e.cellHtml = str;
				}
				
				e.cellStyle = "text-align:right";
			}
		</script>

  <script src="report.js" type="text/javascript"></script>
</body>
</html>