<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>门店主要指标完成情况报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
	
	<div class="ocm-formheader" config="formheader1"></div>
	
	<div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>

  <script type="text/javascript">
  //字典数据初始化
  var moduleid = "500914";
  // var cnwmid = [ {  code : "5",  name : "租赁"}, {  code : "4",  name : "联营"} ];
  var dictData = OcmControl.getDict("WMID","code,name,pro1,ddvalue")

  var toolbar1 = {
		    items : [ [ {
		      "text" : "查询",
		      "iconCls" : "icon-search",
		      "name" : "searchData",
		      "onclick" : "searchData",
		      "enabled" : true,
		    }, {
		      "text" : "清除",
		      "iconCls" : "icon-remove",
		      "name" : "clearData",
		      "onclick" : "clearData",
		      "enabled" : true,
		    } , {
				"text" : "导出",
				"iconCls" : "icon-upload",
				"name" : "exportData",
				"onclick" : "exportData",
				"enabled" : true,
		    } ] ]
		  };


		var formheader1 = {
				"type" : "formgrid",
				"properties" : {
					"id" : "formheader1",
				},
				items : [ {
					"label" : "销售开始月：",
					"type" : "MonthPicker",
					"name" : "sdate",
					"format" : "yyyy-MM",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
					"style" : "width:22.5%"
				}, {
					"label" : "销售结束月：",
					"type" : "MonthPicker",
					"name" : "edate",
					"format" : "yyyy-MM",
					"enabled" : true,
					"required" : true,
					"value" : mini.formatDate(new Date(), "yyyy-MM"),
					"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
			        "style" : "width:22.5%"
				}, {
					"label" : "销售门店：",
					"type" : "ButtonEdit",
					"name" : "mktid",
					"enabled" : true,
					"onbuttonclick" : "onMktidClick",
					"onValuechanged" : "onMktidChange",
					"style" : "width:22.5%"
				}, {
					"label" : "经营方式：",
					"type" : "ComboBox",
					"name" : "wmid",
					"enabled" : true,
					"data" : dictData.WMID,
					"style" : "width:22.5%"
				} ]
			};


		var gridbox1 = {
				"type" : "gridbox",
				"resources" : OmdUrl.mall,
				"method" : "mss.work.report.query",
				"response" : "report",
				"manualLoad" : true,
				"searchParam" : {
					"queryid" : "select_saleshj",
				},
				"properties" : {
					"id" : "gridbox1",
					"showSummaryRow" : true,
					"ondrawsummarycell" : "onDrawSummaryCell",
					"columns" : [ {
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "mktid",
						header : "门店",
						allowSort : true,
						headerAlign : "center",
						width : 160,
					}, {
						field : "scdwmid",
						header : "经营方式",
						type : "comboboxcolumn",  
						headerAlign : "center",
						readOnly: true,
 		        	    textField:"name",
		        	    valueField:"code" , 
						data: dictData.WMID,
						renderer: "OcmControl.dictRendererWithCode",
						width : 100,
					},{
						field : "scddate",
						header : "销售时间",
						allowSort : true,
						headerAlign : "center",
						width : 100,
					}, {
						header : "当期销售",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "xssr",
							header : "销售额(含税)",
							allowSort : true,
							headerAlign : "center",
							numberFormat : "#,0.00",
							vtype : "float",
							align : "right",
							width : 100,
						}, {
							field : "ml",
							header : "毛利额",
							allowSort : true,
							headerAlign : "center",
							numberFormat : "#,0.00",
							vtype : "float",
							align : "right",
							width : 100,
						}, {
							field : "mll",
							header : "毛利率%",
							headerAlign : "center",
							numberFormat : "p2",
							vtype : "float;range:0,1",
							align : "right",
							allowSort : true,
							editorSet : {onValuechanged : "setdoublevalue"},
						} ]
					}, {
						header : "同期销售",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "tqxssr",
							header : "销售额(含税)",
							allowSort : true,
							headerAlign : "center",
							numberFormat : "#,0.00",
							vtype : "float",
							align : "right",
							width : 100,
						}, {
							field : "tqml",
							header : "毛利额",
							allowSort : true,
							headerAlign : "center",
							numberFormat : "#,0.00",
							vtype : "float",
							align : "right",
							width : 100,
						}, {
							field : "tqmll",
							header : "毛利率%",
							headerAlign : "center",
							numberFormat : "p2",
							vtype : "float;range:0,1",
							align : "right",
							allowSort : true,
							editorSet : {onValuechanged : "setdoublevalue"},
						} ]
					},{
						header : "同比",
						allowSort : true,
						headerAlign : "center",
						"columns" : [ {
							field : "xssrtb",
							header : "销售额(含税)",
							allowSort : true,
							headerAlign : "center",
							numberFormat : "p2",
							vtype : "float",
							align : "right",
							width : 100,
						}, {
							field : "mltb",
							header : "毛利额",
							allowSort : true,
							headerAlign : "center",
							numberFormat : "p2",
							vtype : "float",
							align : "right",
							width : 100,
						}, {
							field : "mlltb",
							header : "毛利率%",
							headerAlign : "center",
							numberFormat : "p2",
							/* vtype : "float;range:0,1", */
							vtype : "float",
							align : "right",
							allowSort : true,
						} ]
					} ]
				},
			};
			mini.parse();
			
			function onDrawSummaryCell(e) {
				var rows = e.data;
				var xssr = 0.00;var ml = 0.00;
				var tqxssr = 0.00;var tqml = 0.00;
				if (rows.length > 0) {
					for (var i = 0; i < rows.length; i++) {
						var row = rows[i];
						if (isNaN(row.xssr) == false) {
							xssr += parseFloat(row.xssr);
						}
						if (isNaN(row.tqxssr) == false) {
							tqxssr += parseFloat(row.tqxssr);
						}
						if (isNaN(row.ml) == false) {
							ml += parseFloat(row.ml);
						}
						if (isNaN(row.tqml) == false) {
							tqml += parseFloat(row.tqml);
						}
					}
				}

				if (e.field == "scdmkt") {
					e.cellHtml = "<b>" + "合计: " + "</b>";
				}
				if (e.field == "xssr") {
					e.cellHtml = "<b>" + xssr.toFixed(2) + "</b>";
				}
				if (e.field == "tqxssr") {
					e.cellHtml = "<b>" + tqxssr.toFixed(2) + "</b>";
				}
				if (e.field == "ml") {
					e.cellHtml = "<b>" + ml.toFixed(2) + "</b>";
				}
				if (e.field == "tqml") {
					e.cellHtml = "<b>" + tqml.toFixed(2) + "</b>";
				}
				e.cellStyle = "text-align:right";
			}
		</script>

  <script src="profit.js" type="text/javascript"></script>
</body>
</html>