<%@ page language="java" contentType="text/html; charset=utf-8"
  pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>银联对账报表</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">


  <div class="ocm-systoolbar" config="toolbar1" style="margin-bottom:10px"></div>
  
  <div class="ocm-formheader" config="formheader1"></div>
  
  <!--  
  <div class="mini-fit" style="border: 1px solid #000;">
    <iframe id="mainframe" frameborder="0" name="mainframe" style="width:100%;height:100%;" border="0"></iframe>
  </div>
  -->
  <div class="mini-fit">
		<div class="ocm-gridbox" config="gridbox1" border="0"></div>
	</div>
  
  <script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>

  <script type="text/javascript">
    //字典数据初始化
	var moduleid = "500915";
	var dicData ={};
	
	function getPaycode() {
        var temp = "";
		itemLoader.doRequest(OmdUrl.mall, "mss.base.pay.search", {
			order_field : "pmcode",
			pmflag:"Y",
			pmstatus:"Y",
			page_no : 1,
			page_size : 9999,
			pmtype:"3"
		}, null, null, function(data) {
			temp = data.paymode;
			for ( var i = 0; i < temp.length; i++) {
				temp[i].code = temp[i].pmcode;
				temp[i].name = temp[i].pmcname;

			}	
		}, null, null, false);
		return temp;
	}

	dicData.pay_mode = getPaycode();


    var toolbar1 = {
      items : [ [ {
        "text" : "查询",
        "iconCls" : "icon-search",
        "name" : "searchData",
        "onclick" : "searchData",
        "enabled" : true,
      }, {
        "text" : "清除",
        "iconCls" : "icon-remove",
        "name" : "clearData",
        "onclick" : "clearData",
        "enabled" : true,
      }, {
			"text" : "导出",
			"iconCls" : "icon-upload",
			"name" : "exportData",
			"onclick" : "exportData",
			"enabled" : true,
		} ] ]
    };

    var formheader1 = {
      "type" : "formgrid",
      "properties" : {
        "id" : "formheader1",
      },
      items : [{
     	 "label" : "开始日期：",
         "type" : "DatePicker",
         "name" : "shsdate",
         "format" : "yyyy-MM-dd",
         "required" : "true",
         "enabled" : true,
         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "style" : "width:30%"
      }, {
         "label" : "结束日期：",
         "type" : "DatePicker",
         "name" : "shedate",
         "format" : "yyyy-MM-dd",
         "required" : "true",
         "enabled" : true,
         "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
         "style" : "width:30%"
      }, {
          "label" : "收银机：",
          "type" : "TextBox",
          "name" : "shsyjid",
          "enabled" : true,
          "style" : "width:30%"
       }, {
           "label" : "收银员：",
           "type" : "TextBox",
           "name" : "shchecker",
           "enabled" : true,
           "style" : "width:30%"
        }, {
			"label" : "付款方式：",
			"name" : "sppmcode",
			"type" : "ComboBox",
			"enabled" : true,
			"data":dicData.pay_mode,
			"style" : "width:30%;" 
		}]};

    var gridbox1 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.report.query",
			"response" : "report",
			"manualLoad" : true,
			"searchParam" : {
				"queryid":"select_500915",
			},
			"properties" : {
				"id" : "gridbox1",
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"columns" : [ {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				},{
					field : "shsyjid", 
					header : "收银机号",
					headerAlign : "center",
					width : 180,
				},{
					field : "shinvno", 
					header : "小票号",
					headerAlign : "center",
					width : 200,
				},{
					field : "shchecker", 
					header : "收银员",
					headerAlign : "center",
					width : 120,
				},{
					field : "shdjlb", 
					header : "单据类型",
					headerAlign : "center",
					width : 150,
				},{
					field: "shdate",
					type:"TextBox",
					header:"销售日期",
					headerAlign:"center",
					dateFormat : "yyyy-MM-dd",
					dataType : "date",
					width : 180,
				},{
					field: "sppmcode",
					type:"TextBox",
					headerAlign:"center",
					header:"付款代码",
					width: 150,
				},{
					field: "pmcname",
					type:"TextBox",
					headerAlign:"center",
					header:"付款名称",
					width: 150,
				},{
					field: "spno",
					type:"TextBox",
					headerAlign:"center",
					header:"卡号",
					width: 150,
				},{
					field : "shfactpay", 
					header : "小票金额",
					headerAlign : "center",	
					width : 100,
					numberFormat : "c2",
					align: "right",
					width : 150,
				},{
					field : "sprmbje", 
					header : "付款金额",
					headerAlign : "center",	
					width : 100,
					numberFormat : "c2",
					align: "right",
					width : 150,
				}, ]
			},
		}; 

    mini.parse();

    function onDrawSummaryCell(e) {
		var rows = e.data;
		
		var shfactpay = 0;
		var sprmbje = 0;

		if (rows.length > 0) {
			for ( var i = 0; i < rows.length; i++) {
				var row = rows[i];
				if (isNaN(row.shfactpay) == false) {
					shfactpay += parseFloat(row.shfactpay);
				}
				if (isNaN(row.sprmbje) == false) {
					sprmbje += parseFloat(row.sprmbje);
				}
			}
		}
		
		if (e.field == "shfactpay") {
			e.cellHtml ="<b>"+ "小票金额合计: ￥" + mini.formatNumber(Number(shfactpay),"#,0.00")+"</b>";
		}
		if (e.field == "sprmbje") {
			e.cellHtml ="<b>"+ "付款金额合计: ￥" + mini.formatNumber(Number(sprmbje),"#,0.00")+"</b>";
		}

		e.cellStyle = "text-align:right";  
	}
    
  </script>

  <script src="report.js" type="text/javascript"></script>
  
</body>
</html>