/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('supdebt.view');

	var bill = {};
	
	var billtype = getBilltype(app.modulecode);
	
	ns.bill = bill;
	
	var manatype = {};
	  itemLoader.doRequest(OmdUrl.mall, "mss.work.report.query",
			  {queryid : "select_company_new", order_field:"cocode"}, null, null, function(data) {
		  manatype = data.report;       
	 }, null, null, false);
	  
	// 查询列表
	bill.bsupdebtlist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.base.bsupdebthead.search",
		"response": "bsupdebthead",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam": {
		//	"billmoduleid" : app.modulecode,
			"billtype" :billtype,
			"order_field": "inputdate",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('bsupdebtlist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 150,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
				width : 100,
			},{
				field: "billtype",
				type: "TextBox",
				headerAlign: "center",
				header: "单据类型",
				dictkey: 'BILLTYPE',
				visible:false,
				width : 100,
			},{
				field: "sbid",
				type: "TextBox",
				headerAlign: "center",
				header: "商户",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "sbid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"sbid"},
				width: 180,
			}, {
				field: "manatype",
				headerAlign: "center",
				header: "经营主体",
				type: "TextBox",
		        editor : OcmControl.newControl('ComboBox'),
				renderer: "OcmControl.dictRendererWithCode",
				data : manatype,
				width : 200,
				allowSort : true,
			}, {
				field : "jkdate",
				type : "date",
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				header : "缴款日期",
				width : 150,
				headerAlign : "center",
				align : "center",
			}, {
				field: "ysbalance",
				type: "TextBox",
				headerAlign: "center",
				header: "欠款总金额",
				width: 120,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				enabledSearch : false,
			},{
				field : "inputer_name",
				header : "录入人",
				width : 150,
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
			},{
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}]
		}
	};
	
	// 单据主表
	bill.bsupdebthead = {
		"type": "formgrid",
		"initHeight":0.2,
		"resources": OmdUrl.mss,
		"name": 'bsupdebthead',
		"method": "mss.base.bsupdebthead.get",
		"response": "bsupdebthead",
		"properties": {
			"id": utils.createid('bsupdebthead')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"style" : "width:22.5%"
			}, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "ComboBox",
				"defaultValue": billtype,
				dictkey: 'BILLTYPE',
				"visible": false,
				"style" : "width:22.5%"
			}, 
//			{
//				"label": "单据类型：",
//				"name": "billmoduleid",
//				"type": "ComboBox",
//				"defaultValue": app.modulecode,
//				dictkey: 'BILLMODULEID',
//				"readOnly": true,
//				"style" : "width:22.5%"
//			}, 
			{
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
				"style" : "width:22.5%"
			}, {
				"label" : "缴款日期：",
				"type" : "DatePicker",
				"name" : "jkdate",
				"format" : "yyyy-MM-dd",
				"style" : "width:22.5%"
			}, {
				"label": "商户：",
				"name": "sbid",
				"type": "fut_popselect",
				selectkey: "sbid",
				textName: "sbid_name",
				allowInput: true,
				"style" : "width:22.5%"
			}, {
				"label": "经营主体：",
				"name": "manatype",
				"type": "ComboBox",
				"enabled" : true,
				"data" : manatype,
				"style" : "width:22.5%"
			},{
				"label" : "欠款总额：",
				"name" : "ysbalance",
				"type" : "NumButtonEdit",
				"format" : "c2",
				"defaultValue":0,
				"readOnly": "true",
				"style" : "width:22.5%;display:block;float:none",
			},{
				"label": "录入人：",
				"name" : "inputer_name",
				"type" : "TextBox",
				"readOnly" : true,
				"visible" : true,
				"defaultValue" : app.username,
				"style" : "width:22.5%"
			}, {
				"label" : "录入日期：",
				"name" : "inputdate",
				"type" : "DatePicker",
				"readOnly" : true,
				"format" : "yyyy-MM-dd HH:mm:ss",
				"visible" : true,
				"defaultValue" : new Date(),
				"style" : "width:22.5%"
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
				"style" : "width:22.5%"
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
				"style" : "width:22.5%"
			}, {
				"label" : "录入人编码：",
				"type" : "TextBox",
				"name" : "inputer",
				"visible" : false,
				"defaultValue" : app.usercode
			}
		]
	}
	// 单据明细
	bill.bsupdebtdet= {
			title: '单据明细',
			"type": "gridbox",
			name: 'bsupdebtdet',
			"properties": {
				"id": utils.createid('bsupdebtdet'),
				"multiSelect": "true",
				"allowCellEdit": "true",
				"allowCellSelect": "true",
				"editNextOnEnterKey": "true",
				"editNextRowCell": "true",
				"allowSortColumn": "false",
				"allowCellValid": true,
				"showSummaryRow": true,
				"ondrawsummarycell" : onDrawSummaryCell,
				"oncellbeginedit": "OcmControl.checkboxEditor",
				"columns": [{
					type: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
					width: 40,
				}, {
					field: "browno",
					header: "导入行号",
					visible: false,
				}, {
					field: "muid",
					displayField : "muid_name",
					allowSort : true,
					headerAlign: "center",
					editor : OcmControl.newControl('fut_popselectgrid'),
					header: "门店",
					cdEdtCfg : {selectkey : "muid"},
					readOnly : true,
					width: 160,
				}, {
					field : "contno",
					header : "合同",
					headerAlign : "center",
					allowSort : true,
					editor : OcmControl.newControl('fut_popselectgrid'),
					displayField : "contno",
					width : 100,
					editorSet : {selectkey : 'contno'},
					readOnly : true,
				}, {
					field : "cccode",
					header : "费用编码",
					headerAlign : "center",
					allowSort : true,
					editor : OcmControl.newControl('fut_popselectgrid'),
					displayField : "cccode_name",
					width : 160,
					editorSet : {selectkey : 'cccode'},
					readOnly : true,
				}, {
					field : "feesdate",
					header : "开始日期",
					width : 100,
					allowSort : true,
					headerAlign : "center",
					align : "center",
					editor : OcmControl.newControl('DatePicker'),
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					editorSet : {
						format : "yyyy-MM-dd",
					},
					readOnly : true,
				}, {
					field : "feeedate",
					header : "结束日期",
					width : 100,
					allowSort : true,
					headerAlign : "center",
					align : "center",
					editor : OcmControl.newControl('DatePicker'),
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					editorSet : {
						format : "yyyy-MM-dd",
					},
					readOnly : true,	
				}, {
					field : "accmon",
					header : "账期",
					readOnly : true,
					headerAlign : "center",
					width : 100,
					readOnly : true,
				}, {
					field : "ysamount",
					header : "应收金额",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					align : "right",
					readOnly : true
				}, {
					field : "recamount",
					header : "已收金额",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					align : "right",
					readOnly : true
				}, {
					field : "qkamount",
					header : "欠款",
					headerAlign : "center",
					width : 120,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					readOnly : true,
				} ]
			},
		};
	function onDrawSummaryCell(e) {
    	var rows = e.data;
		var ysamount = 0.00;
		var recamount = 0.00;
		var qkamount = 0.00;
		
		if (rows.length > 0) {
			for ( var i = 0; i < rows.length; i++) {
				var row = rows[i];
				if (isNaN(row.ysamount) == false) {
					ysamount += parseFloat(row.ysamount);
				}
				if (isNaN(row.recamount) == false) {
					recamount += parseFloat(row.recamount);
				}
				if (isNaN(row.qkamount) == false) {
					qkamount += parseFloat(row.qkamount);
				}
			}
		}

		if (e.field == "spid") {
			e.cellHtml = "<b>"+"合计: "+"</b>";
		}
		if (e.field == "ysamount") {
			e.cellHtml ="<b>"+ ysamount.toFixed(2)+"</b>";
		}
		if (e.field == "recamount") {
			e.cellHtml = "<b>"+recamount.toFixed(2)+"</b>";
		}
		if (e.field == "qkamount") {
			e.cellHtml ="<b>"+ qkamount.toFixed(2)+"</b>";
		}
		e.cellStyle = "text-align:right";
    }
	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.searchData,btn.delData,btn.auditData]
	}

	// 单据配置
	bill.billconfig = {
		billhead: bill.bsupdebthead, // 单据主表
		billdetail: [bill.bsupdebtdet], // 单据明细表
		billquerylist: bill.bsupdebtlist, // 查询列表
		dettabpages: [bill.bsupdebtdet], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}
	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
