/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('badjust.view');
	
	function getBilltype (billmoduleid) {
		 var billtype = "";
		 var searchParam = {"modeid":billmoduleid};
		 var method = "mss.base.billmain.search";
		 itemLoader.doRequest(OmdUrl.mall, method,searchParam, null, null, function(data) {
			 	var data = data.billmain;
				if(data.length >0){
					billtype =data[0].billtype;
				}
		 },null,null,false);
		 return billtype;
	}

	// 定义一个对象用来配置界面
	var bill = {};
	var moduleid = app.modulecode;
	var billtype=getBilltype(moduleid);
	
	var dicData = OcmControl.getDict("BDHMODE,WMID","code,name,ddvalue") || {};
	//数据来源  1电脑生成2手工录入
	var bdhsource = [ {code : '1', name : '电脑生成'}, {code : '2', name : '手工录入'} ];
	
	var tempbdhmode = [];
	for(var i = 0;i < dicData.BDHMODE.length;i++){
		if(dicData.BDHMODE[i].code == '1' || dicData.BDHMODE[i].code == '2' || dicData.BDHMODE[i].code == '3' || dicData.BDHMODE[i].code == '6'){
			tempbdhmode.push(dicData.BDHMODE[i]);
		}
	}
	dicData.BDHMODE = tempbdhmode;
	
	var tempbdhwmid = [];
	for(var i = 0;i < dicData.WMID.length;i++){
		if(dicData.WMID[i].code == '1' || dicData.WMID[i].code == '2' || dicData.WMID[i].code == '3' || dicData.WMID[i].code == '4'){
			tempbdhwmid.push(dicData.WMID[i]);
		}
	}
	dicData.WMID = tempbdhwmid;
	
	// 把定义对象放到命名空间下
	ns.bill = bill;

	utils.billtype=billtype;
	// 查询列表
	bill.badjustlist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.base.badjusthead.search",
		"response": "badjusthead",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam": {
			"billtype" : billtype,
			"order_field": "inputdate",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('badjustlist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 140,
			}, {
				field : "billsgno",
				header : "手工单号",
				allowSort : true,
				headerAlign : "center",
				width : 140,
				visible : false,
				enabledSearch : false,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
				width : 90,
			}, {
				field: "billtype",
				type: "TextBox",
				headerAlign: "center",
				header: "单据类型",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLTYPE',
				visible:false,
				enabledSearch : false,
			}, {
				field : "bdhmode",
				header : "调整方式",
				headerAlign : "center",
				renderer : "OcmControl.dictRendererWithCode",
				data : dicData.BDHMODE,
				allowSort : true,
				width : 130,
			},{
				field: "bdhmarket",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "bdhmarket_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "bdhmarket_name",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				enabledSearch : false,
				width: 180,
			}, {
				field: "bdhsupid",
				type: "TextBox",
				headerAlign: "center",
				header: "供应商",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "bdhsup_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"bhsbid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "bdhsup_name",
				type: "TextBox",
				headerAlign: "center",
				header: "供应商",
				enabledSearch : false,
				width: 180,
			},{
				field : "bdhwmid",
				header : "经营方式",
				headerAlign : "center",
				renderer : "OcmControl.dictRendererWithCode",
				data : dicData.WMID,
				allowSort : true,
				width : 90,
			},{
				field: "bdhmfid",
				type: "TextBox",
				headerAlign: "center",
				header: "柜组",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "bdhmfid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"selfspid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "bdhmfid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "柜组",
				enabledSearch : false,
				width: 180,
			}, {
				field : "ksrq",
				type : "date",
				format : "yyyy-MM-dd",
				header : "开始日期",
				width : 80,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "jsrq",
				type : "date",
				format : "yyyy-MM-dd",
				header : "结束日期",
				width : 80,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "syjh",
				header : "收银机号",
				width : 65,
				allowSort : true,
				headerAlign : "center",
			}, {
				field : "invno",
				header : "小票号",
				width : 70,
				allowSort : true,
				headerAlign : "center",
			}, {
				field : "bdhfsdate",
				type : "date",
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				header : "调整发生日期",
				width : 85,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "bdhmemo",
				header : "备注",
				width : 80,
				allowSort : true,
				headerAlign : "center",
				visible:false,
				enabledSearch : false,
			}, {
				field : "badjustdetail:bddgdid",
				header : "商品编码",
				width : 120,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "bddbarcode",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"goodsbaseid"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			},{
				field : "inputer_name",
				header : "录入人",
				width : 130,
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 130,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 130,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 130,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}]
		}
	};
	
	// 单据主表
	bill.badjusthead = {
		"type": "formgrid",
		"resources": OmdUrl.mss,
		"name": 'badjusthead',
		"method": "mss.base.badjusthead.get",
		"response": "badjusthead",
		"properties": {
			"id": utils.createid('badjusthead')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"visible": true,
			}, {
				"label": "模块编号：",
				"name": "billmoduleid",
				"type": "TextBox",
				"defaultValue": moduleid,
				"visible": false
			}, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "TextBox",
				"defaultValue": billtype,
				"visible": false
			}, {
				"label" : "数据来源：",
				"name" : "bdhsource",
				"type" : "ComboBox",
				"data" : bdhsource,
				"valueField" : "code",
				"textField" : "name",
				"defaultValue" : "2",
				"visible": false,
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
			}, {
				"label" : "调整方式：",
				"type" : "ComboBox",
				"name" : "bdhmode",
				"readOnly" : false,
				"required" : true,
				"data" : dicData.BDHMODE,
				"valueField" : "code",
				"textField" : "name",
				"defaultValue" : "1",
				"onvaluechanged" : "page.head_valuechanged",
			}, {
				"label": "门店：",
				"name": "bdhmarket",
				"type": "fut_popselect",
				selectkey: "muid",
				textName: "bdhmarket_name",
				allowInput: true,
				"required" : true,
				beforefunc : "page.head_beforefunc",
				itemchangedfunc:"page.head_itemchanged",
			}, {
				"label": "门店：",
				"name": "bdhmarket_code",
				"type": "TextBox",
				readOnly: true,
				visible: false
			},{
				"label": "门店：",
				"name": "bdhmarket_name",
				"type": "TextBox",
				readOnly: true,
				visible: false
			}, {
				"label" : "供应商：",
				"name" : "bdhsupid",
				"type" : "ButtonEdit",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "bhsbid",//弹框类型
				textName : "bdhsup_name", //文本显示字段
				beforefunc : "page.head_beforefunc",
				itemchangedfunc : "page.head_itemchanged",
			}, {
				"label" : "供应商名称：",
				"name" : "bdhsup_name",
				"type" : "TextBox",
				"required" : "true",
				"allowSort" : true,
				"visible" : false,
			},{
				"label" : "经营方式：",
				"name" : "bdhwmid",
				type : "ComboBox",
				"data" : dicData.WMID,
				"visible": true,
				"required" : true,
				"onvaluechanged" : "page.head_valuechanged",
			}, {
				"label" : "柜组：",
				"name" : "bdhmfid",
				"type" : "ButtonEdit",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "selfspid",//弹框类型
				textName : "bdhmfid_name", //文本显示字段
				beforefunc : "page.head_beforefunc",
				itemchangedfunc : "page.head_itemchanged",
				"required" : true,
			}, {
				"label" : "柜组名称：",
				"name" : "bdhmfid_name",
				"type" : "TextBox",
				"required" : "true",
				"allowSort" : true,
				"visible" : false,
			}, {
				"label" : "制单日期：",
				"type" : "DatePicker",
				"name" : "bdhzddate",
				"enabled" : "true",
				"format" : "yyyy-MM-dd",
				"defaultValue" : new Date(),
				"required" : true,
				 visible: false
			},{
				"label" : "收银机号：",
				"type" : "TextBox",
				"name" : "syjh",
				"enabled" : "true",
				"readOnly" : true,
				"onvaluechanged" : "page.head_valuechanged",
			}, {
				"label" : "小票号：",
				"type" : "TextBox",
				"name" : "invno",
				"enabled" : "true",
				"readOnly" : true,
				"onvaluechanged" : "page.head_valuechanged",
			}, {
				"label" : "调整发生日期：",
				"type" : "DatePicker",
				"name" : "bdhfsdate",
				"enabled" : "true",
				"format" : "yyyy-MM-dd",
				"required" : true,
				"defaultValue" : new Date(),
			}, {
				"label" : "开始日期：",
				"type" : "DatePicker",
				"name" : "ksrq",
				"enabled" : "true",
				"format" : "yyyy-MM-dd",
				"required" : true,
				"defaultValue" : new Date(),
				onvaluechanged : "page.head_valuechanged",
			}, {
				"label" : "结束日期：",
				"type" : "DatePicker",
				"name" : "jsrq",
				"enabled" : "true",
				"format" : "yyyy-MM-dd",
				"required" : true,
				"defaultValue" : new Date(),
				onvaluechanged : "page.head_valuechanged",
				"style" : "display:block;float:none",
			}, {
				"label": "录入人：",
				"type": "TextBox",
				"name": "inputer_name",
				"readOnly": "true",
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
				"style" : "display:block;float:none",
			}, {
				"label": "取消人：",
				"type": "TextBox",
				"name": "canceler_name",
				"readOnly": "true",
				"visible": false,
			}, {
				"label": "录入日期：",
				"type": "DatePicker",
				"name": "inputdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "取消日期：",
				"type": "DatePicker",
				"name": "canceldate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
				"visible": false,
			}, {
				"label": "录入人编码",
				"type": "TextBox",
				"name": "inputer",
				"visible": false,
			}
		]
	}
	// 单据明细
	bill.badjustdetail= {
			title: '单据明细',
			"type": "gridbox",
			name: 'badjustdetail',
			"properties": {
				"id": utils.createid('badjustdetail'),
				"multiSelect": "true",
				"allowCellEdit": "true",
				"allowCellSelect": "true",
				"editNextOnEnterKey": "true",
				"editNextRowCell": "true",
				"allowSortColumn": "false",
				"allowCellValid": true,
				"sortMode": "client",
				//"showPager": true,
				"showSummaryRow": true,
				"oncellbeginedit": "OcmControl.checkboxEditor",
				"columns": [{
					type: "checkcolumn",
					name: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
					width: "40",
				}, {
					type: "indexcolumn",
					name: "indexcolumn",
					header: "行号",
					headerAlign: "center",
					readOnly: true,
					width: "40",
				}, {
					field: "browno",
					headerAlign: "center",
					align: "center",
					header: "导入行号",
					dataType: "int",
					allowSort: true,
					readOnly: true,
					visible: false,
				},{
					field: "bddgdid",
					name: "bddgdid",
					header : "商品编码",
					headerAlign : "center",				    
				    width : 110,
				    align : "left",
				    readOnly: true,
				},{
					field : "bddbarcode",
					name : "bddbarcode",
					header : "商品条码",
					editor: OcmControl.newControl('fut_popselectgrid'),
					width : 120,
					headerAlign : "center",
					required : true,
					editorSet: {
		                selectkey: 'selfgbase',/*'goodsbaseid',*/
		                multiSelect: true,
		                beforefunc:"page.det_beforefunc_gbid",
		                itemchangedfunc:"page.det_itemchanged",
					},
				}, {
					field : "bddname",
					header : "商品名称",
					headerAlign : "center",				    
				    width : 130,
				    align : "left",
				    readOnly: true,
				}, {
					field : "bddcatid",
					header : "商品类别",
					headerAlign : "center",				    
				    width : 80,
				    readOnly: true,
				    visible: false,
				    align : "left",
				}, {
					field : "bddcatname",
					header : "商品类别",
					headerAlign : "center",				    
				    width : 130,
				    readOnly: true,
				    align : "left",
				}, {
					field : "bddppcode",
					header : "品牌",
					headerAlign : "center",				    
				    width : 130,
				    readOnly: true,
				    visible: false,
				}, {
					field : "bddppname",
					name : "bddppname",
					header : "品牌",
					readOnly : true,
					align : "left",
					width : 130,
				}, {
					field : "bddoldhsjj",
					header : "原含税进价",
					headerAlign : "center",				    
				    width : 100,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					readOnly: true,
				}, {
					field : "bddnewhsjj",
					header : "新含税进价",
					headerAlign : "center",				    
				    width : 100,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					required : true,
					readOnly: false,
				}, {
					field : "bddoldbhsjj",
					header : "原不含税进价",
					headerAlign : "center",				    
				    width : 100,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c4",},
					numberFormat:"c4",
					defaultValue : "0",
					align : "right",
					readOnly: true,
				}, {
					field : "bddnewbhsjj",
					header : "新不含税进价",
					headerAlign : "center",				    
				    width : 100,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c4",},
					numberFormat:"c4",
					defaultValue : "0",
					align : "right",
					readOnly: false,
					required : true,
				},{
					field : "bddoldjxtax",
					header : "原进项税率",
					headerAlign : "center",
					width : 90,
					readOnly: true,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "p2",},
					numberFormat:"p2",
					defaultValue : "0",
					align : "right",
				}, {
					field : "bddnewjxtax",
					header : "新进项税率",
					headerAlign : "center",	
					width : 90,
					readOnly: true,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "p2",},
					numberFormat:"p2",
					defaultValue : "0",
					align : "right",
					visible : false,
				},{
					field : "bddoldkl",
					header : "原扣率",
					headerAlign : "center",				    
				    width : 90,
				    align : "right",
				    readOnly: true,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "p2",},
					numberFormat:"p2",
					defaultValue : "0",
					align : "right",
				}, {
					field : "bddnewkl",
					header : "新扣率",
					headerAlign : "center",				    
				    width : 90,
				    required: false,
					editor : OcmControl.newControl('TextBox'),
					editorSet : {
						onValuechanged : "bddnewklChanged"
					},
					width : "90",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "p2",},
					numberFormat:"p2",
					defaultValue : "0",
					align : "right",
					required : true,
				},  {
					field : "bddrate",
					header : "降扣点数",
					headerAlign : "center",				    
				    width : 90,
				    align : "right",
				    readOnly: true,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "p2",},
					numberFormat:"p2",
					defaultValue : "0",
					align : "right",
				}, {
					field : "bddsj",
					header : "售价",
					headerAlign : "center",				    
				    width : 100,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					readOnly: true,
				}, {
					field : "bddslxstz",
					header : "销售调整数量",
					headerAlign : "center",	
					align : "right",
					width : 100,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					defaultValue : "0",
					align : "right",
					readOnly: false,
				}, {
					field : "bddhsxstz",
					header : "含税销售提成调整",
					headerAlign : "center",	
					align : "right",
					width : 130,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					readOnly: false,
				}, {
					field : "bddbhsxstz",
					header : "不含税销售提成调整",
					headerAlign : "center",	
					align : "right",
				    width : 130,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c4",},
					numberFormat:"c4",
					defaultValue : "0",
					align : "right",
					readOnly: false,
				}, {
					field : "bddsljhtz",
					header : "进货调整数量",
					headerAlign : "center",	
					align : "right",
					width : 100,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					defaultValue : "0",
					align : "right",
					readOnly: true,
				}, {
					field : "bddhsjhtz",
					header : "含税进货成本调整",
					headerAlign : "center",	
					align : "right",
					width : 130,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					readOnly: true,
				}, {
					field : "bddbhsjhtz",
					header : "不含税进货成本调整",
					headerAlign : "center",	
					align : "right",
				    width : 130,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c4",},
					numberFormat:"c4",
					defaultValue : "0",
					align : "right",
					readOnly: true,
				}  ]
			},
		};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData,
			btn.separator,btn.auditData/*, btn.cancelData*/, btn.separator, btn.searchData
		]
	}

	// 单据配置
	bill.billconfig = {
		billhead: bill.badjusthead, // 单据主表
		billdetail: [bill.badjustdetail], // 单据明细表
		billquerylist: bill.badjustlist, // 查询列表
		dettabpages: [bill.badjustdetail], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
