/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('badjustcx.view');

	// 定义一个对象用来配置界面
	var bill = {};
	var moduleid = app.modulecode;
	var billtype=getBilltype(moduleid);
	
	var dicData = {
		adjustMode: [{
			code : '1',
			name : '按时间段调整',
			ddvalue : '[1]按时间段调整'
		},{
			code : '2',
			name : '按销售小票调整',
			ddvalue : '[2]按销售小票调整'
		}],
		dataSource: [ {
			code : '1',
			name : '电脑生成'
		}, {
			code : '2',
			name : '手工录入'
		} ],
		Wmid: [{
			code: '1',
			name: '经销',
			ddvalue: '[1]经销'
		},{
			code: '2',
			name: '成本代销',
			ddvalue: '[2]成本代销'
		},{
			code: '3',
			name: '扣率代销',
			ddvalue: '[3]扣率代销'
		},{
			code: '4',
			name: '联营',
			ddvalue: '[4]联营'
		},{
			code: '5',
			name: '租赁',
			ddvalue: '[5]租赁'
		}],
		SaleType: [{
			code: 'E',
			name: '销售',
			ddvalue:'[E]销售'
		},{
			code: 'F',
			name: '退货',
			ddvalue:'[F]退货'
		}]
	}
	
	
	// 把定义对象放到命名空间下
	ns.bill = bill;

	utils.billtype=billtype;
	// 查询列表
	bill.badjustlist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.base.badjusthead.search",
		"response": "badjusthead",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam": {
			"billtype" : billtype,
			"order_field": "inputdate",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('badjustlist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 40,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 150,
			}, {
				field : "billsgno",
				header : "手工单号",
				allowSort : true,
				headerAlign : "center",
				width : 150,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
				width : 70,
			}, {
				field: "billtype",
				type: "TextBox",
				headerAlign: "center",
				header: "单据类型",
				dictkey: 'BILLTYPE',
				visible:false,
				enabledSearch : false,
			}, {
				field : "bdhsource",
				header : "数据来源",
				headerAlign : "center",
				renderer : "OcmControl.dictRendererWithCode",
				data : dicData.dataSource,
				allowSort : true,
				width : 80,
			}, {
				field : "bdhmode",
				header : "调整方式",
				headerAlign : "center",
				renderer : "OcmControl.dictRendererWithCode",
				data : dicData.adjustMode,
				allowSort : true,
				width : 120,
			}, {
				field: "bdhmarket",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "bdhmarket_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
				visible:false,
				enabledSearch : true,
				width: 180,
			}, {
				field: "bdhmarket_name",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				enabledSearch : false,
				width: 180,
			}, {
				field: "bdhmfid",
				type: "TextBox",
				headerAlign: "center",
				header: "串销商铺/柜组",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "bdhmfid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"spid"},
				visible:false,
				enabledSearch : true,
				width: 180,
			}, {
				field: "bdhmfid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "串销商铺/柜组",
				enabledSearch : false,
				width: 200,
			}, {
				field: "bdhsupid",
				type: "TextBox",
				headerAlign: "center",
				header: "串销供应商",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "bdhsup_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"sbid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "bdhsup_name",
				type: "TextBox",
				headerAlign: "center",
				header: "串销供应商",
				enabledSearch : false,
				width: 200,
			}, {
				field : "badjustdetail:bddgdid",
				header : "商品编码",
				width : 120,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "bddbarcode",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"goodsbaseid"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "bdhzddate",
				type : "date",
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				header : "制单日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
				visible:false,
				enabledSearch : true,
			},{
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "ksrq",
				type : "date",
				format : "yyyy-MM-dd",
				header : "串销开始日期",
				width : 90,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "jsrq",
				type : "date",
				format : "yyyy-MM-dd",
				header : "串销结束日期",
				width : 90,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "syjh",
				header : "收银机号",
				width : 60,
				allowSort : true,
				headerAlign : "center",
				align : "center"
			}, {
				field : "invno",
				header : "小票号",
				width : 60,
				allowSort : true,
				headerAlign : "center",
				align : "right"
			}, {
				field : "bdhmemo",
				header : "备注",
				width : 60,
				allowSort : true,
				headerAlign : "center",
				visible:false,
				enabledSearch : false,
			}, {
				field : "bdhfsdate",
				type : "date",
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				header : "调整发生日期",
				width : 90,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			},{
				field : "inputer",
				header : "录入人",
				width : 80,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			},{
				field : "inputer_name",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 130,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 130,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}]
		}
	};
	
	// 单据主表
	bill.badjusthead = {
		"type": "formgrid",
		"resources": OmdUrl.mss,
		"name": 'badjusthead',
		"method": "mss.base.badjusthead.get",
		"response": "badjusthead",
		"properties": {
			"id": utils.createid('badjusthead'),
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"visible": true,
			}, {
				"label": "模块编号：",
				"name": "billmoduleid",
				"type": "TextBox",
				"defaultValue": moduleid,
				"visible": false
			}, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "TextBox",
				"defaultValue": billtype,
				"visible": false
			}, {
				"label" : "数据来源：",
				"name" : "bdhsource",
				"type" : "ComboBox",
				"data" : dicData.dataSource,
				"valueField" : "code",
				"textField" : "name",
				"defaultValue" : "2",
				"visible": false,
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
			}, {
				"label": "手工单号：",
				"name": "billsgno",
				"type": "TextBox",
				"visible": true,
			}, {
				"label" : "调整方式：",
				"type" : "ComboBox",
				"name" : "bdhmode",
				"readOnly" : false,
				"required" : true,
				"data" : dicData.adjustMode,
				"valueField" : "code",
				"textField" : "name",
				"defaultValue" : "1",
				"onvaluechanged" : "page.head_valuechanged",
				itemchangedfunc : "page.head_itemchangedfunc",
			}, {
				//设置默认日期为当前日期
				"label" : "新发生日期：",
				"type" : "DatePicker",
				"name" : "bdhfsdate",
				"enabled" : "true",
				"format" : "yyyy-MM-dd",
				"required" : true,
				"defaultValue" : new Date(),
			}, {
				"label": "门店：",
				"name": "bdhmarket",
				"type": "fut_popselect",
				selectkey: "muid",
				textName: "bdhmarket_name",
				allowInput: true,
				"required" : true,
				beforefunc : "page.head_beforefunc_muid",
			}, {
				"label": "门店名称：",
				"name": "bdhmarket_name",
				"type": "TextBox",
				readOnly: true,
				visible: false
			}, {
				"label": "串销商铺/柜组：",
				"name": "bdhmfid",
				"type": "fut_popselect",
				selectkey: "spid",
				textName: "bdhmfid_name",
				allowInput: true,
				"required" : true,
				beforefunc : "page.head_beforefunc_mfid",
			}, {
				"label": "商铺/柜组名称：",
				"name": "bdhmfid_name",
				"type": "TextBox",
				readOnly: true,
				visible: false
			}, {
				"label" : "原供应商：",
				"name" : "bdhsupid",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "sbid",//弹框类型
				textName : "bdhsup_name", //文本显示字段
				beforefunc : "page.head_beforefunc_sbid",
				"required" : "true",
			}, {
				"label" : "供应商名称：",
				"name" : "bdhsup_name",
				"type" : "TextBox",
				"allowSort" : true,
				"visible" : false,
			},{
				"label" : "原交易类型：",
				"name" : "bdhtrans",
				"type" : "ComboBox",
				"data" : dicData.SaleType,
				"valueField" : "code",
				"textField" : "name",
				"defaultValue" : "E",
				"required" : true,
				"onvaluechanged" : "page.head_valuechanged",
			}, {
				"label" : "制单日期：",
				"type" : "DatePicker",
				"name" : "bdhzddate",
				"enabled" : "true",
				"format" : "yyyy-MM-dd",
				defaultValue: new Date(),
				visible: false
			}, {
				"label" : "原开始日期：",
				"type" : "DatePicker",
				"name" : "ksrq",
				"enabled" : "true",
				"format" : "yyyy-MM-dd",
				"required" : true,
				"defaultValue" : new Date(new Date() -86400000),
				"onvaluechanged" : "page.head_itemchangedfunc",
			}, {
				"label" : "原结束日期：",
				"type" : "DatePicker",
				"name" : "jsrq",
				"enabled" : "true",
				"format" : "yyyy-MM-dd",
				"required" : true,
				"defaultValue" : new Date(new Date() -86400000),
				"onvaluechanged" : "page.head_valuechanged",
				"itemchangedfunc": "page.head_itemchangedfunc",
			},{
				"label" : "原经营方式：",
				"type" : "ComboBox",
				"name" : "bdhwmid",
				"required" : false,
//				"readOnly" : true,
				"data" : dicData.Wmid,
				"valueField" : "code",
				"textField" : "name",
//				"defaultValue" : "4",
//				"onvaluechanged" : "page.head_valuechanged",
				visible : true,
				"style" : "display:block;float:none"
			},  {
				"label" : "原收银机号：",
				"type" : "TextBox",
				"name" : "syjh",
				"enabled" : "true",
				"readOnly" : true,
				"required" : true,
				"onvaluechanged" : "page.head_valuechanged"
			}, {
				"label" : "原小票号：",
				"type" : "TextBox",
				"name" : "invno",
				"enabled" : "true",
				"readOnly" : true,
				"required" : true,
				"onvaluechanged" : "page.head_valuechanged",
				"style" : "display:block;float:none",
			}, {
				"label": "录入人：",
				"type": "TextBox",
				"name": "inputer_name",
				"readOnly": "true",
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
				"style" : "display:block;float:none",
			}, {
				"label": "取消人：",
				"type": "TextBox",
				"name": "canceler_name",
				"readOnly": "true",
				"visible": false,
			}, {
				"label": "录入日期：",
				"type": "DatePicker",
				"name": "inputdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "取消日期：",
				"type": "DatePicker",
				"name": "canceldate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
				"visible": false,
			}, {
				"label": "录入人编码",
				"type": "TextBox",
				"name": "inputer",
				"visible": false,
			}
		]
	};
	// 单据明细
	bill.badjustdetail= {
			title: '单据明细',
			"type": "gridbox",
			name: 'badjustdetail',
			"properties": {
				"id": utils.createid('badjustdetail'),
				"multiSelect": "true",
				"allowCellEdit": "true",
				"allowCellSelect": "true",
				"editNextOnEnterKey": "true",
				//"editNextRowCell": "true",
				"skipReadOnlyCell": "true",
				"allowSortColumn": "false",
				"allowCellValid": true,
				"sortMode": "client",
				//"showPager": true,
				"showSummaryRow": true,
				"oncellbeginedit": "OcmControl.checkboxEditor",
				"columns": [{
					type: "checkcolumn",
					name: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
					width: "40",
				}, {
					type: "indexcolumn",
					name: "indexcolumn",
					header: "行号",
					headerAlign: "center",
					readOnly: true,
					width: "40",
				}, {
					field: "browno",
					name: "browno",
					headerAlign: "center",
					align: "center",
					header: "导入行号",
					dataType: "int",
					allowSort: true,
					readOnly: true,
					visible: false,
				}, {
					field: "bddgdid",
					name: "bddgdid",
					header: "串销商品码",
					headerAlign: "center",
					allowSort: true,
					required: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                displayField: "bddbarcode",
	                width: "100",
	                editorSet: {
	                    selectkey: 'goodsbaseid',
	                    textName :"bddbarcode",
	                    multiSelect: false,
	                    beforefunc:"page.det_beforefunc_gbid",
						itemchangedfunc:"page.det_itemchanged"
	                },
				}, {
					field: "bddbarcode",
					name: "bddbarcode",
					header: "串销商品条码",
					headerAlign: "center",
					width: "150",
					visible: false,
				}, {
					field: "bddmanamode",
					name: "bddmanamode",
					header: "商品管理方法",
					headerAlign: "center",
					width: "50",
					visible: false,
					defaultValue: '4',
				}, {
					field : "bddoldmfid",
					name:"bddoldmfid",
					header : "串销商铺/柜组",
					headerAlign : "center",
					width : 150,
					readOnly : true,
					visible: false
				}, {
					field: "bddoldmfname",
					name: "bddoldmfname",
					//type: "TextBox",
					header: "串销商铺/柜组",
					headerAlign: "center",
					align : "left",
					width: 180,
					readOnly: true
				}, {
					field : "bddppcode",
					name : "bddppcode",
					header : "串销品牌",
					headerAlign : "center",	
				    width : 100,
				    readOnly: true,
				    visible: false,
				}, {
					field : "bddppname",
					name : "bddppname",
					header : "串销品牌",
					readOnly : true,
					align : "left",
					width : 100,
				}, {
					field : "bddname",
					name : "bddname",
					header : "品名",
					headerAlign : "center",				    
				    width : 150,
				    align : "left",
				    readOnly: true,
				}, {
					field : "bddspec",
					name : "bddspec",
					header : "规格",
					headerAlign : "center",				    
				    width : 60,
				    readOnly: true,
				    visible: false,
				    align : "left",
				}, {
					field : "bdduid",
					name : "bdduid",
					header : "UID",
					headerAlign : "center",				    
				    width : 60,
				    readOnly: true,
				    visible: false,
				    align : "left",
				    defaultValue:"00"
				}, {
					field : "bddunit",
					name : "bddunit",
					header : "单位",
					headerAlign : "center",				    
				    width : 60,
				    readOnly: true,
				    visible: false,
				    align : "left",
				}, {
					field : "bddcatid",
					name : "bddcatid",
					header : "商品类别",
					headerAlign : "center",				    
				    width : 80,
				    readOnly: true,
				    visible: false,
				    align : "left",
				}, {
					field : "bddcatname",
					name : "bddcatname",
					header : "商品类别",
					headerAlign : "center",				    
				    width : 150,
				    readOnly: true,
				    align : "left",
				    visible: false,
				}, {
					field : "bddoldsl",
					name : "bddoldsl",
					header : "销售数量",
					headerAlign : "center",				    
				    width : 60,
				    align : "right",
					numberFormat:"n0",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				}, {
					field : "bddoldsjje",
					name : "bddoldsjje",
					header : "售价金额",
					headerAlign : "center",				    
				    width : 100,
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				}, {
					field : "bddoldxsje",
					name : "bddoldxsje",
					header : "实际销售收入",
					headerAlign : "center",				    
				    width : 100,
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				},{
					field : "bddnewsl",
					name : "bddnewsl",
					header : "调整数量",
					headerAlign : "center",				    
				    width : 60,
				    align : "right",
					required : true,
				    type: "TextBox",
				    /*editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{
						format: "n0",
					},*/
					numberFormat:"n0",
					defaultValue : "0",
					align : "right",
				}, {
					field : "bddnewxsje",
					name : "bddnewxsje",
					header : "调整金额",
					headerAlign : "center",				    
				    width : 100,
				    required: true,
				    type: "TextBox",
					//editor : OcmControl.newControl('NumButtonEdit'),
					/*editorSet : {
						format: "c2",  
					},*/
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					"onvaluechanged" : "page.det_valuechanged",
				}, {
					field : "bddnewmfid",
					name:"bddnewmfid",
					header : "应销商铺",
					required : true,
					headerAlign : "center",
					displayField : "bddnewmfname",
					editor:OcmControl.newControl('fut_popselectgrid'),
					editorSet: {
						label : "商铺",
						selectkey:"spid",
						textName :"spid_name",
	                    beforefunc:"page.det_before_newmfid",
						itemchangedfunc:"page.det_itemchanged"
						}, 
					width : 150,
				}, {
					field : "bddnewmfname",
					name:"bddnewmfname",
					header : "应销商铺",
					required : true,
					headerAlign : "center",
					width : 150,
					visible : false,
				}, {
					field : "bddnewsupid",
					name:"bddnewsupid",
					header : "应销供应商",
					required : true,
					headerAlign : "center",
					displayField : "bddnewsupname",
					editor:OcmControl.newControl('fut_popselectgrid'),
					editorSet: {
						label : "供应商",
						selectkey:"sbid",
						textName :"sbid_name",
	                    beforefunc:"page.det_before_newsupid",
						itemchangedfunc:"page.det_itemchanged"
						}, 
					width : 150,
				}, {
					field : "bddnewsupname",
					name:"bddnewsupname",
					header : "应销供应商",
					required : false,
					headerAlign : "center",
					width : 150,
					visible: false,
				}, {
					field : "bddnewwmid",
					header : "应销经营方式",
					headerAlign : "center",
					type : "comboboxcolumn",
					valueField : "code",
					textField : "name",
					width : 80,
					editor : OcmControl.newControl('ComboBox'),
					renderer: "OcmControl.dictRendererWithCode",
					data : dicData.Wmid,
					defaultValue : '4',
					readOnly : true,
					visible : false,
				}, {
					field: "bddnewgdid",
					name: "bddnewgdid",
					header: "应销商品编码",
					headerAlign: "center",
					allowSort: true,
					required: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                displayField: "bddnewbarcode",
	                width: 100,
	                editorSet: {
	                    selectkey: 'goodsbaseid',
	                    textName :"bddnewbarcode",
	                    beforefunc:"page.det_before_newgbid",
						itemchangedfunc:"page.det_itemchanged"
	                },
				}, {
					field: "bddnewbarcode",
					name: "bddnewbarcode",
					header: "应销商品条码",
					headerAlign: "center",
					width: "150",
					visible: false
				}, {
					field : "bddnewppcode",
					header : "品牌",
					headerAlign : "center",
				    width : 100,
				    readOnly: true,
				    visible: false,
				}, {
					field : "bddnewppname",
					name : "bddnewppname",
					header : "品牌",
					readOnly : true,
					align : "left",
					width : 100,
				}, {
					field : "bddnewgbname",
					header : "品名",
					headerAlign : "center",
				    width : 150,
				    align : "left",
				    readOnly: true,
				}, {
					field : "bddnewspec",
					header : "规格",
					headerAlign : "center",
				    width : 60,
				    readOnly: true,
				    visible: false,
				    align : "left",
				}, {
					field : "bddnewunit",
					header : "单位",
					headerAlign : "center",
				    width : 60,
				    readOnly: true,
				    visible: false,
				    align : "left",
				} ]
			},
		};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData,
			btn.separator,btn.auditData/*, btn.cancelData*/, btn.separator, btn.searchData
		]
	}

	// 单据配置
	bill.billconfig = {
		billhead: bill.badjusthead, // 单据主表
		billdetail: [bill.badjustdetail], // 单据明细表
		billquerylist: bill.badjustlist, // 查询列表
		dettabpages: [bill.badjustdetail], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
