/**
 * 
 */
(function () {
    // 命名空间
    /** @namespace Future.badjustcx.out */
    var ns = Future.ns('badjustcx.out');
    var utils = Future.ns('utils');
    var validate = Future.ns('validate');
    var billtype =utils.billtype;
    
    var cols_1 = ["ksrq","jsrq"];
    var cols_2 = ["syjh","invno"];
    var lastGoods = {
    		bddnewmfid : "",
    		bddnewmfname : "",
    		bddnewsupid : "",
    		bddnewsupname : "",
    		bddnewgdid : "",
    		bddnewbarcode : "",
    		bddnewgbname : "",
    		bddnewcatid : "",
    		bddnewcatname : "",
    		bddnewppcode : "",
    		bddnewppname : "",
    };
    var Badjustcx = function () {
    	Badjustcx.superclass.constructor.call(this);
        this.servicekey = 'mss';
        this.head_beforefunc_sbid = this.head_beforefunc_sbid.bind(this);
        this.head_beforefunc_muid = this.head_beforefunc_muid.bind(this);
        this.head_beforefunc_mfid = this.head_beforefunc_mfid.bind(this);
        this.head_valuechanged = this.head_valuechanged.bind(this);
        this.head_itemchangedfunc = this.head_itemchangedfunc.bind(this);
        this.det_before_newmfid = this.det_before_newmfid.bind(this);
        this.det_before_newsupid = this.det_before_newsupid.bind(this);
        this.det_beforefunc_gbid = this.det_beforefunc_gbid.bind(this);
        
        this.det_before_newgbid = this.det_before_newgbid.bind(this);
        this.det_itemchanged = this.det_itemchanged.bind(this);
        
        //this.getHeadValues = this.getHeadValues.bind(this);
    }
    var findcol = function (cols, col,value) {
        for (var i = 1; i < cols.length; i++) {
            var rtn = cols[i];
            if (rtn.name == col) {
                return rtn;
                break;
            }
        }
    }
 // 显示列
    function showColumns(fileds) {
    	for (var i = 0; i < fileds.length; i++) {
    		badjusthead.showColumn(fileds[i]);
    	}
    };

    // 隐藏列
    function hideColumns(fileds) {
    	for (var i = 0; i < fileds.length; i++) {
    		badjusthead.hideColumn(fileds[i]);
    	}
    };

    ns.Badjustcx = Badjustcx;
    
    
    Future.extend(ns.Badjustcx, Future.pub.Basebill, {
    	
    	_initview: function () {
    		Badjustcx.superclass._initview.call(this);
        },
        initevent : function() {
        	Badjustcx.superclass.initevent.call(this);
			this.badjustdetail.on('cellcommitedit',this.detcellcommitedit, this);
			this.badjustdetail.on('cellbeginedit', this.oncellbeginedit,   this);
			this.oldbdhmode = this.billhead.getText('bdhmode');
			
			// 新增赋值事件
	    	//this.badjustdetail.addNewRowBefore = this.addNewRowBefore.bind(this);

		},
		changeView: function (colname,flag) {
        	if (colname == 'bdhmode') {
        		var bdhmode = this.billhead.getValue('bdhmode');
        		if (bdhmode == "2") {
					//收银机号 syjh
					var col = mini.getbyName("syjh");
					col.setEnabled(true);
					col.setReadOnly(false);
					col.setRequired(true);
					//小票号 invno
					var col = mini.getbyName("invno");
					col.setEnabled(true);
					col.setReadOnly(false);
					col.setRequired(true);
					
					//生效开始时间
					var col = mini.getbyName("ksrq");
					col.setEnabled(false);
					col.setRequired(false);
					//生效结束时间
					var col = mini.getbyName("jsrq");
					col.setEnabled(false);
					col.setRequired(false);
					
					//供应商 bdhsupid
					var col = mini.getbyName("bdhsupid");
					col.setEnabled(true);
					col.setRequired(true);
					
					//经营方式bdhwmid
					var col = mini.getbyName("bdhwmid");
					col.setEnabled(true);
					col.setRequired(true);
					if (flag) {
						this.billhead.setValue('ksrq', null);
						this.billhead.setValue('jsrq', null);
					}
        		} else{
        			//收银机号 syjh
					var col = mini.getbyName("syjh");
					col.setEnabled(false);
					col.setRequired(false);
					//小票号 invno
					var col = mini.getbyName("invno");
					col.setEnabled(false);
					col.setRequired(false);
					//生效开始时间
					var col = mini.getbyName("ksrq");
					col.setEnabled(true);
					col.setRequired(true);
					
					//生效结束时间
					var col = mini.getbyName("jsrq");
					col.setEnabled(true);
					col.setRequired(true);
					
					//供应商 bdhsupid
					var col = mini.getbyName("bdhsupid");
					col.setEnabled(true);
					col.setRequired(true);
					//经营方式bdhwmid
					var col = mini.getbyName("bdhwmid");
					col.setEnabled(true);
					col.setRequired(true);
					if (flag) {
						this.billhead.setValue('syjh', "");
						this.billhead.setValue('invno', "");
						this.billhead.setValue("ksrq",new Date(new Date() -86400000));
						this.billhead.setValue("jsrq",new Date(new Date() -86400000));
					}
        		}
        	} else if (colname == "bdhtrans"){
        		var colvalue = this.billhead.getValue('bdhtrans');
        		if (colvalue == "E" || colvalue == "G"){
        			this.badjustdetail.updateColumn("bddoldsl", {header: "销售数量"});
        			this.badjustdetail.updateColumn("bddoldxsje", {header: "实际销售收入"});
        		} else{
        			this.badjustdetail.updateColumn("bddoldsl", {header: "退货数量"});
        			this.badjustdetail.updateColumn("bddoldxsje", {header: "退货金额"});
        		}
        	} else if(colname == "" ||colname == undefined){
        		var bdhMode = this.billhead.getValue('bdhmode');
        		if (bdhMode == "1"){
        			//收银机号 syjh
    				var col = mini.getbyName("syjh");
    				col.setEnabled(false);
    				col.setRequired(false);
    				//小票号 invno
    				var col = mini.getbyName("invno");
    				col.setEnabled(false);
    				col.setRequired(false);
        			//生效开始时间
    				var col = mini.getbyName("ksrq");
    				col.setEnabled(true);
    				col.setRequired(true);
    				//this.billhead.setValue("ksrq",new Date(new Date() -86400000));
    				//生效结束时间
    				var col = mini.getbyName("jsrq");
    				col.setEnabled(true);
    				col.setRequired(true);
        		} else if (bdhMode == "2"){
        			//收银机号 syjh
    				var col = mini.getbyName("syjh");
    				col.setEnabled(true);
    				col.setRequired(true);
    				//小票号 invno
    				var col = mini.getbyName("invno");
    				col.setEnabled(true);
    				col.setRequired(true);
        			//生效开始时间
    				var col = mini.getbyName("ksrq");
    				col.setEnabled(false);
    				col.setRequired(false);
    				//this.billhead.setValue("ksrq",new Date(new Date() -86400000));
    				//生效结束时间
    				var col = mini.getbyName("jsrq");
    				col.setEnabled(false);
    				col.setRequired(false);
        		}
    			
				//供应商 bdhsupid
				var col = mini.getbyName("bdhsupid");
				col.setEnabled(true);
				col.setRequired(true);
        		var colvalue = this.billhead.getValue('bdhtrans');
        		if (colvalue == "E" || colvalue == "G"){
        			this.badjustdetail.updateColumn("bddoldsl", {header: "销售数量"});
        			this.badjustdetail.updateColumn("bddoldxsje", {header: "实际销售收入"});
        		} else{
        			this.badjustdetail.updateColumn("bddoldsl", {header: "退货数量"});
        			this.badjustdetail.updateColumn("bddoldxsje", {header: "退货金额"});
        		}
        	}
        },
        initdict:function(){

        },
        head_beforefunc_sbid : function(e) {
			var bdhmarket = this.billhead.getValue('bdhmarket');
			//根据门店过滤商户
			if (!e.searchParam) {
				e.searchParam = {};
			}
			if (bdhmarket != undefined && bdhmarket != "") {
				e.searchParam.wherestr = "sbid in (select sbid from view_supmkt where muid ='" + bdhmarket  + "')";
			}
			return 1;
			
		},
        head_beforefunc_muid : function(e) {
            //如果值发生改变，检查明细是否有数据
        	if (this.badjustdetail.data.length > 0) {
        		var lable = e.sender.label.replace("：","");
                mini.alert("明细已存在数据,请先删除后再修改【" + lable+"】！");
                return -1;
              }
			
			return 1;
			
		},
        head_beforefunc_mfid : function(e) {
            //如果值发生改变，检查明细是否有数据
        	if (this.badjustdetail.data.length > 0) {
        		var lable = e.sender.label.replace("：","");
                mini.alert("明细已存在数据,请先删除后再修改【" + lable+"】！");
                return -1;
              }
        	var bdhsupid = this.billhead.getValue('bdhsupid');
			if (!e.searchParam) {
				e.searchParam = {};
			}
			if (bdhsupid != undefined && bdhsupid != "") {
				e.searchParam.wherestr = " muid in (select muid from view_supmkt where sbid ='" + bdhsupid  + "')";
			}
			var bdhmarket = this.billhead.getValue('bdhmarket');
			if (bdhmarket != undefined && bdhmarket != "") {
				e.searchParam.muid = bdhmarket;
			}
			return 1;
			
		},
		det_beforefunc_gbid : function(e) {
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var bdhsupid = this.billhead.getValue('bdhsupid');
			var bdhmfid = this.billhead.getValue('bdhmfid');
			var bdhwmid = this.billhead.getValue('bdhwmid');
			//e.searchParam.multiSelect=true;
			if (bdhsupid == undefined && bdhsupid == ""){
				mini.alert("单据头：串销供应商不能为空！");
				return -1;
			}
			if (bdhmfid == undefined && bdhmfid == ""){
				mini.alert("单据头：串销商铺不能为空！");
				return -1;
			}
			if (bdhwmid == undefined && bdhwmid == ""){
				mini.alert("单据头：串销经营方式不能为空！");
				return -1;
			}
			var str = " Exists (Select 1 From Goodsmframe, Shoplist, Supplierbase ";
			str = str +  " Where Gmfmfid = Shoplist.Spcode";
			str = str +  "   And Gmfsupid = Supplierbase.Sbcode";
			str = str +  "   And Supplierbase.Sbid = '" + bdhsupid + "'";
			str = str +  "   And Gmfwmid = '" + bdhwmid + "'";
			str = str +  "   And Shoplist.Spid = '" + bdhmfid + "'";
			str = str +  "   And Gmfgdid = v_Goodsbase.Gbid)";
			str = str +  "   And gbtype <> '6'";  //限制母码商品
			e.searchParam.wherestr = str;
			if(e.type == "valuechanged") {
				e.searchParam.gbbarcode = e.value;
			}
			
			return 0;
			
		},
		det_before_newmfid : function(e) {
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var bdhmarket = this.billhead.getValue('bdhmarket');
			if (bdhmarket != undefined && bdhmarket != "") {
				e.searchParam.muid = bdhmarket;
			}
			return 0;
			
		},
		det_before_newsupid : function(e) {
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var row = this.badjustdetail.getSelected();
			var newmfid = row["bddnewmfid"];
			if (newmfid == undefined || newmfid == ""){
				mini.alert("请先选择应销商铺！");
				return -1;
			} else {
				e.searchParam.wherestr = " exists (Select * From goodsmframe,shoplist Where gmfmfid=shoplist.spcode and shoplist.spid='"+ newmfid +"' And gmfsupid=supplierbase.sbcode)";
			}
			return 0;
			
		},
		det_before_newgbid : function(e) {
			if (!e.searchParam) {
				e.searchParam = {};
			}
			var row = this.badjustdetail.getSelected();
			var newmfid = row["bddnewmfid"];
			if (newmfid == undefined || newmfid == ""){
				mini.alert("请先选择应销商铺！");
				return -1;
			} 
			var newsupid = row["bddnewsupid"];
			if (newsupid == undefined || newsupid == ""){
				mini.alert("请先选择应销供应商！");
				return -1;
			}
			var str = " Exists (Select 1 From Goodsmframe, Shoplist, Supplierbase ";
			str = str +  " Where Gmfmfid = Shoplist.Spcode";
			str = str +  "   And Gmfsupid = Supplierbase.Sbcode";
			str = str +  "   And Supplierbase.Sbid = '" + newsupid + "'";
			str = str +  "   And Shoplist.Spid = '" + newmfid + "'";
			str = str +  "   And Gmfgdid = v_Goodsbase.Gbid)";
			str = str +  "   And gbtype <> '6'";  //限制母码商品
			e.searchParam.wherestr = str;
			if(e.type == "valuechanged") {
				e.searchParam.gbbarcode = e.value;
			}
			return 0;
			
		},
		head_itemchangedfunc: function(e, data) {
            var colname = e.sender.name;
            var colvalue = e.value;
            var oldcolvalue = e.sender.oldValue;
            //如果值发生改变，检查明细是否有数据
            if (colvalue != oldcolvalue) {
            	if (this.badjustdetail.data.length > 0) {
            		var lable = e.sender.label.replace("：","");
                    mini.alert("请先删除明细数据后再修改【" + lable+"】！");
                    this.billhead.setValueText(colname, oldcolvalue,e.sender);
                    //this.billhead.setValue(colname,oldcolvalue);
                    return -1;
                }

            }
			this.changeView(colname,true);
		},
		head_valuechanged: function (e, data) {
            var colname = e.sender.name;
            var colvalue = e.value;
            var oldcolvalue = e.sender.oldValue;
            //如果值发生改变，检查明细是否有数据
            if (colvalue != oldcolvalue) {
            	if (this.badjustdetail.data.length > 0) {
            		var lable = e.sender.label.replace("：","");
                    mini.alert("明细已存在数据,请先删除后再修改【" + lable+"】！");
                    this.billhead.setValue(colname,oldcolvalue);
                    return -1;
                }
            	if (colname == 'syjh'){
            		var bdhwmid = mini.getbyName("bdhwmid").getValue();
            	    if (bdhwmid == undefined || bdhwmid == "") {
            	    	/*bdhwmid == '4';*/
            	    	mini.alert("经营方式不能为空，请填写！！！");
            	    	this.billhead.setValue('syjh', "");
            			return;
            		}
            	}
            	if (colname == 'invno') {
            		var bdhmode = mini.getbyName("bdhmode").getValue();
            		var bdhmarket = mini.getbyName("bdhmarket").getValue();
            		if (bdhmarket == undefined || bdhmarket == "") {
            			mini.alert("门店不能为空，请填写！！！");
            			this.billhead.setValue('invno', "");
            			return;
            		}
            		var bdhmfid = mini.getbyName("bdhmfid").getValue();
            		if (bdhmfid == undefined || bdhmfid == "") {
            			mini.alert("串销商铺不能为空，请填写！！！");
            			this.billhead.setValue('invno', "");
            			return;
            		}
            		var bdhsupid = mini.getbyName("bdhsupid").getValue();
        		    if (bdhsupid == ""){
        		    	bdhsupid = null;
        		    }
        		    var bdhwmid = mini.getbyName("bdhwmid").getValue();
            	    if (bdhwmid == undefined || bdhwmid == "") {
            	    	/*bdhwmid == '4';*/
            	    	mini.alert("经营方式不能为空，请填写！！！");
            	    	this.billhead.setValue('invno', "");
            			return;
            		}
            		var syjh = mini.getbyName("syjh").getValue();
            		if (syjh == undefined || syjh == "") {
            			mini.alert("收银机号不能为空，请填写！！！");
            			this.billhead.setValue('invno', "");
            			return;
            		} 
            		var invno = mini.getbyName("invno").getValue().toString();
            		if (invno == undefined || invno == "") {
            			mini.alert("小票号不能为空，请填写！！！");
            			return;
            		}            	    
            	    var bdhtrans = mini.getbyName("bdhtrans").getValue();
        		    if (bdhtrans == "E"){
        				var tran = "12";
        			} else if (bdhtrans == "F"){
        				var tran = "45";
        			} else if (bdhtrans == "G"){
        				var tran = 'AB';
        			} else if (bdhtrans == "H"){
        				var tran = 'DE';
        			} else {
        				var tran = "1245ABDE";
        			}
        		    var searchParam = {
        		    		adjmode: bdhmode,
        		    		supid: bdhsupid,
        		    		wmid: bdhwmid,
        		    		mktid: bdhmarket,
        		    		mfid: bdhmfid,
        		    		syjid: syjh,
        		    		invno: invno,
        		    		tran: tran,
        		    };
        		    searchParam.queryid="select_selldet_cx";
            		var that = this;
            		var selldetail = {};
            		var table = [];
            		var url = OmdUrl.mall;
            		var method = "mss.work.report.query";
            		itemLoader.doRequest(url, method, searchParam, null, null, function(data) {
            			selldetail = data.report;
            			if (selldetail.length > 0) {
            				for (var j = 0; j < selldetail.length; j++) {
            					if (selldetail[j].gbspec == undefined){
            						selldetail[j].gbspec = "";
            					}
            					if (selldetail[j].gbunit == undefined){
            						selldetail[j].gbunit = "";
            					}
            					var newrow = {
            						bddgdid : selldetail[j].sglgdid,
            						bddbarcode : selldetail[j].sglbarcode,
            						bddmanamode: selldetail[j].gbmanamode,
            						bddname : selldetail[j].gbcname,
            						bddppcode : selldetail[j].sglppcode,
            						bddcatid : selldetail[j].sglcatid,
            						bddspec : selldetail[j].gbspec,
            						bddunit : selldetail[j].gbunit,
            						bdduid : selldetail[j].sgluid,
            						bddoldsl : selldetail[j].sglsl,
            						bddoldxsje : selldetail[j].sglxssr,
            						bddoldsjje : selldetail[j].sglsjje,
            						bddnewsl : selldetail[j].sglsl,
            						bddnewxsje : selldetail[j].sglxssr,
            						bddcatname : selldetail[j].catname,
            						bddppname : selldetail[j].ppcname,
            						bddoldmfid : selldetail[j].sglmfid,
            						bddoldmfname : selldetail[j].mfname,
            					};
            					that.badjustdetail.addRow(newrow);
            				}
            			} else {
            				mini.alert("没有找到该交易小票！");
            				return -1;
            			}
            		}, function(data) {
            			if (data != null) {
            				mini.alert(data);
            				return;
            			}
            		}, null, false);
            	}
            	if (colname == "bdhmode" || colname == "bdhtrans"){
            		this.changeView(colname,true);
            	}
           }
        },
		head_itemchanged: function(e,data) {
			//门店修改后，清掉供应商、领用商铺
			 var colname = e.sender.name;
			 var colcode = data[0].code;
	         if(colname=='bdhsupid'){
	        	
	         }
	         this.changeView(colname,true);
	         return 1;
		},
		/*det_valuechanged: function(e,data){
			if(colname == 'bddnewxsje'){
	        	 var that = this;
	        	 //var vtrans = mini.getbyName("bdhtrans").getValue()
	        	 var row = that.badjustdetail.getSelected();
	        	 if (row["bddnewxsje"] == 0){
	        		 mini.alert("调整金额错误：不能为0！");
	        		 return -1;
	        	 } else if (row["bddoldxsje"]>0 && row["bddnewxsje"]<0){
	        		 mini.alert("调整金额错误：不能为负数！");
	        		 return -1;
	        	 } else if (row["bddoldxsje"]<0 && row["bddnewxsje"]<0){
	        		 mini.alert("调整金额错误：不能为正数！");
	        		 return -1;
	        	 } else if (row["bddoldxsje"]>0 && row["bddnewxsje"] > row["bddoldxsje"]){
	        		 mini.alert("调整金额错误：不能大于原销售金额！");
	        		 return -1;
	        	 } else if (row["bddoldxsje"]<0 && row["bddnewxsje"] < row["bddoldxsje"]){
	        		 mini.alert("调整金额错误：不能大于原退货金额！");
	        		 return -1;
	        	 }
	         }
			return 1;
		},*/
		det_itemchanged: function(e,data) {
			//门店修改后，清掉供应商、领用商铺
			 var colname = e.sender.name;
			 var colcode = data[0].code;
			 var returnflag = 1;
	         if(colname == 'bddgdid'){
				var bdhmode = mini.getbyName("bdhmode").getValue();
        	    var bdhmarket = mini.getbyName("bdhmarket").getValue();
        	    var bdhmfid = mini.getbyName("bdhmfid").getValue();
        	    var bdhsupid = mini.getbyName("bdhsupid").getValue();
    		    if (bdhsupid == ""){
    		    	mini.alert("原供应商为空，请填写！！！");
        			return -1;
    		    }
				var bdhwmid = mini.getbyName("bdhwmid").getValue();
				var ksrq = utils.getDateStr(mini.getbyName("ksrq").getValue(),'yyyy-MM-dd');
				var jsrq = utils.getDateStr(mini.getbyName("jsrq").getValue(),'yyyy-MM-dd');
        	    if (jsrq < ksrq) {
        			mini.alert("开始日期大于结束日期，请重新填写！！！");
        			this.billhead.setValue('jsrq', "");
        			return;
        		}
        	    var bdhtrans = mini.getbyName("bdhtrans").getValue();
        	    if (bdhtrans == "E"){
    				var tran = "12";
    			} else if (bdhtrans == "F"){
    				var tran = "45";
    			} else if (bdhtrans == "G"){
    				var tran = 'AB';
    			} else if (bdhtrans == "H"){
    				var tran = 'DE';
    			} else {
    				var tran = "1245ABDE";
    			}
        	    var searchParam = {};
        	    if (data.length > 1){
        	    	var gdid = "";
        	    	for (var j = 0; j < data.length; j++){
        	    		gdid = gdid +"'" + data[j].code + "',";
        	    	}
        	    	gdid = gdid +"''";
        	    	searchParam.wherestr = " a.Sglgdid in ("+gdid+")";
        	    	gdid = "";
        	    } else{
        	    	var gdid = data[0].code;
        	    }
    		    searchParam.adjmode = bdhmode;
    		    searchParam.supid = bdhsupid;
    		    searchParam.wmid = bdhwmid;
    		    searchParam.mktid = bdhmarket;
    		    searchParam.mfid = bdhmfid;
    		    searchParam.sdate =ksrq;
    		    searchParam.edate = jsrq
    		    searchParam.tran = tran;
    		    searchParam.gdid = gdid;	
    		    searchParam.queryid="select_selldet_cx";
    		    var that = this;
        		var selldetail = {};
        		var table = [];
        		var url = OmdUrl.mall;
        		var method = "mss.work.report.query";
        		itemLoader.doRequest(url, method, searchParam, null, null, function(data) {
        			selldetail = data.report;
        			if (selldetail.length > 0) {
        				//that.badjustdetail.
        				for (var j = 0; j < selldetail.length; j++) {
        					
        					//that.badjustdetail.addRow(newrow);

            				var row = that.badjustdetail.getSelected();
            		        // 不允许添加重复商品
            	 			var duplicate = false;
            	 			var existGoods = "";
            	 			var maxrow = 1;
            		        var existDatas = that.badjustdetail.getData();
            				for (var i = 0; i < existDatas.length; i++) {
            					if (existDatas[i].bddgdid == selldetail[j].sglgdid) {
            						existGoods = existGoods + "[" + selldetail[j].sglgdid + "],";
            						duplicate = true;
            						break;
            					}
            				}
            				if (!duplicate) {
            					var newrow = {
                					bddgdid : selldetail[j].sglgdid,
                					bddbarcode : selldetail[j].sglbarcode,
                					bddmanamode: selldetail[j].gbmanamode,
                					bddname : selldetail[j].gbcname,
                					bddppcode : selldetail[j].sglppcode,
                					bddcatid : selldetail[j].sglcatid,
                					bddspec : selldetail[j].gbspec,
                					bddunit : selldetail[j].gbunit,
                					bdduid : selldetail[j].sgluid,
                					bddoldsl : selldetail[j].sglsl,
                					bddoldxsje : selldetail[j].sglxssr,
                					bddoldsjje : selldetail[j].sglsjje,
                					bddnewsl : selldetail[j].sglsl,
                					bddnewxsje : selldetail[j].sglxssr,
                					bddcatname : selldetail[j].catname,
                					bddppname : selldetail[j].ppcname,
                					bddoldmfid : selldetail[j].sglmfid,
                					bddoldmfname : selldetail[j].mfname,
            					};
            					if (row.bddgdid == undefined || row.bddgdid == "" || row.bddgdid == " "){
                                    newrow.bddnewmfid = lastGoods.bddnewmfid;
                                    newrow.bddnewmfname = lastGoods.bddnewmfname;
                                    newrow.bddnewsupid = lastGoods.bddnewsupid
                                    newrow.bddnewsupname = lastGoods.bddnewsupname;
                                    newrow.bddnewgdid = lastGoods.bddnewgdid;
                                    newrow.bddnewbarcode = lastGoods.bddnewbarcode;
                                    newrow.bddnewgbname = lastGoods.bddnewgbname;
                                    newrow.bddnewcatid = lastGoods.bddnewcatid;
                                    newrow.bddnewcatname = lastGoods.bddnewcatname;
                                    newrow.bddnewppcode = lastGoods.bddnewppcode;
                                    newrow.bddnewppname = lastGoods.bddnewppname;
                                    //新行
            						//that.badjustdetail.addRow(newrow);
            						that.badjustdetail.updateRow(row, newrow);
            					} else {
            						that.badjustdetail.updateRow(row, newrow);
            					}
            				} else {
            					var delrow = {
            							flag : "D",
            					};
            					//that.badjustdetail.updateRow(row, delrow);
            					that.badjustdetail.rejectRecord(row);
            					//that.badjustdetail.removeRow(row);
            					duplicate = false;
            				}

            	 			if (existGoods != "" && existGoods.length > 1) {
            	 				mini.alert("已经过滤重复的商品编码:"
            	 						+ existGoods.substring(0,
            	 								existGoods.length - 1));
            	 			}
        				}
        			} else {
        				mini.alert("没有此条件下的交易记录！");
						returnflag = -1;  //解决回调函数返回后继续走值改变后的return 1导致选择的值回填了问题
        				return -1;
        			}
        		}, function(data) {
        			if (data != null) {
        				mini.alert(data);
        				return;
        			}
        		}, null, false);

			 } else if(colname == 'bddnewgdid'){
				var that = this;
     			if (data.length > 0) {
     				 var row = that.badjustdetail.getSelected();
     				 var newrow = {
							bddnewbarcode : data[0].code,
							bddnewgbname : data[0].gbcname,
							bddnewcatid : data[0].gbcatcode,
							bddnewcatname : data[0].mid_name,
							bddnewppcode : data[0].gbppcode,
							bddnewppname : data[0].ppcode_name,
 					};
 					that.badjustdetail.updateRow(row, newrow);
 					lastGoods.bddnewgdid = data[0].code;
 					lastGoods.bddnewbarcode = data[0].code;
					lastGoods.bddnewgbname = data[0].gbcname;
					lastGoods.bddnewcatid = data[0].gbcatcode;
					lastGoods.bddnewcatname = data[0].mid_name;
					lastGoods.bddnewppcode = data[0].gbppcode;
					lastGoods.bddnewppname = data[0].ppcode_name;
     			}
	         } else if(colname == 'bddnewmfid'){
	        	 if (data.length > 0) {
	        		 var that = this;
	        		 var newmfid = data[0].oid;
	        		 if (newmfid == undefined || newmfid == ""){
		        		 mini.alert("应销商铺不能为空，请填写！！！");
		        			return -1;
		        	 } else{
		        		 var row = that.badjustdetail.getSelected();
		        		 lastGoods.bddnewmfid = data[0].oid;
		        		 lastGoods.bddnewmfname = data[0].spid_name;
		        		 var newrow = {
		        				bddnewsupid : "",
		        				bddnewsupname : "",
				        		bddnewgdid : "",
				 				bddnewbarcode : "",
								bddnewgbname : "",
								bddnewcatid : "",
								bddnewcatname : "",
								bddnewppcode : "",
								bddnewppname : "",
		        		 };
		 				 that.badjustdetail.updateRow(row, newrow);		 					
		        	 }
	        	 }
	         } else if(colname == 'bddnewsupid'){
	        	 if (data.length > 0) {
	        		 
	        		 var that = this;
	        		 var newmfid = data[0].oid;
	        		 if (newmfid == undefined || newmfid == ""){
		        		 mini.alert("应销供应商不能为空，请填写！！！");
		        			return -1;
		        	 } else{
		        		 var row = that.badjustdetail.getSelected();
		        		 lastGoods.bddnewsupid = data[0].oid;
		        		 lastGoods.bddnewsupname = "["+data[0].code + "]" + data[0].name;
		        		 var newrow = {
				        		bddnewgdid : "",
				 				bddnewbarcode : "",
								bddnewgbname : "",
								bddnewcatid : "",
								bddnewcatname : "",
								bddnewppcode : "",
								bddnewppname : "",
		        		 };
		 				 that.badjustdetail.updateRow(row, newrow);		 					
		        	 }
	        	 }
	         }
	         return returnflag;
		},
		detcellcommitedit : function(e) {
			// 校验调整数量和调整金额
			if(e.field == 'bddnewsl'){
	        	 var that = this;
	        	 var row = that.badjustdetail.getSelected();
	        	 if (e.value <= 0){
	        		 mini.alert("调整数量错误：不能为0或负数！");
	        		 e.value = e.row.bddoldsl;
	        	 } else if (e.value > e.row.bddoldsl){
	        		 mini.alert("调整数量错误：不能大于原销售或退货数量！");
	        		 e.value = e.row.bddoldsl;
	        	 }
	        	 return;
	         } else if(e.field == 'bddnewxsje'){
	        	 var that = this;
	        	 if (e.value <= 0){
	        		 mini.alert("调整金额错误：不能为0或负数！");
	        		 e.value = e.row.bddoldxsje;
	        	 } else if (e.value > e.row.bddoldxsje){
	        		 mini.alert("调整金额错误：不能大于原销售或退货金额！");
	        		 e.value = e.row.bddoldxsje;
	        	 }
	        	 return;
	         }
			
		},
		oncellbeginedit : function(e) {
			var record = e.record;
			var field = e.field;
			var bdhmode = this.billhead.getValue('bdhmode');
			if (field == "bddgdid") {
				//按小票调整时，不允许修改串销商品
				if(record.bdhmode != undefined || record.bdhmode != "" ){
					if (bdhmode == "2") {
						e.cancel = true;
					} else {
						e.cancel = false;
					}
				} 
			} else if (field == "bddnewsl") {
				// 现金键商品不允许按数量调整
				if(record.bddmanamode == "4" ){
					e.cancel = true;
				} else {
					e.cancel = false;
				}
			} else if (field == "bddnewxsje") { 
				// 单品码商品不允许按销售金额调整
//				if(record.bddmanamode == "1"/* || record.bddmanamode == "3"*/){
//					e.cancel = true;
//				} else {
					e.cancel = false;
//				}
			}
		},
		_systabChanged  : function (e) {
			if (e.tab.name == "badjusthead") {
				this.oldbdhmode = this.billhead.getText('bdhmode');
			    }
			this._refreshSysbtnEnable();
		},
        transformSetData: function (data) {


        },
        transformSaveData: function (data) {


        },
        addTabsGridRowAfter : function (e){
        	var that = this;
        	var data = that.badjustdetail.data;
        	if (data.length > 1){
        		var row = data[data.length -1];
        		var newrow = {
        				bddnewmfid : data[data.length -2].bddnewmfid,
        				bddnewmfname : data[data.length -2].bddnewmfname,
        				bddnewsupid : data[data.length -2].bddnewsupid,
        				bddnewsupname : data[data.length -2].bddnewsupname,
        				bddnewwmid : data[data.length -2].bddnewwmid,
        				bddnewspec : data[data.length -2].bddnewspec,
        				bddnewunit : data[data.length -2].bddnewunit,
        				bddnewuid : data[data.length -2].bddnewuid,
        				bddnewbarcode : data[data.length -2].bddnewbarcode,
						bddnewgbname : data[data.length -2].bddnewgbname,
						bddnewcatid : data[data.length -2].bddnewcatid,
						bddnewcatname : data[data.length -2].bddnewcatname,
						bddnewppcode : data[data.length -2].bddnewppcode,
						bddnewppname : data[data.length -2].bddnewppname,
        		};
        	}
        },
        addTabsGridRowBefore : function (e) {
        	if(this.billhead.getValue('bdhmode') == "2"){
        		e.cancle=false;
        		mini.alert("按销售小票调整时，不能手工增加明细行!");
        		return;
        	} else {
				var bdhmode = this.billhead.getValue('bdhmode');
				if (bdhmode == undefined || bdhmode == ""){
					mini.alert("调整方式不能为空，请填写！！！");
        			return;
				}
        	    var bdhmarket = this.billhead.getValue('bdhmarket');
        		if (bdhmarket == undefined || bdhmarket == "") {
        			mini.alert("门店号不能为空，请填写！！！");
        			return;
        		}
        	    var bdhmfid = mini.getbyName("bdhmfid").getValue();
        		if (bdhmfid == undefined || bdhmfid == "") {
        			mini.alert("串销商铺不能为空，请填写！！！");
        			return;
        		}
        	    var bdhsupid = mini.getbyName("bdhsupid").getValue();
    		    if (bdhsupid == ""){
    		    	mini.alert("原供应商不能为空，请填写！！！");
        			return;
    		    }
				var bdhwmid = mini.getbyName("bdhwmid").getValue();
        		if (bdhwmid == undefined || bdhwmid == "") {
        			mini.alert("经营方式不能为空，请填写！！！");
        			return;
        		}
				var ksrq = utils.getDateStr(mini.getbyName("ksrq").getValue(),'yyyy-MM-dd');
        		if (ksrq == undefined || ksrq == "") {
        			mini.alert("开始日期不能为空，请填写！！！");
        			return;
				} 
				var jsrq = utils.getDateStr(mini.getbyName("jsrq").getValue(),'yyyy-MM-dd');
        		if (jsrq == undefined || jsrq == "") {
        			mini.alert("结束日期不能为空，请填写！！！");
        			return;
        		}
        	    if (jsrq < ksrq) {
        	    	mini.alert("开始日期不能大于结束日期，请重新填写！！！");
        			this.billhead.setValue('jsrq', "");
        			return;
        		}
        	    return 1;
			}
        },
        editDataAfter : function (e) {
    		var colname = "bdhmode";
        	this.changeView(colname,false);
        	return 1;
        },
        /*editDataBefore : function (e) {
    		var colname = "bdhmode";
        	this.changeView(colname,false);
        	return 1;
        },*/
        saveDataBefore : function (data) {
    		// 门店
    		var bdhmarket = this.billhead.getValue('bdhmarket');
    		if (bdhmarket == undefined || bdhmarket == "") {
    			mini.alert("单据头：门店为空，请检查!");
    			return;
    		}
    		// 商铺
    		var bdhmfid = this.billhead.getValue('bdhmfid');
    		if (bdhmfid == undefined || bdhmfid == "") {
    			mini.alert("单据头：串销商铺为空，请检查!");
    			return;
    		}
        	var bdhmode = this.billhead.getValue('bdhmode');
        	if (bdhmode == undefined || bdhmode == ""){
        		mini.alert("单据头：必须选择一种调整方式!");
    			return;
        	}else if (bdhmode == "2") {
        		// 收银机
        		var syjh = this.billhead.getValue('syjh');
        		// 小票号
        		var invno = this.billhead.getValue('invno');
        		if (syjh == undefined || syjh == "") {
        			mini.alert("单据头：按小票调整时收银机号不能为空，请检查！");
        			return;
        		}
        		if (invno == undefined || invno == "") {
        			mini.alert("单据头：按小票调整时小票号不能为空，请检查！");
        			return;
        		}
        		/*if (invno.isNaN()){
        			mini.alert("小票号必须数字串，请检查");
        			return;
        		}*/
        	} else {
        		// 开始日期
        		var ksrq = this.billhead.getValue('ksrq');
        		if (ksrq == undefined || ksrq == "") {
        			mini.alert("单据头：按时间段调整时开始日期不能为空，请检查！");
        			return;
        		}
        		// 结束日期
        		var jsrq = this.billhead.getValue('jsrq');
        		if (jsrq == undefined || jsrq == "") {
        			mini.alert("单据头：按时间段调整时结束日期不能为空，请检查！");
        			return;
        		}

        		// 商铺
        		var bdhsupid = this.billhead.getValue('bdhsupid');
        		if (bdhsupid == undefined || bdhsupid == "") {
        			mini.alert("单据头：串销供应商为空，请检查!");
        			return;
        		}
        	}
        	var detData = this.badjustdetail.getData();
        	if(detData.length == 0){
        		mini.alert("单据明细：调整明细不能为空，请检查！");
    			return;
        	}
        	for(var i =0; i<detData.length;i++){
        		if (!(detData[i].bddgdid) || detData[i].bddgdid ==""|| detData[i].bddgdid ==" "){
        			mini.alert("单据明细：第"+(i+1)+"行，串销商品条码不能为空，请检查！");
        			return;
        		}
        		if (detData[i].bddmanamode != "4"){
        			if (!(detData[i].bddnewsl)){
            			mini.alert("单据明细：第"+(i+1)+"行，管单品商品调整数量不能为空或0，请检查！");
            			return;
            		} else if (Math.abs(detData[i].bddnewsl)> Math.abs(detData[i].bddoldsl)){
            			mini.alert("单据明细：第"+(i+1)+"行，调整数量超过原交易数量，请检查！");
            			return;
            		}
        		}
        		if (detData[i].bddmanamode != "4"){
        			if (!(detData[i].bddnewxsje)){
            			mini.alert("单据明细：第"+(i+1)+"行，现金键商品调整金额不能为空或0，请检查！");
            			return;
            		} else if (Math.abs(detData[i].bddnewxsje)> Math.abs(detData[i].bddoldxsje)){
            			mini.alert("单据明细：第"+(i+1)+"行，调整金额超过原成交金额，请检查！");
            			return;
            		}
        		}
        		
        		if (!(detData[i].bddnewmfid) || detData[i].bddnewmfid ==""|| detData[i].bddnewmfid ==" "){
        			mini.alert("单据明细：第"+(i+1)+"行，应销商铺不能为空，请检查！");
        			return;
        		}
        		if (!(detData[i].bddnewsupid)|| detData[i].bddnewsupid ==""|| detData[i].bddnewsupid ==" "){
        			mini.alert("单据明细：第"+(i+1)+"行，应销供应商不能为空，请检查！");
        			return;
        		}
        		if (!(detData[i].bddnewgdid)|| detData[i].bddnewgdid ==""|| detData[i].bddnewgdid ==" "){
        			mini.alert("单据明细：第"+(i+1)+"行，应销商品条码不能为空，请检查！");
        			return;
        		}
        		if (detData[i].bddnewgdid == detData[i].bddgdid && detData[i].bddnewmfid == bdhmfid && detData[i].bddnewsupid == bdhsupid){
        			mini.alert("单据明细：第"+(i+1)+"行，应销商品条码、商铺、供应商与原商品完全一致，不能做调整，请检查！");
        			return;
        		}
        	}
        	
        	for (var i = 0; i < detData.length; i++) {
        		var row = detData[i]
        		var num = i + 1;
        		if (row.bddrowno == undefined || row.bddrowno == "" ||row.bddrowno != i) {
        			row.bddrowno =  num;
        		}
        	}
        	//setGridData(detData);
        	
        	var obj = {};
        	if(this.badjustdetail){
        		obj.badjustdetail = detData;
        		setGridData(obj.badjustdetail);	
        	}
        	
        	return obj;
        },
        initcontrol: function () {
        	Badjustcx.superclass.initcontrol.call(this);

        },
        checkValidate: function () {
            var isValid = Badjustcx.superclass.checkValidate.call(this);
            if (isValid == false) {
                return isValid;
            }
            return true;

        }
    });
})()
