/**
 * 页面定义
 */
(function() {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('ownerpayment.view');

	// 定义一个对象用来配置界面
	var bill = {};
	var billtype = getBilltype(app.modulecode);

	// 把定义对象放到命名空间下
	ns.bill = bill;

	utils.billtype = billtype;

	// 查询列表
	bill.ownerpaymentlist = {
		"type" : "gridbox",
		"resources" : OmdUrl.mall,
		"method" : "mss.work.ownerpayment.search",
		"response" : "v_supsetpayhead",
		"bindform" : "layouttabs",
		"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段
		"searchParam" : {
			"billmoduleid" : app.modulecode,
			"order_field" : "billno",
			"order_direction" : "desc",
		},
		"properties" : {
			"id" : utils.createid('ownerpaymentlist'),
			"columns" : [ {
				type : "indexcolumn",
				headerAlign : "center",
				header : "行号",
				width : 60,
			}, {
				field : "billno",
				type : "TextBox",
				headerAlign : "center",
				header : "单据编号",
				width : 150,
			}, {
				field : "billtype",
				type : "TextBox",
				headerAlign : "center",
				header : "单据类型",
				renderer : "OcmControl.dictRendererWithCode",
				dictkey : 'BILLTYPE',
				visible : false,
				enabledSearch : false,
				width : 150,
			}, {
				field : "billstatus",
				type : "TextBox",
				headerAlign : "center",
				header : "单据状态",
				renderer : "OcmControl.dictRendererWithCode",
				dictkey : 'BILLSTATUS',
			}, {
				field : "muid",
				type : "TextBox",
				headerAlign : "center",
				header : "门店",
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "muid_name",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "muid"
				},
				visible : true,
				enabledSearch : true,
				width : 200,
			}, {
				field : "muid_name",
				type : "TextBox",
				headerAlign : "center",
				header : "门店",
				visible : false,
				enabledSearch : false,
			}, {
				field : "ownerid",
				type : "TextBox",
				headerAlign : "center",
				header : "业主",
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "ownerid_name",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "owner"
				},
				visible : true,
				enabledSearch : true,
				width : 200,
			}, {
				field : "ownerid_name",
				type : "TextBox",
				headerAlign : "center",
				header : "业主",
				visible : false,
				enabledSearch : false,
			}, {
				field : "payment",
				type : "TextBox",
				headerAlign : "center",
				header : "支付方式",
				renderer : "OcmControl.dictRendererWithCode",
				dictkey : 'PAYMODE',
			}, {
				field : "factpay",
				type : "TextBox",
				headerAlign : "center",
				header : "本次付款",
				enabledSearch : false,
				width : 150,
			}, {
				field : "moneyupper",
				type : "TextBox",
				headerAlign : "center",
				header : "大写付款金额",
				enabledSearch : false,
				width : 150,
			}, {
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "user"
				},
				visible : false,
				enabledSearch : true,
			}, {
				field : "inputer_name",
				header : "录入人",
				width : 200,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "user"
				},
				visible : false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 200,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "canceler",
				header : "取消人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "user"
				},
				visible : false,
			}, {
				field : "canceler_name",
				header : "取消人",
				width : 200,
				allowSort : true,
				headerAlign : "center",
			}, {
				field : "canceldate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "取消日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "memo",
				header : "备注",
				width : 120,
				allowSort : true,
				headerAlign : "center",
				visible : false,
			} ]
		}
	};

	// 单据主表
	bill.supsetpayhead = {
		"type" : "formgrid",
		"initHeight" : 0.5,
		"resources" : OmdUrl.mall,
		"name" : 'v_supsetpayhead',
		"method" : "mss.work.ownerpayment.get",
		"response" : "v_supsetpayhead",
		"properties" : {
			"id" : utils.createid('supsetpayhead')
		},
		items : [ {
			"label" : "ph_key：",
			"name" : "ph_key",
			"type" : "TextBox",
			"visible" : false,
		}, {
			"label" : "单据编号：",
			"name" : "billno",
			"type" : "TextBox",
			"readOnly" : true,
			"visible" : true,
		}, {
			"label" : "单据类型：",
			"name" : "billtype",
			"type" : "ComboBox",
			"defaultValue" : billtype,
			dictkey : 'BILLTYPE',
			"visible" : true,
			"readOnly" : true,
		}, {
			"lable" : "billmoduleid",
			"name" : "billmoduleid",
			"type" : "TextBox",
			"defaultValue" : app.modulecode,
			"visible" : false,
		}, {
			"label" : "单据状态：",
			"name" : "billstatus",
			"type" : "ComboBox",
			dictkey : 'BILLSTATUS',
			"readOnly" : true,
			"defaultValue" : "N",
		}, {
			"label" : "单据状态：",
			"name" : "billflag",
			"type" : "ComboBox",
			"readOnly" : true,
			"defaultValue" : "N",
			"visible" : false,
		}, {
			"label" : "门店：",
			"name" : "muid",
			"type" : "fut_popselect",
			"required" : "true",
			selectkey : "muid",
			textName : "muid_name",
			allowInput : true,
			beforefunc : "page.head_beforefunc",
			itemchangedfunc : "page.head_itemchangedfunc",
			readOnly : false,
		}, {
			"label" : "门店：",
			"name" : "muid_name",
			"type" : "TextBox",
			readOnly : true,
			visible : false
		}, {
			"label" : "业主：",
			"name" : "ownerid",
			"type" : "fut_popselect",
			"required" : "true",
			selectkey : "owner",
			textName : "ownerid_name",
			allowInput : true,
			beforefunc : "page.head_beforefunc",
			itemchangedfunc : "page.head_itemchangedfunc",
			readOnly : false,
		}, {
			"label" : "业主名称：",
			"name" : "ownerid_name",
			"type" : "TextBox",
			readOnly : true,
			visible : false
		}, {
			"label" : "支付方式：",
			"name" : "payment",
			"type" : "ComboBox",
			"dictkey" : "PAYMODE",
			readOnly : false,
			"visible" : true,
		}, {
			"label" : "本次付款：",
			"name" : "factpay",
			"type" : "NumButtonEdit",
			"defaultValue" : "0",
			"format" : "c2",
			readOnly: true,
			"visible" : true,
		}, {
			"label" : "大写金额：",
			"name" : "moneyupper",
			"type" : "TextBox",
			readOnly: true,
			"visible" : true,
			style : "width:60%; display:block;float:none",
		}, {
			"label" : "开户银行：",
			"name" : "bank",
			"type" : "TextBox",
			readOnly: true,
			"visible" : true,
		}, {
			"label" : "收款人：",
			"name" : "payee",
			"type" : "TextBox",
			readOnly: true,
			"visible" : true,
		}, {
			"label" : "银行帐号：",
			"name" : "accntno",
			"type" : "TextBox",
			readOnly: true, 
			"visible" : true,
			"style" : "width:60%; display:block;float:none",
		}, {
			"label" : "备注：",
			"name" : "memo",
			"type" : "TextBox",
			/* readOnly: true, */
			"visible" : true,
			"style" : "width:90%; display:block;float:none",
		}, {
			"label" : "录入人：",
			"type" : "TextBox",
			"name" : "inputer_name",
			"readOnly" : "true",
		}, {
			"label" : "审核人：",
			"type" : "TextBox",
			"name" : "auditor_name",
			"readOnly" : "true",
		}, {
			"label" : "取消人：",
			"type" : "TextBox",
			"name" : "canceler_name",
			"readOnly" : "true",
		}, {
			"label" : "录入日期：",
			"type" : "DatePicker",
			"name" : "inputdate",
			"format" : "yyyy-MM-dd HH:mm:ss",
			"readOnly" : "true",
		}, {
			"label" : "审核日期：",
			"type" : "DatePicker",
			"name" : "auditdate",
			"format" : "yyyy-MM-dd HH:mm:ss",
			"readOnly" : "true",
		}, {
			"label" : "取消日期：",
			"type" : "DatePicker",
			"name" : "canceldate",
			"format" : "yyyy-MM-dd HH:mm:ss",
			"readOnly" : "true",
		}, {
			"label" : "录入人编码",
			"type" : "TextBox",
			"name" : "inputer",
			"visible" : false,
		} ]
	}
	// 单据明细
	bill.supsetpaydet = {
		title : '单据明细',
		"type" : "gridbox",
		name : 'supsetpaydet',
		"properties" : {
			"id" : utils.createid('supsetpaydet'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"sortMode" : "client",
			//"showPager" : true,
			// "showSummaryRow": true,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				name : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
			}, {
				type : "indexcolumn",
				name : "indexcolumn",
				header : "行号",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				field : "setbillno",
				name : "setbillno",
				header : "收款单编号",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				width : 160,
			}, {
				field : "setrowno",
				name : "setrowno",
				header : "收款单序号",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : 160,
			}, {
				field : "sbid",
				name : "sbid",
				header : "商户",
				headerAlign : "center",
				allowSort : true,
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "sbid_name",
				width : 160,
				editorSet : {
					selectkey : 'sbid',
				},
				readOnly : true,
			}, {
				field : "sbid_name",
				name : "sbid_name",
				header : "商户名称",
				headerAlign : "center",
				width : 150,
				visible : false
			}, {
				field : "spid",
				name : "spid",
				header : "商铺",
				headerAlign : "center",
				allowSort : true,
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "spid_name",
				width : 160,
				editorSet : {
					selectkey : 'spid',
				},
				readOnly : true,
			}, {
				field : "spid_name",
				name : "spid_name",
				header : "商铺名称",
				headerAlign : "center",
				width : 150,
				visible : false
			}, {
				field : "contno",
				name : "contno",
				header : "合同号",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				width : 120,
			}, {
				field : "itemcode",
				name : "itemcode",
				header : "费用项目",
				headerAlign : "center",
				allowSort : true,
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "itemcode_name",
				width : 160,
				editorSet : {
					selectkey : 'cccode',
				},
				readOnly : true,
			}, {
				field : "itemcode_name",
				name : "itemcode_name",
				header : "费用项目名称",
				headerAlign : "center",
				width : 150,
				visible : false
			}, {
				field : "startdate",
				name : "startdate",
				header : "开始日期",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				align : "center",
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				editorSet : {
					format : "yyyy-MM-dd",
				},
				readOnly : true,
			}, {
				field : "enddate",
				name : "enddate",
				header : "结束日期",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				align : "center",
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				editorSet : {
					format : "yyyy-MM-dd",
				},
				readOnly : true,
			}, {
				field : "amount",
				name : "amount",
				header : "应付业主金额",
				headerAlign : "center",
				width : 120,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "c2",
				},
				numberFormat : "c2",
				defaultValue : "0",
				align : "right",
				readOnly : true
			} ]
		},
	};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id : utils.createid('systoolbar'),
		items : [ btn.addData, btn.delData, btn.editData, btn.saveData,
				btn.separator, btn.auditData, btn.cancelData, btn.separator,
				btn.searchData ]
	}

	// 单据配置
	bill.billconfig = {
		billhead : bill.supsetpayhead, // 单据主表
		billdetail : [ bill.supsetpaydet ], // 单据明细表
		billquerylist : bill.ownerpaymentlist, // 查询列表
		dettabpages : [ bill.supsetpaydet ], // 要放入明细TAB列表的组件
		defaultmoduleid : app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
