/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('payin.view');

	// 定义一个对象用来配置界面
	var bill = {};
	//var billtype = getBilltype(app.modulecode);
	// 把定义对象放到命名空间下
	ns.bill = bill;
	//utils.billtype = billtype;
	// 查询列表
	bill.payinlist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.settleup.payinhead.search",
		"response": "payinhead",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam": {
			"billmoduleid" : app.modulecode,
			"order_field": "inputdate",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('payinlist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 150,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
			}, {
				field: "muid",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "muid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "muid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				enabledSearch : false,
				width: 180,
			}, {
				field : "syjh",
				header : "收银机号",
				width : 60,
				headerAlign : "center",
			}, {
				field : "syyh",
				header : "收银员",
				width : 60,
				headerAlign : "center",
			}, {
				field : "rqsj",
				type : "date",
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				header : "销售日期",
				width : 150,
				headerAlign : "center",
				align : "center",
			},{
				field : "jkje",
				header : "合计金额",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				width : 100,
			}, {
				field : "jkrq",
				type : "date",
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				header : "缴款日期",
				width : 150,
				headerAlign : "center",
				align : "center",
			},{
				field : "inputer_name",
				header : "录入人",
				width : 150,
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
			},{
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "canceler",
				header : "取消人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "canceler_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "canceler_name",
				header : "取消人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "canceldate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "取消日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "memo",
				header : "备注",
				width : 120,
				allowSort : true,
				headerAlign : "center",
				visible:false,
			}]
		}
	};
	
	// 单据主表
	bill.payinhead = {
		"type": "formgrid",
		"resources": OmdUrl.mss,
		"name": 'payinhead',
		"method": "mss.settleup.payinhead.get",
		"response": "payinhead",
		"properties": {
			"id": utils.createid('payinhead')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "电脑单号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"style" : "width:22.5%"
			}, {
				"label": "单据类型：",
				"name": "billmoduleid",
				"type": "ComboBox",
				"defaultValue": app.modulecode,
				dictkey: 'BILLMODULEID',
				"readOnly": true,
				"style" : "width:22.5%",
			    "visible": false,
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
				"style" : "width:22.5%"
			}, {
				"label" : "销售日期：",
				"type" : "DatePicker",
				"name" : "rqsj",
				"format" : "yyyy-MM-dd",
				"required" : "true",
				"enabled" : true,
				"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"style" : "width:22.5%"
			}, {
				"label": "门店：",
				"name": "muid",
				"type": "fut_popselect",
				selectkey: "muid",
				textName: "muid_name",
				allowInput: true,
				"required" : true,
				beforefunc : "page.head_beforefunc_muid",
				itemchangedfunc:"page.head_itemchanged",
				"style" : "width:22.5%"
			}, {
				"label": "门店：",
				"name": "mkt",
				"type": "TextBox",
				visible: false
			}, {
				"label" : "收银机号：",
				"type" : "TextBox",
				"name" : "syjh",
				"enabled" : "true",
				"required" : "true",
				"onvaluechanged" : "page.head_valuechanged",
				"style" : "width:22.5%"
			}, {
				"label" : "收银员号：",
				"type" : "TextBox",
				"name" : "syyh",
				"enabled" : "true",
				"required" : "true",
				"onvaluechanged" : "page.head_valuechanged",
				"style" : "width:22.5%"
			}, {
				"label" : "缴款日期：",
				"type" : "DatePicker",
				"name" : "jkrq",
				"enabled" : "true",
				"format" : "yyyy-MM-dd",
				"defaultValue" : new Date(),
				"style" : "width:22.5%"
			}, {
				"label" : "现金：",
				"type" : "TextBox",
				"name" : "cashmoney",
				"enabled" : "true",
				"readOnly" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "支票：",
				"type" : "TextBox",
				"name" : "checkmoney",
				"enabled" : "true",
				"readOnly" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "MIS卡：",
				"type" : "TextBox",
				"name" : "ccardmoney",
				"enabled" : "true",
				"readOnly" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "IC卡：",
				"type" : "TextBox",
				"name" : "fcardmoney",
				"enabled" : "true",
				"readOnly" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "礼券：",
				"type" : "TextBox",
				"name" : "gcertmoney",
				"readOnly" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "赊销：",
				"type" : "TextBox",
				"name" : "oncdmoney",
				"readOnly" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "其他：",
				"type" : "TextBox",
				"name" : "opaymoney",
				"readOnly" : true,
				"style" : "width:22.5%"
			}, {
				"label" : "合计金额：",
				"type" : "TextBox",
				"name" : "jkje",
				"readOnly" : true,
				"style" : "width:22.5%"
			}, {
				"label": "备注：",
				"name": "memo",
				"type": "TextBox",
				"style": "width:90%",
			},{
				"label": "录入人：",
				"name" : "inputer_name",
				"type" : "TextBox",
				"readOnly" : true,
				"visible" : true,
				"defaultValue" : app.username
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
			}, {
				"label": "取消人：",
				"type": "TextBox",
				"name": "canceler_name",
				"readOnly": "true",
			}, {
				"label" : "录入日期：",
				"name" : "inputdate",
				"type" : "DatePicker",
				"readOnly" : true,
				"format" : "yyyy-MM-dd HH:mm:ss",
				"visible" : true,
				"defaultValue" : new Date()
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "取消日期：",
				"type": "DatePicker",
				"name": "canceldate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label" : "录入人编码：",
				"type" : "TextBox",
				"name" : "inputer",
				"visible" : false,
				"defaultValue" : app.usercode
			}
		]
	}
	// 单据明细
	bill.payindetail= {
			title: '单据明细',
			"type": "gridbox",
			name: 'payindetail',
			"properties": {
				"id": utils.createid('payindetail'),
				"multiSelect" : true,
				"allowCellEdit" : true,
				"allowCellSelect" : true,
				"editNextOnEnterKey" : true,
				"editNextRowCell" : true,
				"allowSortColumn" : false,
				"showColumnsMenu":true,
				"showSummaryRow":true,
				"oncellbeginedit": "OcmControl.checkboxEditor",
				"columns": [{
					type: "checkcolumn",
					name: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
					width: "40",
				}, {
					field: "rowno",
					header: "导入行号",
					visible: false,
				}, {
					type: "indexcolumn",
					name: "indexcolumn",
					header: "行号",
					headerAlign: "center",
					readOnly: true,
					width: "40",
				}, {
					field : "code",
					header : "缴款代码",
					headerAlign : "center",				    
				    width : 200,
				    readOnly: true,
				}, {
					field : "name",
					header : "名称",
					readOnly : true,
					width : 200,
				},  {
					field : "hl",
					header : "汇率",
					headerAlign : "center",				    
					visible: false,
				},  {
					field : "base",
					header : "缴款基数",
					headerAlign : "center",	
					readOnly: true
				}, {
					field : "zs",
					header : "张数",
					headerAlign : "center",	
					align : "right",
					width : 150,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					defaultValue : "0",
					align : "right",
					readOnly: false,
					required : true,
				}, {
					field : "je",
					header : "金额",
					headerAlign : "center",	
					align : "right",
					width : 150,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					readOnly: false,
					required : true,
				}, {
					field : "mkt",
					header : "门店",
					headerAlign : "center",	
					visible: false,
				}, {
					field : "pmtype",
					header : "支付类型",
					headerAlign : "center",	
					visible: false,
				} ]
			},
		};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData,
			btn.separator,btn.auditData, btn.cancelData, btn.separator, btn.searchData
		]
	}

	// 单据配置
	bill.billconfig = {
		billhead: bill.payinhead, // 单据主表
		billdetail: [bill.payindetail], // 单据明细表
		billquerylist: bill.payinlist, // 查询列表
		dettabpages: [bill.payindetail], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}
	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
