/**
 * 
 */
(function () {
    // 命名空间
    /** @namespace Future.payin.out */
    var ns = Future.ns('payin.out');
    var utils = Future.ns('utils');
    var validate = Future.ns('validate');
    var billtype =utils.billtype;
    
    var Payin = function () {
    	Payin.superclass.constructor.call(this);
        this.servicekey = 'mss';
        this.ibcanadddet = false;
        this.head_beforefunc_muid = this.head_beforefunc_muid.bind(this);
        this.head_valuechanged = this.head_valuechanged.bind(this);
        this.head_itemchanged = this.head_itemchanged.bind(this);
    }
    ns.Payin = Payin;
    Future.extend(ns.Payin, Future.pub.Basebill, {
    	_initview: function () {
    		Payin.superclass._initview.call(this);
        },
        initevent : function() {
        	Payin.superclass.initevent.call(this);
        	this.billhead.tabsToolbar.btns["addRow"].setVisible(false);
			this.payindetail.on('cellcommitedit', this.detcellcommitedit, this);
			this.payindetail.on('cellbeginedit', this.oncellbeginedit, this);
		},
        head_beforefunc_muid : function(e) {
        	if (this.payindetail.data.length > 0) {
                mini.alert("明细已存在数据,请先删除！");
                return -1;
              }
			return 1;
		},
		//判断收银机+收银员正确性
		head_valuechanged: function (e, data) {
            var colname = e.sender.name;
            var mkt  = this.billhead.form.getField("mkt").getValue();
            var temp;
            var searchParam = {
      				 "queryid":colname == 'syjh'?"select_skth" :"select_syyh",
      				 "mkt" : mkt,
      				 "syjh" : e.value
      			 };
      		 itemLoader.doRequest(OmdUrl.mss, "mss.work.report.query",searchParam, null, null, 
      				 function(data) {
      			 temp  = data.report ;
      		 },null,null,false);
      		 if (temp.length == 0) {
      			 var text = e.sender.label;
      			text = text.substring(0,text.length-1);
      			this.billhead.setValue(colname, "")
      			mini.alert("输入的"+text+"不存在，请检查！");
      			return -1;
			}
            return 1;
        },
		head_itemchanged: function(e,data) {
			this.billhead.setValue('syjh', "");
			this.billhead.setValue('syyh', "");
			this.billhead.setValue('mkt', data[0].mucode);
			var that = this;
			var searchParam = {
      				 "queryid":"select_payinmode" ,
      				 "mkt" : data[0].mucode,
      			 };
      		 itemLoader.doRequest(OmdUrl.mss, "mss.work.report.query",searchParam, null, null, 
      				 function(data) {
      			 var _data  = data.report;
      			 if (_data.length > 0) {
      				for (var i = 0; i < _data.length; i++) {
      					var row = {
      							rowno : _data[i].rowno,
      							code : _data[i].code,
      							name : _data[i].name,
      							hl : "1", zs:"1", je:"0",
      							mkt : _data[i].mkt,
      							pmtype : _data[i].pmtype,
      							base : _data[i].base
      					}
      					that.payindetail.addNewRow(row);
					}
				} else {
					mini.alert("当前门店没有缴款模版，请检查！");
				}
      		 },null,null,false);
	        return 1;
		},
		detcellcommitedit : function(e) {
			if (e.field == 'je'){
				this.getCommitedit(e.row.pmtype,accSub(e.value,e.oldValue),"1")
			}
			if (e.field == 'zs') {
				if (e.value < 0) {
					e.value = e.oldValue;
					mini.alert("张数不能小于0，请检查！");
					return;
				}
				if(e.value && e.row.base){
					if (e.row.base != '0') {
						var oldje = e.row.je;
						e.row.je = Math.round(e.value * e.row.base * 100) / 100;
						this.getCommitedit(e.row.pmtype,accSub(e.row.je,oldje),"1")
					}
				}
			}
		},
		delTabsGridRowBefore: function (e) {
			 var row = this.payindetail.getSelecteds();
			 for (var i = 0; i < row.length; i++) {
				 this.getCommitedit(row[i].pmtype,row[i].je,"2")
			}
			 return 0;
		},
        initcontrol: function () {
        	Payin.superclass.initcontrol.call(this);
        },
        checkValidate: function () {
            var isValid = Payin.superclass.checkValidate.call(this);
            if (isValid == false) {
                return isValid;
            }
            return true;
        },
        getCommitedit : function(type,value,dat){
        	var jkje  = this.billhead.form.getField("jkje").getValue();
			jkje = dat=='1'? accAdd(jkje ,value):accSub(jkje ,value) ;
			this.billhead.setValue('jkje', jkje);
			switch(type){
			case "1":
				var cashmoney  = this.billhead.form.getField("cashmoney").getValue();
				cashmoney = dat=='1'?accAdd(cashmoney ,value):accSub(cashmoney ,value) ;
				this.billhead.setValue('cashmoney', cashmoney);
			  break;
			case "2":
				var checkmoney  = this.billhead.form.getField("checkmoney").getValue();
				checkmoney = dat=='1'?accAdd(checkmoney ,value):accSub(checkmoney ,value);
				this.billhead.setValue('checkmoney', checkmoney);
				break;
			case "3":
				var ccardmoney  = this.billhead.form.getField("ccardmoney").getValue();
				ccardmoney = dat=='1'?accAdd(ccardmoney  ,value):accSub(ccardmoney  ,value);
				this.billhead.setValue('ccardmoney', ccardmoney);
				break;
			case "4":
				var fcardmoney  = this.billhead.form.getField("fcardmoney").getValue();
				fcardmoney = dat=='1'?accAdd(fcardmoney,value):accSub(fcardmoney,value);
				this.billhead.setValue('fcardmoney', fcardmoney);
				break;
			case "5":
				var gcertmoney  = this.billhead.form.getField("gcertmoney").getValue();
				gcertmoney = dat=='1'?accAdd(gcertmoney,value):accSub(gcertmoney,value);
				this.billhead.setValue('gcertmoney', gcertmoney);
				break;
			case "6":
				var oncdmoney  = this.billhead.form.getField("oncdmoney").getValue();
				oncdmoney = dat=='1'?accAdd(oncdmoney,value):accSub(oncdmoney,value) ;
				this.billhead.setValue('oncdmoney', oncdmoney);
				break;
			default:
				var opaymoney  = this.billhead.form.getField("opaymoney").getValue();
				opaymoney = dat=='1'?accAdd(opaymoney,value):accSub(opaymoney,value);
				this.billhead.setValue('opaymoney', opaymoney); 
			}
   	},
    oncellbeginedit : function(e) {
		var record = e.record;
		var field = e.field;
		if (field == "je" ){
			if(record.base != undefined || record.base != "" ){
				if (record.base > "0") {
					e.cancel = true;
				} else {
					e.cancel = false;
				}
			} 
		}
		/*if (field == "zs" ){
			if(record.base != undefined || record.base != "" ){
				if (record.base > "0") {
					e.cancel = false;
				} else {
					e.cancel = true;
				}
			} 
		}*/
    }
    });
})()
