/**
 * 页面定义
 */
(function () {
    // 要引用的包
    var utils = Future.ns('Future.utils');
    var validate = Future.ns('Future.validate');
    var col = Future.ns('default.col');
    // 活动命名空间
    var ns = Future.ns('recdelay.view');
    // 定义一个对象用来配置界面
    var bill = {};
    var moduleid = app.modulecode;
    var billtype = getBilltype(moduleid);
    // 把定义对象放到命名空间下
    ns.bill = bill;
    utils.billtype = billtype;
    // 查询列表
    bill.recdelaylist = {
        "type": "gridbox",
        "resources": OmdUrl.settle,
        "method": "mall.settle.recdelayhead.search",
        "response": "recdelayhead",
        "bindform": "layouttabs",
        "bindSearchParam": ["ph_key"], // 明细页面查询条件字段
        "searchParam": {
            "billtype": billtype,
            "order_field": "billno",
            "order_direction": "desc",
        },
        "properties": {
            "id": utils.createid('recdelaylist'),
            "columns": [{
                type: "indexcolumn",
                headerAlign: "center",
                header: "行号",
                width: 60,
            }, {
                field: "billno",
                type: "TextBox",
                headerAlign: "center",
                header: "单据编号",
                width: 150,
            }, {
                field: "billsgno",
                type: "TextBox",
                headerAlign: "center",
                header: "手工编号",
                width: 150,
            }, {
                field: "billstatus",
                type: "TextBox",
                headerAlign: "center",
                header: "单据状态",
                renderer: "OcmControl.dictRendererWithCode",
                dictkey: 'SYSTEM_BILLSTATUS',
            }, {
                field: "muid",
                displayField: "muid_name",
                type: "TextBox",
                headerAlign: "center",
                header: "门店",
                editor: OcmControl.newControl('fut_popselectgrid'),
                cdEdtCfg: {compnentType: 'fut_popselect', selectkey: "muid"},
                visible: false,
                enabledSearch: true,
            }, {
                field: "muid_name",
                type: "TextBox",
                headerAlign: "center",
                header: "门店",
                enabledSearch: false,
                width: 180,
            }, {
                field: "rhmemo",
                type: "TextBox",
                headerAlign: "center",
                header: "备注",
                width: 260,
            }, {
                field: "inputer_name",
                header: "录入人",
                width: 150,
                allowSort: true,
                headerAlign: "center",
                enabledSearch: false,
            }, {
                field: "inputer",
                header: "录入人",
                width: 100,
                allowSort: true,
                headerAlign: "center",
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "inputer_name",
                cdEdtCfg: {compnentType: 'fut_popselect', selectkey: "user"},
                visible: false,
                enabledSearch: true,
            }, {
                field: "inputdate",
                type: "date",
                dataType: "date",
                format: "yyyy-MM-dd",
                header: "录入日期",
                width: 150,
                allowSort: true,
                headerAlign: "center",
                align: "center",
            }, {
                field: "auditor",
                header: "审核人",
                width: 150,
                allowSort: true,
                headerAlign: "center",
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "auditor_name",
                cdEdtCfg: {compnentType: 'fut_popselect', selectkey: "user"},
                visible: false,
                enabledSearch: true,
            }, {
                field: "auditor_name",
                header: "审核人",
                width: 150,
                allowSort: true,
                headerAlign: "center",
                enabledSearch: false,
            }, {
                field: "auditdate",
                type: "date",
                format: "yyyy-MM-dd",
                header: "审核日期",
                width: 150,
                dataType: "date",
                allowSort: true,
                headerAlign: "center",
                align: "center",
            }, {
                field: "canceler",
                header: "取消人",
                width: 150,
                allowSort: true,
                headerAlign: "center",
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "canceler_name",
                cdEdtCfg: {compnentType: 'fut_popselect', selectkey: "user"},
                visible: false,
                enabledSearch: false,
            }, {
                field: "canceler_name",
                header: "取消人",
                width: 150,
                allowSort: true,
                headerAlign: "center",
                visible: false,
                enabledSearch: false,
            }, {
                field: "canceldate",
                type: "date",
                format: "yyyy-MM-dd",
                header: "取消日期",
                width: 150,
                dataType: "date",
                allowSort: true,
                headerAlign: "center",
                align: "center",
                visible: false,
                enabledSearch: false,
            }]
        }
    };

    // 单据主表
    bill.recdelayhead = {
        "type": "formgrid",
        "initHeight": 0.3,
        "resources": OmdUrl.settle,
        "name": 'recdelayhead',
        "method": "mall.settle.recdelayhead.get",
        "response": "recdelayhead",
        "properties": {
            "id": utils.createid('recdelayhead')
        },
        items: [{
            "label": "ph_key：",
            "name": "ph_key",
            "type": "TextBox",
            "visible": false,
        }, {
            "label": "单据编号：",
            "name": "billno",
            "type": "TextBox",
            "readOnly": true,
        }, {
            "label": "模块编号：",
            "name": "billmoduleid",
            "type": "TextBox",
            "defaultValue": moduleid,
            "visible": false
        }, {
            "label": "单据类型：",
            "name": "billtype",
            "type": "TextBox",
            "defaultValue": billtype,
            "visible": false
        }, {
            "label": "单据状态：",
            "name": "billstatus",
            "type": "ComboBox",
            dictkey: 'SYSTEM_BILLSTATUS',
            "readOnly": true,
            "defaultValue": "N",
            "style": "display:block;float:none"
        }, {
            "label": "手工编号：",
            "name": "billsgno",
            "type": "TextBox",
        }, {
            "label": "门店：",
            "name": "muid",
            "type": "fut_popselect",
            "required": "true",
            selectkey: "muid",
            textName: "muid_name",
            allowInput: true,
            beforefunc: "page.head_beforefunc_muid",
            "style": "display:block;float:none",
        }, {
            "label": "门店：",
            "name": "muid_name",
            "type": "TextBox",
            readOnly: true,
            visible: false,
        }, {
            "label": "备注：",
            "name": "rhmemo",
            "type": "TextBox",
            "style": "width:60%;display:block;float:none",
        }, {
            "label": "录入人：",
            "name": "inputer_name",
            "type": "TextBox",
            "readOnly": true,
            "visible": true,
            "defaultValue": app.username,
        }, {
            "label": "审核人：",
            "type": "TextBox",
            "name": "auditor_name",
            "readOnly": "true",
            "visible": false,
            "style": "display:block;float:none",
        }, {
            "label": "取消人：",
            "type": "TextBox",
            "name": "canceler_name",
            "readOnly": "true",
            "visible": false,
            //"style" : "display:block;float:none",
        }, {
            "label": "录入日期：",
            "name": "inputdate",
            "type": "DatePicker",
            "readOnly": true,
            "format": "yyyy-MM-dd HH:mm:ss",
            "visible": true,
            "defaultValue": new Date()
        }, {
            "label": "审核日期：",
            "type": "DatePicker",
            "name": "auditdate",
            "format": "yyyy-MM-dd HH:mm:ss",
            "readOnly": "true",
        }, {
            "label": "取消日期：",
            "type": "DatePicker",
            "name": "canceldate",
            "format": "yyyy-MM-dd HH:mm:ss",
            "readOnly": "true",
            "visible": false,
            enabledSearch: false,
        }, {
            "label": "录入人编码：",
            "type": "TextBox",
            "name": "inputer",
            "visible": false,
            "defaultValue": app.usercode
        }
        ]
    }
    // 单据明细
    bill.recdelaydetail = {
        title: '单据明细',
        "type": "gridbox",
        name: 'recdelaydetail',
        "properties": {
            "id": utils.createid('recdelaydetail'),
            "multiSelect": true,
            "allowCellEdit": true,
            "allowCellSelect": true,
            "editNextOnEnterKey": true,
            "editNextRowCell": true,
            "allowSortColumn": false,
            "showColumnsMenu": true,
            "showSummaryRow": true,
            "oncellbeginedit": "OcmControl.checkboxEditor",
            "oncellendedit": 'OcmControl.datetimeFormate',
            "ondrawsummarycell": onDrawSummaryCell,
            "columns": [{
                type: "checkcolumn",
                name: "checkcolumn",
                headerAlign: "center",
                readOnly: true,
                width: "40",
            }, {
                field: "rdrowno",
                header: "导入行号",
                visible: false,
            }, {
                field: "sclseq",
                header: "序号",
                visible: false,
            }, {
                type: "indexcolumn",
                name: "indexcolumn",
                header: "行号",
                headerAlign: "center",
                readOnly: true,
                width: "40",
            }, {
                field: "sbid",
                type: "TextBox",
                headerAlign: "center",
                header: "商户编码",
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "sbid_name",
                cdEdtCfg: {compnentType: 'fut_popselect', selectkey: "sbid"},
                visible: false,
                readOnly: true,
            }, {
                field: "sbid_name",
                type: "TextBox",
                headerAlign: "center",
                header: "商户",
                readOnly: true,
                width: 180,
            }, {
                field: "contno",
                header: "合同编号",
                headerAlign: "center",
                width: 200,
                readOnly: true,
            }, {
                field: "jsbillno",
                header: "结算单号",
                headerAlign: "center",
                width: 200,
                readOnly: true,
            }, {
                field: "cccode_name",
                header: "费用项目",
                headerAlign: "center",
                width: 200,
                readOnly: true,
            }, {
                field: "cccode",
                header: "费用项目",
                headerAlign: "center",
                width: 200,
                readOnly: true,
                visible: false
            }, {
                field: "rdbegindate",
                editor: OcmControl.newControl('DatePicker'),
                dataType: "date",
                dateFormat: "yyyy-MM-dd",
                header: "开始计算日期",
                width: 150,
                allowSort: true,
                readOnly: true,
                headerAlign: "center",
                align: "center",
            }, {
                field: "rdenddate",
                editor: OcmControl.newControl('DatePicker'),
                dataType: "date",
                dateFormat: "yyyy-MM-dd",
                header: "最后计算日期",
                width: 150,
                allowSort: true,
                readOnly: true,
                headerAlign: "center",
                align: "center",
            }, {
                field: "rdoverrate",
                header: "滞纳金率",
                allowSort: false,
                headerAlign: "center",
                width: 100,
                numberFormat: "#0.00%",
                align: "right",
                readOnly: true,
                width: 80,
            }, {
                field: "rdye",
                header: "滞纳金金额",
                headerAlign: "center",
                align: "right",
                width: 150,
                editor: OcmControl.newControl('NumButtonEdit'),
                editorSet: {format: "n0",},
                numberFormat: "#0.00",
                defaultValue: "0.00",
                align: "right",
                readOnly: true,
            }, {
                field: "rdrecje",
                header: "已收金额",
                headerAlign: "center",
                align: "right",
                width: 150,
                editor: OcmControl.newControl('NumButtonEdit'),
                editorSet: {format: "n0",},
                numberFormat: "#0.00",
                defaultValue: "0.00",
                align: "right",
                readOnly: true,
            }, {
                field: "rdcanje",
                header: "应收余额",
                headerAlign: "center",
                align: "right",
                width: 150,
                editor: OcmControl.newControl('NumButtonEdit'),
                editorSet: {
                    onvaluechanged: "page.rdcanje_valuechanged",
                },
                numberFormat: "#0.00",
                defaultValue: "0.00",
                align: "right",
            }, {
                field: "rdbccanje",
                header: "调整金额",
                headerAlign: "center",
                align: "right",
                width: 150,
                editor: OcmControl.newControl('NumButtonEdit'),
                editorSet: {
                    onvaluechanged: "page.rdbccanje_valuechanged",
                },
                numberFormat: "#0.00",
                defaultValue: "0.00",
                align: "right",
                readOnly: false,
            }, {
                field: "rdmemo",
                header: "备注",
                headerAlign: "center",
            }]
        },
    };

    function onDrawSummaryCell(e) {
        var rows = e.data;
        var rdye = 0;
        var rdrecje = 0;
        var rdcanje = 0;
        var rdbccanje = 0;
        if (rows.length > 0) {
            for (var i = 0; i < rows.length; i++) {
                var row = rows[i];
                if (isNaN(row.rdye) == false) {
                    rdye += parseFloat(row.rdye);
                }
                if (isNaN(row.rdrecje) == false) {
                    rdrecje += parseFloat(row.rdrecje);
                }
                if (isNaN(row.rdcanje) == false) {
                    rdcanje += parseFloat(row.rdcanje);
                }
                if (isNaN(row.rdbccanje) == false) {
                    rdbccanje += parseFloat(row.rdbccanje);
                }
            }
        }

        if (e.field == "rdoverrate") {
            e.cellHtml = "<b>" + "合计: " + "</b>";
        }
        if (e.field == "rdye") {
            e.cellHtml = "<b>" + rdye.toFixed(2) + "</b>";
        }
        if (e.field == "rdrecje") {
            e.cellHtml = "<b>" + rdrecje.toFixed(2) + "</b>";
        }
        if (e.field == "rdcanje") {
            e.cellHtml = "<b>" + rdcanje.toFixed(2) + "</b>";
        }
        if (e.field == "rdbccanje") {
            e.cellHtml = "<b>" + rdbccanje.toFixed(2) + "</b>";
        }

        e.cellStyle = "text-align:right";
    }

    var reportconfig = getReportConfig(app.modulecode);
    var btn = Future.default.btn;
    // 按钮配置 - 固定名称
    bill.toolbarconfig = {
        id: utils.createid('systoolbar'),
        items: [btn.addData, btn.delData, btn.editData, btn.saveData,
            btn.separator, btn.auditData, btn.separator, btn.searchData, btn.separator, {
                'text': '上传附件',
                'iconCls': 'icon-upload',
                'name': 'uploadData',
                billstatus: 'N',
                ibediting: 'N',
                tabindex: '1'
            }, {
                'text': '下载附件',
                'iconCls': 'icon-search',
                'name': 'showPic',
                billstatus: 'N,Y',
                ibediting: 'N',
                tabindex: '1'
            }
        ]
    }
    if (reportconfig) {
        bill.toolbarconfig.items.push(btn.printData);
    }
    bill.reportconfig = reportconfig;

    // 单据配置
    bill.billconfig = {
        billhead: bill.recdelayhead, // 单据主表
        billdetail: [bill.recdelaydetail], // 单据明细表
        billquerylist: bill.recdelaylist, // 查询列表
        dettabpages: [bill.recdelaydetail], // 要放入明细TAB列表的组件
        defaultmoduleid: app.modulecode, // 默认单据类型
    }
    // 创建标准单据模板
    utils.create_standardbill_config(bill);
})()