/**
 * 
 */
(function () {
    // 命名空间
    /** @namespace Future.recdelay.out */
    var ns = Future.ns('recdelay.out');
    var utils = Future.ns('utils');
    var validate = Future.ns('validate');
    var billtype =utils.billtype;
    
    var Recdelay = function () {
    	Recdelay.superclass.constructor.call(this);
        this.servicekey = 'mss';
        this.head_beforefunc_muid = this.head_beforefunc_muid.bind(this);
        this.rdbccanje_valuechanged = this.rdbccanje_valuechanged.bind(this);
        this.rdcanje_valuechanged = this.rdcanje_valuechanged.bind(this);
        this.printData = this.printData.bind(this);
    }
    ns.Recdelay = Recdelay;
    Future.extend(ns.Recdelay, Future.pub.Basebill, {
    	_initview: function () {
    		Recdelay.superclass._initview.call(this);
        },
        initevent : function() {
        	Recdelay.superclass.initevent.call(this);
		},
        head_beforefunc_muid : function(e) {
        	if (this.recdelaydetail.data.length > 0) {
                mini.alert("明细已存在数据,请先删除！");
                return -1;
              }
			return 1;
		},
		rdbccanje_valuechanged : function(e){
        	var row = this.recdelaydetail.getSelected();
        	var rdbccanje = e.value;
        	row.rdcanje = Math.round((parseFloat(row.rdye) - parseFloat(row.rdrecje) + parseFloat(rdbccanje)) * 100) / 100;
        },
        rdcanje_valuechanged : function(e){
        	var row = this.recdelaydetail.getSelected();
        	var rdcanje = e.value;
        	row.rdbccanje = Math.round((parseFloat(rdcanje) - parseFloat(row.rdye) + parseFloat(row.rdrecje)) * 100) / 100;
        },
        saveDataBefore:function(){
        	//保存前判断
        	if (this.recdelaydetail.data.length < 1) {
				mini.alert("不允许空单，明细表必须有数据!");
				return ;
			}else{
				var detData = this.recdelaydetail.getData();
				for(var i = 0;i < detData.length;i++){
					var rdbccanje = detData[i].rdbccanje;
					if (rdbccanje == null || rdbccanje == ""){
						mini.alert("第"+(i+1)+"行调整金额为空，请检查");
						return ;
					}
					return 1;
				}
			}
        },
      //上传附件
        uploadData : function(e){
         	var billno = this.recdelayhead.form.getField('billno').value;
         	var billmoduleid  = app.modulecode;
         	Future.Pub.addfile(billno,billmoduleid,function(data){
         		if (data.returncode == "0"){
         			mini.alert("上传成功！");
         		}
         	});
         },
         //下载附件
         showPic : function(e){
         	var billno=this.recdelayhead.form.getField('billno').value;
         	if (billno == ""){
         		mini.alert("请先选择单据编号！");
         	}else{
         		var billmoduleid  = app.modulecode;
         		var searchParam ={
         		    	  billno : billno,
         				  billmoduleid :billmoduleid,
         			  };
         	    var method = "serverutils.getEnclosure";
         	    itemLoader.doRequest(OmdUrl.mss, method, searchParam, null, null, function (data) {
         	  	   if(data.length == "0"){
         	  		   mini.alert("没有上传附件！");
         	  		   return;
         	  	   }
         	  	   else {
         	  		 Future.Pub.viewfile(billno,billmoduleid);
         	  	   }
         	    },null, null, false);
         	}
         },
		delTabsGridRowBefore: function (e) {
			 return 0;
		},
		addTabsGridRowBefore : function() {
        	var muid = this.recdelayhead.form.getField('muid').value;
        	var that = this;
        	if (muid == undefined || muid == "") {
				mini.alert("请先选择门店");
				return;
			}
        	if (this.recdelaydetail.data.length > 0) {
                mini.alert("明细已存在数据,请先删除！");
                return;
              }
        	var renderData=[];
        	renderData.muid = muid;
			var _url = "/mall-business-ui/pages/settleup/suprecdelay-view.jsp?token=" +	getUrlParam("token");
			if (app.srvkey && app.srvkey != "")	{
				_url = _url + "&srvkey="+ app.srvkey;
			}
        	mini.open({
        		url : encodeURI(_url),
    			title : "费用列表",
    			width : $(window).width()*0.9,
    			height : $(window).height()*0.9,
    			onload : function() {
    				var iframe = this.getIFrameEl();
					var data = {
						muid : muid
					};
					iframe.contentWindow.SetData(data);
    			},
    			ondestroy : function(data) {
    				if(data != "close"){
                		if(data.length > 0){
                			that.recdelaydetail.removeRows(that.recdelaydetail.getData());
                			for (var i = 0; i < data.length; i++) {
                				data[i].rdrowno = i+1;
                				that.recdelaydetail.addNewRow(data[i]);
							}
                		}
                	}
    			}
    		});
		},
        initcontrol: function () {
        	Recdelay.superclass.initcontrol.call(this);
        },
        checkValidate: function () {
            var isValid = Recdelay.superclass.checkValidate.call(this);
            if (isValid == false) {
                return isValid;
            }
            return true;
        },
        printData : function(){
    		var billno = mini.getbyName('billno').getValue();
    		var billstatus = mini.getbyName('billstatus').getValue();
    		if (billstatus != 'Y') {
    			mini.alert("单据未审核，不能打印！");
    			return;
    		} 
    	    var userid= getUrlParam("userid");
    	    var postid= getUrlParam("postid");
		    var url = this.viewconfig.reportconfig + "&__masterpage=true&__showtitle=false&__format=html&__page=1";	
		    var paramurl = "";
			var key = "billno";
				paramurl += "&" + key + "=" + billno;
				paramurl += "&" + "__userid" + "=" + userid;
				paramurl += "&" + "__postid" + "=" + postid;
				paramurl += "&__accesstime=" + new Date().getTime();
			url = encodeURI(url + paramurl);
			var mainframe  = document.getElementById("mainframe");
			mainframe.src = url;
			var delayPanel = mini.get("delayPanel");
			delayPanel.show();
    	}
    });
})()