<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>付款申请单</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-layout" config="config1" borderStyle="border:0px;"
		style="width: 100%; height: 100%;"></div>

	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script src="/mall-business-ui/pages/common/queryconfig.js"
		type="text/javascript"></script>
	<script type="text/javascript">
		var billmoduleid = getUrlParam("billmoduleid");
		if (billmoduleid == "" || billmoduleid == null) {
			billmoduleid = getUrlParam("modulecode");
		}
		var dicData = OcmControl.getDict("BILLMODULEID,BILLFLAG,PAYMODE,BILLSTATUS,BILLTYPE,WMID")
		var billtype = getBilltype(billmoduleid);

		var searchParam = {
			queryid : "select_company",
			order_field : "cocode"
		};
		itemLoader.doRequest(OmdUrl.mall, "mss.work.report.query", searchParam,
				null, null, function(data) {
				dicData.MANATYPE = data.report;
				}, null, null, false);

		// 页面布局配置
		var toolbar1 = {
			rule : { // 按钮可用规则 Y:已审核, N:录入, C:已取消 ,S:提交
				'billstatus' : {
					'Y' : [ 'addData', 'searchData', 'printData', 'cancelData',
							'invalid', 'upTemplate', 'downTemplate', 'pay' ],
					'N' : [ 'addData', 'editData', 'auditData', 'delData',
							'copyData', 'searchData', 'printData',
							'cancelData', 'firstData', 'billImport',
							'recallData', 'upTemplate', 'downTemplate' ],
					'C' : [ 'addData', 'copyData', 'searchData', 'printData',
							'upTemplate', 'downTemplate' ],
					'S' : [ 'addData', 'searchData', 'firstData', 'fallData',
							'upTemplate', 'downTemplate' ],
					'Q' : [ 'addData', 'searchData', 'upTemplate',
							'downTemplate' ],
					'D' : [ 'addData', 'searchData', 'upTemplate',
							'downTemplate' ],
					'A' : [ 'addData', 'editData', 'searchData', 'recallData',
							'auditData', 'upTemplate', 'downTemplate' ],
				}
			},
			status : { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
				'N' : [ 'addData', 'saveData', 'searchData', 'addPhoto',
						'upPhoto', 'searchPhoto', 'delPhoto', 'checkPhoto',
						'upTemplate', 'downTemplate' ],
				'V' : [ 'addData', 'editData', 'auditData', 'delData',
						'copyData', 'searchData', 'printData', 'upTemplate',
						'downTemplate' ],
				'E' : [ 'addData', 'saveData', 'delData', 'copyData',
						'searchData', 'printData', 'addPhoto', 'billImport',
						'searchPhoto', 'delPhoto', 'checkPhoto', 'upTemplate',
						'downTemplate' ],
				'S' : [ 'addData', 'editData', 'auditData', 'delData',
						'copyData', 'searchData', 'printData', 'upTemplate',
						'downTemplate' ],
				'A' : [ 'addData', 'cancelData', 'copyData', 'searchData',
						'printData', 'export', 'upTemplate', 'downTemplate',
						'pay' ],
				'C' : [ 'addData', 'copyData', 'searchData', 'printData',
						'export', 'upTemplate', 'invalid', 'downTemplate' ],
				'D' : [ 'addData', 'searchData', 'billImport', 'upTemplate',
						'downTemplate' ],
			},
			items : [ [ {
				'text' : '新增',
				'iconCls' : 'icon-add',
				'name' : 'addData'
			}, {
				'text' : '修改',
				'iconCls' : 'icon-edit',
				'name' : 'editData'
			}, {
				'text' : '保存',
				'iconCls' : 'icon-save',
				'name' : 'saveData'
			} ], [ {
				'text' : '审核',
				'iconCls' : 'icon-ok',
				'name' : 'auditData'
			}, ], [ {
				'text' : '删除',
				'iconCls' : 'icon-remove',
				'name' : 'delData'
			}, {
				'text' : '查询',
				'iconCls' : 'icon-search',
				'name' : 'searchData'
			} ] ]
		};

		//单据列表
		var gridbox2 = {
			"type" : "gridbox",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.rentalpaymentapply.search",
			"response" : "rentalpaymentapplyhead",
			"bindform" : "tabs1", // 绑定切换的TabsBox.name
			"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段 
			"searchParam" : {
				"billtype" : billtype,
				"order_field" : "billno",
				"order_direction" : "desc",
			},
			"properties" : {
				"id" : "rentalpaymentapplyhead",
				"columns" : [ {
					type : "indexcolumn",
					headerAlign : "center",
					header : "行号",
					width : 70,
				}, {
					field : "billno",
					headerAlign : "center",
					header : "单据编号",
					allowSort : true,
					width : 140,
				}, {
					field : "billtype",
					type : "TextBox",
					headerAlign : "center",
					header : "单据类型",
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.BILLTYPE,
					width : 140,
					visible : false,
				}, {
					field : "billstatus",
					headerAlign : "center",
					header : "单据状态",
					width : 95,
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.BILLSTATUS,
				}, {
					field : "muid",
					displayField : "muid_name",
					header : "门店",
					headerAlign : "center",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "muid",
						textName : "muid_name",
						responseName : "muid"
					},
					readOnly : true,
					width : 200,
					visible : false,
				}, {
					field : "contno",
					header : "合同",
					headerAlign : "center",
					width : 120,
					visible : false,
				},{
					field : "rentalpaymentapplydet:wmid",
					header : "经营方式",
					allowSort : true,
					headerAlign : "center",
					width : 100,
					renderer : "OcmControl.dictRendererWithCode",
					visible : false,
					data : dicData.WMID,
					enabledSearch : true,
				},{
					field : "manatype",
					headerAlign : "center",
					header : "经营主体",
					width : 150,
					allowSort : true,
					renderer : "OcmControl.dictRendererWithCode",
					data : dicData.MANATYPE,
				}, {
					field : "sbid",
					type : "TextBox",
					headerAlign : "center",
					header : "商户",
					editor : OcmControl.newControl('fut_popselectgrid'),
					displayField : "sbid_name",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "sbid"
					},
					visible : true,
					enabledSearch : true,
					width : 200,

				}, {
					field : "rentalpaymentapplydet:spid",
					type : "TextBox",
					headerAlign : "center",
					header : "商铺",
					editor : OcmControl.newControl('fut_popselectgrid'),
					displayField : "spid_name",
					cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "spid"
					},
					visible : false,
					enabledSearch : true,
					width : 200,

				},{
					field : "thisamount",
					headerAlign : "center",
					header : "本次付款",
					width : 130,
					numberFormat : "c2",
					"defaultValue" : "0",
					visible : false,
				}, {
					field : "plusthisamount",
					headerAlign : "center",
					header : "本次付款",
					width : 150,
					numberFormat : "c2",
					"defaultValue" : "0",
					readOnly : true,
				}, {
					field : "supsetpaybillno",
					headerAlign : "center",
					header : "付款单号",
					allowSort : true,
					width : 140,
				}, {
					field : "memo",
					headerAlign : "center",
					header : "备注",
					width : 160,
				}, {
					field : "inputer_name",
					headerAlign : "center",
					header : "录入人",
					width : 140,
					allowSort : true,
				}, {
					field : "inputdate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd HH:mm:ss",
					header : "录入日期",
					width : 140,
					allowSort : true,
				}, {
					field : "auditor_name",
					headerAlign : "center",
					header : "审核人",
					width : 140,
					allowSort : true,
				}, {
					field : "auditdate",
					dataType : "date",
					dateFormat : "yyyy-MM-dd HH:mm:ss",
					header : "审核日期",
					width : 140,
					allowSort : true,
				} ],
			},
		};

		//单据头
		var formheader1 = {
			"type" : "formgrid",
			"resources" : OmdUrl.mss,
			"method" : "mss.work.rentalpaymentapply.get",
			"response" : "rentalpaymentapplyhead",
			"properties" : {
				"id" : "rentalpaymentapplyhead",
			},
			items : [ {
				"label" : "ph_key：",
				"type" : "TextBox",
				"name" : "ph_key",
				"readOnly" : "true",
				"visible" : false,
			}, {
				"label" : "单据编号：",
				"id" : "billno",
				"name" : "billno",
				"type" : "TextBox",
				"readOnly" : true,
			}, {
				"label" : "单据类别：",
				"name" : "billmoduleid",
				"type" : "ComboBox",
				"data" : dicData.BILLMODULEID,
				"defaultValue" : billmoduleid,
				"readOnly" : true,
				"visible" : false,
			}, {
				"label" : "单据状态：",
				"name" : "billstatus",
				"type" : "ComboBox",
				"data" : dicData.BILLSTATUS,
				"defaultValue" : "N",
				"readOnly" : true,
			}, {
				"label" : "单据类别：",
				"name" : "billtype",
				"type" : "ComboBox",
				"data" : dicData.BILLTYPE,
				"defaultValue" : billtype,
				"visible" : false,
			}, {
				"label" : "门店：",
				"name" : "muid",
				"required" : "true",
				"defaultValue" : "",
				type : "fut_popselect",//类型
				selectkey : "muid",//弹框类型
				textName : "muid_name", //文本显示字段
				"enabled" : true,
				"visible" : false,
			}, {
				"label" : "商户：",
				"name" : "sbid",
				"required" : "true",
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey : "sbid",
				textName : "sbid_name",
				beforefunc : "head_beforefunc",
				itemchangedfunc : "head_itemchanged_sbid",
				allowSort : true,
			}, {
				"label" : "合同：",
				"name" : "contno",
				"required" : "true",
				"defaultValue" : "",
				type : "fut_popselect",
				selectkey : "contno",
				textName : "contno",
				allowSort : true,
				"visible" : false,
			}, {
				"label" : "经营主体：",
				"name" : "manatype",
				"type" : "ComboBox",
				"required" : true,
				"enabled" : true,
				"data" : dicData.MANATYPE,
				"defaultValue" : '0',
				"valueField" : "cocode",
				"textField" : "coname",
				"onValuechanged":"onManatypeChange",
			}, {
				"label" : "商场开户银行：",
				"name" : "jvbank",
				"type" : "TextBox",
				"defaultValue" : "",
				"readOnly" : true,
				"visible" : false,
			}, {
				"label" : "商场银行账号：",
				"name" : "jvaccount",
				"type" : "TextBox",
				"defaultValue" : "",
				"readOnly" : true,
				"visible" : false,
			}, {
				"label" : "商场税号：",
				"name" : "taxno",
				"type" : "TextBox",
				"readOnly" : true,
				"visible" : false,
			}, {
				"label" : "商户开户银行：",
				"name" : "shbank",
				"type" : "TextBox",
				"defaultValue" : "",
				"readOnly" : false,
				"visible" : false,
			}, {
				"label" : "商户银行账号：",
				"name" : "shaccount",
				"type" : "TextBox",
				"defaultValue" : "",
				"readOnly" : false,
				"visible" : false,
			}, {
				"label" : "商户税号：",
				"name" : "shtaxno",
				"type" : "TextBox",
				"visible" : false,
			}, {
				"label" : "本次付款：",
				"name" : "thisamount",
				"type" : "NumButtonEdit",
				"defaultValue" : "0",
				"format" : "n2",
				"enabled" : true,
				"readOnly" : true,
				"visible" : false,
				"align" : "right",
			}, {
				"label" : "本次付款：",
				"name" : "plusthisamount",
				"type" : "NumButtonEdit",
				"defaultValue" : "0",
				"format" : "n2",
				"enabled" : true,
				"readOnly" : true,
				"align" : "right",
			}, {
				"label" : "大写金额：",
				"name" : "capitalamount",
				"type" : "TextBox",
				"defaultValue" : "",
				"enabled" : true,
				"readOnly" : true,
			}, {
				"label" : "实际付款日期：",
				"name" : "actualdate",
				"type" : "DatePicker",
				"format" : "yyyy-MM-dd",
				"visible" : false,
			}, {
				"label" : "付款方式：",
				"name" : "payment",
				"type" : "ComboBox",
				"data" : dicData.PAYMODE,
				"enabled" : true,
				"renderer" : "OcmControl.dictRendererWithCode",
				"visible" : false,
			}, {
				"label" : "备注：",
				"name" : "memo",
				"type" : "TextBox",
				"defaultValue" : "",
				"style" : "width:60%",
			}, {
				"label" : "生成付款单号：",
				"name" : "supsetpaybillno",
				"type" : "TextBox",
				"readOnly" : true,
			}, {
				"label" : "录入人：",
				"name" : "inputer_name",
				"type" : "TextBox",
				"readOnly" : true,
			}, {
				"label" : "录入人",
				"name" : "inputer",
				"type" : "TextBox",
				"readOnly" : true,
				"visible" : false,
			}, {
				"label" : "审核人：",
				"name" : "auditor_name",
				"type" : "TextBox",
				"readOnly" : true,
				"style" : "display:block;float:none",
			}, {
				"label" : "取消人：",
				"name" : "canceler_name",
				"type" : "TextBox",
				"readOnly" : true,
				"visible" : false,
			}, {
				"label" : "录入日期：",
				"name" : "inputdate",
				"type" : "DatePicker",
				"readOnly" : true,
				"format" : "yyyy-MM-dd HH:mm:ss",
			}, {
				"label" : "审核日期：",
				"name" : "auditdate",
				"type" : "DatePicker",
				"readOnly" : true,
				"format" : "yyyy-MM-dd HH:mm:ss",
			}, {
				"label" : "取消日期：",
				"name" : "canceldate",
				"type" : "DatePicker",
				"readOnly" : true,
				"format" : "yyyy-MM-dd HH:mm:ss",
				"visible" : false,
			} ]
		};

		//条件grid
		var rentalpaymentapplydet = {
			"type" : "gridbox",
			"properties" : {
				"id" : "rentalpaymentapplydet",
				"multiSelect" : true,
				"allowCellEdit" : true,
				"allowCellSelect" : true,
				"editNextOnEnterKey" : true,
				"editNextRowCell" : true,
				"allowSortColumn" : false,
				"showColumnsMenu" : true,
				"showSummaryRow" : true,
				"ondrawsummarycell" : "onDrawSummaryCell",
				"oncellbeginedit" : "OcmControl.checkboxEditor",
				"oncellendedit" : 'OcmControl.datetimeFormate',
				"columns" : [ {
					"label" : "ph_key：",
					"type" : "TextBox",
					"name" : "ph_key",
					"readOnly" : "true",
					"visible" : false,
				}, {
					type : "checkcolumn",
					headerAlign : "center",
					readOnly : true,
				}, {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
					"readOnly" : true,
				}, {
					field : "pseq",
					header : "序号",
					headerAlign : "center",
					visible : false,
				}, {
					field : "prowno",
					header : "结算单行号",
					headerAlign : "center",
					visible : false,
				}, {
					field : "sclseq",
					header : "费用SCLSEQ",
					allowSort : true,
					headerAlign : "center",
					"readOnly" : true,
					width:60,
					visible : false,
				}, {
					field : "jsbillid",
					header : "结算单类型",
					headerAlign : "center",
					visible : false,
				}, {
					field : "jsbillno",
					header : " 结算单号",
					allowSort : true,
					headerAlign : "center",
					"readOnly" : true,
					width : 100,
				}, {
					field : "setrowno",
					header : " 结算月",
					allowSort : true,
					headerAlign : "center",
					"readOnly" : true,
					width:60,
					visible : false,
				}, {
					field : "muid_name",
					header : "门店",
					allowSort : true,
					headerAlign : "center",
					"readOnly" : true,
					width : 120,
				}, {
					field : "muid",
					header : "门店",
					allowSort : true,
					headerAlign : "center",
					"readOnly" : true,
					width : 100,
					visible : false,
				}, {
					field : "spid_name",
					header : "商铺",
					allowSort : true,
					headerAlign : "center",
					"readOnly" : true,
					width : 120,
				}, {
					field : "spid",
					header : "商铺",
					allowSort : true,
					headerAlign : "center",
					"readOnly" : true,
					width : 100,
					visible : false,
				}, {
					field : "sbid_name",
					header : "商户",
					allowSort : true,
					headerAlign : "center",
					"readOnly" : true,
					width : 100,
					visible : false,
				}, {
					field : "sbid",
					header : "商户",
					allowSort : true,
					headerAlign : "center",
					"readOnly" : true,
					width : 100,
					visible : false,
				}, {
					field : "contno",
					header : "合同",
					allowSort : true,
					headerAlign : "center",
					"readOnly" : true,
					width : 80,
				}, {
					field : "wmid_name",
					header : "经营方式",
					allowSort : true,
					headerAlign : "center",
					"readOnly" : true,
					width : 50,
					visible : false,
				}, {
					field : "wmid",
					headerAlign : "center",
					header : "经营方式",	
					width : 90,
					allowSort : true,
					renderer: "OcmControl.dictRendererWithCode",
				    data: dicData.WMID,
				    "readOnly" : true,
				},{
					field : "itemcode_name",
					header : "费用代码",
					allowSort : true,
					headerAlign : "center",
					"readOnly" : true,
					width : 80,
				}, {
					field : "itemcode",
					header : "费用代码",
					allowSort : true,
					headerAlign : "center",
					visible : false,
					width : 80,
				}, {
					field : "manatype",
					header : "经营主体",
					allowSort : true,
					headerAlign : "center",
					"readOnly" : true,
					width : 100,
					visible : false,
				}, {
					field : "stflag",
					header : "应付/应退标志",
					allowSort : true,
					headerAlign : "center",
					"readOnly" : true,
					width : 100,
					visible : false,
				}, {
					field : "startdate",
					header : "开始日期",
					allowSort : true,
					headerAlign : "center",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					"readOnly" : true,
					width : 80,
				}, {
					field : "enddate",
					header : "结束日期",
					allowSort : true,
					headerAlign : "center",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					"readOnly" : true,
					width : 80,
				}, {
					field : "jkr",
					header : "缴款日",
					allowSort : true,
					headerAlign : "center",
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					"readOnly" : true,
					width:80,
					visible : false,
				}, {
					field : "plusamount",
					header : "应付金额",
					width : 70,
					allowSort : true,
					headerAlign : "center",
					readOnly : true,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					align : "right",
				}, {
					field : "plusrecamount",
					header : "已付金额",
					width : 70,
					allowSort : true,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					"readOnly" : true,
					align : "right",
				}, {
					field : "plusbcpay",
					header : "本次付款",
					width : 70,
					allowSort : true,
					required : true,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					align : "right",
				}, {
					field : "amount",
					header : "应付金额",
					width : 70,
					allowSort : true,
					headerAlign : "center",
					readOnly : true,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					align : "right",
					visible : false,
				}, {
					field : "ckamount",
					header : "参考金额",
					width : 70,
					allowSort : true,
				  	headerAlign : "center",
				  	readOnly : true,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{
						format: "c2",
					},
					numberFormat:"c2",
				    align: "right",
				    visible : false,
				}, {
					field : "recamount",
					header : "已付金额",
					width : 70,
					allowSort : true,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					"readOnly" : true,
					align : "right",
					visible : false,
				}, {
					field : "bcpay",
					header : "本次付款",
					width : 70,
					allowSort : true,
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					align : "right",
					visible : false,
				}, {
					field : "calcamount",
					header : "滞纳金金额",
					width : 70,
					allowSort : true,
					headerAlign : "center",
					readOnly : true,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					align : "right",
					visible : false,
				}, {
					field : "delayamount",
					header : "调整后滞纳金金额",
					width : 70,
					allowSort : true,
					headerAlign : "center",
					readOnly : true,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "c2",
					},
					numberFormat : "c2",
					align : "right",
					visible : false,
				} ]
			}
		};

		//单据明细
		var tabs2 = {
			properties : {
				id : "tabs2",
			},
			items : [ {
				"title" : "单据明细",
				"name" : "rentalpaymentapplydet",
				"control" : rentalpaymentapplydet
			} ]
		};

		//单据明细组成：单据头+单据明细tab
		var details1 = {
			"type" : "formgrid",
			"initHeight" : 0.40,
			"resources" : OmdUrl.mss,
			"method" : "mss.work.rentalpaymentapply.get",
			"response" : "rentalpaymentapplyhead",
			"properties" : {
				"id" : "details1",
			},
			"items" : formheader1.items, //绑定到具体的项
			"tabs" : tabs2, //直接绑定tab

		};

		//单据列表和单据明细
		var tabs1 = {
			properties : {
				"id" : "tabs1"
			},
			items : [ {
				"title" : "单据列表",
				"name" : "ListGrid",
				"control" : gridbox2,
			}, {
				"title" : "单据明细",
				"name" : "details1",
				"control" : details1,
			} ]
		};

		var config1 = {
			"properties" : {
				"id" : "config1",
			},
			"toolbar" : toolbar1,
			"tabs" : tabs1,

		};
		function onDrawSummaryCell(e) {
			var rows = e.data;
			var plusamount = 0;
			var plusbcpay = 0;
			if (rows.length > 0) {
				for (var i = 0; i < rows.length; i++) {
					var row = rows[i];
					if (isNaN(row.amount) == false) {
						plusamount += parseFloat(row.plusamount);
					}
					if (isNaN(row.bcpay) == false) {
						plusbcpay += parseFloat(row.plusbcpay);
					}
				}
			}
			if (e.field == "startdate") {
				var str = "<b>" + "合计: " + "</b><br>";
				e.cellHtml = str;
				e.cellStyle = "text-align:right";
			}
			if (e.field == "plusamount") {
				var str = "<b>" + plusamount.toFixed(2) + "</b><br>";
				e.cellHtml = str;
				e.cellStyle = "text-align:right";
			}
			if (e.field == "plusbcpay") {
				var str = "<b>" + plusbcpay.toFixed(2) + "</b><br>";
				e.cellHtml = str;
				e.cellStyle = "text-align:right";
			}
			e.cellStyle = "text-align:right";
		}
	</script>
	<script src="rentalpaymentapplyform.js" type="text/javascript"></script>
</body>
</html>