/**
 *  页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('supcharge.view');

	// 定义一个对象用来配置界面
	var bill = {};
	app.modulecode='300116'; 
	var billtype=getBilltype(app.modulecode);
	
	// 把定义对象放到命名空间下
	ns.bill = bill;

	utils.billtype=billtype;
	//查询列表
	bill.supchargelist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.work.supchargehead.search",
		"response": "supchargehead",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段		
		"searchParam": {
			"billmoduleid" : app.modulecode,
			"order_field": "billno",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('supchargelist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 160,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
				width: 120,
			}, {
				field: "muid",
				displayField : "muid_name",
				headerAlign: "center",
				header: "门店",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "muid",
					textName : "muid_name",
					responseName : "muid"
				},
				width: 200,
			}, {
				field: "sbid",
				displayField : "sbid_name",
				headerAlign: "center",
				header: "商户",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "sbid",
					textName : "sbid_name",
					responseName : "sbid"
				},
				width: 200,
			}, {
				field: "contno",
				type: "TextBox",
				headerAlign: "center",
				header: "合同号",
				width: 160,
			}, {
				field : "memo",
				header : "备注",
				width : 120,
				allowSort : true,
				headerAlign : "center",
				width: 250,
			}, {
				field : "inputer_name",
				header : "录入人",
				width : 150,
				allowSort : true,
				headerAlign : "center",				
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			
			}]
		}
	};
	
	//单据主表
	bill.supchargehead = {
		"type": "formgrid",
		"initHeight" : 0.3,
		"resources": OmdUrl.mss,
		"name": 'supchargehead',
		"method": "mss.work.supchargehead.get",
		"response": "supchargehead",
		"properties": {
			"id": utils.createid('supchargehead')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"visible": true,
			}, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "ComboBox",
				"defaultValue": billtype,
				dictkey: 'BILLTYPE',
				"visible": false,
				"readOnly": true,
			}, {
				"lable": "billmoduleid",
				"name": "billmoduleid",
				"type": "TextBox",
				"defaultValue": app.modulecode,
				"visible": false,
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
			},{
				"label": "门店：",
				"name": "muid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "muid",
				textName: "muid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_muid",
				itemchangedfunc:"page.head_itemchangedfunc",
			}, {
				"label": "门店：",
				"name": "muid_name",
				"type": "TextBox",
				readOnly: true,
				visible: false
			}, {
				"label": "商户：",
				"name": "sbid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "sbid",
				textName: "sbid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_sbid",
			}, {
				"label": "商户：",
				"name": "sbid_name",
				"type": "TextBox",
				readOnly: true,
				visible: false
			}, {
				"label": "合同号：",
				"name": "contno",
				"type": "fut_popselect",
				"readOnly": "true",
				selectkey: "contno",
				textName: "contno",
				allowInput: true,
				beforefunc : "page.head_beforefunc_contno",
			}, {
				"label": "备注：",
				"name": "memo",
				"type": "TextBox",
				"visible": true,
				"style": "width:90%",
			},{
				"label": "录入人：",
				"type": "TextBox",
				"name": "inputer_name",
				"readOnly": "true",
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
				"style" : "display:block;float:none",
			}, {
				"label": "录入日期：",
				"type": "DatePicker",
				"name": "inputdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "录入人编码",
				"type": "TextBox",
				"name": "inputer",
				"visible": false,
			}
		]
	}
	//单据明细
	bill.supchargedet= {
			title: '单据明细',
			"type": "gridbox",
			name: 'supchargedet',
			"properties": {
				"id": utils.createid('supchargedet'),
				"multiSelect": "true",
				"allowCellEdit": "true",
				"allowCellSelect": "true",
				"editNextOnEnterKey": "true",
				"editNextRowCell": "true",
				"allowSortColumn": "false",
				"allowCellValid": true,
				"sortMode": "client",
				"showPager": false,
				"showSummaryRow": false,
				"oncellbeginedit": "OcmControl.checkboxEditor",
				"columns": [{
					type: "checkcolumn",
					name: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
				}, {
					type: "indexcolumn",
					name: "indexcolumn",
					header: "行号",
					headerAlign: "center",
					readOnly: true,
					width: 60,
				}, {
					field: "rowno",
					headerAlign: "center",
					align: "center",
					header: "导入行号",
					dataType: "int",
					allowSort: true,
					readOnly: true,
					visible: false,
				}, {
					field: "cccode",
					name: "cccode",
					header: "费用项目",
					headerAlign: "center",
					allowSort: true,
					required: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                displayField: "cccname",
	                width: 120,
	                editorSet: {
	                    selectkey: 'cccode',
	                    multiSelect: false,
	                    beforefunc:"page.det_beforefunc_cccode",	                    
	                }
				}, {
					field: "cccname",
					name: "cccname",
					header: "费用编码",
					headerAlign: "center",
					width: 120,
					visible: false
				}, {
					field : "startdate",
					name : "startdate",
					headerAlign : "center",
					header : "开始日期",
					allowSort : true,
					required : true,
					editor : OcmControl.newControl('DatePicker'),
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					width : 90,
				},{
					field : "enddate",
					name : "enddate",
					headerAlign : "center",
					header : "结束日期",
					allowSort : true,
					required : true,
					editor : OcmControl.newControl('DatePicker'),
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					width : 90,
				}, {
					field : "amount",
					header : "费用金额",
					width : 100,
					headerAlign : "center",	
					align : "right",
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
				}, {
					field : "memo",
					header : "备注",
					width : 180,
					allowSort : true,
					headerAlign : "center",
				}]
			},
		};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData,
			btn.separator,btn.auditData,
			{'text': '打印','iconCls': 'icon-print','name': 'printData',
			     billstatus: 'YP',ibediting: 'N',tabindex: '1'
				},
			{'text': '收款','iconCls': 'icon-download','name': 'payData',
		     billstatus: 'Y',ibediting: 'N',tabindex: '1'
			},
			{'text': '变更','iconCls': 'icon-download','name': 'chgData',
		     billstatus: 'YP',ibediting: 'N',tabindex: '1'
			},
		    btn.separator, btn.searchData
		]
	}

	// 单据配置
	bill.billconfig = {
		billhead: bill.supchargehead, // 单据主表
		billdetail: [bill.supchargedet], // 单据明细表
		billquerylist: bill.supchargelist, // 查询列表
		dettabpages: [bill.supchargedet], // 要放入明细TAB列表的组件
		defaultmoduleid: '300116', // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
