/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	/*var ns = Future.ns('supcharge.view');*/
	var ns = Future.ns('supprepay.view');
	// 定义一个对象用来配置界面
	var bill = {};
	//app.modulecode='300117';
	var billtype=getBilltype(app.modulecode);
	
	// 把定义对象放到命名空间下
	ns.bill = bill;

	utils.billtype=billtype;
	// 查询列表
	/*bill.supchargelist = {*/
	bill.supprepaylist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.work.supprepay.search",
		/*"response": "supchargehead",*/
		"response": "supprepay",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam": {
			"billmoduleid" : app.modulecode,
			"order_field": "billno",
			"order_direction": "desc",
		},
		"properties": {
			/*"id": utils.createid('supchargelist'),*/
			"id": utils.createid('supprepaylist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 150,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
			}, {
				field: "muid",
				displayField : "muid_name",
				headerAlign: "center",
				header: "门店",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "muid",
					textName : "muid_name",
					responseName : "muid"
				},
				width: 180,
			}, {
				field: "sbid",
				displayField : "sbid_name",
				headerAlign: "center",
				header: "商户/供应商",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "sbid",
					textName : "sbid_name",
					responseName : "sbid"
				},
				width: 180,
			},{
				field: "source",
				type: "TextBox",
				headerAlign: "center",
				header: "单据来源",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'DJSOURCE',
			},{
				field: "spid",
				displayField : "spid_name",
				headerAlign: "center",
				header: "商铺/柜组",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "contspid",
					textName : "spid_name",
					responseName : "spid"
				},
				width: 180,
			},{
				field: "wmid",
				headerAlign: "center",
				type: "TextBox",
				header: "经营方式",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'WMID',
			},{
				field: "contno",
				type: "TextBox",
				headerAlign: "center",
				header: "合同号",
			}, {
				field : "sdate",
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				header : "预付款开始日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			},{
				field : "edate",
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				header : "预付款结束日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			},{
				field : "rate",
				//type : "Spinner",
				//format: "p",
				//dataType : "string",
				type: "TextBox",
				header : "预付款比例",
				headerAlign : "center",
				align : "right",
			},{
				field : "saleamt",
				header : "当前销售金额",
				headerAlign : "center",	
				align : "right",
			},{
				field : "salecost",
				header : "当前销售成本",
				headerAlign : "center",	
				align : "right",
			},{
				field : "salegp",
				header : "当前销售提成金额",
				headerAlign : "center",	
				align : "right",
			},{
				field : "salepay",
				header : "应付金额",
				headerAlign : "center",	
				align : "right",
			},{
				field : "actpay",
				header : "实付金额",
				headerAlign : "center",	
				align : "right",
			},{
				field : "paychn",
				header : "大写金额",
				headerAlign : "center",	
				align : "right",
			},{
				field : "bank",
				header : "开户银行",
				headerAlign : "center",	
				align : "right",
			},{
				field : "accntno",
				header : "银行账号",
				headerAlign : "center",	
				align : "right",
			},/*{
				field : "referbillno",
				header : "费用单序号",
				headerAlign : "center",	
				align : "right",
			},*/{
				field : "settleno",
				header : "结算单号",
				headerAlign : "center",	
				align : "right",
			},/*{
				field : "payno",
				header : "付款单号",
				headerAlign : "center",	
				align : "right",
			},*//*{
				field : "ye",
				header : "核销余额",
				headerAlign : "center",	
				align : "right",
			},*/{
				field : "inputer_name",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",				
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				style: "display:block;float:none", 
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "memo",
				header : "备注",
				width : 120,
				allowSort : true,
				headerAlign : "center",
			}]
		}
	};
	
	// 单据主表
	bill.supprepayhead = {
		"type": "formgrid",
		"resources": OmdUrl.mss,
		"name": 'supprepayhead',
		"method": "mss.work.supprepay.get",
		"response": "supprepay",
		"properties": {
			"id": utils.createid('supprepayhead')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"visible": true,
			}, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "ComboBox",
				"defaultValue": billtype,
				dictkey: 'BILLTYPE',
				"visible": false,
				"readOnly": true,
			}, {
				"label": "单据类型：",
				"name": "billmoduleid",
				"type": "ComboBox",
				"defaultValue": app.modulecode,
				dictkey: 'BILLMODULEID',
				"readOnly": true,
				"visible": false,
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
			}, col.line, {
				"label": "门店：",
				"name": "muid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "muid",
				textName: "muid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_muid",
				itemchangedfunc:"page.head_itemchangedfunc",
			}, {
				"label": "门店：",
				"name": "muid_name",
				"type": "TextBox",
				readOnly: true,
				visible: false,
			}, {
				"label": "商户/供应商：",
				"name": "sbid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "sbid",
				textName: "sbid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_sbid",
				itemchangedfunc:"page.head_itemchangedfunc",
			}, {
				"label": "商户/供应商：",
				"name": "sbid_name",
				"type": "TextBox",
				readOnly: true,
				visible: false,
			}, {
				"label": "合同号：",
				"name": "contno",
				"type": "fut_popselect",
				/*"readOnly": "true",*/
				selectkey: "contno",
				textName: "contno",
				allowInput: true,
				"required": "true",
				beforefunc : "page.head_beforefunc_contno",
				itemchangedfunc:"page.head_itemchangedfunc",
			},{
				"label": "单据来源：",
				"type": "ComboBox",
				"name": "source",
				"readOnly": "true",
				dictkey : 'DJSOURCE',
				visible: true,
			},{
				"label": "商铺/柜组：",
				"name": "spid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "contspid",
				textName: "spid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_spid",
				/*afterfunc:"page.head_afterfunc_spid",*/
				itemchangedfunc:"page.head_itemchangedfunc",
			},{
				"label": "商铺/柜组：",
				"name": "spid_name",
				"type": "TextBox",
				visible: false,
				readOnly: true,
			},{
				"label": "经营方式：",
				"type" : "ComboBox",
				"name": "wmid",
				dictkey : 'WMID',
				"readOnly": "true",
			},{
				"label": "预付款开始日期：",
				"type": "DatePicker",
				"name": "sdate",
				"format": "yyyy-MM-dd",
				//"readOnly": "true",
				onvaluechanged:"page.head_itemchangedfunc",
				"required": "true",
			}, {
				"label": "预付款结束日期：",
				"type": "DatePicker",
				"name": "edate",
				"format": "yyyy-MM-dd",
				//"readOnly": "true",
				onvaluechanged:"page.head_itemchangedfunc",
				"required": "true",
			},{
				label : "预付款比例：",
				"type" : "NumButtonEdit",
				"format" : "p2",
				name : "rate",
				"visible": true,
				align: "right",
				"readOnly": "true",
			},{
				label : "当前销售金额：",
				name : "saleamt",
				"type" : "NumButtonEdit",
				"format" : "n2",
		        align: "right",
		        "readOnly": "true",
			},{
				label : "当前销售提成：",
				name : "salegp",
				"type" : "NumButtonEdit",
				"format" : "n2",
		        align: "right",
		        "readOnly": "true",
			},{
				label : "当前销售成本：",
				name : "salecost",
				"type" : "NumButtonEdit",
				"format" : "n2",
		        align: "right",
		        "readOnly": "true",
			},{
				label: "应付金额：",
				name: "salepay",
				"type" : "NumButtonEdit",
				"format" : "n2",
				"readOnly": "true",
			},{
				"label": "实付金额：",
				"name": "actpay",
				"type" : "NumButtonEdit",
				"format" : "n2",
				onvaluechanged:"page.head_itemchangedfunc",
				"required": "true",
			},{
				"label": "大写金额：",
				"name": "paychn",
				"type": "TextBox",
				"readOnly": "true",
			},{
				"label": "开户银行：",
				"name": "bank",
				"type": "TextBox",
				"readOnly": "true",
			},{
				"label": "银行账号：",
				"name": "accntno",
				"type": "TextBox",
				"readOnly": "true",
			},/*{
				"label": "费用单序号：",
				"name": "referbillno",
				"type": "TextBox",
				"readOnly": "true",
			},*/{
				"label": "结算单号：",
				"name": "settleno",
				"type": "TextBox",
				"readOnly": "true",
			},/*{
				"label": "付款单号：",
				"name": "payno",
				"type": "TextBox",
				"readOnly": "true",
			},*/{
				"label": "核销余额：",
				"name": "ye",
				"type": "TextBox",
				"readOnly": "true",
				visible: false,
			},{
				"label": "备注：",
				"name": "memo",
				"type": "TextBox",
				"visible": true,
				"style": "width:90%",
			},{
				"label": "录入人：",
				"type": "TextBox",
				"name": "inputer_name",
				"readOnly": "true",
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
				"style" : "display:block;float:none",
			}, {
				"label": "录入日期：",
				"type": "DatePicker",
				"name": "inputdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "录入人编码",
				"type": "TextBox",
				"name": "inputer",
				"visible": false,
			}
		]
	}
	// 单据明细
	/*bill.supchargedet= {
			title: '单据明细',
			"type": "gridbox",
			name: 'supchargedet',
			"properties": {
				"id": utils.createid('supchargedet'),
				"multiSelect": "true",
				"allowCellEdit": "true",
				"allowCellSelect": "true",
				"editNextOnEnterKey": "true",
				"editNextRowCell": "true",
				"allowSortColumn": "false",
				"allowCellValid": true,
				"sortMode": "client",
				"showPager": true,
				"showSummaryRow": true,
				"oncellbeginedit": "OcmControl.checkboxEditor",
				"columns": [{
					type: "checkcolumn",
					name: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
				}, {
					type: "indexcolumn",
					name: "indexcolumn",
					header: "行号",
					headerAlign: "center",
					readOnly: true,
					width: "60px",
				}, {
					field: "rowno",
					headerAlign: "center",
					align: "center",
					header: "导入行号",
					dataType: "int",
					allowSort: true,
					readOnly: true,
					visible: false,
				}, {
					field: "cccode",
					name: "cccode",
					header: "费用项目",
					headerAlign: "center",
					allowSort: true,
					required: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                displayField: "cccname",
	                width: "150px",
	                editorSet: {
	                    selectkey: 'cccode',
	                    multiSelect: false,
	                    beforefunc:"page.det_beforefunc_cccode",	                    
	                }
				}, {
					field: "cccname",
					name: "cccname",
					header: "费用编码",
					headerAlign: "center",
					width: "150px",
					visible: false
				}, {
					field : "startdate",
					name : "startdate",
					headerAlign : "center",
					header : "开始日期",
					allowSort : true,
					required : true,
					editor : OcmControl.newControl('DatePicker'),
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
// editorSet:{
// format:"yyyy-MM-dd",
// onValuechanged : "fsdatevalue"
// }
				},{
					field : "enddate",
					name : "enddate",
					headerAlign : "center",
					header : "结束日期",
					allowSort : true,
					required : true,
					editor : OcmControl.newControl('DatePicker'),
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					// editorSet:{format:"yyyy-MM-dd",onValuechanged :
					// "fedatevalue"},
				}, {
					field : "amount",
					header : "费用金额",
					width : 100,
					allowSort : true,
					// required:"true",
					headerAlign : "center",
					// vtype:"float",
			       // "onvalidation": validate.onEnglishAndNumberValidation,
					editor : OcmControl.newControl('Spinner'),
					// "type":"Spinner",
					// "value":0,
					editorSet:{
						format: "n2",
						minValue: "0",
						maxValue: "10000000000",
						"changeOnMousewheel": false,
					},
			        align: "right",
				}, {
					field : "memo",
					header : "备注",
					width : 60,
					allowSort : true,
					headerAlign : "center",
				}]
			},
		};*/

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData,
			btn.separator,btn.auditData,
			{'text': '重新计算','iconCls': 'icon-download','name': 'recompData',
			  billstatus: 'N',ibediting: 'N',tabindex: '1'
			},
			{'text': '付款','iconCls': 'icon-download','name': 'payData',
		     billstatus: 'Y',ibediting: 'N',tabindex: '1'
			},
			/*{'text': '变更','iconCls': 'icon-download','name': 'chgData',
		     billstatus: 'YP',ibediting: 'N',tabindex: '1'
			},*/
		    btn.separator, btn.searchData
		]
	}

	// 单据配置
	bill.billconfig = {
		billhead: bill.supprepayhead, // 单据主表
		/*billdetail: [bill.supchargedet], // 单据明细表
*/		/*billquerylist: bill.supchargelist, // 查询列表
*/		billquerylist: bill.supprepaylist, // 查询列表
		/*dettabpages: [bill.supchargedet], // 要放入明细TAB列表的组件
*/		defaultmoduleid: app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
