<%@ page language="java" contentType="text/html; charset=utf-8"  pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>账单选择</title>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<!-- 引用基类 -->
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<div class="ocm-systoolbar" config="toolbar1" style="margin-bottom: 10px"></div>
	<div class="ocm-formheader" config="formheader1"></div>
	<div class="mini-fit">
		<div id="layout1" class="mini-layout" style="width: 100%; height: 100%;" borderStyle="border:solid 1px #aaa;">
			<div title="账单列表" showProxyText="false" region="west" width="400" expanded="true" showSplitIcon="false">
				<div class="ocm-gridbox" config="gridbox1" border="0"></div>
			</div>
			<div title="费用明细" region="center" showHeader="true" showCollapseButton="false">
				<div class="ocm-gridbox" config="gridbox2" border="0"></div>
			</div>
		</div>
	</div>
</body>

<script type="text/javascript">
	var toolbar1 = {
		items : [ [ {
			"text" : "查询",
			"iconCls" : "icon-search",
			"name" : "searchData",
			"onclick" : "searchData",
			"enabled" : true,
		}, {
			"text" : "清除",
			"iconCls" : "icon-remove",
			"name" : "clearData",
			"onclick" : "clearData",
			"enabled" : true,
		},{
			"text" : "确定",
			"iconCls" : "icon-ok",
			"name" : "confirm",
			"onclick" : "confirm",
			"enabled" : true,
		} ] ]
	};

	var formheader1 = {
		"type" : "formgrid",
		"properties" : {
			"id" : "formheader1",
		},
		items : [ {
			"label" : "结算月：",
			"type" : "MonthPicker",
			"name" : "thisdate",
			"format" : "yyyy-MM",
			"enabled" : true,
			"required" : true,
			"value" : mini.formatDate(new Date(), "yyyy-MM"),
			"defaultValue" : mini.formatDate(new Date(), "yyyy-MM"),
			"style" : "width:30%"
		}]
	};

	var defcolumns = [ {
		type : "checkcolumn",
		headerAlign : "center",
		readOnly : true,
	},{
		type : "indexcolumn",
		header : "行号",
		headerAlign : "center",
	}, {
		field : "billno",
		header : "单据编号",
		allowSort : true,
		headerAlign : "center",
		readOnly: true,
	}, {
		field : "contno",
		header : "合同",
		allowSort : true,
		headerAlign : "center",
		readOnly: true,
	}, {
		field : "thisdate",
		editor : OcmControl.newControl('DatePicker'),
		dataType : "date",
		dateFormat : "yyyy-MM-dd",
		header : "结算月",
		allowSort : true,
		headerAlign : "center",
		align : "center",
		readOnly: true,
	} ];

	var gridbox1 = {
		"type" : "gridbox",
		"resources" : OmdUrl.settle,
		"method" : "mall.settle.supsettlehead.searchByAccom",
		"response" : "supsettlehead",
		// "queryid" : "select_supsettlehead",
		"manualLoad" : true,
		"searchParam" : {
			"billstatus" : "Y",
		},
		"properties" : {
			"id" : "gridbox1",
			"multiSelect" : true,
			"allowSortColumn" : false,
			"columns" : defcolumns,
		},
	};

	var gridbox2 = {
		"type" : "gridbox",
		"resources" : OmdUrl.settle,
		"method" : "mall.settle.supchargelist.search",
		"response" : "supchargelist",
		"manualLoad" : true,
		"searchParam" : {
			// "queryid" : "select_supchargelist",
		},
		"properties" : {
			"id" : "gridbox2",
			"multiSelect" : true,
			"allowSortColumn" : false,
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
			},{
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			}, {
				field : "spid_name",
				header : "商铺",
				allowSort : true,
				headerAlign : "center",
				width : 160,
				readOnly: true,
			}, {
				field : "cccode_name",
				header : "费用项目",
				allowSort : true,
				headerAlign : "center",
				readOnly: true,
			}, {
				field : "accmon",
				header : "账期",
				allowSort : true,
				headerAlign : "center",
				readOnly: true,
			},{
				field : "ysamount",
				header : "结算金额",
				allowSort : true,
				headerAlign : "center",
				numberFormat : "#,0.00",
				defaultValue : "0.00",
				readOnly: true,
			},{
				field : "feesdate",
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				header : "费用开始日期",
				allowSort : true,
				headerAlign : "center",
				readOnly: true,
			},{
				field : "feeedate",
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				header : "费用结束日期",
				allowSort : true,
				headerAlign : "center",
				readOnly: true,
			} ]
		},
	};
	
</script>
<script src="supsettle.js" type="text/javascript"></script>
</html>