/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('supsettotadj.view');
	// 定义一个对象用来配置界面
	var bill = {};
	var moduleid = app.modulecode;
	var billtype = getBilltype(moduleid);
	// 把定义对象放到命名空间下
	ns.bill = bill;
	utils.billtype=billtype;
	// 查询列表
	bill.supsettotadjlist = {
		"type": "gridbox",
		"resources": OmdUrl.settle,
		"method": "mall.settle.supsettotadjhead.search",
		"response": "supsettotadjhead",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam" : {
			"billtype":billtype,
			"order_field" : "billno",
			"order_direction" : "desc",
		},
		"properties": {
			"id": utils.createid('supsettotadjlist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 150,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'SYSTEM_BILLSTATUS',
			}, {
				field: "muid",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "muid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "muid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				enabledSearch : false,
				width: 180,
			},{
				field: "sbid",
				type: "TextBox",
				headerAlign: "center",
				header: "租户",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "sbid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"sbid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "sbid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "租户",
				enabledSearch : false,
				width: 180,
			}, {
				field : "contno",
				header : "合同编号",
				width: 150,
				headerAlign : "center",
			}, {
				field : "setbillno",
				header : "账单编号",
				width: 150,
				headerAlign : "center",
			},{
				field : "inputer_name",
				header : "录入人",
				width : 150,
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
			},{
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "canceler",
				header : "取消人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "canceler_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "canceler_name",
				header : "取消人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "canceldate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "取消日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}]
		}
	};
	
	// 单据主表
	bill.supsettotadjhead = {
		"type": "formgrid",
		"initHeight" : 0.3,
		"resources": OmdUrl.settle,
		"name": 'supsettotadjhead',
		"method": "mall.settle.supsettotadjhead.get",
		"response": "supsettotadjhead",
		"properties": {
			"id": utils.createid('supsettotadjhead')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"style" : "width:22.5%"
			}, {
				"label": "模块编号：",
				"name": "billmoduleid",
				"type": "TextBox",
				"defaultValue": moduleid,
				"visible": false
			}, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "TextBox",
				"defaultValue": billtype,
				"visible": false
			}, {
				"label": "手工编号：",
				"name": "billsgno",
				"type" : "TextBox",
				"style" : "width:22.5%"
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'SYSTEM_BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
				"style" : "width:22.5%"
			},{
				"label": "门店：",
				"name": "muid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "muid",
				textName: "muid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_muid",
				itemchangedfunc:"page.head_itemchangedfunc",
				"style" : "width:22.5%"
			}, {
				"label": "门店：",
				"name": "muid_name",
				"type": "TextBox",
				readOnly: true,
				visible: false,
			}, {
				"label": "商户：",
				"name": "sbid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "sbid",
				textName: "sbid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_sbid",
				itemchangedfunc:"page.head_itemchangedfunc",
				"style" : "width:22.5%"
			}, {
				"label": "商户：",
				"name": "sbid_name",
				"type": "TextBox",
				readOnly: true,
				visible: false,
			}, {
				"label": "合同号：",
				"name": "contno",
				"type": "fut_popselect",
				/*"readOnly": "true",*/
				selectkey: "contno",
				textName: "contno",
				allowInput: true,
				"required": "true",
				beforefunc : "page.head_beforefunc_contno",
				itemchangedfunc:"page.head_itemchangedfunc",
				"style" : "width:22.5%"
			}, {
				"label": "账单编号：",
				"name": "setbillno",
				"type": "ButtonEdit",
				/*"readOnly": "true",*/
				textName: "setbillno",
				allowInput: true,
				"required": "true",
				onbuttonclick : "page.setbillnoClick",
				"style" : "width:22.5%"
			}, {
				"label": "备注：",
				"name": "memo",
				"type": "TextBox",
				"style": "width:90%",
			},{
				"label": "录入人：",
				"name" : "inputer_name",
				"type" : "TextBox",
				"readOnly" : true,
				"visible" : true,
				"defaultValue" : app.username
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
			}, {
				"label": "取消人：",
				"type": "TextBox",
				"name": "canceler_name",
				"readOnly": "true",
			}, {
				"label" : "录入日期：",
				"name" : "inputdate",
				"type" : "DatePicker",
				"readOnly" : true,
				"format" : "yyyy-MM-dd HH:mm:ss",
				"visible" : true,
				"defaultValue" : new Date()
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "取消日期：",
				"type": "DatePicker",
				"name": "canceldate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label" : "录入人编码：",
				"type" : "TextBox",
				"name" : "inputer",
				"visible" : false,
				"defaultValue" : app.usercode
			}
		]
	}
	// 单据明细
	bill.supsettotadjdet= {
			title: '单据明细',
			"type": "gridbox",
			name: 'supsettotadjdet',
			"properties": {
				"id": utils.createid('supsettotadjdet'),
				"multiSelect" : true,
				"allowCellEdit" : true,
				"allowCellSelect" : true,
				"editNextOnEnterKey" : true,
				"editNextRowCell" : true,
				"allowSortColumn" : false,
				"showColumnsMenu":true,
				"showSummaryRow":true,
				"oncellbeginedit" : "OcmControl.checkboxEditor",
				"oncellendedit" : 'OcmControl.datetimeFormate',
				"ondrawsummarycell" : onDrawSummaryCell,
				"columns": [{
					type: "checkcolumn",
					name: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
					width: "40",
				}, {
					field: "browno",
					header: "导入行号",
					visible: false,
				},{
					field: "sclseq",
					header: "序号",
					visible: false,
				}, {
					type: "indexcolumn",
					name: "indexcolumn",
					header: "行号",
					headerAlign: "center",
					readOnly: true,
					width: "40",
				}, {
					field : "cccode_name",
					header : "费用项目",
					headerAlign : "center",				    
				    width : 200,
				    readOnly: true,
				},{
					field : "item",
					header : "费用项目",
					headerAlign : "center",				    
				    width : 200,
				    readOnly: true,
				    visible : false
				},{
					field : "contno",
					header : "合同号",
					headerAlign : "center",				    
				    width : 200,
				    readOnly: true,
				    visible : false
				},{
					field : "spid_name",
					header : "商铺",
					readOnly : true,
					width : 200,
				},{
					field : "begindate",
					editor : OcmControl.newControl('DatePicker'),
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "开始日期",
					width : 150,
					allowSort : true,
					readOnly: true,
					headerAlign : "center",
					align : "center",
				},{
					field : "enddate",
					editor : OcmControl.newControl('DatePicker'),
					dataType : "date",
					dateFormat : "yyyy-MM-dd",
					header : "结束日期",
					width : 150,
					allowSort : true,
					readOnly: true,
					headerAlign : "center",
					align : "center",
				},{
					field : "adjamount",
					header : "调整金额",
					headerAlign : "center",	
					align : "right",
					width : 150,
				    editor : OcmControl.newControl('NumButtonEdit'),
				    editorSet:{format: "n2"},
					align : "right",
					readOnly: false,
				}, {
					field : "sadamount",
					header : "调整后金额",
					headerAlign : "center",	
					align : "right",
					width : 150,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{ format: "n2"},
					align : "right",
					readOnly: false,
				},{
					field : "ysamount",
					header : "应收金额",
					headerAlign : "center",	
					align : "right",
					width : 150,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2"},
					align : "right",
					readOnly: true,
				}, {
					field : "recamount",
					header : "已收金额",
					headerAlign : "center",	
					align : "right",
					width : 150,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n2"},
					align : "right",
					readOnly: true,
				}, {
					field : "memo",
					header : "备注",
					headerAlign : "center",	
				} ]
			},
		};
	 function onDrawSummaryCell(e){
     	var rows = e.data;
     	var adjamount = 0;
     	var sadamount = 0;
     	var ysamount = 0;
     	var recamount = 0;
     	if (rows.length > 0) {
     		for ( var i = 0; i < rows.length; i++) {
     			var row = rows[i];
     			if (isNaN(row.adjamount) == false) {
     				adjamount += parseFloat(row.adjamount);
     			}
     			if (isNaN(row.sadamount) == false) {
     				sadamount += parseFloat(row.sadamount);
     			}
     			if (isNaN(row.ysamount) == false) {
     				ysamount += parseFloat(row.ysamount);
     			}
     			if (isNaN(row.recamount) == false) {
     				recamount += parseFloat(row.recamount);
     			}
     		}
     	}

     	if (e.field == "enddate") {
     		e.cellHtml = "<b>"+"合计: "+"</b>";
     	}
     	if (e.field == "adjamount") {
     		e.cellHtml ="<b>"+ adjamount.toFixed(2)+"</b>";
     	}
     	if (e.field == "sadamount") {
     		e.cellHtml ="<b>"+ sadamount.toFixed(2)+"</b>";
     	}
     	if (e.field == "ysamount") {
     		e.cellHtml = "<b>"+ysamount.toFixed(2)+"</b>";
     	}
     	if (e.field == "recamount") {
     		e.cellHtml = "<b>"+recamount.toFixed(2)+"</b>";
     	}

     	e.cellStyle = "text-align:right";
     }
	
	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData,
			btn.separator,btn.auditData, btn.cancelData, btn.separator, btn.searchData
		]
	}

	// 单据配置
	bill.billconfig = {
		billhead: bill.supsettotadjhead, // 单据主表
		billdetail: [bill.supsettotadjdet], // 单据明细表
		billquerylist: bill.supsettotadjlist, // 查询列表
		dettabpages: [bill.supsettotadjdet], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}
	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
