/**
 * 
 */
(function () {
    // 命名空间
    /** @namespace Future.supsettotadj.out */
    var ns = Future.ns('supsettotadj.out');
    var utils = Future.ns('utils');
    var validate = Future.ns('validate');
    var billtype =utils.billtype;
    
    var Supsettotadj = function () {
    	Supsettotadj.superclass.constructor.call(this);
        this.servicekey = 'mss';
        this.ibcanadddet = false;
        this.head_beforefunc_muid = this.head_beforefunc_muid.bind(this);
        this.head_beforefunc_sbid = this.head_beforefunc_sbid.bind(this);
        this.head_beforefunc_contno = this.head_beforefunc_contno.bind(this);
        this.head_itemchangedfunc = this.head_itemchangedfunc.bind(this);
        this.setbillnoClick = this.setbillnoClick.bind(this);
    }
    ns.Supsettotadj = Supsettotadj;
    Future.extend(ns.Supsettotadj, Future.pub.Basebill, {
    	_initview: function () {
    		Supsettotadj.superclass._initview.call(this);
        },
        initevent : function() {
        	Supsettotadj.superclass.initevent.call(this);
        	this.billhead.tabsToolbar.btns["addRow"].setVisible(false);
			this.supsettotadjdet.on('cellcommitedit', this.detcellcommitedit, this);
		},
        head_beforefunc_muid : function(e) {
        	if (this.supsettotadjdet.data.length > 0) {
                mini.alert("明细已存在数据,请先删除！");
                return -1;
              }
			return 1;
		},
		head_beforefunc_sbid : function(e) {
			if (this.supsettotadjdet.data.length > 0) {
                mini.alert("明细已存在数据,请先删除！");
                return -1;
              }
			var muid = this.billhead.form.getField('muid').value;
			if (muid == undefined || muid == "") {
				mini.alert("请先选择门店");
				return -1;
			}
			//根据门店过滤商户
			if (!e.searchParam) {
				e.searchParam = {};
			}
			e.searchParam = {"supmkt:muid": muid};
			return 1;
		},
		head_beforefunc_contno : function (e) {
			if (this.supsettotadjdet.data.length > 0) {
                mini.alert("明细已存在数据,请先删除！");
                return -1;
              }
        	//根据门店和供应商过滤合同
        	var muid = this.billhead.form.getField('muid').value;
        	var sbid = this.billhead.form.getField('sbid').value;
        	if (!e.searchParam) {
				e.searchParam = {};
			}
			if (muid != "" && sbid == "") {
				e.searchParam.muid = muid;
			}
			if (muid == "" && sbid != "") {
				e.searchParam.sbid = sbid;
			}
			if (muid != "" && sbid != "") {
				e.searchParam = {
					muid : muid,
					sbid : sbid,
				};
			}
			return 1;
        },
        head_itemchangedfunc: function(e, data) {
			//门店修改后，清掉供应商、领用商铺
			 var colname = e.sender.name;
	         if(colname=='muid'){
	        	this.billhead.setValue('sbid', "");
				this.billhead.setText('sbid', "");
				this.billhead.setValue('sbid_name', "");
				this.billhead.setValue('contno', "");
				this.billhead.setText('contno', "");
				this.billhead.setValue('setbillno',"");
				this.billhead.setText('setbillno',"");
	         }
	         if(colname=='sbid') {
	        	this.billhead.setValue('contno', "");
				this.billhead.setText('contno', "");
				this.billhead.setValue('setbillno',"");
				this.billhead.setText('setbillno',"");
	         }
	         if(colname=='contno') {
	        	this.billhead.setValue('muid',data[0].muid);
	        	this.billhead.setText('muid', data[0].muid_name);
	        	this.billhead.setValue('muid_name', data[0].muid_name);
	        	this.billhead.setValue('sbid',data[0].sbid);
	        	this.billhead.setText('sbid',data[0].sbid_name);
	        	this.billhead.setValue('sbid_name',data[0].sbid_name);
	        	this.billhead.setValue('setbillno',"");
				this.billhead.setText('setbillno',"");
	         }
	         return 1;
		},
        setbillnoClick : function(e){
        	if (this.supsettotadjdet.data.length > 0) {
                mini.alert("明细已存在数据,请先删除！");
                return -1;
              }
        	var muid = this.billhead.form.getField('muid').value;
        	var sbid = this.billhead.form.getField('sbid').value;
        	var contno = this.billhead.form.getField('contno').value;
        	var setbillno = this.billhead.form.getField('setbillno')
        	var that = this;
        	if (muid == undefined || muid == "") {
				mini.alert("门店信息不能为空");
				return -1;
			}
        	if (sbid == undefined || sbid == "") {
				mini.alert("商户信息不能为空");
				return -1;
			}
        	if (contno == undefined || contno == "") {
				mini.alert("合同信息不能为空");
				return -1;
			}
			var _url = encodeURI("/mall-business-ui/pages/settleup/supsettle-view.jsp?token=" + getUrlParam("token"));
			if (app.srvkey && app.srvkey != ""){
				_url = _url + "&srvkey="+ app.srvkey;
			}
        	mini.open({
				url : encodeURI(_url),
				title : "账单选择",
				width : $(window).width()*0.8,
				height : 500,
				onload : function() {
					var iframe = this.getIFrameEl();
					var columns = "";
					if (columns != null && columns != "") {
						columns = columns.substring(0, columns.length - 1);
					}
					var data = {
						muid : muid,
						sbid : sbid,
						contno : contno
					};
					iframe.contentWindow.SetData(data);
				},
				ondestroy : function(data) {
					if(data != "close"){
						var rows = data;
						if(rows.length > 0){
							setbillno.setValue(rows[0].jsbillno);
							setbillno.setText(rows[0].jsbillno);
						}
						that.supsettotadjdet.removeRows(that.supsettotadjdet.getData());
						for(var i = 0;i < rows.length;i++){
							var row = {
									"browno" : i+1,
									"sclseq" : rows[i].sclseq,
									"cccode_name" : rows[i].cccode_name,
									"item" : rows[i].cccode,
									"contno" : rows[i].contno,
									"spid" : rows[i].spid,
									"spid_name" : rows[i].spid_name,
									"begindate" : rows[i].feesdate,
									"enddate" : rows[i].feeedate,
									"adjamount" : 0,
									"sadamount" : rows[i].ysamount,
									"ysamount" : rows[i].ysamount,
									"recamount" : rows[i].recamount,
								}
							that.supsettotadjdet.addNewRow(row);
						}
					}
				}
			});
        },
        saveDataBefore:function(){
        	//保存前判断
        	if (this.supsettotadjdet.data.length < 1) {
				mini.alert("不允许空单，明细表必须有数据!");
				return ;
			}else{
				var detData = this.supsettotadjdet.getData();
				for(var i = 0;i < detData.length;i++){
					var adjamount = detData[i].adjamount;
					if (adjamount == 0){
						mini.alert("第"+(i+1)+"行调整金额不能为0，请检查");
						return ;
					}
				}
				return 1;
			}
        },
		detcellcommitedit : function(e) {
        	var amount = e.value;
        	if (e.field == "adjamount") {
        		e.row.sadamount =  Math.round((parseFloat(amount) + parseFloat(e.row.ysamount)) * 100) / 100;
			}
        	if (e.field == "sadamount") {
        		e.row.adjamount =  Math.round((parseFloat(amount) - parseFloat(e.row.ysamount)) * 100) / 100;
        	}
		},
        initcontrol: function () {
        	Supsettotadj.superclass.initcontrol.call(this);
        },
        checkValidate: function () {
            var isValid = Supsettotadj.superclass.checkValidate.call(this);
            if (isValid == false) {
                return isValid;
            }
            return true;
        },
    });
})()