/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('supsetyfk.view');
	// 定义一个对象用来配置界面
	var bill = {};
	var billtype=getBilltype(app.modulecode);
	
	var dicData = {};
	var wmid = [{code: '1',name: '经销',ddvalue: '[1]经销'}]
	var djsource = [{code: '1',name: '自动生成',ddvalue: '[1]自动生成'},{code: '2',name: '手工录入',ddvalue: '[2]手工录入'}]
	
	// 把定义对象放到命名空间下
	ns.bill = bill;
	utils.billtype=billtype;
	
	// 查询列表
	bill.supsetyfklist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.work.supsetyfk.search",
		"response": "supsetyfk",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam": {
			"billmoduleid" : app.modulecode,
			"order_field": "billno",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('supsetyfklist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 150,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
			},{
				field: "ssource",
				type:"TextBox",
				headerAlign:"center",
				header:"单据来源",
				allowSort : true,
				renderer: "OcmControl.dictRendererWithCode",
				enabledSearch : true,
				data: djsource,
				width: 90,
			},{
				field: "ssyorderno",
				type: "TextBox",
				headerAlign: "center",
				header: "订单号",
				width: 150,
			},{
				field: "ssycontno",
				type: "TextBox",
				headerAlign: "center",
				header: "合同编号",
				width : 100,
			},{
				field: "ssysupid",
				displayField : "sbid_name",
				headerAlign: "center",
				header: "供应商",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "selfsbid",
					/*beforefunc : "page.list_beforefunc_sbid",*/
				},
				width: 180,
			},{
				field: "ssywmid",
				type:"TextBox",
				headerAlign:"center",
				header:"经营方式",
				allowSort : true,
				renderer: "OcmControl.dictRendererWithCode",
				data: wmid,
				enabledSearch : false,
				width: 90,
			},{
				field : "ssymarket",
				header : "收货门店",
				width : 160,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "muid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
				visible : true,
				enabledSearch : true,
			},{
				field : "ssymfid",
				header : "收货柜组",
				width : 190,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "spid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"selfspid",beforefunc : "page.list_beforefunc_spid"},
				visible : true,
				enabledSearch : true,
			},{
				field : "ssydhje",
				header : "订货总金额",
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				width : 90,
				enabledSearch : false,
			},{
				field : "ssyrate",
				header : "预付比例",
				type: "TextBox",
				header : "预付款比例",
				headerAlign : "center",
				numberFormat : "#,0.00%",
				vtype : "float",
				align : "right",
				width : 90,
				enabledSearch : false,
			}, {
				field : "ssyyfje",
				header : "应付金额",
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				width : 90,
				enabledSearch : false,
			},{
				field : "ssysfje",
				header : "实付金额",
				headerAlign : "center",
				numberFormat : "#,0.00",
				vtype : "float",
				align : "right",
				width : 90,
				enabledSearch : false,
			},{
				field : "ssyjxtax",
				header : "税率",
				headerAlign : "center",				    
			    width : 80,
			    type : "NumButtonEdit",
			    editorSet:{format: "p2",},
				numberFormat:"p2",						
				align: "right",
				allowSort: true,
				visible : true,
				enabledSearch : true,
			}, {
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			},{
				field : "inputer_name",
				header : "录入人",
				width : 120,
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
			},{
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 130,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			},{
				field : "auditor_name",
				header : "审核人",
				width : 120,
				allowSort : true,
				headerAlign : "center",
				style: "display:block;float:none",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 130,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}]
		}
	};
	
	// 单据主表
	bill.supsetyfkhead = {
		"type": "formgrid",
		"resources": OmdUrl.mss,
		"name": 'supsetyfkhead',
		"method": "mss.work.supsetyfk.get",
		"response": "supsetyfk",
		"properties": {
			"id": utils.createid('supsetyfkhead')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"visible": true,
			}, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "ComboBox",
				"defaultValue": billtype,
				dictkey: 'BILLTYPE',
				"visible": false,
				"readOnly": true,
			}, {
				"label": "单据类型：",
				"name": "billmoduleid",
				"type": "ComboBox",
				"defaultValue": app.modulecode,
				 dictkey: 'BILLMODULEID',
				"readOnly": true,
				"visible": false,
			},{
				"label": "单据来源：",
				"type" : "ComboBox",
				"name" : "ssource",
				"data" : djsource,
				"valueField" : "code",
				"textField" : "name",
				"readOnly": true,
				"defaultValue" : "2",
				 visible: true,
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				 dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
			}, /*col.line,*/ {
				"label": "订单号：",
				"name": "ssyorderno",
				"type": "fut_popselect",
				 selectkey: "borderno",
				 textName: "ssyorderno",
				 allowInput: true,
				 "required": "true",
				 beforefunc : "page.head_beforefunc",
				 itemchangedfunc:"page.head_itemchangedfunc",
			},{
				"label": "合同编号：",
				"name": "ssycontno",
				"type": "TextBox",
				 readOnly: true,
				 visible: true,
			},{
				"label" : "经营方式：",
				"type" : "ComboBox",
				"name" : "ssywmid",
				"data" : wmid,
				"valueField" : "code",
				"textField" : "name",
				 readOnly: true,
				"defaultValue" : "1",
			},{
				"label": "供应商：",
				"name": "ssysupid",
				"type": "fut_popselect",
				 selectkey: "selfsbid",
				 textName: "sbid_name",
				 allowInput: true,
				 readOnly: true,
				 "visible": false
			}, {
				"label": "供应商：",
				"name": "supcode",
				"type": "TextBox",
				"visible": false
			}, {
				"label": "供应商：",
				"name": "sbid_name",
				"type": "TextBox",
				"readOnly": true,
			},{
				"label": "税号：",
				"name": "ssytaxno",
				"type": "TextBox",
				 readOnly: true,
			}, {
				"label": "开户银行：",
				"name": "ssybank",
				"type": "TextBox",
				 readOnly: true,
			},{
				"label": "银行账户：",
				"name": "ssyaccount",
				"type": "TextBox",
				 readOnly: true,
			},{
				"label": "收货门店：",
				"name": "ssymarket",
				"type": "fut_popselect",
				 selectkey: "muid",
				 textName: "muid_name",
				 "visible": false,
			},{
				"label": "收货门店：",
				"name": "mucode",
				"type": "TextBox",
				"visible": false,
			},{
				"label": "收货门店：",
				"name": "muid_name",
				"type": "TextBox",
				 "readOnly": true,
			},{
				"label" : "收货柜组：",
				"name" : "ssymfid",
				"type" : "ButtonEdit",
				type : "fut_popselect",//类型
				selectkey : "selfspid",//弹框类型
				textName : "spid_name", //文本显示字段
				"readOnly": true,
				"visible": false
			},{
				"label": "收货柜组：",
				"name": "mfcode",
				"type": "TextBox",
				 "readOnly": true,
				"visible": false
			},{
				"label": "收货柜组：",
				"name": "spid_name",
				"type": "TextBox",
				 "readOnly": true,
			},{
				"label": "订货总金额：",
				 "name":  "ssydhje",
				"type" : "NumButtonEdit",
				"format" : "c2",
		         align: "right",
		        "readOnly": "true",
			},{
				"label": "预付比例：",
				"name": "ssyrate",
				"type" : "NumButtonEdit",
				"format" : "p2",				
				"visible": true,
				 align: "right",
				"readOnly": "true",
			},{
				"label": "应付金额：",
				 "name":  "ssyyfje",
				"type" : "NumButtonEdit",
				"format" : "c2",
		         align: "right",
		        "readOnly": "true",
			},{
				"label": "实付金额：",
				 "name":  "ssysfje",
				"type" : "NumButtonEdit",
				"format" : "c2",
		         align: "right",
		         onvaluechanged:"page.head_itemchangedfunc",
		         "required": "true",
			},{
				"label": "税率：",
				"name": "ssyjxtax",
				"type" : "NumButtonEdit",
				"format" : "p2",						
				 align: "right",
				"readOnly": "true",
				 "visible": true,
				 /*style: "display:block;float:none",*/
			},{
				"label": "备注：",
				"name": "ssymemo",
				"type": "TextBox",
				"visible": true,
				/*"style": "display:block;float:none;width:60%",*/
			},{
				"label": "应收不含税金额：",
				"name": "ssysfbhsje",
				"type" : "NumButtonEdit",
				"format" : "c2",				
				"visible": true,
				 align: "right",
				"readOnly": "true",
				"visible": false
			},{
				"label" : "录入人：",
				"name" : "inputer_name",
				"type" : "TextBox",
				"defaultValue" : app.username,
				"readOnly" : true,
			}, {
				"label" : "录入人",
				"name" : "inputer",
				"type" : "TextBox",
				"readOnly" : true,
				"visible":false,
			},{
				"label" : "审核人：",
				"name" : "auditor_name",
				"type" : "TextBox",
				"readOnly" : true,
				"style" : "display:block;float:none",
			},{
				"label" : "审核人姓名",
				"name" : "auditor",
				"type" : "TextBox",
				"readOnly" : true,
				"visible":false,
			},{
		        "label" : "录入日期：",
		        "type" : "DatePicker",
		        "name" : "inputdate",
		        "format" : "yyyy-MM-dd HH:mm:ss",
		        "defaultValue" : new Date(),
		        "readOnly" : "true",
		    },{
	            "label": "审核日期：",
	            "type": "DatePicker",
	            "name": "auditdate",
	            "format": "yyyy-MM-dd HH:mm:ss",
	            "readOnly": "true",
		    }]
	}	

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData, btn.separator,btn.auditData, btn.separator, btn.searchData]
	}

	// 单据配置
	bill.billconfig = {
		billhead: bill.supsetyfkhead, // 单据主表
		billquerylist: bill.supsetyfklist, // 查询列表
		defaultmoduleid: app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
