/**
 * 商铺批量录入/商铺批量修改/商铺合并/商铺拆分 --- 界面定义
 */
(function () {
    // 要引用的包
    var utils = Future.ns('Future.utils');

    // 商铺修改命名空间
    var ns = Future.ns('shop.view');

    // 定义一个对象用来配置界面
    var bshopchange = {};

    // 把定义对象放到命名空间下
    ns.bshopchange = bshopchange;

    var billtype = getBilltype(app.modulecode);
	var rulemode = getRulemode("shop");
	utils.billtype = billtype;
	utils.rulemode = rulemode;
    var initmainhead = null;
    if (billsylx != "" && billsylx != null) {
        initmainhead = [{name: "sylx", defaultValue: billsylx, readOnly: true},]
    }
    var bshopchgheadItems = Future.Table.Head.getConfig("bshopchghead", initmainhead);
    bshopchgheadItems = app.repaint.initHead("bshopchghead", bshopchgheadItems);

    // 表头 自定义名称
    bshopchange.bshophead = {
        "title": '单据明细',
        "name": 'bshophead',
        "type": "formgrid",
        "initHeight": 0.25,
        "resources": OmdUrl.mall,
        "method": "mall.work.bshopchg.get",
        "response": "bshopchghead",
        "properties": {
            "id": utils.createid('bshophead'),
        },
        items: bshopchgheadItems
    };
    var bshopchgdetItems = Future.Table.Detail.getConfig("bshopchgdet", null);
    bshopchgdetItems = app.repaint.initDetail("bshopchgdet", bshopchgdetItems);

    // 明细 自定义名称
    bshopchange.bshopdetail = {
        "title": '商铺明细',// tab页面标题
        "name": 'bshopchgdet',// 名称 数据绑定根据此数据来匹配
        "type": "gridbox",
        "properties": {
            "id": utils.createid('bshopdetail'),
            "multiSelect": "true",
            "allowCellEdit": "true",
            "allowCellSelect": "true",
            "editNextOnEnterKey": "true",
            "editNextRowCell": "true",
            "allowSortColumn": "false",
            "allowCellValid": true,
            "oncellbeginedit": "OcmControl.checkboxEditor",
            "columns": bshopchgdetItems
        }
    };

    var bshopchgheadlistItems = Future.Table.List.getConfig("bshopchghead", null);
    bshopchgheadlistItems = app.repaint.initList("bshopchghead", bshopchgheadlistItems);

    // 查询 自定义名称
    if (billsylx != "" && billsylx != null) {
        bshopchange.bshopquerylist = {
            "title": '单据列表',
            "name": 'bshopquerylist',
            "type": "gridbox",
            "resources": OmdUrl.mall,
            "method": "mall.work.bshopchg.search",
            "response": "bshopchghead",
            "canquery": true,
            /* "manualLoad" : true, */
            "bindform": "layouttabs", // 绑定切换的TabsBox.name
            "bindSearchParam": ["ph_key"], // 明细页面查询条件字段
            "searchParam": {
                "billmoduleid": app.modulecode,
                "sylx": billsylx,
                "order_field": "billno",
                "order_direction": "desc"
            },
            "properties": {
                "id": utils.createid('bshopquerylist'),
                "columns": bshopchgheadlistItems
            }
        };
    } else {
        bshopchange.bshopquerylist = {
            "title": '单据列表',
            "name": 'bshopquerylist',
            "type": "gridbox",
            "resources": OmdUrl.mall,
            "method": "mall.work.bshopchg.search",
            "response": "bshopchghead",
            "canquery": true,
            /* "manualLoad" : true, */
            "bindform": "layouttabs", // 绑定切换的TabsBox.name
            "bindSearchParam": ["ph_key"], // 明细页面查询条件字段
            "searchParam": {
                "billmoduleid": app.modulecode,
                "order_field": "billno",
                "order_direction": "desc"
            },
            "properties": {
                "id": utils.createid('bshopquerylist'),
                "columns": bshopchgheadlistItems
            }
        };
    }

    var btn = Future.default.btn;
    // 按钮配置 - 固定名称
    bshopchange.toolbarconfig = {
        id: utils.createid('systoolbar'),
        // items : Future.pub.Basebill.default_toolsbar  btn.printData,
        items: [btn.addData, btn.editData, btn.delData, btn.saveData,
            btn.separator, btn.auditData, btn.separator, btn.searchData,
            btn.billImport, /*btn.upTemplate,*/ btn.downTemplate]
    }

    // 单据配置
    bshopchange.billconfig = {
        billhead: bshopchange.bshophead, // 单据主表
        billdetail: [bshopchange.bshopdetail], // 单据明细表
        billquerylist: bshopchange.bshopquerylist,// 查询列表
        dettabpages: [bshopchange.bshopdetail],// 要放入明细TAB列表的组件
        defaultmoduleid: app.modulecode,// 默认单据类型
    }

    // 创建标准单据模板
    utils.create_standardbill_config(bshopchange);

})();
