/**
 * 商铺批量录入/商铺批量修改/商铺合并/商铺拆分
 */
(function () {
    // 商铺录入命名空间
    /** @namespace Future.shop.bu */
    var ns = Future.ns('shop.bu');
    var utils = Future.ns('Future.utils');
    var billtype = utils.billtype;
    var rulemode = utils.rulemode;
    /**
     * 商铺批量录入，修改，合并和拆分
     *
     * @constructor
     */
    var BshopChange = function () {
        BshopChange.superclass.constructor.call(this);
        this.servicekey = 'mss';
        this.bshopchgdet_beforefunc = this.bshopchgdet_beforefunc.bind(this);
        this.head_btnClickbefore = this.head_btnClickbefore.bind(this);
        this.head_beforefunc_owner = this.head_beforefunc_owner.bind(this);
        this.head_itemchanged_spggtype = this.head_itemchanged_spggtype.bind(this);
        this.head_itemchanged_sylx = this.head_itemchanged_sylx.bind(this);
        this.rowdblclickAfter = this.rowdblclickAfter.bind(this);

    }
    var findcol = function (cols, col, value) {
        for (var i = 1; i < cols.length; i++) {
            var rtn = cols[i];
            if (rtn.name == col) {
                return rtn;
                break;
            }
        }
    }
    ns.BshopChange = BshopChange;

    Future.extend(ns.BshopChange, Future.pub.Basebill, {

        _initview: function () {
            BshopChange.superclass._initview.call(this);

        },
        initevent: function () {
            BshopChange.superclass.initevent.call(this);
            this.bshopchgdet.on('cellcommitedit',
                this.detcellcommitedit, this);
            this.bshopchgdet.addNewRowBefore = this.addNewRowBefore.bind(this);

        },
        initdict: function () {
            /*商铺导入新增的商铺类型，把广告位过滤去掉*/
            /*var fitlsptypedata=[];
            var sptypedictdata = Future.Pub.DictSrv.data.SPTYPE;
            for(var i=0;i<sptypedictdata.length;i++ ){
                if(sptypedictdata[i].pro1=="Y" ){
                    fitlsptypedata.push(sptypedictdata[i]);
                }
            }
            Future.Pub.DictSrv.data.SPTYPE = fitlsptypedata;*/
        },
        addDataBefore: function (data) {
            var flag = false;
            var that = this
            if (flag) {
                return {};
            } else {
                var form = this.bshophead.form;
//						var spggtype = form.getField('spggtype');
                var spid = this.bshopchgdet.getColumn("spid");
                var spid2 = this.bshopchgdet.getColumn("spid2");
                var spcname = this.bshopchgdet.getColumn("spcname");
                var spcname2 = this.bshopchgdet.getColumn("spcname2");
                var ownerid = this.bshopchgdet.getColumn("ownerid");
                var sptype = this.bshopchgdet.getColumn("sptype");
                var sptype2 = this.bshopchgdet.getColumn("sptype2");
                var spmode = this.bshopchgdet.getColumn("spmode");
                var poolrate = this.bshopchgdet.getColumn("poolrate");
                var poolcoeffi = this.bshopchgdet.getColumn("poolcoeffi");
                var spggtype = this.bshopchgdet.getColumn("spggtype");
                var media = this.bshopchgdet.getColumn("media");
                this.bshopchgdet.showColumn(spid);
                if (rulemode == "1") {
                    this.bshopchgdet.updateColumn('spid', {
                        required: false,
                        readOnly: true,
                        headerStyle: "color:black"
                    });
                } else {
                    this.bshopchgdet.updateColumn('spid', {required: true, readOnly: false, headerStyle: "color:blue"});
                }
                this.bshopchgdet.hideColumn(spid2);
                spid2.required = false;
                this.bshopchgdet.showColumn(spcname);
                spcname.required = true;
                this.bshopchgdet.hideColumn(spcname2);
                spcname2.required = false;
                this.bshopchgdet.showColumn(ownerid);
                ownerid.required = true;
                this.bshopchgdet.showColumn(sptype);
                sptype.required = true;
                this.bshopchgdet.hideColumn(sptype2);
                sptype2.required = false;
                this.bshopchgdet.showColumn(spmode);
                spmode.required = true;
                this.bshopchgdet.showColumn(poolrate);
                poolrate.required = true;
                this.bshopchgdet.showColumn(poolcoeffi);
                poolcoeffi.required = true;
                this.bshopchgdet.hideColumn(spggtype);
                spggtype.required = false;
                this.bshopchgdet.hideColumn(media);
                media.required = false;

                if ((billsylx != "" && billsylx != null) && billsylx == "03") {
                    this.bshopchgdet.showColumn(spid2);
                    if (rulemode == "1") {
                        this.bshopchgdet.updateColumn('spid2', {
                            required: false,
                            readOnly: true,
                            headerStyle: "color:black"
                        });
                    } else {
                        this.bshopchgdet.updateColumn('spid2', {
                            required: true,
                            readOnly: false,
                            headerStyle: "color:blue"
                        });
                    }
                    this.bshopchgdet.hideColumn(spid);
                    spid.required = false;
                    this.bshopchgdet.showColumn(spcname2);
                    spcname2.required = true;
                    this.bshopchgdet.hideColumn(spcname);
                    spcname.required = false;
                    this.bshopchgdet.showColumn(ownerid);
                    ownerid.required = true;
                    this.bshopchgdet.showColumn(sptype2);
                    sptype2.required = true;
                    this.bshopchgdet.hideColumn(sptype);
                    sptype.required = false;
                    this.bshopchgdet.hideColumn(spmode);
                    spmode.required = false;
                    this.bshopchgdet.showColumn(poolrate);
                    poolrate.required = true;
                    this.bshopchgdet.showColumn(poolcoeffi);
                    poolcoeffi.required = true;
                    this.bshopchgdet.hideColumn(spggtype);
                    spggtype.required = false;
                    this.bshopchgdet.showColumn(media);
                    media.required = true;
                    this.bshopchgdet.hideColumn(poolrate);
                    this.bshopchgdet.hideColumn(poolcoeffi);
                }

                return 0;
            }
        },
        addNewRowBefore: function () {
            var muid = this.bshophead.form.getField('muid').value;
            var sylx = this.bshophead.form.getField('sylx').value;
            if (!muid) {
                mini.alert("请先选择门店");
                return;
            }
            if (!sylx) {
                mini.alert("请先选择商铺使用类型");
                return;
            }

            var data = this.bshopchgdet.getData();
            var num = data.length + 1;
            var obj = {};
            var spmode = this.bshopchgdet.getColumn("spmode");
            if (spmode) {
                obj.spmode = spmode.defaultValue;
            }
            obj.browno = num;
            return obj
        },
        downTemplate: function () {
            var form = this.bshophead.form;
            var sylx = form.getField('sylx').value;
            if (sylx == '02' || sylx == '') {
                var searchParam =
                    {
                        "billmoduleid": "100501",
                    };
            }
            if (sylx == '03') {
                var searchParam =
                    {
                        "billmoduleid": "100501_G",
                    };
            }
            var config = this.billhead.config;
            var token = getUrlParam("token");
            var url = getresturl_base(config.resources, "", token, "");
            url = encodeURI(url + "&param=" + JSON.stringify(searchParam));
            url = url.replace("rest", "exportTemplate");
            window.open(url, '_self');
        },
        saveDataBefore: function () {
            var obj = {};
            var sylx = this.bshophead.form.getField('sylx').value;
            var detData = this.bshopchgdet.data;
            for (var i = 0; i < detData.length; i++) {
                if (!detData[i].spstartdate) {
                    mini.alert("第" + (i + 1) + "行生效日期为空，请检查");
                    return;
                }
                if (sylx == '02') {
                    if ((!detData[i].spmode) && Number(detData[i].spmode) != 0) {
                        mini.alert("第" + (i + 1) + "行商铺属性为空，请检查");
                        return;
                    }
					if (rulemode != "1") {
						if (!detData[i].spid) {
							mini.alert("第" + (i + 1) + "行商铺编码为空，请检查");
							return;
						}
					}
                    if (!detData[i].sptype) {
                        mini.alert("第" + (i + 1) + "行商铺类型为空，请检查");
                        return;
                    }
                }
                if (!detData[i].region) {
                    mini.alert("第" + (i + 1) + "行上级编码为空，请检查");
                    return;
                }
                if (!detData[i].spbuildarea && ("string" == typeof (detData[i].spbuildarea))) {
                    mini.alert("第" + (i + 1) + "行建筑面积为空，请检查");
                    return;
                }
                if (!detData[i].splettarea && ("string" == typeof (detData[i].splettarea))) {
                    mini.alert("第" + (i + 1) + "行套内面积为空，请检查");
                    return;
                }
                if (sylx == '03') {
                    if (!detData[i].media) {
                        mini.alert("第" + (i + 1) + "行广告介质为空，请检查");
                        return;
                    }
					if (rulemode != "1") {
						if (!detData[i].spid) {
							mini.alert("第" + (i + 1) + "行广告位编码为空，请检查");
							return;
						}
					}
                    if (!detData[i].sptype) {
                        mini.alert("第" + (i + 1) + "行广告位类型为空，请检查");
                        return;
                    }
                }
            }
            return obj;
        },
        auditDataBefore: function () {
            if (this.bshopchgdet.data.length < 1) {
                mini.alert("单据明细为空，不能进行审核！");
                return;
            }
            return true;
        },
        head_btnClickbefore: function (e) {
            // 判断明细是否有数据,如果有数据，必须先删除了，再才能修改
            if (this.bshopchgdet.data.length > 0) {
                mini.alert("明细已存在数据,请先删除后再修改门店");
                e.cancel = true;
                return -1;
            }
        },
        head_beforefunc_owner: function (e) {
            var muid = this.bshophead.form.getField('muid').value;

            if (muid == undefined || muid == "") {
                mini.alert("请先选择门店");
                return -1;
            }

            if (!e.searchParam) {
                e.searchParam = {};
            }
            e.searchParam.muid = muid;
            return 0;
        },
        head_itemchanged_spggtype: function (e) {
            var sgtype = this.bshophead.form.getField('spggtype');
            var spid = this.bshopchgdet.getColumn("spid");
            var spid2 = this.bshopchgdet.getColumn("spid2");
            var spcname = this.bshopchgdet.getColumn("spcname");
            var spcname2 = this.bshopchgdet.getColumn("spcname2");
            var ownerid = this.bshopchgdet.getColumn("ownerid");
            var sptype = this.bshopchgdet.getColumn("sptype");
            var sptype2 = this.bshopchgdet.getColumn("sptype2");
            var spmode = this.bshopchgdet.getColumn("spmode");
            var poolrate = this.bshopchgdet.getColumn("poolrate");
            var poolcoeffi = this.bshopchgdet.getColumn("poolcoeffi");
            var spggtype = this.bshopchgdet.getColumn("spggtype");
            var media = this.bshopchgdet.getColumn("media");
            var spggtype = e.value;
            if (this.bshopchgdet.data.length > 0) {
                mini.alert("明细已存在数据,请先删除后再修改商铺性质!");
                mini.getbyName("spggtype").setText("");
                mini.getbyName("spggtype").setValue("");
                e.cancel = true;
                return -1;
            }
            if (spggtype == 'S') {  //商铺
                this.bshopchgdet.hideColumn(spid2);
                spid2.required = false;
                this.bshopchgdet.showColumn(spid);
                if (rulemode == "1") {
                    this.bshopchgdet.updateColumn('spid', {
                        required: false,
                        readOnly: true,
                        headerStyle: "color:black"
                    });
                } else {
                    this.bshopchgdet.updateColumn('spid', {required: true, readOnly: false, headerStyle: "color:blue"});
                }
                this.bshopchgdet.hideColumn(spcname2);
                spcname2.required = false;
                this.bshopchgdet.showColumn(spcname);
                spcname.required = true;
                this.bshopchgdet.showColumn(ownerid);
                ownerid.required = true;
                this.bshopchgdet.hideColumn(sptype2);
                sptype2.required = false;
                this.bshopchgdet.showColumn(sptype);
                sptype.required = true;
                this.bshopchgdet.showColumn(spmode);
                spmode.required = true;
                this.bshopchgdet.showColumn(poolrate);
                poolrate.required = true;
                this.bshopchgdet.showColumn(poolcoeffi);
                poolcoeffi.required = true;
                this.bshopchgdet.hideColumn(spggtype);
                spggtype.required = false;
                this.bshopchgdet.hideColumn(media);
                media.required = false;
            }
            if (spggtype == 'G') {  //广告位
                this.bshopchgdet.hideColumn(spid);
                spid.required = false;
                this.bshopchgdet.showColumn(spid2);
                if (rulemode == "1") {
                    this.bshopchgdet.updateColumn('spid2', {
                        required: false,
                        readOnly: true,
                        headerStyle: "color:black"
                    });
                } else {
                    this.bshopchgdet.updateColumn('spid2', {
                        required: true,
                        readOnly: false,
                        headerStyle: "color:blue"
                    });
                }
                this.bshopchgdet.hideColumn(spcname);
                spcname.required = false;
                this.bshopchgdet.showColumn(spcname2);
                spcname2.required = true;
                this.bshopchgdet.hideColumn(ownerid);
                ownerid.required = false;
                this.bshopchgdet.hideColumn(sptype);
                sptype.required = false;
                this.bshopchgdet.showColumn(sptype2);
                sptype2.required = true;
                this.bshopchgdet.hideColumn(spmode);
                spmode.required = false;
                this.bshopchgdet.hideColumn(poolrate);
                poolrate.required = false;
                this.bshopchgdet.hideColumn(poolcoeffi);
                poolcoeffi.required = false;
                this.bshopchgdet.hideColumn(spggtype);
                spggtype.required = false;
                this.bshopchgdet.showColumn(media);
                media.required = true;
            }
        },
        head_itemchanged_sylx: function (e) {
            var sylx = this.bshophead.form.getField('sylx');
            var spid = this.bshopchgdet.getColumn("spid");
            var spid2 = this.bshopchgdet.getColumn("spid2");
            var spcname = this.bshopchgdet.getColumn("spcname");
            var spcname2 = this.bshopchgdet.getColumn("spcname2");
            var ownerid = this.bshopchgdet.getColumn("ownerid");
            var sptype = this.bshopchgdet.getColumn("sptype");
            var sptype2 = this.bshopchgdet.getColumn("sptype2");
            var spmode = this.bshopchgdet.getColumn("spmode");
            var poolrate = this.bshopchgdet.getColumn("poolrate");
            var poolcoeffi = this.bshopchgdet.getColumn("poolcoeffi");
            var spggtype = this.bshopchgdet.getColumn("spggtype");
            var media = this.bshopchgdet.getColumn("media");
            var spggtype = e.value;
            if (this.bshopchgdet.data.length > 0) {
                mini.alert("明细已存在数据,请先删除后再修改使用类型!");
                mini.getbyName("sylx").setText("");
                mini.getbyName("sylx").setValue("");
                e.cancel = true;
                return -1;
            }
            if (spggtype == '02') {  //商铺
                this.bshopchgdet.hideColumn(spid2);
                spid2.required = false;
                this.bshopchgdet.showColumn(spid);
                if (rulemode == "1") {
                    this.bshopchgdet.updateColumn('spid', {
                        required: false,
                        readOnly: true,
                        headerStyle: "color:black"
                    });
                } else {
                    this.bshopchgdet.updateColumn('spid', {required: true, readOnly: false, headerStyle: "color:blue"});
                }
                this.bshopchgdet.hideColumn(spcname2);
                spcname2.required = false;
                this.bshopchgdet.showColumn(spcname);
                spcname.required = true;
                this.bshopchgdet.showColumn(ownerid);
                ownerid.required = true;
                this.bshopchgdet.hideColumn(sptype2);
                sptype2.required = false;
                this.bshopchgdet.showColumn(sptype);
                sptype.required = true;
                this.bshopchgdet.showColumn(spmode);
                spmode.required = true;
                this.bshopchgdet.showColumn(poolrate);
                poolrate.required = true;
                this.bshopchgdet.showColumn(poolcoeffi);
                poolcoeffi.required = true;
                this.bshopchgdet.hideColumn(spggtype);
                spggtype.required = false;
                this.bshopchgdet.hideColumn(media);
                media.required = false;
            }
            if (spggtype == '03') {  //广告位
                this.bshopchgdet.hideColumn(spid);
                spid.required = false;
                this.bshopchgdet.showColumn(spid2);
                if (rulemode == "1") {
                    this.bshopchgdet.updateColumn('spid2', {
                        required: false,
                        readOnly: true,
                        headerStyle: "color:black"
                    });
                } else {
                    this.bshopchgdet.updateColumn('spid2', {
                        required: true,
                        readOnly: false,
                        headerStyle: "color:blue"
                    });
                }
                this.bshopchgdet.hideColumn(spcname);
                spcname.required = false;
                this.bshopchgdet.showColumn(spcname2);
                spcname2.required = true;
                this.bshopchgdet.hideColumn(ownerid);
                ownerid.required = false;
                this.bshopchgdet.hideColumn(sptype);
                sptype.required = false;
                this.bshopchgdet.showColumn(sptype2);
                sptype2.required = true;
                this.bshopchgdet.hideColumn(spmode);
                spmode.required = false;
                this.bshopchgdet.hideColumn(poolrate);
                poolrate.required = false;
                this.bshopchgdet.hideColumn(poolcoeffi);
                poolcoeffi.required = false;
                this.bshopchgdet.hideColumn(spggtype);
                spggtype.required = false;
                this.bshopchgdet.showColumn(media);
                media.required = true;
            }
        },
        rowdblclickAfter: function () {
            var sylx = this.bshophead.form.getField('sylx');
            var spid = this.bshopchgdet.getColumn("spid");
            var spid2 = this.bshopchgdet.getColumn("spid2");
            var spcname = this.bshopchgdet.getColumn("spcname");
            var spcname2 = this.bshopchgdet.getColumn("spcname2");
            var ownerid = this.bshopchgdet.getColumn("ownerid");
            var sptype = this.bshopchgdet.getColumn("sptype");
            var sptype2 = this.bshopchgdet.getColumn("sptype2");
            var spmode = this.bshopchgdet.getColumn("spmode");
            var poolrate = this.bshopchgdet.getColumn("poolrate");
            var poolcoeffi = this.bshopchgdet.getColumn("poolcoeffi");
            var spggtype = this.bshopchgdet.getColumn("spggtype");
            var media = this.bshopchgdet.getColumn("media");
            var spggtype = sylx.value;
            if (spggtype == '02') {  //商铺
                this.bshopchgdet.hideColumn(spid2);
                spid2.required = false;
                this.bshopchgdet.showColumn(spid);
                if (rulemode == "1") {
                    this.bshopchgdet.updateColumn('spid', {
                        required: false,
                        readOnly: true,
                        headerStyle: "color:black"
                    });
                } else {
                    this.bshopchgdet.updateColumn('spid', {required: true, readOnly: false, headerStyle: "color:blue"});
                }
                this.bshopchgdet.hideColumn(spcname2);
                spcname2.required = false;
                this.bshopchgdet.showColumn(spcname);
                spcname.required = true;
                this.bshopchgdet.showColumn(ownerid);
                ownerid.required = true;
                this.bshopchgdet.hideColumn(sptype2);
                sptype2.required = false;
                this.bshopchgdet.showColumn(sptype);
                sptype.required = true;
                this.bshopchgdet.showColumn(spmode);
                spmode.required = true;
                this.bshopchgdet.showColumn(poolrate);
                poolrate.required = true;
                this.bshopchgdet.showColumn(poolcoeffi);
                poolcoeffi.required = true;
                this.bshopchgdet.hideColumn(spggtype);
                spggtype.required = false;
                this.bshopchgdet.hideColumn(media);
                media.required = false;
            }
            if (spggtype == '03') {  //广告位
                this.bshopchgdet.hideColumn(spid);
                spid.required = false;
                this.bshopchgdet.showColumn(spid2);
                if (rulemode == "1") {
                    this.bshopchgdet.updateColumn('spid2', {
                        required: false,
                        readOnly: true,
                        headerStyle: "color:black"
                    });
                } else {
                    this.bshopchgdet.updateColumn('spid2', {
                        required: true,
                        readOnly: false,
                        headerStyle: "color:blue"
                    });
                }
                this.bshopchgdet.hideColumn(spcname);
                spcname.required = false;
                this.bshopchgdet.showColumn(spcname2);
                spcname2.required = true;
                this.bshopchgdet.hideColumn(ownerid);
                ownerid.required = false;
                this.bshopchgdet.hideColumn(sptype);
                sptype.required = false;
                this.bshopchgdet.showColumn(sptype2);
                sptype2.required = true;
                this.bshopchgdet.hideColumn(spmode);
                spmode.required = false;
                this.bshopchgdet.hideColumn(poolrate);
                poolrate.required = false;
                this.bshopchgdet.hideColumn(poolcoeffi);
                poolcoeffi.required = false;
                this.bshopchgdet.hideColumn(spggtype);
                spggtype.required = false;
                this.bshopchgdet.showColumn(media);
                media.required = true;
            }
        },
        _systabChanged: function (e) {
            var title = e.tab.title;
            var form = e.sender.businessobj.bshophead.form;
            var det = e.sender.businessobj.bshopchgdet;
            if (title == "单据明细") {
                var sylx = this.bshophead.form.getField('sylx');
                var spid = this.bshopchgdet.getColumn("spid");
                var spid2 = this.bshopchgdet.getColumn("spid2");
                var spcname = this.bshopchgdet.getColumn("spcname");
                var spcname2 = this.bshopchgdet.getColumn("spcname2");
                var ownerid = this.bshopchgdet.getColumn("ownerid");
                var sptype = this.bshopchgdet.getColumn("sptype");
                var sptype2 = this.bshopchgdet.getColumn("sptype2");
                var spmode = this.bshopchgdet.getColumn("spmode");
                var poolrate = this.bshopchgdet.getColumn("poolrate");
                var poolcoeffi = this.bshopchgdet.getColumn("poolcoeffi");
                var spggtype = this.bshopchgdet.getColumn("spggtype");
                var media = this.bshopchgdet.getColumn("media");
                var spggtype = sylx.value;
                if (spggtype == '02') {  //商铺
                    this.bshopchgdet.hideColumn(spid2);
                    spid2.required = false;
                    this.bshopchgdet.showColumn(spid);
                    if (rulemode == "1") {
                        this.bshopchgdet.updateColumn('spid', {
                            required: false,
                            readOnly: true,
                            headerStyle: "color:black"
                        });
                    } else {
                        this.bshopchgdet.updateColumn('spid', {
                            required: true,
                            readOnly: false,
                            headerStyle: "color:blue"
                        });
                    }
                    this.bshopchgdet.hideColumn(spcname2);
                    spcname2.required = false;
                    this.bshopchgdet.showColumn(spcname);
                    spcname.required = true;
                    this.bshopchgdet.showColumn(ownerid);
                    ownerid.required = true;
                    this.bshopchgdet.hideColumn(sptype2);
                    sptype2.required = false;
                    this.bshopchgdet.showColumn(sptype);
                    sptype.required = true;
                    this.bshopchgdet.showColumn(spmode);
                    spmode.required = true;
                    this.bshopchgdet.showColumn(poolrate);
                    poolrate.required = true;
                    this.bshopchgdet.showColumn(poolcoeffi);
                    poolcoeffi.required = true;
                    this.bshopchgdet.hideColumn(spggtype);
                    spggtype.required = false;
                    this.bshopchgdet.hideColumn(media);
                    media.required = false;
                }
                if (spggtype == '03') {  //广告位
                    this.bshopchgdet.hideColumn(spid);
                    spid.required = false;
                    this.bshopchgdet.showColumn(spid2);
                    if (rulemode == "1") {
                        this.bshopchgdet.updateColumn('spid2', {
                            required: false,
                            readOnly: true,
                            headerStyle: "color:black"
                        });
                    } else {
                        this.bshopchgdet.updateColumn('spid2', {
                            required: true,
                            readOnly: false,
                            headerStyle: "color:blue"
                        });
                    }
                    this.bshopchgdet.hideColumn(spcname);
                    spcname.required = false;
                    this.bshopchgdet.showColumn(spcname2);
                    spcname2.required = true;
                    this.bshopchgdet.hideColumn(ownerid);
                    ownerid.required = false;
                    this.bshopchgdet.hideColumn(sptype);
                    sptype.required = false;
                    this.bshopchgdet.showColumn(sptype2);
                    sptype2.required = true;
                    this.bshopchgdet.hideColumn(spmode);
                    spmode.required = false;
                    this.bshopchgdet.hideColumn(poolrate);
                    poolrate.required = false;
                    this.bshopchgdet.hideColumn(poolcoeffi);
                    poolcoeffi.required = false;
                    this.bshopchgdet.hideColumn(spggtype);
                    spggtype.required = false;
                    this.bshopchgdet.showColumn(media);
                    media.required = true;
                }
            }
            if (title == "单据列表") {
                e.sender.businessobj.bshopquerylist.reload();
            }
            this._refreshSysbtnEnable();
        },
        detcellcommitedit: function (e) {
            var ns = Future.ns('shop.pub');
            var muid = this.bshophead.form.getField('muid').value;
            var sylx = this.bshophead.form.getField('sylx').value;
            if (e.field == 'spid') {
                // 页面判断商铺编号是否重复
                var exitDatas = this.bshopchgdet.getData();
                for (var i = 0; i < exitDatas.length; i++) {
                    if (exitDatas[i].spid == e.value) {
                        if (sylx == '03') {
                            mini.alert("广告位[" + e.value + "]编号已存在!");
                        } else {
                            mini.alert("商铺[" + e.value + "]编号已存在!");
                        }
                        e.cancel = true;
                        return;
                    }

                }
                if (e.value != "") {
                    if (ns.checkspexist(e.value, muid)) {
                        e.cancel = true;
                        return;
                    }
                }

            }
            if (e.field == 'spbuildarea' || e.field == 'splettarea') {
                var buildarea;
                var lettarea;
                //建筑面积
                if (e.field == 'spbuildarea') {
                    buildarea = e.value;
                    lettarea = e.row.splettarea;
                }
                //套内面积
                if (e.field == 'splettarea') {
                    buildarea = e.row.spbuildarea;
                    lettarea = e.value;
                }
                var poolrate = ns.calcpoolrate1(buildarea, lettarea);
                var poolcoeffi = ns.calcpoolrate2(buildarea, lettarea);

                if (!poolrate) {
                    e.cancel = true;
                    return;
                } else {
                    e.row.poolrate = poolrate.value;
                }

                if (!poolcoeffi) {
                    e.cancel = true;
                    return;
                } else {
                    e.row.poolcoeffi = poolcoeffi.value;
                }
            }
        },
        bshopchgdet_beforefunc: function (e) {
            if (!e.searchParam) {
                e.searchParam = {};
            }
            /*e.searchParam.wherestr = " a.mmfflag = 'Y'";*/
            e.searchParam.muid = this.billhead.getValue('muid');
            /*e.searchParam.mmfflag = "Y";*/
        },
        getImportParam: function () {
            var that = this;
            var form = that.bshophead.form;
            var sylx = form.getField('sylx').value;
            if (sylx == '03') {
                return {
                    billmoduleid: "100501_G",
                    billno: that.billhead.getValue('billno'),
                    muid: that.billhead.getValue('muid'),
                    muid_name: that.billhead.getValue('muid_name')
                }
            } else {
                return {
                    billmoduleid: that.billmoduleid,
                    billno: that.billhead.getValue('billno'),
                    muid: that.billhead.getValue('muid'),
                    muid_name: that.billhead.getValue('muid_name')
                }
            }

        },
        transformSaveData: function (data) {
            var sylx = this.bshophead.form.getField('sylx').value;
            if (sylx == '03') {
                data.issp = "N";
                data.spmode = '0';
            } else {
                data.issp = "Y";
            }
            if (billtype == '10') {
                data.billmoduleid = '100501';
                data.billtype = billtype;
            } else {
                data.billtype = billtype;
                data.billmoduleid = billmoduleid;
            }
            data.billflag = 'N';

            var exitDatas = this.bshopchgdet.getData();
            for (var i = 0; i < exitDatas.length; i++) {
                if (exitDatas[i].spid && exitDatas[i].spid.length != exitDatas[i].spid.trim().length) {
                    var newrow = {};
                    newrow.spid = exitDatas[i].spid.trim();
                    this.bshopchgdet.updateRow(exitDatas[i], newrow);
                }
            }


        }
    });

})();
